/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.service.impl;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.RestfulResult;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.KeywordStatusEnum;
import com.kuaike.scrm.common.enums.MeetingStatus;
import com.kuaike.scrm.common.enums.MeetingType;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.impl.PlaceHolderService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.meeting.dto.MeetingKeywordInfo;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingCriteria;
import com.kuaike.scrm.dal.meeting.entity.MeetingKeyword;
import com.kuaike.scrm.dal.meeting.entity.MeetingKeywordCriteria;
import com.kuaike.scrm.dal.meeting.entity.MeetingKeywordGroup;
import com.kuaike.scrm.dal.meeting.entity.MeetingKeywordGroupCriteria;
import com.kuaike.scrm.dal.meeting.entity.MeetingKeywordRel;
import com.kuaike.scrm.dal.meeting.entity.MeetingKeywordRelCriteria;
import com.kuaike.scrm.dal.meeting.mapper.MeetingKeywordGroupMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingKeywordMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingKeywordRelMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.meeting.dto.reponse.KeywordResp;
import com.kuaike.scrm.meeting.service.BaijiacloudApiService;
import com.kuaike.scrm.meeting.service.MeetingKeywordService;
import com.kuaike.scrm.wework.contact.dto.KeyName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MeetingKeywordServiceImpl
implements MeetingKeywordService {
    private static final Logger log = LoggerFactory.getLogger(MeetingKeywordServiceImpl.class);
    private static final List<Integer> validStatus = Lists.newArrayList((Object[])new Integer[]{KeywordStatusEnum.IN_USED.getValue(), KeywordStatusEnum.SYNECED.getValue()});
    @Resource
    private MeetingKeywordMapper meetingKeywordMapper;
    @Resource
    private MeetingKeywordGroupMapper meetingKeywordGroupMapper;
    @Resource
    private MeetingKeywordRelMapper meetingKeywordRelMapper;
    @Resource
    private MeetingMapper meetingMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private PlaceHolderService placeHolderService;
    @Autowired
    private BaijiacloudApiService baijiacloudApiService;

    @Override
    public List<MeetingKeywordInfo> list(MeetingKeywordInfo params) {
        PageDto pageDto = params.getPageDto();
        if (Objects.isNull(pageDto)) {
            pageDto = new PageDto();
        }
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        MeetingKeywordGroupCriteria criteria = new MeetingKeywordGroupCriteria();
        criteria.createCriteria().andBizIdEqualTo(currentUser.getBizId()).andStatusEqualTo(YnEnum.YES.getValue());
        Page page = PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize(), (String)"update_time desc").doSelectPage(() -> this.meetingKeywordGroupMapper.selectByExample((Object)criteria));
        page.setPageNum(page.getPageNum());
        page.setPageSize(page.getPageSize());
        pageDto.setCount(Integer.valueOf((int)page.getTotal()));
        params.setPageDto(pageDto);
        List meetingKeywords = page.getResult();
        if (CollectionUtils.isEmpty((Collection)meetingKeywords)) {
            return Lists.newArrayList();
        }
        List groupIds = meetingKeywords.stream().map(MeetingKeywordGroup::getId).collect(Collectors.toList());
        log.info("\u5f53\u524dbizId:{}, keyword group id:{}", (Object)currentUser.getBizId(), (Object)JSON.toJSONString(groupIds));
        MeetingKeywordCriteria keywordCriteria = new MeetingKeywordCriteria();
        keywordCriteria.createCriteria().andBizIdEqualTo(currentUser.getBizId()).andGroupIdIn(groupIds).andStatusIn(validStatus);
        List keywords = this.meetingKeywordMapper.selectByExample((Object)keywordCriteria);
        Map<Long, List<MeetingKeywordInfo>> collectByGroupId = keywords.stream().map(item -> {
            MeetingKeywordInfo keywordInfo = new MeetingKeywordInfo();
            BeanUtils.copyProperties((Object)item, (Object)keywordInfo);
            return keywordInfo;
        }).collect(Collectors.groupingBy(MeetingKeyword::getGroupId));
        return meetingKeywords.stream().map(item -> {
            MeetingKeywordInfo groupInfo = new MeetingKeywordInfo();
            groupInfo.setGroupName(item.getName());
            groupInfo.setGroupId(item.getId());
            groupInfo.setKeywordInfos((List)collectByGroupId.get(item.getId()));
            return groupInfo;
        }).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(MeetingKeywordInfo params) {
        this.addParamCheck(params);
        log.info("keyword add param:\uff1a{}", (Object)JSON.toJSONString((Object)params));
        MeetingKeywordGroup keywordGroup = this.addKeywordGroup(params.getGroupName().trim());
        this.butchAddKeyword(params.getKeywordInfos(), keywordGroup.getId());
    }

    @Override
    public List<MeetingKeywordInfo> detailByMeetingId(Long meetingId) {
        if (Objects.isNull(meetingId)) {
            return Lists.newArrayList();
        }
        MeetingKeywordRelCriteria criteria = new MeetingKeywordRelCriteria();
        criteria.createCriteria().andMeetingIdEqualTo(meetingId).andBizIdEqualTo(LoginUtils.getCurrentUserBizId()).andStatusEqualTo(YnEnum.YES.getValue());
        List meetingKeywordRels = this.meetingKeywordRelMapper.selectByExample((Object)criteria);
        if (CollectionUtils.isEmpty((Collection)meetingKeywordRels)) {
            return Lists.newArrayList();
        }
        List keywordsId = meetingKeywordRels.stream().map(MeetingKeywordRel::getKeywordId).collect(Collectors.toList());
        MeetingKeywordCriteria keywordCriteria = new MeetingKeywordCriteria();
        keywordCriteria.createCriteria().andIdIn(keywordsId).andBizIdEqualTo(LoginUtils.getCurrentUserBizId());
        List meetingKeywords = this.meetingKeywordMapper.selectByExample((Object)keywordCriteria);
        if (CollectionUtils.isEmpty((Collection)meetingKeywords)) {
            return Lists.newArrayList();
        }
        List groupIdList = meetingKeywords.stream().map(MeetingKeyword::getGroupId).distinct().collect(Collectors.toList());
        MeetingKeywordGroupCriteria groupCriteria = new MeetingKeywordGroupCriteria();
        groupCriteria.createCriteria().andIdIn(groupIdList).andBizIdEqualTo(LoginUtils.getCurrentUserBizId());
        List keywordGroups = this.meetingKeywordGroupMapper.selectByExample((Object)groupCriteria);
        if (CollectionUtils.isEmpty((Collection)keywordGroups)) {
            return Lists.newArrayList();
        }
        Map<Long, List<MeetingKeywordInfo>> groupByGroupId = meetingKeywords.stream().map(item -> {
            MeetingKeywordInfo keywordInfo = new MeetingKeywordInfo();
            keywordInfo.setGroupId(item.getGroupId());
            keywordInfo.setName(item.getName());
            keywordInfo.setId(item.getId());
            return keywordInfo;
        }).collect(Collectors.groupingBy(MeetingKeyword::getGroupId));
        return keywordGroups.stream().map(item -> {
            MeetingKeywordInfo keywordInfo = new MeetingKeywordInfo();
            keywordInfo.setGroupName(item.getName());
            keywordInfo.setGroupId(item.getId());
            keywordInfo.setKeywordInfos((List)groupByGroupId.get(item.getId()));
            return keywordInfo;
        }).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(MeetingKeywordInfo params) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        List<MeetingKeywordInfo> toAddKeywords = params.getKeywordInfos().stream().filter(item -> Objects.nonNull(item.getName()) && (Objects.isNull(item.getIsDel()) || item.getIsDel() == false)).collect(Collectors.toList());
        List<Long> toDelKeywords = params.getKeywordInfos().stream().filter(item -> Objects.nonNull(item.getId()) && Objects.nonNull(item.getIsDel()) && item.getIsDel() != false).map(MeetingKeyword::getId).collect(Collectors.toList());
        List delKeywordsInfo = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(toDelKeywords)) {
            MeetingCriteria checkCriteria = new MeetingCriteria();
            checkCriteria.createCriteria().andBizIdEqualTo(currentUser.getBizId()).andIdIn(toDelKeywords);
            delKeywordsInfo = this.meetingKeywordMapper.selectByExample((Object)checkCriteria);
        }
        this.editParamCheck(params.getGroupId(), params.getGroupName(), toAddKeywords);
        this.delkeywordParamCheck(toDelKeywords, currentUser.getBizId());
        log.info("keyword edit param:{}", (Object)JSON.toJSONString((Object)params));
        this.editKeywordGroup(params.getGroupId(), params.getGroupName());
        this.butchAddKeyword(toAddKeywords, params.getGroupId());
        this.delKeywordByIds(delKeywordsInfo, currentUser);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(List<Long> groupIds) {
        log.info("keyword delete param:{}", (Object)JSON.toJSONString(groupIds));
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(groupIds), (Object)"\u5173\u952e\u8bcd\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        MeetingKeywordGroup keywordGroup = new MeetingKeywordGroup();
        keywordGroup.setUpdateTime(new Date());
        keywordGroup.setUpdateBy(currentUser.getId());
        keywordGroup.setStatus(YnEnum.NO.getValue());
        MeetingKeywordGroupCriteria criteria = new MeetingKeywordGroupCriteria();
        criteria.createCriteria().andBizIdEqualTo(currentUser.getBizId()).andIdIn(groupIds);
        this.meetingKeywordGroupMapper.updateByExampleSelective((Object)keywordGroup, (Object)criteria);
        MeetingKeywordCriteria queryCriteria = new MeetingKeywordCriteria();
        queryCriteria.createCriteria().andBizIdEqualTo(currentUser.getBizId()).andGroupIdIn(groupIds).andStatusIn(validStatus);
        List keywords = this.meetingKeywordMapper.selectByExample((Object)queryCriteria);
        if (CollectionUtils.isEmpty((Collection)keywords)) {
            return;
        }
        List<Long> collect = keywords.stream().map(MeetingKeyword::getId).collect(Collectors.toList());
        this.delkeywordParamCheck(collect, currentUser.getBizId());
        this.delKeywordByIds(keywords, currentUser);
    }

    @Override
    public void associateMeetingWithKeywords(Meeting meeting, List<MeetingKeywordInfo> keywordGroups, Long bizId, Integer meetingType, Integer isAdd) {
        if (CollectionUtils.isEmpty(keywordGroups) || Objects.isNull(bizId) || Objects.isNull(meeting)) {
            return;
        }
        log.info("\u3010\u76f4\u64ad\u95f4\u5173\u8054\u5173\u952e\u8bcd\u3011meetingId:{}; keywordGroupId:{},bizId:{},isAdd:{}", new Object[]{meeting.getId(), JSON.toJSONString(keywordGroups), bizId, isAdd});
        if (Objects.isNull(meetingType) || meetingType.intValue() != MeetingType.EXTERNAL_MEETING.getValue()) {
            return;
        }
        ArrayList shouldAssociateKeywords = Lists.newArrayList();
        for (MeetingKeywordInfo groupInfo : keywordGroups) {
            List<MeetingKeyword> meetingKeywords = this.queryByGroupId(groupInfo.getGroupId(), bizId);
            if (CollectionUtils.isEmpty(meetingKeywords)) {
                log.info("\u5f53\u524d\u5173\u952e\u8bcd\u7ec4:{}\u6ca1\u6709\u5bf9\u5e94\u5173\u952e\u8bcd\u4fe1\u606f", (Object)groupInfo.getGroupId());
                continue;
            }
            Set keywordIds = meetingKeywords.stream().map(MeetingKeyword::getId).collect(Collectors.toSet());
            if (YnEnum.YES.getValue().equals(isAdd)) {
                shouldAssociateKeywords.addAll(meetingKeywords);
                continue;
            }
            List existMeetingKeywordIds = this.meetingKeywordRelMapper.selectByMeetingIdAndKeywordId(bizId, meeting.getId(), keywordIds);
            Set existKeywordIds = existMeetingKeywordIds.stream().map(MeetingKeywordRel::getKeywordId).collect(Collectors.toSet());
            HashSet unExistKeywordIds = Sets.newHashSet(keywordIds);
            unExistKeywordIds.removeAll(existKeywordIds);
            Map<Long, List<MeetingKeyword>> allKeywords = meetingKeywords.stream().collect(Collectors.groupingBy(MeetingKeyword::getId));
            for (Long unExistKeywordId : unExistKeywordIds) {
                shouldAssociateKeywords.addAll((Collection)allKeywords.get(unExistKeywordId));
            }
        }
        if (CollectionUtils.isEmpty((Collection)shouldAssociateKeywords)) {
            log.info("\u3010\u76f4\u64ad\u95f4\u5173\u8054\u5173\u952e\u8bcd\u3011\u5f53\u524d\u64cd\u4f5c\uff1a{}; groupInfos:{}, meetingIds:{}", new Object[]{isAdd, JSON.toJSONString(keywordGroups), meeting.getMeetingInfo()});
            return;
        }
        List keyNameList = shouldAssociateKeywords.stream().map(keyword -> {
            MeetingKeywordRel meetingKeywordRel = new MeetingKeywordRel();
            meetingKeywordRel.setKeywordId(keyword.getId());
            meetingKeywordRel.setMeetingId(meeting.getId());
            meetingKeywordRel.setMeetingTitle(meeting.getTitle());
            meetingKeywordRel.setRoomId(meeting.getRoomId());
            meetingKeywordRel.setBizId(bizId);
            meetingKeywordRel.setCreateTime(new Date());
            meetingKeywordRel.setUpdateTime(new Date());
            meetingKeywordRel.setCreateBy(meeting.getCreateBy());
            meetingKeywordRel.setStatus(YnEnum.YES.getValue());
            this.meetingKeywordRelMapper.insert((Object)meetingKeywordRel);
            KeyName idName = new KeyName();
            idName.setKey((Serializable)meetingKeywordRel.getId());
            idName.setName(keyword.getName());
            return idName;
        }).collect(Collectors.toList());
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Map<String, String> param = this.buildAddBjyKeywords(shouldAssociateKeywords, meeting.getRoomId());
        TypeReference<RestfulResult<List<KeywordResp>>> resultTypeToken = new TypeReference<RestfulResult<List<KeywordResp>>>(){};
        List<KeywordResp> keywordListResp = this.baijiacloudApiService.postListBjyApi(resultTypeToken, this.placeHolderService.getBjyKeywordAddUrl(), param, currentUser.getCorpId(), "\u65b0\u589e", "\u5173\u952e\u8bcd\u64cd\u4f5c");
        if (CollectionUtils.isEmpty(keywordListResp)) {
            log.warn("\u3010\u76f4\u64ad\u95f4\u5173\u8054\u5173\u952e\u8bcd\u3011\u65b0\u589e\u76f4\u64ad\u95f4\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a\uff1aparam:{}", param);
            return;
        }
        for (KeyName keyword2 : keyNameList) {
            for (KeywordResp resp : keywordListResp) {
                if (!StringUtils.equals((CharSequence)keyword2.getName(), (CharSequence)resp.getWord())) continue;
                MeetingKeywordRel updateData = new MeetingKeywordRel();
                updateData.setId((Long)keyword2.getKey());
                updateData.setBjyKeywordId(resp.getId());
                updateData.setUpdateTime(new Date());
                this.meetingKeywordRelMapper.updateByPrimaryKeySelective((Object)updateData);
            }
        }
    }

    private Map<String, String> buildAddBjyKeywords(List<MeetingKeyword> keyword, String roomId) {
        HashMap param = Maps.newHashMap();
        List keywordName = keyword.stream().map(MeetingKeyword::getName).collect(Collectors.toList());
        param.put("words", JSON.toJSONString(keywordName));
        param.put("room_id", roomId);
        return param;
    }

    private Map<String, String> buildButchDelBjyKeywords(List<MeetingKeywordRel> meetingKeywordRels, String roomId) {
        String bjyKeywordsList = meetingKeywordRels.stream().map(MeetingKeywordRel::getBjyKeywordId).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
        if (StringUtils.isEmpty((CharSequence)bjyKeywordsList)) {
            return Maps.newHashMap();
        }
        HashMap param = Maps.newHashMap();
        param.put("ids", bjyKeywordsList);
        param.put("room_id", roomId);
        return param;
    }

    private List<MeetingKeyword> queryByGroupId(Long groupId, Long bizId) {
        MeetingKeywordCriteria criteria = new MeetingKeywordCriteria();
        criteria.createCriteria().andBizIdEqualTo(bizId).andGroupIdEqualTo(groupId).andStatusIn(validStatus);
        return this.meetingKeywordMapper.selectByExample((Object)criteria);
    }

    private void addParamCheck(MeetingKeywordInfo keyword) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(keyword), (Object)"\u5173\u952e\u8bcd\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        keyword.setBizId(currentUser.getBizId());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)keyword.getGroupName()), (Object)"\u5173\u952e\u8bcd\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)keyword.getKeywordInfos()), (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(keyword.getBizId()), (Object)"\u5546\u6237id \u4e0d\u80fd\u4e3a\u7a7a");
        MeetingKeywordGroupCriteria criteria = new MeetingKeywordGroupCriteria();
        criteria.createCriteria().andBizIdEqualTo(currentUser.getBizId()).andNameEqualTo(keyword.getGroupName()).andStatusIn(validStatus);
        List keywordGroups = this.meetingKeywordGroupMapper.selectByExample((Object)criteria);
        if (CollectionUtils.isNotEmpty((Collection)keywordGroups)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5173\u952e\u8bcd\u7ec4\u540d\uff1a[" + keyword.getGroupName() + "] \u5df2\u5b58\u5728");
        }
    }

    private void editParamCheck(Long groupId, String groupName, List<MeetingKeywordInfo> toUpdateKeyword) {
        Preconditions.checkArgument((boolean)Objects.nonNull(groupId), (Object)"\u5173\u952e\u8bcd\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(groupName), (Object)"\u5173\u952e\u8bcd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        MeetingKeywordGroup group = this.keywordGroupByName(groupName, currentUser.getBizId());
        if (Objects.nonNull(group) && !group.getId().equals(groupId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5173\u952e\u8bcd\u7ec4\u540d\uff1a[" + groupName + "] \u5df2\u5b58\u5728");
        }
        if (CollectionUtils.isEmpty(toUpdateKeyword)) {
            return;
        }
        Map<String, List<MeetingKeywordInfo>> collect = toUpdateKeyword.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getName())).collect(Collectors.groupingBy(MeetingKeywordInfo::getName));
        for (Map.Entry<String, List<MeetingKeywordInfo>> stringListEntry : collect.entrySet()) {
            if (stringListEntry.getValue().size() <= 1) continue;
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5173\u952e\u8bcd\u7ec4\u540d\uff1a[" + stringListEntry.getKey() + "] \u5df2\u5b58\u5728");
        }
    }

    private void delkeywordParamCheck(List<Long> keywordIds, Long bizId) {
        if (CollectionUtils.isEmpty(keywordIds) || Objects.isNull(bizId)) {
            return;
        }
        MeetingKeywordRelCriteria relCriteria = new MeetingKeywordRelCriteria();
        relCriteria.createCriteria().andBizIdEqualTo(bizId).andKeywordIdIn(keywordIds).andMeetingIdIsNotNull();
        List keywordRels = this.meetingKeywordRelMapper.selectByExample((Object)relCriteria);
        if (CollectionUtils.isEmpty((Collection)keywordRels)) {
            return;
        }
        List meetingIds = keywordRels.stream().map(MeetingKeywordRel::getMeetingId).collect(Collectors.toList());
        MeetingCriteria meetingCriteria = new MeetingCriteria();
        meetingCriteria.createCriteria().andIdIn(meetingIds);
        List meetings = this.meetingMapper.selectByExample((Object)meetingCriteria);
        if (CollectionUtils.isEmpty((Collection)meetings)) {
            return;
        }
        for (Meeting meeting : meetings) {
            if (meeting.getStatus().intValue() != MeetingStatus.MEETING.getValue()) continue;
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u76f4\u64ad\u95f4\u5173\u8054\u7684\u76f4\u64ad\u95f4\uff1a " + meeting.getTitle() + "\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u65e0\u6cd5\u5220\u9664");
        }
    }

    public void delKeywordByIds(List<MeetingKeyword> keywords, CurrentUserInfo currentUser) {
        if (CollectionUtils.isEmpty(keywords)) {
            return;
        }
        List keywordIds = keywords.stream().map(MeetingKeyword::getId).collect(Collectors.toList());
        MeetingKeyword meetingKeyword = new MeetingKeyword();
        meetingKeyword.setStatus(Integer.valueOf(KeywordStatusEnum.DELETED.getValue()));
        meetingKeyword.setUpdateTime(new Date());
        meetingKeyword.setUpdateBy(currentUser.getId());
        MeetingKeywordCriteria keywordCriteria = new MeetingKeywordCriteria();
        keywordCriteria.createCriteria().andBizIdEqualTo(currentUser.getBizId()).andIdIn(keywordIds);
        this.meetingKeywordMapper.updateByExampleSelective((Object)meetingKeyword, (Object)keywordCriteria);
        MeetingKeywordRelCriteria relCriteria = new MeetingKeywordRelCriteria();
        relCriteria.createCriteria().andKeywordIdIn(keywordIds).andBizIdEqualTo(currentUser.getBizId()).andRoomIdIsNotNull();
        List meetingKeywordRels = this.meetingKeywordRelMapper.selectByExample((Object)relCriteria);
        if (CollectionUtils.isEmpty((Collection)meetingKeywordRels)) {
            log.info("\u5f53\u524d\u5173\u952e\u8bcd\uff0c\u672a\u7ed1\u5b9a\u76f4\u64ad\u95f4\uff0c\u76f4\u63a5\u5220\u9664 keywordIds:{}", (Object)JSON.toJSONString(keywordIds));
            return;
        }
        TypeReference<RestfulResult<KeywordResp>> resultTypeToken = new TypeReference<RestfulResult<KeywordResp>>(){};
        Map<String, List<MeetingKeywordRel>> groupByRoomIds = meetingKeywordRels.stream().collect(Collectors.groupingBy(MeetingKeywordRel::getRoomId));
        for (Map.Entry<String, List<MeetingKeywordRel>> stringListEntry : groupByRoomIds.entrySet()) {
            Map<String, String> param = this.buildButchDelBjyKeywords(stringListEntry.getValue(), stringListEntry.getKey());
            if (MapUtils.isEmpty(param)) {
                log.warn("\u8c03\u7528\u767e\u5bb6\u4e91\u63a5\u53e3\u6784\u5efa\u7684\u53c2\u6570\u4e3a\u7a7a\uff1aparam:{}", (Object)JSON.toJSONString(stringListEntry));
                continue;
            }
            this.baijiacloudApiService.postBjyApi(resultTypeToken, this.placeHolderService.getBjyKeywordButchDelUrl(), param, currentUser.getCorpId(), "\u5220\u9664", "\u5173\u952e\u8bcd\u64cd\u4f5c");
        }
    }

    private MeetingKeywordGroup addKeywordGroup(String groupName) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        MeetingKeywordGroup group = this.keywordGroupByName(groupName, currentUser.getBizId());
        if (Objects.nonNull(group)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5173\u952e\u8bcd\u7ec4\u540d\uff1a[" + groupName + "] \u5df2\u5b58\u5728");
        }
        MeetingKeywordGroup keywordGroup = new MeetingKeywordGroup();
        keywordGroup.setBizId(currentUser.getBizId());
        keywordGroup.setNum(this.idGen.getNum());
        keywordGroup.setName(groupName);
        keywordGroup.setCreateBy(currentUser.getId());
        keywordGroup.setStatus(YnEnum.YES.getValue());
        keywordGroup.setUpdateBy(currentUser.getId());
        keywordGroup.setUpdateTime(new Date());
        keywordGroup.setCreateTime(new Date());
        this.meetingKeywordGroupMapper.insert((Object)keywordGroup);
        return keywordGroup;
    }

    private void editKeywordGroup(Long groupId, String groupName) {
        MeetingKeywordGroup keywordGroup = new MeetingKeywordGroup();
        keywordGroup.setId(groupId);
        keywordGroup.setName(groupName);
        keywordGroup.setUpdateTime(new Date());
        this.meetingKeywordGroupMapper.updateByPrimaryKeySelective((Object)keywordGroup);
    }

    private MeetingKeyword addOrModKeyword(MeetingKeywordInfo keywordInfo) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(keywordInfo.getName()), (Object)"\u5173\u952e\u8bcd\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(keywordInfo.getGroupId()), (Object)"\u5173\u952e\u8bcd\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        MeetingKeyword keyword = new MeetingKeyword();
        if (Objects.isNull(keywordInfo.getId())) {
            keyword.setNum(this.idGen.getNum());
            keyword.setGroupId(keywordInfo.getGroupId());
            keyword.setBizId(currentUser.getBizId());
            keyword.setCreateTime(new Date());
            keyword.setCreatorBy(currentUser.getId());
            keyword.setStatus(Integer.valueOf(KeywordStatusEnum.IN_USED.getValue()));
        }
        keyword.setName(keywordInfo.getName().trim());
        keyword.setUpdateTime(new Date());
        keyword.setUpdateBy(currentUser.getId());
        if (Objects.isNull(keywordInfo.getId())) {
            log.info("\u65b0\u589e\u76f4\u64ad\u95f4\u5173\u952e\u8bcd\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)keyword));
            this.meetingKeywordMapper.insert((Object)keyword);
        } else {
            this.meetingKeywordMapper.updateByPrimaryKeySelective((Object)keyword);
        }
        return keyword;
    }

    private MeetingKeywordGroup keywordGroupByName(String groupName, Long bizId) {
        MeetingKeywordGroup queryCondition = new MeetingKeywordGroup();
        queryCondition.setBizId(bizId);
        queryCondition.setName(groupName);
        queryCondition.setStatus(YnEnum.YES.getValue());
        return (MeetingKeywordGroup)this.meetingKeywordGroupMapper.selectOne((Object)queryCondition);
    }

    private List<MeetingKeyword> butchAddKeyword(List<MeetingKeywordInfo> keywordInfos, Long groupId) {
        if (CollectionUtils.isEmpty(keywordInfos)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        for (MeetingKeywordInfo keywordInfo : keywordInfos) {
            keywordInfo.setGroupId(groupId);
            MeetingKeyword meetingKeyword = this.addOrModKeyword(keywordInfo);
            result.add(meetingKeyword);
        }
        return result;
    }
}

