/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.dto.reponse;

import com.kuaike.scrm.dal.meeting.entity.MeetingRoomChatDetail;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.BeanUtils;

public class MeetingChatListResponseDto {
    private long chatTime;
    private String bjyNumber;
    private int userRole;
    private String userRoleDesc;
    private String content;
    private String bjyName;
    private String contactName;
    private String contactId;
    private String avatar;

    public static MeetingChatListResponseDto convertPOToDto(MeetingRoomChatDetail source, Map<String, WeworkContact> contactMap, Map<String, WeworkUser> userMap) {
        WeworkUser user;
        MeetingChatListResponseDto target = new MeetingChatListResponseDto();
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])new String[]{"chatTime"});
        if (source.getUserRole().intValue() == NumberUtils.INTEGER_ZERO.intValue()) {
            target.setUserRoleDesc("\u5b66\u5458");
        } else if (source.getUserRole().intValue() == NumberUtils.INTEGER_ONE.intValue()) {
            target.setUserRoleDesc("\u8001\u5e08");
        } else if (source.getUserRole().intValue() == NumberUtils.INTEGER_TWO.intValue()) {
            target.setUserRoleDesc("\u52a9\u6559");
        }
        String contactId = source.getContactId();
        String weworkUserNum = source.getWeworkUserNum();
        if (StringUtils.isNotBlank((CharSequence)contactId) && !"-1".equals(source.getContactId()) && Objects.nonNull(contactMap)) {
            WeworkContact contact = contactMap.get(contactId);
            if (Objects.nonNull(contact)) {
                target.setAvatar(contact.getAvatar());
                target.setContactName(contact.getName());
            }
        } else if (StringUtils.isNotBlank((CharSequence)weworkUserNum) && Objects.nonNull(userMap) && Objects.nonNull(user = userMap.get(weworkUserNum))) {
            target.setAvatar(user.getAvatar());
            target.setContactName(user.getName());
        }
        target.setChatTime(source.getChatTime().getTime());
        return target;
    }

    public long getChatTime() {
        return this.chatTime;
    }

    public String getBjyNumber() {
        return this.bjyNumber;
    }

    public int getUserRole() {
        return this.userRole;
    }

    public String getUserRoleDesc() {
        return this.userRoleDesc;
    }

    public String getContent() {
        return this.content;
    }

    public String getBjyName() {
        return this.bjyName;
    }

    public String getContactName() {
        return this.contactName;
    }

    public String getContactId() {
        return this.contactId;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setChatTime(long chatTime) {
        this.chatTime = chatTime;
    }

    public void setBjyNumber(String bjyNumber) {
        this.bjyNumber = bjyNumber;
    }

    public void setUserRole(int userRole) {
        this.userRole = userRole;
    }

    public void setUserRoleDesc(String userRoleDesc) {
        this.userRoleDesc = userRoleDesc;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setBjyName(String bjyName) {
        this.bjyName = bjyName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public void setContactId(String contactId) {
        this.contactId = contactId;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeetingChatListResponseDto)) {
            return false;
        }
        MeetingChatListResponseDto other = (MeetingChatListResponseDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getChatTime() != other.getChatTime()) {
            return false;
        }
        if (this.getUserRole() != other.getUserRole()) {
            return false;
        }
        String this$bjyNumber = this.getBjyNumber();
        String other$bjyNumber = other.getBjyNumber();
        if (this$bjyNumber == null ? other$bjyNumber != null : !this$bjyNumber.equals(other$bjyNumber)) {
            return false;
        }
        String this$userRoleDesc = this.getUserRoleDesc();
        String other$userRoleDesc = other.getUserRoleDesc();
        if (this$userRoleDesc == null ? other$userRoleDesc != null : !this$userRoleDesc.equals(other$userRoleDesc)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$bjyName = this.getBjyName();
        String other$bjyName = other.getBjyName();
        if (this$bjyName == null ? other$bjyName != null : !this$bjyName.equals(other$bjyName)) {
            return false;
        }
        String this$contactName = this.getContactName();
        String other$contactName = other.getContactName();
        if (this$contactName == null ? other$contactName != null : !this$contactName.equals(other$contactName)) {
            return false;
        }
        String this$contactId = this.getContactId();
        String other$contactId = other.getContactId();
        if (this$contactId == null ? other$contactId != null : !this$contactId.equals(other$contactId)) {
            return false;
        }
        String this$avatar = this.getAvatar();
        String other$avatar = other.getAvatar();
        return !(this$avatar == null ? other$avatar != null : !this$avatar.equals(other$avatar));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MeetingChatListResponseDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $chatTime = this.getChatTime();
        result = result * 59 + (int)($chatTime >>> 32 ^ $chatTime);
        result = result * 59 + this.getUserRole();
        String $bjyNumber = this.getBjyNumber();
        result = result * 59 + ($bjyNumber == null ? 43 : $bjyNumber.hashCode());
        String $userRoleDesc = this.getUserRoleDesc();
        result = result * 59 + ($userRoleDesc == null ? 43 : $userRoleDesc.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $bjyName = this.getBjyName();
        result = result * 59 + ($bjyName == null ? 43 : $bjyName.hashCode());
        String $contactName = this.getContactName();
        result = result * 59 + ($contactName == null ? 43 : $contactName.hashCode());
        String $contactId = this.getContactId();
        result = result * 59 + ($contactId == null ? 43 : $contactId.hashCode());
        String $avatar = this.getAvatar();
        result = result * 59 + ($avatar == null ? 43 : $avatar.hashCode());
        return result;
    }

    public String toString() {
        return "MeetingChatListResponseDto(chatTime=" + this.getChatTime() + ", bjyNumber=" + this.getBjyNumber() + ", userRole=" + this.getUserRole() + ", userRoleDesc=" + this.getUserRoleDesc() + ", content=" + this.getContent() + ", bjyName=" + this.getBjyName() + ", contactName=" + this.getContactName() + ", contactId=" + this.getContactId() + ", avatar=" + this.getAvatar() + ")";
    }
}

