/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.support;

import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.kuaike.scrm.call.enums.VoiceCallStatusEnum;
import com.kuaike.scrm.common.enums.CallTaskFkTypeEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.dto.CustomerDto;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.call.dto.CallTaskQueryParams;
import com.kuaike.scrm.dal.call.entity.CallTask;
import com.kuaike.scrm.dal.call.entity.CallTaskDetail;
import com.kuaike.scrm.dal.call.entity.CallTaskDetailCriteria;
import com.kuaike.scrm.dal.call.mapper.CallTaskDetailMapper;
import com.kuaike.scrm.dal.call.mapper.CallTaskMapper;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerInfo;
import com.kuaike.scrm.dal.meeting.entity.MeetingSendDetail;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingSendDetailMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UnArriveRoomTaskSupport {
    private static final Logger log = LoggerFactory.getLogger(UnArriveRoomTaskSupport.class);
    @Resource
    private CallTaskMapper callTaskMapper;
    @Resource
    private IdGen idGen;
    @Resource
    private CallTaskDetailMapper callTaskDetailMapper;
    @Resource
    private CcCustomerNumService ccCustomerNumService;
    @Resource
    private MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    @Resource
    private MeetingSendDetailMapper meetingSendDetailMapper;

    public void doTask() {
        CallTaskQueryParams callTaskQueryParams = new CallTaskQueryParams();
        callTaskQueryParams.setFkType(Integer.valueOf(CallTaskFkTypeEnum.NO_ARRIVE_MEETING.getValue()));
        callTaskQueryParams.setPlanCompleteStartTime(DateUtil.getDateAddDay((Date)new Date(), (int)-1));
        callTaskQueryParams.setQueryType(YnEnum.YES.getValue());
        callTaskQueryParams.setPlanCompleteEndTime(new Date());
        List callTasks = this.callTaskMapper.queryList(callTaskQueryParams);
        if (CollectionUtils.isEmpty((Collection)callTasks)) {
            return;
        }
        List collect = callTasks.stream().map(CallTask::getId).collect(Collectors.toList());
        log.info("\u3010\u521b\u5efa\u8bed\u97f3\u8be6\u60c5\u3011\u9700\u8981\u7fa4\u53d1\u7684\u4efb\u52a1\u672a:{}", (Object)JSON.toJSONString(collect));
        for (CallTask callTask : callTasks) {
            CallTaskDetailCriteria callTaskDetailCriteria = new CallTaskDetailCriteria();
            callTaskDetailCriteria.createCriteria().andCallTaskIdEqualTo(callTask.getId());
            List existCallTaskDetail = this.callTaskDetailMapper.selectByExample((Object)callTaskDetailCriteria);
            if (!CollectionUtils.isEmpty((Collection)existCallTaskDetail)) {
                log.info("\u3010\u521b\u5efa\u8bed\u97f3\u8be6\u60c5\u3011\u4efb\u52a1\u8be6\u60c5\u5df2\u7ecf\u751f\u6210\uff0c\u65e0\u9700\u91cd\u590d\u751f\u6210 taskId:{}", (Object)callTask.getId());
                continue;
            }
            List list = existCallTaskDetail.stream().map(CallTaskDetail::getId).collect(Collectors.toList());
            log.info("\u3010\u521b\u5efa\u8bed\u97f3\u8be6\u60c5\u3011\u5f85\u6267\u884c\u4efb\u52a1\u8be6\u60c5:{}", (Object)JSON.toJSONString(list));
            if (Objects.isNull(callTask.getFkType()) || CallTaskFkTypeEnum.NO_ARRIVE_MEETING.getValue() != callTask.getFkType().intValue() || Objects.isNull(callTask.getFkId())) continue;
            List meetingSendDetails = this.meetingSendDetailMapper.queryRemindByMeetingIds(callTask.getBizId(), (Collection)Lists.newArrayList((Object[])new Long[]{callTask.getFkId()}));
            if (CollectionUtils.isEmpty((Collection)meetingSendDetails)) {
                log.error("\u3010\u76f4\u64ad\u95f4\u7fa4\u53d1\u3011: MeetingSendDetail isNull \uff1ataskId: {},", (Object)callTask.getId());
                continue;
            }
            Set shouSendNoArriveGroupSend = meetingSendDetails.stream().map(MeetingSendDetail::getContactId).collect(Collectors.toSet());
            List meetingCustomerInfos = this.meetingCustomerInfoMapper.queryMeetingCustomerByMeetingId(callTask.getBizId(), callTask.getFkId());
            if (!CollectionUtils.isEmpty((Collection)meetingCustomerInfos)) {
                Set arriveMeetingContactId = meetingCustomerInfos.stream().filter(customerInfo -> customerInfo.getArrivalTime() != null && StringUtils.isNotBlank((CharSequence)customerInfo.getContactId())).map(MeetingCustomerInfo::getContactId).collect(Collectors.toSet());
                log.info("\u3010\u76f4\u64ad\u95f4\u7fa4\u53d1\u3011\u76f4\u64ad\u95f4\u5df2\u5230\u8bfe\u7528\u6237contactId \u4e3a\uff1a{}", (Object)JSON.toJSONString(arriveMeetingContactId));
                shouSendNoArriveGroupSend.removeAll(arriveMeetingContactId);
            }
            if (CollectionUtils.isEmpty(shouSendNoArriveGroupSend)) continue;
            List customerDtoList = shouSendNoArriveGroupSend.stream().map(item -> {
                CustomerDetailResp detailByType = null;
                try {
                    detailByType = this.ccCustomerNumService.getCustomerDetailByType(callTask.getBizId(), item);
                }
                catch (Exception e) {
                    log.error("[meeting add]\u8c03\u7528customerNumSerImpl \u5f02\u5e38\uff1aparam:bizId: {},userId: {} ,errorMessage", new Object[]{callTask.getBizId(), item, e});
                }
                if (Objects.isNull(detailByType)) {
                    return null;
                }
                if (StringUtils.isBlank((CharSequence)detailByType.getMobile1())) {
                    return null;
                }
                CustomerDto customerDto = new CustomerDto();
                customerDto.setName(detailByType.getName());
                customerDto.setPhone(detailByType.getMobile1());
                return customerDto;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            log.info("\u3010\u521b\u5efa\u8bed\u97f3\u8be6\u60c5\u3011\u5f85\u8bed\u97f3\u901a\u77e5\u4efb\u52a1\u7528\u6237\u4fe1\u606f\u672a\uff1ataskId:{},{}", (Object)callTask.getId(), (Object)JSON.toJSONString(customerDtoList));
            ArrayList callTaskDetails = Lists.newArrayList();
            for (CustomerDto customerDto : customerDtoList) {
                CallTaskDetail detail = new CallTaskDetail();
                detail.setNum(this.idGen.getNum());
                detail.setBizId(callTask.getBizId());
                detail.setCorpId(callTask.getCorpId());
                detail.setName(customerDto.getName());
                detail.setPhone(customerDto.getPhone());
                detail.setCallTaskId(callTask.getId());
                detail.setUserId(Long.valueOf(-1L));
                detail.setUserName("");
                detail.setCreateBy(callTask.getCreateBy());
                detail.setCreateTime(new Date());
                detail.setUpdateBy(callTask.getUpdateBy());
                detail.setUpdateTime(new Date());
                detail.setCallCount(Integer.valueOf(0));
                detail.setCallSuccessCount(Integer.valueOf(0));
                detail.setVoiceTaskExecuteTime(new Date());
                detail.setVoiceTaskStatus(Integer.valueOf(VoiceCallStatusEnum.NOT_EXECUTE.getValue()));
                callTaskDetails.add(detail);
            }
            if (CollectionUtils.isEmpty((Collection)callTaskDetails)) continue;
            this.callTaskDetailMapper.batchInsert((List)callTaskDetails);
            List collect1 = callTaskDetails.stream().map(CallTaskDetail::getNum).collect(Collectors.toList());
            log.info("\u3010\u521b\u5efa\u8bed\u97f3\u8be6\u60c5\u3011\u5f53\u524dcallTask \u5df2\u7ecf\u751f\u6210\u8be6\u60c5 detailInfo:{}", collect1);
        }
    }
}

