/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.meeting.dto.MajorCustomerListRes;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerMsgHit;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerMsgHitMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.meeting.dto.reponse.HitKeywordRes;
import com.kuaike.scrm.meeting.dto.request.HitKeywordReq;
import com.kuaike.scrm.meeting.dto.request.MajorCustomerReq;
import com.kuaike.scrm.meeting.service.MeetingStatisticService;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MeetingStatisticServiceImpl
implements MeetingStatisticService {
    private static final Logger log = LoggerFactory.getLogger(MeetingStatisticServiceImpl.class);
    @Resource
    private MeetingMapper meetingMapper;
    @Resource
    private MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    @Resource
    private MeetingCustomerMsgHitMapper meetingCustomerMsgHitMapper;

    @Override
    public List<MajorCustomerListRes> queryMajorCustomerList(MajorCustomerReq params) {
        log.info("query major customer list params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        params.validate();
        Long bizId = userInfo.getBizId();
        PageDto pageDto = params.getPageDto();
        List resList = null;
        if (pageDto != null) {
            Page page = PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize()).doSelectPage(() -> this.meetingCustomerInfoMapper.queryMajorCustomerList(bizId, params.getMeetingId(), params.getName()));
            pageDto.setCount(Integer.valueOf((int)page.getTotal()));
            resList = page.getResult();
        } else {
            resList = this.meetingCustomerInfoMapper.queryMajorCustomerList(bizId, params.getMeetingId(), params.getName());
        }
        return resList;
    }

    @Override
    public Map<Long, Integer> queryMajorCustomerCount(List<Long> meetingIds) {
        log.info("queryMajorCustomerCount  params: {}", meetingIds);
        return this.meetingCustomerMsgHitMapper.queryMeetingMajorCount(LoginUtils.getCurrentUserBizId(), meetingIds);
    }

    @Override
    public List<HitKeywordRes> queryMajorCustomerHitList(HitKeywordReq params) {
        log.info("query major customer hit list params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        List list = null;
        PageDto pageDto = params.getPageDto();
        if (pageDto != null) {
            Page page = PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize()).doSelectPage(() -> this.meetingCustomerMsgHitMapper.queryMsgHitList(bizId, params.getMeetingId(), params.getCustomerId()));
            pageDto.setCount(Integer.valueOf((int)page.getTotal()));
            list = page.getResult();
        } else {
            list = this.meetingCustomerMsgHitMapper.queryMsgHitList(bizId, params.getMeetingId(), params.getCustomerId());
        }
        ArrayList result = Lists.newArrayList();
        for (MeetingCustomerMsgHit msgHit : list) {
            HitKeywordRes res = new HitKeywordRes();
            res.setContent(msgHit.getContent());
            res.setChatTime(msgHit.getChatTime());
            res.setKeywords(Splitter.on((String)";").splitToList((CharSequence)msgHit.getKeywords()));
            result.add(res);
        }
        return result;
    }

    @Override
    public void exportMajorCustomerList(HttpServletResponse response, MajorCustomerReq params) {
        Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)params.getMeetingId());
        if (meeting == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u76f4\u64ad");
        }
        String fileName = meeting.getTitle() + "-\u91cd\u70b9\u5ba2\u6237.xlsx";
        try {
            List<MajorCustomerListRes> resList = this.queryMajorCustomerList(params);
            OutputStream fileWriter = this.getWebOutputStream(response, fileName);
            ArrayList heads = Lists.newArrayList();
            ArrayList head1 = Lists.newArrayList((Object[])new String[]{"\u5ba2\u6237\u540d\u79f0"});
            ArrayList head2 = Lists.newArrayList((Object[])new String[]{"\u547d\u4e2d\u5173\u952e\u8bcd\u6b21\u6570"});
            ArrayList head3 = Lists.newArrayList((Object[])new String[]{"\u624b\u673a\u53f7"});
            heads.add(head1);
            heads.add(head2);
            heads.add(head3);
            ArrayList table = Lists.newArrayList();
            for (MajorCustomerListRes res : resList) {
                ArrayList row = Lists.newArrayList();
                row.add(res.getName());
                row.add(res.getHitCount());
                row.add(res.getMobile());
                table.add(row);
            }
            ((ExcelWriterBuilder)EasyExcel.write((OutputStream)fileWriter).head((List)heads)).sheet("sheet").doWrite((Collection)table);
        }
        catch (Exception e) {
            log.error("export major customer list error: ", (Throwable)e);
        }
    }

    private OutputStream getWebOutputStream(HttpServletResponse response, String fileName) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", -1L);
        response.addHeader("Content-Disposition", "attachment; filename=\"" + new String(fileName.getBytes(), StandardCharsets.ISO_8859_1) + "\"");
        return response.getOutputStream();
    }
}

