/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.service.impl;

import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerInfo;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerParamEncryRelation;
import com.kuaike.scrm.dal.meeting.entity.MeetingPlaybackCustomerInfo;
import com.kuaike.scrm.dal.meeting.entity.MeetingSetting;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerParamEncryRelationMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingPlaybackCustomerInfoMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.meeting.dto.PlaybackLogDto;
import com.kuaike.scrm.meeting.service.MeetingPlaybackService;
import com.kuaike.scrm.service.MeetingSettingService;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MeetingPlaybackServiceImpl
implements MeetingPlaybackService {
    private static final Logger log = LoggerFactory.getLogger(MeetingPlaybackServiceImpl.class);
    @Value(value="${baijiayuncloud.pull.watchLog.url}")
    private String pullPlaybackUrl;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Autowired
    private MeetingSettingService meetingSettingService;
    @Autowired
    private IdGen idGen;
    @Resource
    private MeetingMapper meetingMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private MeetingPlaybackCustomerInfoMapper meetingPlaybackCustomerInfoMapper;
    @Resource
    private MeetingCustomerParamEncryRelationMapper meetingCustomerParamEncryRelationMapper;
    @Resource
    private MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    private final Map<Long, Map<String, List<String>>> bizRoomLogIdMap = Maps.newHashMap();

    @Override
    public void pullPlaybackInfo(Long bizId, Date curTime) {
        List<PlaybackLogDto> list;
        Date startTime = new Date(curTime.getTime() - 0x6DDD00L);
        Date endTime = new Date(curTime.getTime() - 3600000L);
        String startDay = DateUtil.dateToDateString((Date)startTime, (String)"yyyy-MM-dd");
        String endDay = DateUtil.dateToDateString((Date)endTime, (String)"yyyy-MM-dd");
        String startStr = DateUtil.dateToDateString((Date)startTime);
        String endStr = DateUtil.dateToDateString((Date)endTime);
        if (!startDay.equals(endDay)) {
            endStr = endDay + " 23:59:59";
        }
        if (CollectionUtils.isEmpty(list = this.getWatchLog(bizId, startStr, endStr))) {
            log.info("get watch log is empty");
            return;
        }
        Map roomLogIdMap = this.bizRoomLogIdMap.computeIfAbsent(bizId, k -> Maps.newHashMap());
        for (PlaybackLogDto logDto : list) {
            this.handleWatchLog(roomLogIdMap, logDto);
        }
        roomLogIdMap.clear();
        for (PlaybackLogDto logDto : list) {
            if (roomLogIdMap.containsKey(logDto.getRoomId())) {
                ((List)roomLogIdMap.get(logDto.getRoomId())).add(logDto.getGuid());
                continue;
            }
            roomLogIdMap.put(logDto.getRoomId(), Lists.newArrayList((Object[])new String[]{logDto.getGuid()}));
        }
    }

    @Override
    public void handleWatchLog(Map<String, List<String>> roomLogIdMap, PlaybackLogDto logDto) {
        String roomId = logDto.getRoomId();
        if (StringUtils.isBlank((CharSequence)roomId)) {
            log.info("handle watch log roomid is empty");
            return;
        }
        List<String> logIds = roomLogIdMap.get(roomId);
        if (CollectionUtils.isNotEmpty(logIds) && logIds.contains(logDto.getGuid())) {
            log.warn("last handle log is exists, logDto: {}", (Object)logDto);
            return;
        }
        List meetings = this.meetingMapper.selectByRoomIdUseMeeting(roomId);
        if (CollectionUtils.isEmpty((Collection)meetings)) {
            log.info("handle watch log meetings is empty");
            return;
        }
        Date curTime = new Date();
        for (Meeting meeting : meetings) {
            String bjyNumber = logDto.getUserNumber();
            MeetingPlaybackCustomerInfo customerInfo = this.meetingPlaybackCustomerInfoMapper.queryMeetingCustomer(meeting.getBizId(), meeting.getId(), bjyNumber);
            if (customerInfo == null) {
                WeworkContact contact;
                customerInfo = new MeetingPlaybackCustomerInfo();
                customerInfo.setNum(this.idGen.getNum());
                customerInfo.setBizId(meeting.getBizId());
                customerInfo.setMeetingId(meeting.getId());
                MeetingCustomerParamEncryRelation userInfo = this.meetingCustomerParamEncryRelationMapper.queryUserInfo(meeting.getBizId(), bjyNumber);
                if (userInfo == null) {
                    customerInfo.setAppId("");
                    customerInfo.setOpenId("");
                    customerInfo.setUnionId("");
                    customerInfo.setContactId("");
                } else {
                    Map channelMap;
                    customerInfo.setAppId(userInfo.getAppId());
                    customerInfo.setOpenId(userInfo.getOpenId());
                    customerInfo.setUnionId(userInfo.getUnionId());
                    customerInfo.setContactId(userInfo.getContactId());
                    customerInfo.setChannelId(userInfo.getChannelId());
                    if (customerInfo.getChannelId() != null && MapUtils.isNotEmpty((Map)(channelMap = this.channelMapper.selectIdAndNameByIds(meeting.getBizId(), (Collection)Lists.newArrayList((Object[])new Long[]{customerInfo.getChannelId()}))))) {
                        customerInfo.setChannelName((String)channelMap.get(customerInfo.getChannelId()));
                    }
                }
                customerInfo.setName(logDto.getUserName());
                if (StringUtils.isNotBlank((CharSequence)customerInfo.getContactId()) && (contact = this.weworkContactMapper.queryContactByContactId(meeting.getCorpId(), customerInfo.getContactId())) != null) {
                    customerInfo.setName(contact.getName());
                    customerInfo.setAvatar(contact.getAvatar());
                }
                String infoId = this.getInfoId(customerInfo.getAppId(), customerInfo.getOpenId(), customerInfo.getUnionId(), bjyNumber);
                customerInfo.setInfoId(infoId);
                customerInfo.setCustomerStr(bjyNumber);
                customerInfo.setBjyNumber(bjyNumber);
                customerInfo.setBjyMobile(this.getMobile(meeting.getBizId(), meeting.getId(), bjyNumber, customerInfo.getAppId(), customerInfo.getOpenId(), customerInfo.getUnionId(), customerInfo.getContactId()));
                customerInfo.setCreateTime(curTime);
                customerInfo.setUpdateTime(curTime);
                customerInfo.setTotalDuration(Integer.valueOf(logDto.getPlayLength()));
                customerInfo.setMaxDuration(Integer.valueOf(logDto.getPlayLength()));
                customerInfo.setArrivalTime(DateUtil.getDate((String)logDto.getPlayBeginTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                customerInfo.setQuitTime(DateUtil.getDate((String)logDto.getPlayEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                this.meetingPlaybackCustomerInfoMapper.insertSelective((Object)customerInfo);
                continue;
            }
            customerInfo.setTotalDuration(Integer.valueOf(customerInfo.getTotalDuration() + logDto.getPlayLength()));
            if (customerInfo.getMaxDuration() < logDto.getPlayLength()) {
                customerInfo.setMaxDuration(Integer.valueOf(logDto.getPlayLength()));
                customerInfo.setArrivalTime(DateUtil.getDate((String)logDto.getPlayBeginTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                customerInfo.setQuitTime(DateUtil.getDate((String)logDto.getPlayEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            customerInfo.setBjyMobile(this.getMobile(meeting.getBizId(), meeting.getId(), bjyNumber, customerInfo.getAppId(), customerInfo.getOpenId(), customerInfo.getUnionId(), customerInfo.getContactId()));
            customerInfo.setUpdateTime(curTime);
            this.meetingPlaybackCustomerInfoMapper.updateByPrimaryKeySelective((Object)customerInfo);
        }
    }

    @Override
    public List<PlaybackLogDto> getWatchLog(Long bizId, String startTime, String endTime) {
        HashMap params = Maps.newHashMap();
        params.put("start_time", startTime);
        params.put("end_time", endTime);
        List resultList = null;
        MeetingSetting setting = this.meetingSettingService.getSettingByBizId(bizId);
        if (setting == null || setting.getIsDeleted() == 1 || StringUtils.isBlank((CharSequence)setting.getBjyId())) {
            log.info("not config meetingSetting bizId: {}", (Object)bizId);
            return resultList;
        }
        try {
            JSONArray jsonArr;
            JSONObject result = this.bjyPartnerService.bjyPost(setting.getBjyId(), this.pullPlaybackUrl, (Map)params);
            log.info("get watch log bizId: {}, result: {}", (Object)bizId, (Object)result);
            JSONObject data = result.getJSONObject("data");
            if (data != null && (jsonArr = data.getJSONArray("list")) != null) {
                resultList = jsonArr.toJavaList(PlaybackLogDto.class);
            }
        }
        catch (Exception e) {
            log.error("get watch log error: ", (Throwable)e);
        }
        return resultList;
    }

    private String getInfoId(String appId, String openId, String unionId, String bjyNumber) {
        String infoId = bjyNumber;
        if (StringUtils.isNotBlank((CharSequence)unionId)) {
            infoId = unionId;
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{appId, openId})) {
            infoId = appId + unionId;
        }
        return infoId;
    }

    private String getMobile(Long bizId, Long meetingId, String bjyNumber, String appId, String openId, String unionId, String contactId) {
        MeetingCustomerInfo customerInfo;
        String mobile = "";
        if (MobileUtils.isPhone((String)bjyNumber)) {
            mobile = bjyNumber;
        }
        if (StringUtils.isBlank((CharSequence)mobile) && (customerInfo = this.meetingCustomerInfoMapper.queryCustomerByBjyNumber(bizId, meetingId, bjyNumber)) != null) {
            mobile = customerInfo.getBjyMobile();
        }
        if (StringUtils.isBlank((CharSequence)mobile)) {
            String customerNum;
            Map map;
            if (StringUtils.isNotBlank((CharSequence)contactId)) {
                List mobiles = this.ccCustomerNumService.getMobilesByContactId(bizId, contactId);
                if (CollectionUtils.isNotEmpty((Collection)mobiles)) {
                    mobile = (String)mobiles.get(0);
                }
            } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId, openId}) && MapUtils.isNotEmpty((Map)(map = this.ccCustomerNumService.getMobileByCustomerNums(bizId, (Collection)Lists.newArrayList((Object[])new String[]{customerNum = this.ccCustomerNumService.getCustomerNumByOfficialFans(bizId, appId, openId, unionId)}))))) {
                mobile = (String)map.get(customerNum);
            }
        }
        return mobile;
    }
}

