/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.call.dto.req.CallTaskReqDto;
import com.kuaike.scrm.common.dto.jsmsg.UniformMsgDto;
import com.kuaike.scrm.common.enums.JsMsgType;
import com.kuaike.scrm.common.enums.MeetingType;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.dal.meeting.dto.MeetingKeywordInfo;
import com.kuaike.scrm.dal.weworktag.dto.TagGroupParams;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchContactReq;
import com.kuaike.scrm.meeting.dto.request.MeetingGroupSendReq;
import com.kuaike.scrm.sms.dto.SmsTemplateReqDto;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class MeetingAddOrModReqDto {
    private Long id;
    private String title;
    private Integer type;
    private Date startTime;
    private Date endTime;
    private List<String> weworkUserNums;
    private Integer enableInviteCustomer;
    private MultiSearchContactReq selectParams;
    private List<UniformMsgDto> contentList;
    private Integer reportType;
    private String remind;
    private Integer remindType;
    private List<Date> remindDates;
    private List<TagGroupParams> subscribeTags;
    private List<TagGroupParams> joinLiveRoomTags;
    private List<String> reportWeworkUserNums;
    private String roomId;
    private Integer isPrivate;
    private Integer inviteInfoType;
    private List<String> studentUserIds;
    private Integer liveDeliverySwitch;
    private Integer liveDeliveryTemplate;
    private List<MeetingKeywordInfo> keywordGroups;
    private Integer keywordsNotifySwitch;
    private String keywordsNotifyTemplete;
    private Integer voiceNoticeDeadlineOn;
    private Integer groupSendDeadlineOn;
    private CallTaskReqDto callTaskReq;
    private MeetingGroupSendReq meetingGroupSendReq;
    private Integer orderSmsTemplateSwitch;
    private SmsTemplateReqDto orderSmsTemplate;

    public void validateParams() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.title), (Object)"\u4f1a\u8bae\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.type), (Object)"\u4f1a\u8bae\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.startTime), (Object)"\u4f1a\u8bae\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.endTime), (Object)"\u4f1a\u8bae\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.endTime.getTime() - this.startTime.getTime() > 900000L ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u65f6\u95f4\u4e0e\u5f00\u59cb\u65f6\u95f4\u95f4\u9694\u9700\u5927\u4e8e15\u5206\u949f");
        Preconditions.checkArgument((this.endTime.getTime() - this.startTime.getTime() < 86400000L ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u65f6\u95f4\u4e0e\u5f00\u59cb\u65f6\u95f4\u95f4\u9694\u9700\u5c0f\u4e8e24\u5c0f\u65f6");
        Preconditions.checkArgument((boolean)this.endTime.after(this.startTime), (Object)"\u4f1a\u8bae\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.weworkUserNums), (Object)"\u5171\u4eab\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.inviteInfoType), (Object)"\u9080\u8bf7\u4fe1\u606f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isNotEmpty(this.contentList)) {
            this.contentList.forEach(uniformMsgDto -> uniformMsgDto.validate());
            List meeting = this.contentList.stream().filter(uniformMsgDto -> uniformMsgDto.getMsgType().equals(JsMsgType.meeting.name())).collect(Collectors.toList());
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(meeting), (Object)"\u9080\u8bf7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.remind), (Object)"\u63d0\u9192\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.remindType), (Object)"\u63d0\u9192\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.remindDates), (Object)"\u63d0\u9192\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.isPrivate), (Object)"\u76f4\u64ad\u6559\u5ba4\u8fdb\u5165\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        if (NumberUtils.INTEGER_ONE.equals(this.type)) {
            Preconditions.checkArgument((boolean)Objects.nonNull(this.enableInviteCustomer), (Object)"\u662f\u5426\u5f00\u542f\u9080\u8bf7\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            if (NumberUtils.INTEGER_ONE.equals(this.enableInviteCustomer)) {
                Preconditions.checkArgument((boolean)Objects.nonNull(this.selectParams), (Object)"\u7b5b\u9009\u5ba2\u6237\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
                this.selectParams.validateAddParams();
            }
        }
        if (MeetingType.INTERNAL_MEETING.getValue() == this.type.intValue() && YnEnum.YES.getValue().equals(this.liveDeliverySwitch)) {
            throw new IllegalArgumentException("\u5185\u90e8\u4f1a\u8bae\u65e0\u6cd5\u521b\u5efa\u76f4\u64ad\u5e26\u8d27");
        }
        if (YnEnum.YES.getValue().equals(this.liveDeliverySwitch) && Objects.isNull(this.liveDeliveryTemplate)) {
            throw new IllegalArgumentException("\u76f4\u64ad\u95f4\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.nonNull(this.selectParams)) {
            this.selectParams.setRequestId("");
        }
    }

    public void validateModParams() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.id), (Object)"\u4f1a\u8baeid\u4e0d\u80fd\u4e3a\u7a7a");
        this.validateParams();
    }

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getType() {
        return this.type;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public List<String> getWeworkUserNums() {
        return this.weworkUserNums;
    }

    public Integer getEnableInviteCustomer() {
        return this.enableInviteCustomer;
    }

    public MultiSearchContactReq getSelectParams() {
        return this.selectParams;
    }

    public List<UniformMsgDto> getContentList() {
        return this.contentList;
    }

    public Integer getReportType() {
        return this.reportType;
    }

    public String getRemind() {
        return this.remind;
    }

    public Integer getRemindType() {
        return this.remindType;
    }

    public List<Date> getRemindDates() {
        return this.remindDates;
    }

    public List<TagGroupParams> getSubscribeTags() {
        return this.subscribeTags;
    }

    public List<TagGroupParams> getJoinLiveRoomTags() {
        return this.joinLiveRoomTags;
    }

    public List<String> getReportWeworkUserNums() {
        return this.reportWeworkUserNums;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public Integer getIsPrivate() {
        return this.isPrivate;
    }

    public Integer getInviteInfoType() {
        return this.inviteInfoType;
    }

    public List<String> getStudentUserIds() {
        return this.studentUserIds;
    }

    public Integer getLiveDeliverySwitch() {
        return this.liveDeliverySwitch;
    }

    public Integer getLiveDeliveryTemplate() {
        return this.liveDeliveryTemplate;
    }

    public List<MeetingKeywordInfo> getKeywordGroups() {
        return this.keywordGroups;
    }

    public Integer getKeywordsNotifySwitch() {
        return this.keywordsNotifySwitch;
    }

    public String getKeywordsNotifyTemplete() {
        return this.keywordsNotifyTemplete;
    }

    public Integer getVoiceNoticeDeadlineOn() {
        return this.voiceNoticeDeadlineOn;
    }

    public Integer getGroupSendDeadlineOn() {
        return this.groupSendDeadlineOn;
    }

    public CallTaskReqDto getCallTaskReq() {
        return this.callTaskReq;
    }

    public MeetingGroupSendReq getMeetingGroupSendReq() {
        return this.meetingGroupSendReq;
    }

    public Integer getOrderSmsTemplateSwitch() {
        return this.orderSmsTemplateSwitch;
    }

    public SmsTemplateReqDto getOrderSmsTemplate() {
        return this.orderSmsTemplate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setWeworkUserNums(List<String> weworkUserNums) {
        this.weworkUserNums = weworkUserNums;
    }

    public void setEnableInviteCustomer(Integer enableInviteCustomer) {
        this.enableInviteCustomer = enableInviteCustomer;
    }

    public void setSelectParams(MultiSearchContactReq selectParams) {
        this.selectParams = selectParams;
    }

    public void setContentList(List<UniformMsgDto> contentList) {
        this.contentList = contentList;
    }

    public void setReportType(Integer reportType) {
        this.reportType = reportType;
    }

    public void setRemind(String remind) {
        this.remind = remind;
    }

    public void setRemindType(Integer remindType) {
        this.remindType = remindType;
    }

    public void setRemindDates(List<Date> remindDates) {
        this.remindDates = remindDates;
    }

    public void setSubscribeTags(List<TagGroupParams> subscribeTags) {
        this.subscribeTags = subscribeTags;
    }

    public void setJoinLiveRoomTags(List<TagGroupParams> joinLiveRoomTags) {
        this.joinLiveRoomTags = joinLiveRoomTags;
    }

    public void setReportWeworkUserNums(List<String> reportWeworkUserNums) {
        this.reportWeworkUserNums = reportWeworkUserNums;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public void setIsPrivate(Integer isPrivate) {
        this.isPrivate = isPrivate;
    }

    public void setInviteInfoType(Integer inviteInfoType) {
        this.inviteInfoType = inviteInfoType;
    }

    public void setStudentUserIds(List<String> studentUserIds) {
        this.studentUserIds = studentUserIds;
    }

    public void setLiveDeliverySwitch(Integer liveDeliverySwitch) {
        this.liveDeliverySwitch = liveDeliverySwitch;
    }

    public void setLiveDeliveryTemplate(Integer liveDeliveryTemplate) {
        this.liveDeliveryTemplate = liveDeliveryTemplate;
    }

    public void setKeywordGroups(List<MeetingKeywordInfo> keywordGroups) {
        this.keywordGroups = keywordGroups;
    }

    public void setKeywordsNotifySwitch(Integer keywordsNotifySwitch) {
        this.keywordsNotifySwitch = keywordsNotifySwitch;
    }

    public void setKeywordsNotifyTemplete(String keywordsNotifyTemplete) {
        this.keywordsNotifyTemplete = keywordsNotifyTemplete;
    }

    public void setVoiceNoticeDeadlineOn(Integer voiceNoticeDeadlineOn) {
        this.voiceNoticeDeadlineOn = voiceNoticeDeadlineOn;
    }

    public void setGroupSendDeadlineOn(Integer groupSendDeadlineOn) {
        this.groupSendDeadlineOn = groupSendDeadlineOn;
    }

    public void setCallTaskReq(CallTaskReqDto callTaskReq) {
        this.callTaskReq = callTaskReq;
    }

    public void setMeetingGroupSendReq(MeetingGroupSendReq meetingGroupSendReq) {
        this.meetingGroupSendReq = meetingGroupSendReq;
    }

    public void setOrderSmsTemplateSwitch(Integer orderSmsTemplateSwitch) {
        this.orderSmsTemplateSwitch = orderSmsTemplateSwitch;
    }

    public void setOrderSmsTemplate(SmsTemplateReqDto orderSmsTemplate) {
        this.orderSmsTemplate = orderSmsTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeetingAddOrModReqDto)) {
            return false;
        }
        MeetingAddOrModReqDto other = (MeetingAddOrModReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$enableInviteCustomer = this.getEnableInviteCustomer();
        Integer other$enableInviteCustomer = other.getEnableInviteCustomer();
        if (this$enableInviteCustomer == null ? other$enableInviteCustomer != null : !((Object)this$enableInviteCustomer).equals(other$enableInviteCustomer)) {
            return false;
        }
        Integer this$reportType = this.getReportType();
        Integer other$reportType = other.getReportType();
        if (this$reportType == null ? other$reportType != null : !((Object)this$reportType).equals(other$reportType)) {
            return false;
        }
        Integer this$remindType = this.getRemindType();
        Integer other$remindType = other.getRemindType();
        if (this$remindType == null ? other$remindType != null : !((Object)this$remindType).equals(other$remindType)) {
            return false;
        }
        Integer this$isPrivate = this.getIsPrivate();
        Integer other$isPrivate = other.getIsPrivate();
        if (this$isPrivate == null ? other$isPrivate != null : !((Object)this$isPrivate).equals(other$isPrivate)) {
            return false;
        }
        Integer this$inviteInfoType = this.getInviteInfoType();
        Integer other$inviteInfoType = other.getInviteInfoType();
        if (this$inviteInfoType == null ? other$inviteInfoType != null : !((Object)this$inviteInfoType).equals(other$inviteInfoType)) {
            return false;
        }
        Integer this$liveDeliverySwitch = this.getLiveDeliverySwitch();
        Integer other$liveDeliverySwitch = other.getLiveDeliverySwitch();
        if (this$liveDeliverySwitch == null ? other$liveDeliverySwitch != null : !((Object)this$liveDeliverySwitch).equals(other$liveDeliverySwitch)) {
            return false;
        }
        Integer this$liveDeliveryTemplate = this.getLiveDeliveryTemplate();
        Integer other$liveDeliveryTemplate = other.getLiveDeliveryTemplate();
        if (this$liveDeliveryTemplate == null ? other$liveDeliveryTemplate != null : !((Object)this$liveDeliveryTemplate).equals(other$liveDeliveryTemplate)) {
            return false;
        }
        Integer this$keywordsNotifySwitch = this.getKeywordsNotifySwitch();
        Integer other$keywordsNotifySwitch = other.getKeywordsNotifySwitch();
        if (this$keywordsNotifySwitch == null ? other$keywordsNotifySwitch != null : !((Object)this$keywordsNotifySwitch).equals(other$keywordsNotifySwitch)) {
            return false;
        }
        Integer this$voiceNoticeDeadlineOn = this.getVoiceNoticeDeadlineOn();
        Integer other$voiceNoticeDeadlineOn = other.getVoiceNoticeDeadlineOn();
        if (this$voiceNoticeDeadlineOn == null ? other$voiceNoticeDeadlineOn != null : !((Object)this$voiceNoticeDeadlineOn).equals(other$voiceNoticeDeadlineOn)) {
            return false;
        }
        Integer this$groupSendDeadlineOn = this.getGroupSendDeadlineOn();
        Integer other$groupSendDeadlineOn = other.getGroupSendDeadlineOn();
        if (this$groupSendDeadlineOn == null ? other$groupSendDeadlineOn != null : !((Object)this$groupSendDeadlineOn).equals(other$groupSendDeadlineOn)) {
            return false;
        }
        Integer this$orderSmsTemplateSwitch = this.getOrderSmsTemplateSwitch();
        Integer other$orderSmsTemplateSwitch = other.getOrderSmsTemplateSwitch();
        if (this$orderSmsTemplateSwitch == null ? other$orderSmsTemplateSwitch != null : !((Object)this$orderSmsTemplateSwitch).equals(other$orderSmsTemplateSwitch)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        List<String> this$weworkUserNums = this.getWeworkUserNums();
        List<String> other$weworkUserNums = other.getWeworkUserNums();
        if (this$weworkUserNums == null ? other$weworkUserNums != null : !((Object)this$weworkUserNums).equals(other$weworkUserNums)) {
            return false;
        }
        MultiSearchContactReq this$selectParams = this.getSelectParams();
        MultiSearchContactReq other$selectParams = other.getSelectParams();
        if (this$selectParams == null ? other$selectParams != null : !this$selectParams.equals(other$selectParams)) {
            return false;
        }
        List<UniformMsgDto> this$contentList = this.getContentList();
        List<UniformMsgDto> other$contentList = other.getContentList();
        if (this$contentList == null ? other$contentList != null : !((Object)this$contentList).equals(other$contentList)) {
            return false;
        }
        String this$remind = this.getRemind();
        String other$remind = other.getRemind();
        if (this$remind == null ? other$remind != null : !this$remind.equals(other$remind)) {
            return false;
        }
        List<Date> this$remindDates = this.getRemindDates();
        List<Date> other$remindDates = other.getRemindDates();
        if (this$remindDates == null ? other$remindDates != null : !((Object)this$remindDates).equals(other$remindDates)) {
            return false;
        }
        List<TagGroupParams> this$subscribeTags = this.getSubscribeTags();
        List<TagGroupParams> other$subscribeTags = other.getSubscribeTags();
        if (this$subscribeTags == null ? other$subscribeTags != null : !((Object)this$subscribeTags).equals(other$subscribeTags)) {
            return false;
        }
        List<TagGroupParams> this$joinLiveRoomTags = this.getJoinLiveRoomTags();
        List<TagGroupParams> other$joinLiveRoomTags = other.getJoinLiveRoomTags();
        if (this$joinLiveRoomTags == null ? other$joinLiveRoomTags != null : !((Object)this$joinLiveRoomTags).equals(other$joinLiveRoomTags)) {
            return false;
        }
        List<String> this$reportWeworkUserNums = this.getReportWeworkUserNums();
        List<String> other$reportWeworkUserNums = other.getReportWeworkUserNums();
        if (this$reportWeworkUserNums == null ? other$reportWeworkUserNums != null : !((Object)this$reportWeworkUserNums).equals(other$reportWeworkUserNums)) {
            return false;
        }
        String this$roomId = this.getRoomId();
        String other$roomId = other.getRoomId();
        if (this$roomId == null ? other$roomId != null : !this$roomId.equals(other$roomId)) {
            return false;
        }
        List<String> this$studentUserIds = this.getStudentUserIds();
        List<String> other$studentUserIds = other.getStudentUserIds();
        if (this$studentUserIds == null ? other$studentUserIds != null : !((Object)this$studentUserIds).equals(other$studentUserIds)) {
            return false;
        }
        List<MeetingKeywordInfo> this$keywordGroups = this.getKeywordGroups();
        List<MeetingKeywordInfo> other$keywordGroups = other.getKeywordGroups();
        if (this$keywordGroups == null ? other$keywordGroups != null : !((Object)this$keywordGroups).equals(other$keywordGroups)) {
            return false;
        }
        String this$keywordsNotifyTemplete = this.getKeywordsNotifyTemplete();
        String other$keywordsNotifyTemplete = other.getKeywordsNotifyTemplete();
        if (this$keywordsNotifyTemplete == null ? other$keywordsNotifyTemplete != null : !this$keywordsNotifyTemplete.equals(other$keywordsNotifyTemplete)) {
            return false;
        }
        CallTaskReqDto this$callTaskReq = this.getCallTaskReq();
        CallTaskReqDto other$callTaskReq = other.getCallTaskReq();
        if (this$callTaskReq == null ? other$callTaskReq != null : !this$callTaskReq.equals(other$callTaskReq)) {
            return false;
        }
        MeetingGroupSendReq this$meetingGroupSendReq = this.getMeetingGroupSendReq();
        MeetingGroupSendReq other$meetingGroupSendReq = other.getMeetingGroupSendReq();
        if (this$meetingGroupSendReq == null ? other$meetingGroupSendReq != null : !((Object)this$meetingGroupSendReq).equals(other$meetingGroupSendReq)) {
            return false;
        }
        SmsTemplateReqDto this$orderSmsTemplate = this.getOrderSmsTemplate();
        SmsTemplateReqDto other$orderSmsTemplate = other.getOrderSmsTemplate();
        return !(this$orderSmsTemplate == null ? other$orderSmsTemplate != null : !this$orderSmsTemplate.equals(other$orderSmsTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MeetingAddOrModReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $enableInviteCustomer = this.getEnableInviteCustomer();
        result = result * 59 + ($enableInviteCustomer == null ? 43 : ((Object)$enableInviteCustomer).hashCode());
        Integer $reportType = this.getReportType();
        result = result * 59 + ($reportType == null ? 43 : ((Object)$reportType).hashCode());
        Integer $remindType = this.getRemindType();
        result = result * 59 + ($remindType == null ? 43 : ((Object)$remindType).hashCode());
        Integer $isPrivate = this.getIsPrivate();
        result = result * 59 + ($isPrivate == null ? 43 : ((Object)$isPrivate).hashCode());
        Integer $inviteInfoType = this.getInviteInfoType();
        result = result * 59 + ($inviteInfoType == null ? 43 : ((Object)$inviteInfoType).hashCode());
        Integer $liveDeliverySwitch = this.getLiveDeliverySwitch();
        result = result * 59 + ($liveDeliverySwitch == null ? 43 : ((Object)$liveDeliverySwitch).hashCode());
        Integer $liveDeliveryTemplate = this.getLiveDeliveryTemplate();
        result = result * 59 + ($liveDeliveryTemplate == null ? 43 : ((Object)$liveDeliveryTemplate).hashCode());
        Integer $keywordsNotifySwitch = this.getKeywordsNotifySwitch();
        result = result * 59 + ($keywordsNotifySwitch == null ? 43 : ((Object)$keywordsNotifySwitch).hashCode());
        Integer $voiceNoticeDeadlineOn = this.getVoiceNoticeDeadlineOn();
        result = result * 59 + ($voiceNoticeDeadlineOn == null ? 43 : ((Object)$voiceNoticeDeadlineOn).hashCode());
        Integer $groupSendDeadlineOn = this.getGroupSendDeadlineOn();
        result = result * 59 + ($groupSendDeadlineOn == null ? 43 : ((Object)$groupSendDeadlineOn).hashCode());
        Integer $orderSmsTemplateSwitch = this.getOrderSmsTemplateSwitch();
        result = result * 59 + ($orderSmsTemplateSwitch == null ? 43 : ((Object)$orderSmsTemplateSwitch).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        List<String> $weworkUserNums = this.getWeworkUserNums();
        result = result * 59 + ($weworkUserNums == null ? 43 : ((Object)$weworkUserNums).hashCode());
        MultiSearchContactReq $selectParams = this.getSelectParams();
        result = result * 59 + ($selectParams == null ? 43 : $selectParams.hashCode());
        List<UniformMsgDto> $contentList = this.getContentList();
        result = result * 59 + ($contentList == null ? 43 : ((Object)$contentList).hashCode());
        String $remind = this.getRemind();
        result = result * 59 + ($remind == null ? 43 : $remind.hashCode());
        List<Date> $remindDates = this.getRemindDates();
        result = result * 59 + ($remindDates == null ? 43 : ((Object)$remindDates).hashCode());
        List<TagGroupParams> $subscribeTags = this.getSubscribeTags();
        result = result * 59 + ($subscribeTags == null ? 43 : ((Object)$subscribeTags).hashCode());
        List<TagGroupParams> $joinLiveRoomTags = this.getJoinLiveRoomTags();
        result = result * 59 + ($joinLiveRoomTags == null ? 43 : ((Object)$joinLiveRoomTags).hashCode());
        List<String> $reportWeworkUserNums = this.getReportWeworkUserNums();
        result = result * 59 + ($reportWeworkUserNums == null ? 43 : ((Object)$reportWeworkUserNums).hashCode());
        String $roomId = this.getRoomId();
        result = result * 59 + ($roomId == null ? 43 : $roomId.hashCode());
        List<String> $studentUserIds = this.getStudentUserIds();
        result = result * 59 + ($studentUserIds == null ? 43 : ((Object)$studentUserIds).hashCode());
        List<MeetingKeywordInfo> $keywordGroups = this.getKeywordGroups();
        result = result * 59 + ($keywordGroups == null ? 43 : ((Object)$keywordGroups).hashCode());
        String $keywordsNotifyTemplete = this.getKeywordsNotifyTemplete();
        result = result * 59 + ($keywordsNotifyTemplete == null ? 43 : $keywordsNotifyTemplete.hashCode());
        CallTaskReqDto $callTaskReq = this.getCallTaskReq();
        result = result * 59 + ($callTaskReq == null ? 43 : $callTaskReq.hashCode());
        MeetingGroupSendReq $meetingGroupSendReq = this.getMeetingGroupSendReq();
        result = result * 59 + ($meetingGroupSendReq == null ? 43 : ((Object)$meetingGroupSendReq).hashCode());
        SmsTemplateReqDto $orderSmsTemplate = this.getOrderSmsTemplate();
        result = result * 59 + ($orderSmsTemplate == null ? 43 : $orderSmsTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "MeetingAddOrModReqDto(id=" + this.getId() + ", title=" + this.getTitle() + ", type=" + this.getType() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", weworkUserNums=" + this.getWeworkUserNums() + ", enableInviteCustomer=" + this.getEnableInviteCustomer() + ", selectParams=" + this.getSelectParams() + ", contentList=" + this.getContentList() + ", reportType=" + this.getReportType() + ", remind=" + this.getRemind() + ", remindType=" + this.getRemindType() + ", remindDates=" + this.getRemindDates() + ", subscribeTags=" + this.getSubscribeTags() + ", joinLiveRoomTags=" + this.getJoinLiveRoomTags() + ", reportWeworkUserNums=" + this.getReportWeworkUserNums() + ", roomId=" + this.getRoomId() + ", isPrivate=" + this.getIsPrivate() + ", inviteInfoType=" + this.getInviteInfoType() + ", studentUserIds=" + this.getStudentUserIds() + ", liveDeliverySwitch=" + this.getLiveDeliverySwitch() + ", liveDeliveryTemplate=" + this.getLiveDeliveryTemplate() + ", keywordGroups=" + this.getKeywordGroups() + ", keywordsNotifySwitch=" + this.getKeywordsNotifySwitch() + ", keywordsNotifyTemplete=" + this.getKeywordsNotifyTemplete() + ", voiceNoticeDeadlineOn=" + this.getVoiceNoticeDeadlineOn() + ", groupSendDeadlineOn=" + this.getGroupSendDeadlineOn() + ", callTaskReq=" + this.getCallTaskReq() + ", meetingGroupSendReq=" + this.getMeetingGroupSendReq() + ", orderSmsTemplateSwitch=" + this.getOrderSmsTemplateSwitch() + ", orderSmsTemplate=" + this.getOrderSmsTemplate() + ")";
    }
}

