/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.enums.MeetingSource;
import com.kuaike.scrm.dal.meeting.dto.QueryJoinMeetingParam;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class JoinMeetingReqDto {
    private Long meetingId;
    private String weworkUserNum;
    private Integer joinStatus;
    private Integer sendStatus;
    private PageDto pageDto;
    private String source;
    private static final String FROM_WEWORK_USER = "\u4f01\u4e1a\u5fae\u4fe1\u597d\u53cb";
    public static final String FROM_OTHER_CHANNEL = "\u5176\u4ed6\u5916\u90e8\u9080\u8bf7";

    public void validate() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.meetingId), (Object)"\u4f1a\u8baeid\u9519\u8bef");
    }

    public QueryJoinMeetingParam convertToParam(Long bizId, String corpId) {
        QueryJoinMeetingParam param = new QueryJoinMeetingParam();
        param.setBizId(bizId);
        param.setCorpId(corpId);
        param.setMeetingId(this.meetingId);
        param.setJoinStatus(this.joinStatus);
        param.setSendStatus(this.sendStatus);
        param.setWeworkUserNum(this.weworkUserNum);
        if (StringUtils.isNotBlank((CharSequence)this.source)) {
            if (FROM_WEWORK_USER.contains(this.source)) {
                param.setSourceType(Integer.valueOf(MeetingSource.WEWORK_FRIEND.getValue()));
            } else if (FROM_OTHER_CHANNEL.contains(this.source)) {
                param.setSourceType(Integer.valueOf(MeetingSource.OTHER_EXTERNAL.getValue()));
            } else {
                param.setSource(this.source);
            }
        }
        if (Objects.nonNull(this.pageDto)) {
            param.setOffset(Integer.valueOf((this.pageDto.getPageNum() - 1) * this.pageDto.getPageSize()));
            param.setLimit(this.pageDto.getPageSize());
        }
        return param;
    }

    public Long getMeetingId() {
        return this.meetingId;
    }

    public String getWeworkUserNum() {
        return this.weworkUserNum;
    }

    public Integer getJoinStatus() {
        return this.joinStatus;
    }

    public Integer getSendStatus() {
        return this.sendStatus;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public String getSource() {
        return this.source;
    }

    public void setMeetingId(Long meetingId) {
        this.meetingId = meetingId;
    }

    public void setWeworkUserNum(String weworkUserNum) {
        this.weworkUserNum = weworkUserNum;
    }

    public void setJoinStatus(Integer joinStatus) {
        this.joinStatus = joinStatus;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinMeetingReqDto)) {
            return false;
        }
        JoinMeetingReqDto other = (JoinMeetingReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$meetingId = this.getMeetingId();
        Long other$meetingId = other.getMeetingId();
        if (this$meetingId == null ? other$meetingId != null : !((Object)this$meetingId).equals(other$meetingId)) {
            return false;
        }
        Integer this$joinStatus = this.getJoinStatus();
        Integer other$joinStatus = other.getJoinStatus();
        if (this$joinStatus == null ? other$joinStatus != null : !((Object)this$joinStatus).equals(other$joinStatus)) {
            return false;
        }
        Integer this$sendStatus = this.getSendStatus();
        Integer other$sendStatus = other.getSendStatus();
        if (this$sendStatus == null ? other$sendStatus != null : !((Object)this$sendStatus).equals(other$sendStatus)) {
            return false;
        }
        String this$weworkUserNum = this.getWeworkUserNum();
        String other$weworkUserNum = other.getWeworkUserNum();
        if (this$weworkUserNum == null ? other$weworkUserNum != null : !this$weworkUserNum.equals(other$weworkUserNum)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        if (this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JoinMeetingReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $meetingId = this.getMeetingId();
        result = result * 59 + ($meetingId == null ? 43 : ((Object)$meetingId).hashCode());
        Integer $joinStatus = this.getJoinStatus();
        result = result * 59 + ($joinStatus == null ? 43 : ((Object)$joinStatus).hashCode());
        Integer $sendStatus = this.getSendStatus();
        result = result * 59 + ($sendStatus == null ? 43 : ((Object)$sendStatus).hashCode());
        String $weworkUserNum = this.getWeworkUserNum();
        result = result * 59 + ($weworkUserNum == null ? 43 : $weworkUserNum.hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }

    public String toString() {
        return "JoinMeetingReqDto(meetingId=" + this.getMeetingId() + ", weworkUserNum=" + this.getWeworkUserNum() + ", joinStatus=" + this.getJoinStatus() + ", sendStatus=" + this.getSendStatus() + ", pageDto=" + this.getPageDto() + ", source=" + this.getSource() + ")";
    }
}

