/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.material.service.impl;

import cn.kinyun.wework.sdk.api.WwMaterialApi;
import cn.kinyun.wework.sdk.entity.material.UploadMaterialResult;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.material.dto.QueryMaterialParam;
import com.kuaike.scrm.dal.material.entity.MaterialManage;
import com.kuaike.scrm.dal.material.entity.WeworkUploadMaterial;
import com.kuaike.scrm.dal.material.mapper.MaterialManageMapper;
import com.kuaike.scrm.dal.material.mapper.WeworkUploadMaterialMapper;
import com.kuaike.scrm.material.dto.request.AddMaterialReqDto;
import com.kuaike.scrm.material.dto.request.DelMaterialReqDto;
import com.kuaike.scrm.material.dto.request.MaterialReqDto;
import com.kuaike.scrm.material.dto.request.ModMaterialReqDto;
import com.kuaike.scrm.material.dto.request.QueryMaterialReqDto;
import com.kuaike.scrm.material.dto.response.MaterialListRespDto;
import com.kuaike.scrm.material.dto.response.MaterialRespDto;
import com.kuaike.scrm.material.service.MaterialManagerService;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MaterialManagerServiceImpl
implements MaterialManagerService {
    private static final Logger log = LoggerFactory.getLogger(MaterialManagerServiceImpl.class);
    private static final String TEMP_FILE_DIR = "./temp/";
    @Autowired
    private MaterialManageMapper materialManageMapper;
    @Resource
    private WeworkUploadMaterialMapper weworkUploadMaterialMapper;
    @Autowired
    private WwMaterialApi wwMaterialApi;
    @Autowired
    private CustomizedTokenService customizedTokenService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(AddMaterialReqDto reqDto) {
        log.info("add: reqDto:{}", (Object)reqDto);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("add: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        this.baseValidate(userInfo);
        reqDto.validate();
        List<MaterialReqDto> materialReqDtoList = reqDto.getMaterialReqDtoList();
        Set fileUrlSet = materialReqDtoList.stream().map(MaterialReqDto::getFileUrl).collect(Collectors.toSet());
        Map unExpireUrlAndIdsMap = this.weworkUploadMaterialMapper.queryUnExpireUrlAndIds(userInfo.getBizId(), userInfo.getCorpId(), fileUrlSet);
        ArrayList addUploadMaterialList = Lists.newArrayList();
        for (MaterialReqDto dto : materialReqDtoList) {
            if (unExpireUrlAndIdsMap.containsKey(dto.getFileUrl())) continue;
            String mediaId = this.getMaterialId(userInfo.getCorpId(), dto.getFileUrl(), dto.getType(), dto.getFileName());
            if (Objects.nonNull(mediaId)) {
                WeworkUploadMaterial uploadMaterial = this.buildUploadMaterial(userInfo, dto.getFileUrl(), mediaId, dto.getType(), dto.getFileName());
                addUploadMaterialList.add(uploadMaterial);
                continue;
            }
            log.warn("add: mediaId is null, fileUrl:{}, type{}", (Object)dto.getFileUrl(), (Object)dto.getType());
        }
        if (CollectionUtils.isNotEmpty((Collection)addUploadMaterialList)) {
            this.weworkUploadMaterialMapper.batchInsert((List)addUploadMaterialList);
        }
        Map newUnExpireUrlAndIdsMap = this.weworkUploadMaterialMapper.queryUnExpireUrlAndIds(userInfo.getBizId(), userInfo.getCorpId(), fileUrlSet);
        List<Object> addMaterialManageList = Lists.newArrayList();
        for (MaterialReqDto dto : materialReqDtoList) {
            Long materialId = (Long)newUnExpireUrlAndIdsMap.get(dto.getFileUrl());
            if (!Objects.nonNull(materialId)) continue;
            MaterialManage materialManage = this.buildMaterialManage(userInfo, reqDto, dto, materialId);
            addMaterialManageList.add(materialManage);
        }
        Set existsUrls = this.materialManageMapper.queryExistsUrls((Collection)addMaterialManageList);
        if (CollectionUtils.isNotEmpty((Collection)(addMaterialManageList = addMaterialManageList.stream().filter(a -> !existsUrls.contains(a.getFileUrl())).collect(Collectors.toList())))) {
            this.materialManageMapper.batchInsert((List)addMaterialManageList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mod(ModMaterialReqDto modMaterialReqDto) {
        log.info("mod: modMaterialReqDto: {}", (Object)modMaterialReqDto);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("mod: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        modMaterialReqDto.validate();
        this.materialManageMapper.updateByFk(userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId(), modMaterialReqDto.getFkId(), modMaterialReqDto.getFkType(), modMaterialReqDto.getStartTime(), modMaterialReqDto.getEndTime());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(DelMaterialReqDto reqDto) {
        log.info("delete: reqDto: {}", (Object)reqDto);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("delete: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        this.baseValidate(userInfo);
        reqDto.validate();
        List<MaterialReqDto> materialReqDtoList = reqDto.getMaterialReqDtoList();
        Set delFileUrls = null;
        if (CollectionUtils.isNotEmpty(materialReqDtoList)) {
            delFileUrls = materialReqDtoList.stream().map(MaterialReqDto::getFileUrl).collect(Collectors.toSet());
        }
        this.materialManageMapper.batchDelete(userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId(), reqDto.getFkId(), reqDto.getFkType(), delFileUrls);
    }

    @Override
    public List<MaterialListRespDto> query(Long bizId, String corpId, List<QueryMaterialReqDto> reqDtos) {
        log.info("query: bizId:{}, corpId:{}, reqDtos:{}", new Object[]{bizId, corpId, reqDtos});
        Preconditions.checkArgument((boolean)Objects.nonNull(bizId), (Object)"\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)corpId), (Object)"corpId\u4e0d\u80fd\u4e3a\u7a7a");
        this.validate(reqDtos);
        ArrayList params = Lists.newArrayList();
        for (QueryMaterialReqDto dto : reqDtos) {
            QueryMaterialParam param = QueryMaterialParam.build((Long)dto.getFkId(), (Integer)dto.getFkType());
            params.add(param);
        }
        List materialManageList = this.materialManageMapper.queryListByFks(bizId, corpId, (Collection)params);
        if (CollectionUtils.isEmpty((Collection)materialManageList)) {
            log.info("query: \u65e0\u6cd5\u67e5\u8be2\u5230\u7d20\u6750:{}", reqDtos);
            return Collections.emptyList();
        }
        Map<String, List<MaterialManage>> manageMap = materialManageList.stream().collect(Collectors.groupingBy(item -> this.buildKey(item.getFkId(), item.getFkType())));
        Set materialIds = materialManageList.stream().map(MaterialManage::getMaterialId).collect(Collectors.toSet());
        List uploadMaterials = this.weworkUploadMaterialMapper.queryListById(bizId, corpId, materialIds);
        Map<Long, WeworkUploadMaterial> materialMap = uploadMaterials.stream().collect(Collectors.toMap(WeworkUploadMaterial::getId, a -> a, (k1, k2) -> k2));
        ArrayList respDtos = Lists.newArrayList();
        for (Map.Entry<String, List<MaterialManage>> entry : manageMap.entrySet()) {
            String key = entry.getKey();
            Long fkId = Long.valueOf(key.split("_")[0]);
            Integer fkType = Integer.valueOf(key.split("_")[1]);
            List<MaterialManage> materialManages = entry.getValue();
            ArrayList respDtoList = Lists.newArrayList();
            for (MaterialManage manage : materialManages) {
                WeworkUploadMaterial material = materialMap.get(manage.getMaterialId());
                if (!Objects.nonNull(material)) continue;
                MaterialRespDto respDto = MaterialRespDto.build(material);
                respDtoList.add(respDto);
            }
            MaterialListRespDto respDto = MaterialListRespDto.build(fkId, fkType, respDtoList);
            respDtos.add(respDto);
        }
        return respDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void refreshMaterial() {
        log.info("refreshMaterial:");
        List expireUrlAndTypeList = this.weworkUploadMaterialMapper.queryExpireUrls(new Date());
        ArrayList updateMediaIdList = Lists.newArrayList();
        for (WeworkUploadMaterial material : expireUrlAndTypeList) {
            WeworkUploadMaterial uploadMaterial = new WeworkUploadMaterial();
            String mediaId = this.getMaterialId(material.getCorpId(), material.getFileUrl(), material.getType(), material.getFileName());
            if (!StringUtils.isNotBlank((CharSequence)mediaId)) continue;
            uploadMaterial.setMediaId(mediaId);
            uploadMaterial.setFileUrl(material.getFileUrl());
            Date expireTime = DateUtil.getDateAddDay((Date)new Date(), (int)2);
            uploadMaterial.setExpireTime(expireTime);
            uploadMaterial.setId(material.getId());
            updateMediaIdList.add(uploadMaterial);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateMediaIdList)) {
            this.weworkUploadMaterialMapper.batchUpdate((Collection)updateMediaIdList);
        }
        log.info("refreshMaterial: end");
    }

    private void validate(List<QueryMaterialReqDto> reqDtos) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(reqDtos), (Object)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (QueryMaterialReqDto dto : reqDtos) {
            dto.validate();
        }
    }

    private void baseValidate(CurrentUserInfo currentUserInfo) {
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private MaterialManage buildMaterialManage(CurrentUserInfo userInfo, AddMaterialReqDto addDto, MaterialReqDto reqDto, Long materialId) {
        MaterialManage materialManage = new MaterialManage();
        materialManage.setBizId(userInfo.getBizId());
        materialManage.setCorpId(userInfo.getCorpId());
        materialManage.setCreateBy(userInfo.getId());
        materialManage.setCreateTime(new Date());
        materialManage.setUpdateBy(userInfo.getId());
        materialManage.setUpdateTime(new Date());
        materialManage.setIsDeleted(NumberUtils.INTEGER_ZERO);
        materialManage.setMaterialId(materialId);
        materialManage.setFkId(addDto.getFkId());
        materialManage.setFkType(addDto.getFkType());
        materialManage.setFileUrl(reqDto.getFileUrl());
        materialManage.setType(reqDto.getType());
        materialManage.setStartTime(addDto.getStartTime());
        materialManage.setEndTime(addDto.getEndTime());
        materialManage.setFileName(reqDto.getFileName());
        return materialManage;
    }

    @Override
    public String getMediaId(Long bizId, String corpId, String fileUrl, String type) {
        return this.getMediaId(bizId, corpId, fileUrl, null, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMediaId(Long bizId, String corpId, String fileUrl, String fileName, String type) {
        int index;
        WeworkUploadMaterial uploadMaterial = this.weworkUploadMaterialMapper.queryUploadMaterial(bizId, corpId, fileUrl);
        String mediaId = null;
        if (uploadMaterial != null && StringUtils.isNotBlank((CharSequence)uploadMaterial.getMediaId()) && uploadMaterial.getExpireTime().after(new Date())) {
            return uploadMaterial.getMediaId();
        }
        String tempFileName = StringUtils.isBlank((CharSequence)fileName) ? ((index = fileUrl.lastIndexOf(47)) > -1 ? fileUrl.substring(index + 1) : fileUrl) : fileName.trim();
        String parentPath = TEMP_FILE_DIR + UUID.randomUUID();
        String tempFilePath = parentPath + File.separatorChar + tempFileName;
        log.info("parentPath:{}", (Object)parentPath);
        File tempFile = null;
        try {
            File folder = new File(parentPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            URL url = new URL(fileUrl);
            tempFile = new File(tempFilePath);
            FileUtils.copyURLToFile((URL)url, (File)tempFile);
            String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                log.warn("access_token is empty");
                String string = null;
                return string;
            }
            UploadMaterialResult uploadMaterialResult = this.wwMaterialApi.uploadMaterial(accessToken, type, tempFile);
            mediaId = uploadMaterialResult.getMediaId();
            this.saveUploadMaterialLog(bizId, corpId, fileUrl, mediaId, type);
        }
        catch (IOException e) {
            log.error("getMediaId error", (Throwable)e);
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
        return mediaId;
    }

    @Override
    public String getBillboardMediaId(Long bizId, String corpId, String fileUlr, String type, File file) {
        WeworkUploadMaterial uploadMaterial = this.weworkUploadMaterialMapper.queryUploadMaterial(bizId, corpId, fileUlr);
        String mediaId = null;
        if (uploadMaterial != null && StringUtils.isNotBlank((CharSequence)uploadMaterial.getMediaId()) && uploadMaterial.getExpireTime().after(new Date())) {
            return uploadMaterial.getMediaId();
        }
        try {
            String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                log.warn("access_token is empty");
                return null;
            }
            UploadMaterialResult uploadMaterialResult = this.wwMaterialApi.uploadMaterial(accessToken, type, file);
            mediaId = uploadMaterialResult.getMediaId();
            this.saveUploadMaterialLog(bizId, corpId, fileUlr, mediaId, type);
        }
        catch (IOException e) {
            log.error("getMediaId error", (Throwable)e);
        }
        return mediaId;
    }

    private void saveUploadMaterialLog(Long bizId, String corpId, String fileUrl, String mediaId, String type) {
        WeworkUploadMaterial weworkUploadMaterial = new WeworkUploadMaterial();
        weworkUploadMaterial.setBizId(bizId);
        weworkUploadMaterial.setCorpId(corpId);
        weworkUploadMaterial.setFileUrl(fileUrl);
        weworkUploadMaterial.setMediaId(mediaId);
        weworkUploadMaterial.setType(type);
        Date expireTime = DateUtil.getDateAddDay((Date)new Date(), (int)2);
        weworkUploadMaterial.setPeriodType(Integer.valueOf(1));
        weworkUploadMaterial.setExpireTime(expireTime);
        weworkUploadMaterial.setCreateBy(Long.valueOf(-1L));
        weworkUploadMaterial.setCreateTime(new Date());
        weworkUploadMaterial.setUpdateBy(Long.valueOf(-1L));
        weworkUploadMaterial.setUpdateTime(new Date());
        weworkUploadMaterial.setIsDeleted(Integer.valueOf(0));
        this.weworkUploadMaterialMapper.insertSelective((Object)weworkUploadMaterial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMaterialId(String corpId, String fileUrl, String type, String fileName) {
        int index = fileUrl.lastIndexOf(47);
        String parentPath = TEMP_FILE_DIR + File.separatorChar + UUID.randomUUID();
        log.info("parentPath:{}", (Object)parentPath);
        String tempFilePath = index > -1 ? (StringUtils.isNotBlank((CharSequence)fileName) ? parentPath + '/' + fileName : parentPath + fileUrl.substring(index + 1)) : (StringUtils.isNotBlank((CharSequence)fileName) ? parentPath + '/' + fileName : parentPath + fileUrl);
        File tempFile = null;
        File parentDir = null;
        try {
            UploadMaterialResult uploadMaterialResult;
            URL url = new URL(fileUrl);
            tempFile = new File(tempFilePath);
            parentDir = new File(parentPath);
            FileUtils.copyURLToFile((URL)url, (File)new File(tempFilePath));
            String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
            if (StringUtils.isNotBlank((CharSequence)accessToken) && Objects.nonNull(uploadMaterialResult = this.wwMaterialApi.uploadMaterial(accessToken, type, tempFile))) {
                String string = uploadMaterialResult.getMediaId();
                return string;
            }
        }
        catch (IOException e) {
            log.error("getMaterialId error", (Throwable)e);
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
            if (parentDir != null && parentDir.exists() && parentDir.isDirectory()) {
                parentDir.delete();
            }
        }
        return null;
    }

    private WeworkUploadMaterial buildUploadMaterial(CurrentUserInfo userInfo, String fileUrl, String mediaId, String type, String fileName) {
        WeworkUploadMaterial weworkUploadMaterial = new WeworkUploadMaterial();
        weworkUploadMaterial.setBizId(userInfo.getBizId());
        weworkUploadMaterial.setCorpId(userInfo.getCorpId());
        weworkUploadMaterial.setFileUrl(fileUrl);
        weworkUploadMaterial.setMediaId(mediaId);
        weworkUploadMaterial.setType(type);
        Date expireTime = DateUtil.getDateAddDay((Date)new Date(), (int)2);
        weworkUploadMaterial.setPeriodType(NumberUtils.INTEGER_ONE);
        weworkUploadMaterial.setUrl("");
        weworkUploadMaterial.setExpireTime(expireTime);
        weworkUploadMaterial.setCreateBy(userInfo.getId());
        weworkUploadMaterial.setCreateTime(new Date());
        weworkUploadMaterial.setUpdateBy(userInfo.getId());
        weworkUploadMaterial.setUpdateTime(new Date());
        weworkUploadMaterial.setIsDeleted(NumberUtils.INTEGER_ZERO);
        weworkUploadMaterial.setFileName(fileName);
        return weworkUploadMaterial;
    }

    private String buildKey(Long fkId, Integer fkType) {
        return fkId + "_" + fkType;
    }
}

