/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.material.service.impl;

import cn.kinyun.wework.sdk.api.WwMaterialApi;
import cn.kinyun.wework.sdk.entity.material.UploadImageMaterialResult;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.AliyunOssUtils;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.material.service.UploadImageService;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UploadImageServiceImpl
implements UploadImageService {
    private static final Logger log = LoggerFactory.getLogger(UploadImageServiceImpl.class);
    @Autowired
    private WwMaterialApi wwMaterialApi;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    private static final String TEMP_DIR = "./tmp";

    @Override
    public String uploadImage(MultipartFile file, String fileName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)fileName), (Object)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo currentUserInfo = this.baseValidate();
        log.info("uploadFile: bizId:{}, corpId:{}, id:{}", new Object[]{currentUserInfo.getBizId(), currentUserInfo.getCorpId(), currentUserInfo.getId()});
        StopWatch watch = new StopWatch();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)file.getInputStream(), (OutputStream)output, (int)4096);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        byte[] data = output.toByteArray();
        File source = null;
        try {
            watch.start();
            String newFileName = this.buildNewFileName(fileName);
            source = new File("temp", newFileName).getAbsoluteFile();
            if (!source.getParentFile().exists()) {
                source.getParentFile().mkdir();
            }
            IOUtils.write((byte[])data, (OutputStream)new FileOutputStream(source));
            watch.stop();
            log.info("uploadImg: \u5199\u6587\u4ef6\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
            watch.start();
            String suiteAccessToken = this.customizedTokenService.getAgentAccessToken(currentUserInfo.getCorpId());
            UploadImageMaterialResult result = this.wwMaterialApi.uploadImageMaterial(suiteAccessToken, source);
            watch.stop();
            log.info("uploadImg: url:{}, \u4e3b\u6587\u4ef6\u4e0a\u4f20\u8017\u65f6\uff1a{}", (Object)result.getUrl(), (Object)watch.getLastTaskTimeMillis());
            String string = result.getUrl();
            return string;
        }
        catch (Exception e) {
            log.error("uploadImg: \u7d20\u6750\u4e0a\u4f20\u5931\u8d25 e:{}", (Object)e.getMessage());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        finally {
            if (source != null && source.exists()) {
                source.delete();
            }
        }
    }

    @Override
    public String upload(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        File fileDir = new File(TEMP_DIR);
        if (!fileDir.exists()) {
            fileDir.mkdir();
        }
        fileName = this.buildNewFileName(fileName);
        File tmpFile = new File(TEMP_DIR + File.separator + fileName);
        try {
            String filePath;
            if (!tmpFile.exists()) {
                tmpFile.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
            IOUtils.copy((InputStream)file.getInputStream(), (OutputStream)fileOutputStream);
            String string = filePath = AliyunOssUtils.uploadFile((String)"outsideUpload", (File)tmpFile, (String)fileName);
            return string;
        }
        catch (IOException e) {
            log.error("upload file error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, e.getMessage());
        }
        finally {
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
    }

    private CurrentUserInfo baseValidate() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        return currentUserInfo;
    }

    private String buildNewFileName(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName);
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            return UUID.randomUUID().toString() + "." + extension;
        }
        return UUID.randomUUID().toString();
    }
}

