/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.marketing.dto.PlanGroupTagDto;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlanGroupTag;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanGroupTagMapper;
import com.kuaike.scrm.dal.weworktag.WeworkTagDto;
import com.kuaike.scrm.marketing.service.MarketingTagService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MarketingTagServiceImp
implements MarketingTagService {
    private static final Logger log = LoggerFactory.getLogger(MarketingTagServiceImp.class);
    @Resource
    private MarketingPlanGroupTagMapper marketingPlanGroupTagMapper;
    @Autowired
    private IdGen idGen;

    @Override
    @Transactional
    public void saveMarketingTag(Long bizId, String corpId, Long userId, Long planId, Long planGroupId, List<String> weworkTags) {
        List<MarketingPlanGroupTag> list = this.queryMarketingPlanGroupTag(bizId, corpId, planId, planGroupId);
        ArrayList insertTags = Lists.newArrayList();
        ArrayList delTags = Lists.newArrayList();
        for (MarketingPlanGroupTag planGroupTag : list) {
            String tagId = planGroupTag.getTagId();
            if (!weworkTags.contains(tagId)) {
                delTags.add(tagId);
                continue;
            }
            weworkTags.remove(tagId);
        }
        insertTags.addAll(weworkTags);
        this.delMarketingTag(bizId, corpId, userId, planId, planGroupId, delTags);
        this.insertMarketingTag(bizId, corpId, userId, planId, planGroupId, insertTags);
    }

    @Override
    public void insertMarketingTag(Long bizId, String corpId, Long userId, Long planId, Long planGroupId, List<String> weworkTags) {
        if (CollectionUtils.isEmpty(weworkTags)) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        for (String weworkTagId : weworkTags) {
            MarketingPlanGroupTag marketingPlanGroupTag = new MarketingPlanGroupTag();
            marketingPlanGroupTag.setNum(this.idGen.getNum());
            marketingPlanGroupTag.setBizId(bizId);
            marketingPlanGroupTag.setCorpId(corpId);
            marketingPlanGroupTag.setPlanId(planId);
            marketingPlanGroupTag.setPlanGroupId(planGroupId);
            marketingPlanGroupTag.setTagId(weworkTagId);
            marketingPlanGroupTag.setCreateBy(userId);
            marketingPlanGroupTag.setCreateTime(new Date());
            marketingPlanGroupTag.setUpdateBy(userId);
            marketingPlanGroupTag.setUpdateTime(new Date());
            marketingPlanGroupTag.setIsDeleted(Integer.valueOf(0));
            list.add(marketingPlanGroupTag);
        }
        this.marketingPlanGroupTagMapper.batchInsert((Collection)list);
    }

    @Override
    public void delMarketingTag(Long bizId, String corpId, Long userId, Long planId, Long planGroupId, List<String> weworkTags) {
        if (!CollectionUtils.isEmpty(weworkTags)) {
            this.marketingPlanGroupTagMapper.batchDel(bizId, corpId, planId, planGroupId, userId, weworkTags);
        }
    }

    @Override
    public List<MarketingPlanGroupTag> queryMarketingPlanGroupTag(Long bizId, String corpId, Long planId, Long planGroupId) {
        return this.marketingPlanGroupTagMapper.queryMarketingGroupTag(bizId, corpId, planId, planGroupId);
    }

    @Override
    public void delMarketingUserByPlanGroup(Long bizId, String corpId, Long userId, Long planId, List<Long> planGroupIds) {
        if (!CollectionUtils.isEmpty(planGroupIds)) {
            this.marketingPlanGroupTagMapper.delMarketingGroupTahByGroup(bizId, corpId, planId, userId, planGroupIds);
        }
    }

    @Override
    public List<WeworkTagDto> getPlanGroupTag(Long planId, Long planGroupId) {
        List list = this.marketingPlanGroupTagMapper.queryMarketingGroupTagInfo(planId, planGroupId);
        ArrayList result = Lists.newArrayList();
        for (PlanGroupTagDto tagDto : list) {
            WeworkTagDto weworkTagDto = new WeworkTagDto();
            weworkTagDto.setId(tagDto.getTagId());
            weworkTagDto.setName(tagDto.getTagName());
            result.add(weworkTagDto);
        }
        return result;
    }
}

