/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.ChannelDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.StatisticType;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.marketing.dto.PlanAddFriendLogDto;
import com.kuaike.scrm.dal.marketing.dto.PlanAddFriendLogParams;
import com.kuaike.scrm.dal.marketing.dto.PlanUvDetailDto;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelReportMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkUserDto;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.marketing.dto.AddFriendDto;
import com.kuaike.scrm.marketing.dto.AddFriendQueryParams;
import com.kuaike.scrm.marketing.dto.IdsReq;
import com.kuaike.scrm.marketing.dto.MarketingAddFriendExportDto;
import com.kuaike.scrm.marketing.dto.UvDetailDto;
import com.kuaike.scrm.marketing.dto.UvQueryParams;
import com.kuaike.scrm.marketing.service.MarketingPlanStatisticService;
import com.kuaike.scrm.wework.contact.dto.WeworkContactDto;
import com.kuaike.scrm.wework.contact.service.ContactMobileService;
import com.kuaike.scrm.wework.contacttag.service.ContactTagService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MarketingPlanStatisticServiceImp
implements MarketingPlanStatisticService {
    private static final Logger log = LoggerFactory.getLogger(MarketingPlanStatisticServiceImp.class);
    @Resource
    private MarketingChannelReportMapper marketingChannelReportMapper;
    @Resource
    private MarketingPlanMapper marketingPlanMapper;
    @Resource
    private WeworkContactLogMapper weworkContactLogMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private ContactMobileService contactMobileService;
    @Autowired
    private ContactTagService contactTagService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private WeworkUserService weworkUserService;
    @Resource
    private CcCustomerNumService customerNumService;

    @Override
    public Map<Long, Integer> getPlanPv(List<Long> planIds) {
        return this.marketingChannelReportMapper.queryPlanPv(planIds);
    }

    @Override
    public Map<Long, Integer> getPlanUv(List<Long> planIds) {
        return this.marketingChannelReportMapper.queryPlanUv(planIds);
    }

    @Override
    public Map<Long, Integer> getPlanAddFriends(List<Long> planIds, String corpId) {
        return this.weworkContactLogMapper.queryPlanAddFriends(planIds, corpId);
    }

    @Override
    public Map<Long, Integer> getPlanChannelAddFriends(Long planId, List<Long> channelIds, String corpId) {
        return this.weworkContactLogMapper.queryPlanChannelAddFriends(planId, channelIds, corpId);
    }

    @Override
    public Map<Long, Integer> getPlanChannelPv(Long planId, List<Long> channelIds) {
        return this.marketingChannelReportMapper.queryPlanChannelPv(planId, channelIds);
    }

    @Override
    public Map<Long, Integer> getPlanChannelUv(Long planId, List<Long> channelIds) {
        return this.marketingChannelReportMapper.queryPlanChannelUv(planId, channelIds);
    }

    @Override
    public List<UvDetailDto> queryPlanUvDetail(UvQueryParams params) {
        String num = params.getId();
        if (StringUtils.isBlank((CharSequence)num)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u662f\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(num);
        marketingPlan.setBizId(bizId);
        marketingPlan.setCorpId(corpId);
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u53c2\u6570\u4e0d\u5bf9");
        }
        if (marketingPlan.getIsDraft() == 1 || marketingPlan.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u662f\u8349\u7a3f\u6216\u8005\u5220\u9664");
        }
        if (marketingPlan.getStatsType().intValue() != StatisticType.STATISTIC_UV_DETAIL.getValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u7edf\u8ba1\u7c7b\u578b\u4e0d\u662f\u7edf\u8ba1uv\u8be6\u60c5");
        }
        Long channelId = null;
        if (StringUtils.isNotBlank((CharSequence)params.getChannelId()) && !params.getChannelId().equals("-1")) {
            Channel channel = new Channel();
            channel.setNum(params.getChannelId());
            channel.setCorpId(corpId);
            channel = (Channel)this.channelMapper.selectOne((Object)channel);
            channelId = channel == null ? null : channel.getId();
        } else if (StringUtils.isNotBlank((CharSequence)params.getChannelId())) {
            channelId = -1L;
        }
        int total = this.marketingChannelReportMapper.queryUvCount(marketingPlan.getId(), channelId, params.getStartTime(), params.getEndTime());
        PageDto pageDto = params.getPageDto();
        pageDto.setCount(Integer.valueOf(total));
        Map uniqCountMap = this.marketingChannelReportMapper.queryUv(marketingPlan.getId(), channelId, params.getStartTime(), params.getEndTime(), pageDto);
        if (uniqCountMap.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        List planUvDetailDtoList = this.marketingChannelReportMapper.queryUvDetailList(marketingPlan.getId(), channelId, uniqCountMap.keySet());
        for (PlanUvDetailDto detailDto : planUvDetailDtoList) {
            List customerNums;
            String uniqId = detailDto.getUniqId();
            UvDetailDto uvDetailDto = new UvDetailDto();
            BeanUtils.copyProperties((Object)detailDto, (Object)uvDetailDto);
            if (StringUtils.isNotBlank((CharSequence)detailDto.getCustomerNum()) && CollectionUtils.isEmpty((Collection)(customerNums = this.customerNumService.getCustomerNums(bizId, detailDto.getCustomerNum())))) {
                uvDetailDto.setCustomerNum("");
            }
            uvDetailDto.setCount((Integer)uniqCountMap.get(uniqId));
            result.add(uvDetailDto);
        }
        return result;
    }

    @Override
    public List<AddFriendDto> addFriendList(AddFriendQueryParams params) {
        String num = params.getId();
        if (StringUtils.isBlank((CharSequence)num)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u662f\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(num);
        marketingPlan.setBizId(bizId);
        marketingPlan.setCorpId(corpId);
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u53c2\u6570\u4e0d\u5bf9");
        }
        Long channelId = null;
        if (StringUtils.isNotBlank((CharSequence)params.getChannelId()) && !params.getChannelId().equals("-1")) {
            Channel channel = new Channel();
            channel.setNum(params.getChannelId());
            channel = (Channel)this.channelMapper.selectOne((Object)channel);
            channelId = channel == null ? null : channel.getId();
        } else if (StringUtils.isNotBlank((CharSequence)params.getChannelId())) {
            channelId = -1L;
        }
        PageDto pageDto = params.getPageDto();
        PlanAddFriendLogParams queryParams = new PlanAddFriendLogParams();
        queryParams.setBizId(bizId);
        queryParams.setCorpId(corpId);
        queryParams.setPlanId(marketingPlan.getId());
        queryParams.setChannelId(channelId);
        queryParams.setStartTime(params.getStartTime());
        queryParams.setEndTime(params.getEndTime());
        queryParams.setQuery(params.getQuery());
        queryParams.setWeworkUserNum(params.getWeworkUserId());
        queryParams.setPageDto(pageDto);
        int total = this.weworkContactLogMapper.queryPlanAddFriendListCount(queryParams);
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(total));
        }
        List list = this.weworkContactLogMapper.queryPlanAddFriendList(queryParams);
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return result;
        }
        List<Long> channelIds = list.stream().map(item -> item.getChannelId()).collect(Collectors.toList());
        List<String> weworkUserNums = list.stream().map(item -> item.getWeworkUserNum()).collect(Collectors.toList());
        List<String> contactIds = list.stream().map(item -> item.getContactId()).collect(Collectors.toList());
        Map weworkUserIdMap = this.weworkUserService.getWeworkUserIdMapByNums(weworkUserNums);
        Map<Long, ChannelDto> channelDtoMap = this.getChannelMap(bizId, channelIds);
        Map<String, WeworkUserDto> userDtoMap = this.getWeworkUserMap(weworkUserNums);
        Map<String, WeworkContactDto> contactDtoMap = this.getWeworkContactMap(corpId, contactIds);
        boolean mobileEncrypt = this.settingService.getMobileEncrypt(bizId);
        for (PlanAddFriendLogDto addFriendLogDto : list) {
            AddFriendDto addFriendDto = new AddFriendDto();
            String weworkUserId = (String)weworkUserIdMap.get(addFriendLogDto.getWeworkUserNum());
            String contactId = addFriendLogDto.getContactId();
            addFriendDto.setId(addFriendLogDto.getId());
            addFriendDto.setAddFriendTime(addFriendLogDto.getAddTime());
            WeworkContactRelation contactRelation = this.weworkContactRelationMapper.get(corpId, weworkUserId, contactId);
            String remark = "";
            if (contactRelation != null) {
                remark = contactRelation.getRemark();
            }
            addFriendDto.setRemarkName(remark);
            addFriendDto.setChannel(channelDtoMap.get(addFriendLogDto.getChannelId()));
            List remarkMobiles = this.contactMobileService.getRemarkMobile(corpId, weworkUserId, contactId, Integer.valueOf(0));
            if (mobileEncrypt) {
                remarkMobiles = MobileUtils.encryptMobile((List)remarkMobiles);
            }
            addFriendDto.setRemarkMobiles(remarkMobiles);
            addFriendDto.setWeworkUser(userDtoMap.get(addFriendLogDto.getWeworkUserNum()));
            addFriendDto.setWeworkTagList(this.contactTagService.getWeworkTags(corpId, weworkUserId, contactId, Integer.valueOf(0)));
            addFriendDto.setWeworkContact(contactDtoMap.get(addFriendLogDto.getContactId()));
            result.add(addFriendDto);
        }
        return result;
    }

    @Override
    public List<MarketingAddFriendExportDto> queryAddFriendListByPlanIds(String corpId, Long bizId, IdsReq idsReq) {
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isEmpty(idsReq.getIds())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u662f\u7a7a");
        }
        List marketingPlans = this.marketingPlanMapper.queryByNums(idsReq.getIds());
        List marketingPlanIds = marketingPlans.stream().map(MarketingPlan::getId).collect(Collectors.toList());
        List addFriendLogDtos = this.weworkContactLogMapper.queryAddFriendsByPlanIds(marketingPlanIds, corpId);
        Map planId2PlanMap = marketingPlans.stream().collect(Collectors.toMap(MarketingPlan::getId, Function.identity()));
        List<Long> channelIds = addFriendLogDtos.stream().map(item -> item.getChannelId()).collect(Collectors.toList());
        List<String> weworkUserNums = addFriendLogDtos.stream().map(item -> item.getWeworkUserNum()).collect(Collectors.toList());
        List<String> contactIds = addFriendLogDtos.stream().map(item -> item.getContactId()).collect(Collectors.toList());
        Map weworkUserIdMap = this.weworkUserService.getWeworkUserIdMapByNums(weworkUserNums);
        this.weworkUserService.getWeworkUserIdMapByNums(weworkUserNums);
        Map<Long, ChannelDto> channelDtoMap = this.getChannelMap(bizId, channelIds);
        Map<String, WeworkUserDto> userDtoMap = this.getWeworkUserMap(weworkUserNums);
        Map<String, WeworkContactDto> contactDtoMap = this.getWeworkContactMap(corpId, contactIds);
        List contactRelationsList = this.weworkContactRelationMapper.queryByCorpIdAndAllContactIds(corpId, contactIds);
        Map weworkUserIdAndContactId2ContactRelation = contactRelationsList.stream().collect(Collectors.toMap(item -> item.getWeworkUserId() + item.getContactId(), Function.identity(), (a, b) -> b));
        boolean mobileEncrypt = this.settingService.getMobileEncrypt(bizId);
        for (PlanAddFriendLogDto addFriendLogDto : addFriendLogDtos) {
            MarketingAddFriendExportDto resp = new MarketingAddFriendExportDto();
            String weworkUserId = (String)weworkUserIdMap.get(addFriendLogDto.getWeworkUserNum());
            if (planId2PlanMap.get(addFriendLogDto.getPlanId()) != null) {
                resp.setPlanName(((MarketingPlan)planId2PlanMap.get(addFriendLogDto.getPlanId())).getName());
            }
            if (contactDtoMap.get(addFriendLogDto.getContactId()) != null) {
                resp.setRemarkName(contactDtoMap.get(addFriendLogDto.getContactId()).getNickname());
                String keyId = weworkUserId + addFriendLogDto.getContactId();
                if (weworkUserIdAndContactId2ContactRelation.get(keyId) != null) {
                    if (((WeworkContactRelation)weworkUserIdAndContactId2ContactRelation.get(keyId)).getIsDeleted() == 1) {
                        resp.setFriendStatusDesc("\u5df2\u5220\u9664");
                    } else if (((WeworkContactRelation)weworkUserIdAndContactId2ContactRelation.get(keyId)).getIsZombieFans() == 1) {
                        resp.setFriendStatusDesc("\u50f5\u5c38\u7c89");
                    } else {
                        resp.setFriendStatusDesc("\u6b63\u5e38");
                    }
                }
            }
            if (userDtoMap.get(addFriendLogDto.getWeworkUserNum()) != null) {
                resp.setWeworkUser(userDtoMap.get(addFriendLogDto.getWeworkUserNum()).getNickname());
            }
            if (channelDtoMap.get(addFriendLogDto.getChannelId()) != null) {
                resp.setChannel(channelDtoMap.get(addFriendLogDto.getChannelId()).getName());
            }
            List remarkMobiles = this.contactMobileService.getRemarkMobile(corpId, weworkUserId, addFriendLogDto.getContactId(), Integer.valueOf(0));
            if (mobileEncrypt) {
                remarkMobiles = MobileUtils.encryptMobile((List)remarkMobiles);
            }
            resp.setWeworkTagList(this.contactTagService.getWeworkTags(corpId, weworkUserId, addFriendLogDto.getContactId(), Integer.valueOf(0)).stream().map(item -> item.getName()).collect(Collectors.joining(",")));
            resp.setRemarkMobiles(remarkMobiles.stream().collect(Collectors.joining(",")));
            resp.setAddFriendTime(addFriendLogDto.getAddTime());
            resp.setUid(addFriendLogDto.getContactId());
            result.add(resp);
        }
        return result;
    }

    private Map<String, WeworkUserDto> getWeworkUserMap(List<String> weworkUserNums) {
        List weworkUsers = this.weworkUserMapper.queryInfoListByNums(weworkUserNums);
        HashMap userDtoMap = Maps.newHashMap();
        for (WeworkUser weworkUser : weworkUsers) {
            WeworkUserDto weworkUserDto = new WeworkUserDto();
            weworkUserDto.setId(weworkUser.getNum());
            weworkUserDto.setNickname(weworkUser.getName());
            weworkUserDto.setAvatar(weworkUser.getAvatar());
            userDtoMap.put(weworkUser.getNum(), weworkUserDto);
        }
        return userDtoMap;
    }

    private Map<Long, ChannelDto> getChannelMap(Long bizId, List<Long> channelIds) {
        List channels = this.channelMapper.queryChannels(bizId, channelIds);
        HashMap channelDtoMap = Maps.newHashMap();
        for (Channel channel : channels) {
            ChannelDto channelDto = new ChannelDto();
            channelDto.setId(channel.getNum());
            channelDto.setName(channel.getName());
            channelDtoMap.put(channel.getId(), channelDto);
        }
        return channelDtoMap;
    }

    private Map<String, WeworkContactDto> getWeworkContactMap(String corpId, List<String> weworkContactIds) {
        List weworkContacts = this.weworkContactMapper.queryWeworkContactList(corpId, weworkContactIds);
        HashMap weworkContactDtoMap = Maps.newHashMap();
        for (WeworkContact weworkContact : weworkContacts) {
            WeworkContactDto weworkContactDto = new WeworkContactDto();
            weworkContactDto.setId(weworkContact.getContactId());
            weworkContactDto.setAvatar(weworkContact.getAvatar());
            weworkContactDto.setCorpName(weworkContact.getCorpName());
            weworkContactDto.setNickname(weworkContact.getName());
            weworkContactDto.setCustomerNum(weworkContact.getCustomerNum());
            weworkContactDtoMap.put(weworkContact.getContactId(), weworkContactDto);
        }
        return weworkContactDtoMap;
    }
}

