/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.lockcustomer.dto;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.dto.req.ShareCustomerConfigDto;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ShareCustomerReq
implements Serializable {
    private Integer status;
    private SettingEnum type;
    private String weworkUserNum;
    private List<String> weworkUserNums;
    private List<Long> weworkDepIds;
    private Integer onlyShowConfigDetail = YnEnum.NO.getValue();
    private Integer fillUserOrDepName = YnEnum.YES.getValue();
    private ShareCustomerConfigDto customerConfigDto;

    public void validateForQuery() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.type), (Object)"\u914d\u7f6e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateForPermission() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.type), (Object)"\u914d\u7f6e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.weworkUserNum), (Object)"weworkUserNum \u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateForAdd() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.status), (Object)"\u662f\u5426\u542f\u7528\u4e0d\u80fd\u4e3a\u7a7a");
        if (YnEnum.YES.getValue().equals(this.status)) {
            Preconditions.checkArgument((CollectionUtils.isNotEmpty(this.weworkUserNums) || CollectionUtils.isNotEmpty(this.weworkDepIds) ? 1 : 0) != 0, (Object)"\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public Integer getStatus() {
        return this.status;
    }

    public SettingEnum getType() {
        return this.type;
    }

    public String getWeworkUserNum() {
        return this.weworkUserNum;
    }

    public List<String> getWeworkUserNums() {
        return this.weworkUserNums;
    }

    public List<Long> getWeworkDepIds() {
        return this.weworkDepIds;
    }

    public Integer getOnlyShowConfigDetail() {
        return this.onlyShowConfigDetail;
    }

    public Integer getFillUserOrDepName() {
        return this.fillUserOrDepName;
    }

    public ShareCustomerConfigDto getCustomerConfigDto() {
        return this.customerConfigDto;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setType(SettingEnum type) {
        this.type = type;
    }

    public void setWeworkUserNum(String weworkUserNum) {
        this.weworkUserNum = weworkUserNum;
    }

    public void setWeworkUserNums(List<String> weworkUserNums) {
        this.weworkUserNums = weworkUserNums;
    }

    public void setWeworkDepIds(List<Long> weworkDepIds) {
        this.weworkDepIds = weworkDepIds;
    }

    public void setOnlyShowConfigDetail(Integer onlyShowConfigDetail) {
        this.onlyShowConfigDetail = onlyShowConfigDetail;
    }

    public void setFillUserOrDepName(Integer fillUserOrDepName) {
        this.fillUserOrDepName = fillUserOrDepName;
    }

    public void setCustomerConfigDto(ShareCustomerConfigDto customerConfigDto) {
        this.customerConfigDto = customerConfigDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShareCustomerReq)) {
            return false;
        }
        ShareCustomerReq other = (ShareCustomerReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$onlyShowConfigDetail = this.getOnlyShowConfigDetail();
        Integer other$onlyShowConfigDetail = other.getOnlyShowConfigDetail();
        if (this$onlyShowConfigDetail == null ? other$onlyShowConfigDetail != null : !((Object)this$onlyShowConfigDetail).equals(other$onlyShowConfigDetail)) {
            return false;
        }
        Integer this$fillUserOrDepName = this.getFillUserOrDepName();
        Integer other$fillUserOrDepName = other.getFillUserOrDepName();
        if (this$fillUserOrDepName == null ? other$fillUserOrDepName != null : !((Object)this$fillUserOrDepName).equals(other$fillUserOrDepName)) {
            return false;
        }
        SettingEnum this$type = this.getType();
        SettingEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$weworkUserNum = this.getWeworkUserNum();
        String other$weworkUserNum = other.getWeworkUserNum();
        if (this$weworkUserNum == null ? other$weworkUserNum != null : !this$weworkUserNum.equals(other$weworkUserNum)) {
            return false;
        }
        List<String> this$weworkUserNums = this.getWeworkUserNums();
        List<String> other$weworkUserNums = other.getWeworkUserNums();
        if (this$weworkUserNums == null ? other$weworkUserNums != null : !((Object)this$weworkUserNums).equals(other$weworkUserNums)) {
            return false;
        }
        List<Long> this$weworkDepIds = this.getWeworkDepIds();
        List<Long> other$weworkDepIds = other.getWeworkDepIds();
        if (this$weworkDepIds == null ? other$weworkDepIds != null : !((Object)this$weworkDepIds).equals(other$weworkDepIds)) {
            return false;
        }
        ShareCustomerConfigDto this$customerConfigDto = this.getCustomerConfigDto();
        ShareCustomerConfigDto other$customerConfigDto = other.getCustomerConfigDto();
        return !(this$customerConfigDto == null ? other$customerConfigDto != null : !this$customerConfigDto.equals(other$customerConfigDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShareCustomerReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $onlyShowConfigDetail = this.getOnlyShowConfigDetail();
        result = result * 59 + ($onlyShowConfigDetail == null ? 43 : ((Object)$onlyShowConfigDetail).hashCode());
        Integer $fillUserOrDepName = this.getFillUserOrDepName();
        result = result * 59 + ($fillUserOrDepName == null ? 43 : ((Object)$fillUserOrDepName).hashCode());
        SettingEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $weworkUserNum = this.getWeworkUserNum();
        result = result * 59 + ($weworkUserNum == null ? 43 : $weworkUserNum.hashCode());
        List<String> $weworkUserNums = this.getWeworkUserNums();
        result = result * 59 + ($weworkUserNums == null ? 43 : ((Object)$weworkUserNums).hashCode());
        List<Long> $weworkDepIds = this.getWeworkDepIds();
        result = result * 59 + ($weworkDepIds == null ? 43 : ((Object)$weworkDepIds).hashCode());
        ShareCustomerConfigDto $customerConfigDto = this.getCustomerConfigDto();
        result = result * 59 + ($customerConfigDto == null ? 43 : $customerConfigDto.hashCode());
        return result;
    }

    public String toString() {
        return "ShareCustomerReq(status=" + this.getStatus() + ", type=" + this.getType() + ", weworkUserNum=" + this.getWeworkUserNum() + ", weworkUserNums=" + this.getWeworkUserNums() + ", weworkDepIds=" + this.getWeworkDepIds() + ", onlyShowConfigDetail=" + this.getOnlyShowConfigDetail() + ", fillUserOrDepName=" + this.getFillUserOrDepName() + ", customerConfigDto=" + this.getCustomerConfigDto() + ")";
    }
}

