/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.roomplan.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.component.PojoExportExcel;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkRoomJoinQuitLogMapper;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelReportMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanRoomCodeMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoomRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.marketing.service.MarketingPlanStatisticService;
import com.kuaike.scrm.roomplan.dto.ChannelStatisticDto;
import com.kuaike.scrm.roomplan.dto.LostStatisticDto;
import com.kuaike.scrm.roomplan.dto.MemberDetailStatisticDto;
import com.kuaike.scrm.roomplan.dto.PlanStatisticDto;
import com.kuaike.scrm.roomplan.dto.QueryRoomMemReq;
import com.kuaike.scrm.roomplan.dto.RoomDetailStatisticDto;
import com.kuaike.scrm.roomplan.dto.RoomPlanAnalyzeDto;
import com.kuaike.scrm.roomplan.dto.RoomStatisticDto;
import com.kuaike.scrm.roomplan.service.RoomPlanStatisticService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoomPlanStatisticServiceImpl
implements RoomPlanStatisticService {
    private static final Logger log = LoggerFactory.getLogger(RoomPlanStatisticServiceImpl.class);
    @Resource
    private MarketingPlanMapper marketingPlanMapper;
    @Resource
    private MarketingChannelReportMapper marketingChannelReportMapper;
    @Resource
    private MarketingPlanRoomCodeMapper marketingPlanRoomCodeMapper;
    @Resource
    private WeworkRoomJoinQuitLogMapper weworkRoomJoinQuitLogMapper;
    @Resource
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Resource
    private MarketingChannelMapper marketingChannelMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private MarketingPlanStatisticService marketingPlanStatisticService;

    @Override
    public RoomPlanAnalyzeDto getAnalyze(BaseDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        MarketingPlan marketingPlan = this.getRoomPlan(params);
        Long planId = marketingPlan.getId();
        Date todayStartTime = DateUtil.getTodayStartTime();
        Date todayEndTime = DateUtil.getTodayEndTime();
        RoomPlanAnalyzeDto result = new RoomPlanAnalyzeDto();
        Integer totalUv = this.marketingChannelReportMapper.queryPlanUvCount(corpId, planId, null, null);
        Integer todayUv = this.marketingChannelReportMapper.queryPlanUvCount(corpId, planId, todayStartTime, todayEndTime);
        PlanStatisticDto planStatisticDto = new PlanStatisticDto();
        planStatisticDto.setTotalCount(totalUv);
        planStatisticDto.setDayCount(todayUv);
        result.setPlanStatistic(planStatisticDto);
        if (marketingPlan.getLiveCodeType() == 1) {
            List roomIds = this.marketingPlanRoomCodeMapper.queryRoomByPlanId(corpId, planId);
            todayStartTime = todayStartTime.before(marketingPlan.getCreateTime()) ? marketingPlan.getCreateTime() : todayStartTime;
            Integer totalJoinRoom = this.weworkChatRoomRelationMapper.queryJoinRoomCount(corpId, (Collection)roomIds, marketingPlan.getCreateTime(), null);
            Integer todayJoinRoom = this.weworkChatRoomRelationMapper.queryJoinRoomCount(corpId, (Collection)roomIds, todayStartTime, todayEndTime);
            RoomStatisticDto roomStatisticDto = new RoomStatisticDto();
            roomStatisticDto.setTotalCount(totalJoinRoom == null ? 0 : totalJoinRoom);
            roomStatisticDto.setDayCount(todayJoinRoom == null ? 0 : todayJoinRoom);
            Integer totalQuitRoom = this.weworkChatRoomRelationMapper.queryQuitRoomCount(corpId, (Collection)roomIds, marketingPlan.getCreateTime(), null, marketingPlan.getCreateTime());
            Integer todayQuitRoom = this.weworkChatRoomRelationMapper.queryQuitRoomCount(corpId, (Collection)roomIds, todayStartTime, todayEndTime, marketingPlan.getCreateTime());
            LostStatisticDto lostStatisticDto = new LostStatisticDto();
            lostStatisticDto.setTotalCount(totalQuitRoom == null ? 0 : totalQuitRoom);
            lostStatisticDto.setDayCount(todayQuitRoom == null ? 0 : todayQuitRoom);
            result.setRoomStatistic(roomStatisticDto);
            result.setLostStatistic(lostStatisticDto);
        }
        return result;
    }

    @Override
    public List<RoomDetailStatisticDto> getRoomDetailAnalyze(BaseDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        MarketingPlan marketingPlan = this.getRoomPlan(params);
        Long planId = marketingPlan.getId();
        List roomIds = null;
        if (params.getPageDto() != null) {
            PageDto pageDto = params.getPageDto();
            Page page = PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize()).doSelectPage(() -> this.marketingPlanRoomCodeMapper.queryRoomByPlanId(corpId, planId));
            pageDto.setCount(Integer.valueOf((int)page.getTotal()));
            roomIds = page.getResult();
        } else {
            roomIds = this.marketingPlanRoomCodeMapper.queryRoomByPlanId(corpId, planId);
        }
        if (CollectionUtils.isEmpty((Collection)roomIds)) {
            return null;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)roomIds.size());
        List chatRoomList = this.weworkChatRoomMapper.queryChatRooms(corpId, (Collection)roomIds, params.getName());
        if (CollectionUtils.isEmpty((Collection)chatRoomList)) {
            return null;
        }
        Set ownerIds = chatRoomList.stream().map(it -> it.getOwner()).collect(Collectors.toSet());
        List weworkUsers = this.weworkUserMapper.queryWeworkUserInfoList(corpId, ownerIds);
        Map weworkUserMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getWeworkUserId, Function.identity()));
        Map roomCountMap = this.weworkChatRoomRelationMapper.getRoomIdAndMemberCountByCorpIdAndRoomIds(corpId, (Collection)roomIds);
        for (WeworkChatRoom chatRoom : chatRoomList) {
            RoomDetailStatisticDto dto = new RoomDetailStatisticDto();
            String chatRoomId = chatRoom.getWeworkRoomId();
            dto.setRoomId(chatRoomId);
            dto.setRoomName(chatRoom.getName());
            dto.setOwnerId(chatRoom.getOwner());
            WeworkUser ownerUser = (WeworkUser)weworkUserMap.get(chatRoom.getOwner());
            if (ownerUser != null) {
                dto.setNickName(ownerUser.getName());
                dto.setOwnerAvatar(ownerUser.getAvatar());
            }
            Integer total = (Integer)roomCountMap.get(chatRoomId);
            Integer joinRoomCount = this.weworkChatRoomRelationMapper.queryJoinRoomCount(corpId, (Collection)Lists.newArrayList((Object[])new String[]{chatRoomId}), marketingPlan.getCreateTime(), null);
            Integer quitRoomCount = this.weworkChatRoomRelationMapper.queryQuitRoomCount(corpId, (Collection)Lists.newArrayList((Object[])new String[]{chatRoomId}), marketingPlan.getCreateTime(), null, marketingPlan.getCreateTime());
            dto.setMemberCount(total);
            dto.setInCount(joinRoomCount);
            dto.setOutCount(quitRoomCount);
            result.add(dto);
        }
        return result;
    }

    @Override
    public List<ChannelStatisticDto> getChannelAnalyze(BaseDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        MarketingPlan marketingPlan = this.getRoomPlan(params);
        List marketingChannels = null;
        if (params.getPageDto() != null) {
            PageDto pageDto = params.getPageDto();
            Page page = PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize()).doSelectPage(() -> this.marketingChannelMapper.queryPlanOfChannel(corpId, marketingPlan.getId()));
            pageDto.setCount(Integer.valueOf((int)page.getTotal()));
            marketingChannels = page.getResult();
        } else {
            marketingChannels = this.marketingChannelMapper.queryPlanOfChannel(corpId, marketingPlan.getId());
        }
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)marketingChannels)) {
            return result;
        }
        List planCurChannelIds = marketingChannels.stream().map(marketingChannel -> marketingChannel.getChannelId()).collect(Collectors.toList());
        ArrayList channelIds = Lists.newArrayList(planCurChannelIds);
        List channels = this.channelMapper.queryChannels(bizId, (Collection)channelIds);
        Map channelMap = channels.stream().collect(Collectors.toMap(channel -> channel.getId(), Function.identity()));
        Map<Long, Integer> channelPvMap = this.marketingPlanStatisticService.getPlanChannelPv(marketingPlan.getId(), channelIds);
        Map<Long, Integer> channelUvMap = this.marketingPlanStatisticService.getPlanChannelUv(marketingPlan.getId(), channelIds);
        for (MarketingChannel marketingChannel2 : marketingChannels) {
            Long channelId = marketingChannel2.getChannelId();
            ChannelStatisticDto channelDetailDto = new ChannelStatisticDto();
            if (channelMap.get(channelId) != null) {
                channelDetailDto.setChannelId(((Channel)channelMap.get(channelId)).getNum());
                channelDetailDto.setChannelName(((Channel)channelMap.get(channelId)).getName());
            } else {
                channelDetailDto.setChannelId("-1");
                channelDetailDto.setChannelName("\u4f01\u5fae\u6e20\u9053");
            }
            channelDetailDto.setPv(channelPvMap.getOrDefault(channelId, 0));
            channelDetailDto.setUv(channelUvMap.getOrDefault(channelId, 0));
            result.add(channelDetailDto);
        }
        return result;
    }

    @Override
    public List<MemberDetailStatisticDto> getMemberAnalyze(QueryRoomMemReq params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Long bizId = userInfo.getBizId();
        MarketingPlan marketingPlan = this.getRoomPlan(params);
        Long planId = marketingPlan.getId();
        List roomIds = this.marketingPlanRoomCodeMapper.queryRoomByPlanId(corpId, planId);
        if (CollectionUtils.isEmpty((Collection)roomIds)) {
            return null;
        }
        if (StringUtils.isNotEmpty((CharSequence)params.getRoomId()) && roomIds.contains(params.getRoomId())) {
            roomIds = Lists.newArrayList((Object[])new String[]{params.getRoomId()});
        }
        Integer isDeleted = null;
        if (params.getType() != null) {
            isDeleted = params.getType() == 0 ? 1 : 0;
        }
        if (params.getPageDto() != null) {
            int total = this.weworkChatRoomRelationMapper.queryRoomMemberCount(corpId, (Collection)roomIds, isDeleted, marketingPlan.getCreateTime(), params.getName());
            params.getPageDto().setCount(Integer.valueOf(total));
        }
        List list = this.weworkChatRoomRelationMapper.queryRoomMemberList(corpId, (Collection)roomIds, isDeleted, marketingPlan.getCreateTime(), params.getName(), params.getPageDto());
        List chatRoomList = this.weworkChatRoomMapper.batchQueryChatRooms(corpId, (Collection)roomIds);
        Map chatRoomMap = chatRoomList.stream().collect(Collectors.toMap(WeworkChatRoom::getWeworkRoomId, Function.identity()));
        Set ownerIds = chatRoomList.stream().map(it -> it.getOwner()).collect(Collectors.toSet());
        List weworkUsers = this.weworkUserMapper.queryWeworkUserInfoList(corpId, ownerIds);
        Map ownerUserMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getWeworkUserId, Function.identity()));
        String curCorpName = this.weworkCorpMapper.getByCorpId(corpId).getCorpName();
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (WeworkChatRoomRelation chatRoomRelation : list) {
            MemberDetailStatisticDto dto = new MemberDetailStatisticDto();
            dto.setMemberId(chatRoomRelation.getMemberId());
            if (StringUtils.isNotEmpty((CharSequence)chatRoomRelation.getGroupNickname())) {
                dto.setNickName(chatRoomRelation.getGroupNickname());
            } else {
                dto.setNickName(chatRoomRelation.getName());
            }
            if (chatRoomRelation.getType() == 1) {
                WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, chatRoomRelation.getMemberId());
                if (weworkUser != null) {
                    dto.setAvatar(weworkUser.getAvatar());
                }
                dto.setIsCustomer(0);
                dto.setCorpName(curCorpName);
            } else if (chatRoomRelation.getType() == 2) {
                WeworkContact contact = this.weworkContactMapper.queryWeworkContact(bizId, corpId, chatRoomRelation.getMemberId());
                if (contact != null) {
                    dto.setAvatar(contact.getAvatar());
                    dto.setCorpName(contact.getCorpName());
                    dto.setCustomerNum(contact.getCustomerNum());
                }
                dto.setIsCustomer(1);
            }
            if (chatRoomRelation.getIsDeleted() == 0) {
                dto.setIsAtRoom(1);
                dto.setIsAtRoomDesc("\u662f");
            } else {
                dto.setIsAtRoom(0);
                dto.setIsAtRoomDesc("\u5426");
            }
            dto.setEnterTime(chatRoomRelation.getJoinTime());
            WeworkChatRoom chatRoom = (WeworkChatRoom)chatRoomMap.get(chatRoomRelation.getWeworkRoomId());
            dto.setRoomId(chatRoomRelation.getWeworkRoomId());
            if (chatRoom != null) {
                dto.setRoomName(chatRoom.getName());
                String ownerId = chatRoom.getOwner();
                dto.setOwnerId(ownerId);
                WeworkUser ownerUser = (WeworkUser)ownerUserMap.get(ownerId);
                if (ownerUser != null) {
                    dto.setOwnerNickName(ownerUser.getName());
                    dto.setOwnerAvatar(ownerUser.getAvatar());
                }
            }
            result.add(dto);
        }
        return result;
    }

    @Override
    public void roomDataExport(HttpServletResponse response, BaseDto params) {
        List<RoomDetailStatisticDto> result = this.getRoomDetailAnalyze(params);
        String fileName = "\u7fa4\u6570\u636e.xlsx";
        try {
            PojoExportExcel.doPrint(result, RoomDetailStatisticDto.class, (String)"\u7fa4\u6570\u636e", (HttpServletResponse)response, (String)fileName);
        }
        catch (Exception e) {
            log.error("room data export error: ", (Throwable)e);
        }
    }

    @Override
    public void channelDataExport(HttpServletResponse response, BaseDto params) {
        List<ChannelStatisticDto> result = this.getChannelAnalyze(params);
        String fileName = "\u6e20\u9053\u6570\u636e.xlsx";
        try {
            PojoExportExcel.doPrint(result, ChannelStatisticDto.class, (String)"\u6e20\u9053\u6570\u636e", (HttpServletResponse)response, (String)fileName);
        }
        catch (Exception e) {
            log.error("channel data export error: ", (Throwable)e);
        }
    }

    @Override
    public void roomMemberDataExport(HttpServletResponse response, QueryRoomMemReq params) {
        List<MemberDetailStatisticDto> result = this.getMemberAnalyze(params);
        String fileName = "\u7fa4\u6210\u5458\u6570\u636e.xlsx";
        try {
            PojoExportExcel.doPrint(result, MemberDetailStatisticDto.class, (String)"\u7fa4\u6210\u5458\u6570\u636e", (HttpServletResponse)response, (String)fileName);
        }
        catch (Exception e) {
            log.error("room member data export error: ", (Throwable)e);
        }
    }

    private MarketingPlan getRoomPlan(BaseDto params) {
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)params.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u7fa4\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String planNum = params.getId();
        MarketingPlan marketingPlan = this.marketingPlanMapper.selectByNum(planNum);
        if (marketingPlan == null || marketingPlan.getType().intValue() != PlanType.ROOM_PLAN.getValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u7fa4\u6d3b\u52a8\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        Integer liveCodeType = marketingPlan.getLiveCodeType();
        if (liveCodeType == null || liveCodeType != 1 && liveCodeType != 2) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u7fa4\u6d3b\u7801\u7c7b\u578b\u4e0d\u5bf9");
        }
        return marketingPlan;
    }
}

