/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.regionplan.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.scrm.common.enums.OnLineType;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.MarketingQrcode;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingQrcodeMapper;
import com.kuaike.scrm.dal.region.entity.RegionPlanQrcodeUser;
import com.kuaike.scrm.dal.region.mapper.RegionPlanAlternativeUserMapper;
import com.kuaike.scrm.dal.region.mapper.RegionPlanQrcodeUserMapper;
import com.kuaike.scrm.dal.region.mapper.RegionPlanWorkCycleMapper;
import com.kuaike.scrm.marketing.service.MarketingPlanGroupService;
import com.kuaike.scrm.marketing.service.MarketingQrcodeService;
import com.kuaike.scrm.regionplan.dto.PlanQrcodeUserDto;
import com.kuaike.scrm.regionplan.service.AlternativeUserService;
import com.kuaike.scrm.regionplan.service.RegionPlanAutoPassService;
import com.kuaike.scrm.regionplan.service.RegionPlanCurUserService;
import com.kuaike.scrm.regionplan.service.RegionPlanCycleUserService;
import com.kuaike.scrm.regionplan.service.UserAddFriendLimitService;
import com.kuaike.scrm.wework.department.service.DepartmentService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RegionPlanCurUserServiceImpl
implements RegionPlanCurUserService {
    private static final Logger log = LoggerFactory.getLogger(RegionPlanCurUserServiceImpl.class);
    @Resource
    private RegionPlanQrcodeUserMapper regionPlanQrcodeUserMapper;
    @Resource
    private RegionPlanWorkCycleMapper regionPlanWorkCycleMapper;
    @Resource
    private MarketingQrcodeMapper marketingQrcodeMapper;
    @Resource
    private MarketingChannelMapper marketingChannelMapper;
    @Resource
    private RegionPlanAlternativeUserMapper regionPlanAlternativeUserMapper;
    @Autowired
    private MarketingPlanGroupService marketingPlanGroupService;
    @Autowired
    private RegionPlanCycleUserService regionPlanCycleUserService;
    @Autowired
    private RegionPlanAutoPassService regionPlanAutoPassService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private UserAddFriendLimitService userAddFriendLimitService;
    @Autowired
    private MarketingQrcodeService marketingQrcodeService;
    @Autowired
    private AlternativeUserService alternativeUserService;

    @Override
    @Transactional
    public void assignWeworkUser(MarketingPlan marketingPlan) {
        log.info("assign wework user, planId: {}, ", (Object)marketingPlan.getId());
        if (marketingPlan.getIsDraft() == 1 || marketingPlan.getIsDeleted() == 1 || marketingPlan.getIsEnabled() == 0 || marketingPlan.getType().intValue() != PlanType.REGION_PLAN.getValue()) {
            log.info("assign of plan is error planId: {}", (Object)marketingPlan.getId());
            return;
        }
        Long planId = marketingPlan.getId();
        String corpId = marketingPlan.getCorpId();
        Long bizId = marketingPlan.getBizId();
        Long userId = marketingPlan.getCreateBy();
        int onLineType = marketingPlan.getOnLineType();
        int limitAddFriend = marketingPlan.getLimitAddFriend();
        Long planGroupId = this.marketingPlanGroupService.getDefaultGroupId(corpId, planId);
        Map<String, PlanQrcodeUserDto> userDtoMap = this.getCurUserDtoMap(corpId, planId, planGroupId, onLineType, limitAddFriend);
        Map<Long, List<PlanQrcodeUserDto>> userRegionGroup = this.groupByRegion(corpId, userDtoMap);
        if (userRegionGroup.isEmpty()) {
            userRegionGroup = this.getAlternativeUser(corpId, planId, planGroupId);
        }
        if (userRegionGroup.size() == 0) {
            log.info("cur region list is empty");
        }
        Set<Long> regionIds = userRegionGroup.keySet();
        Set channelIds = this.marketingChannelMapper.queryPlanCurChannelIds(corpId, planId);
        Map<String, MarketingQrcode> marketingQrcodeMap = this.marketingQrcodeService.getPlanOfQrcode(corpId, planId);
        for (Long channelId : channelIds) {
            for (Long regionId : regionIds) {
                List<PlanQrcodeUserDto> regionOfUserDtos = userRegionGroup.get(regionId);
                String key = MessageFormat.format("channelId:{0}-regionInfoId:{1}", channelId, regionId);
                if (marketingQrcodeMap.containsKey(key)) {
                    this.updateQrcode(marketingQrcodeMap.get(key), regionOfUserDtos);
                    marketingQrcodeMap.remove(key);
                    continue;
                }
                MarketingQrcode regionQrcode = this.marketingQrcodeService.buildRegionQrcode(bizId, corpId, planId, planGroupId, channelId, regionId, userId);
                this.marketingQrcodeMapper.insertSelective((Object)regionQrcode);
                Long qrcodeId = regionQrcode.getId();
                this.insertRegionPlanQrcodeUser(bizId, corpId, planId, qrcodeId, regionOfUserDtos, userId);
            }
        }
        if (marketingQrcodeMap.size() > 0) {
            this.delQrcode(corpId, planId, userId, marketingQrcodeMap.values());
        }
        this.marketingQrcodeService.sendNotSyncQrCodeToKafka(planId);
    }

    @Override
    public void delAssignWorkUser(MarketingPlan marketingPlan) {
        Long updateBy = marketingPlan.getUpdateBy();
        String corpId = marketingPlan.getCorpId();
        Long planId = marketingPlan.getId();
        this.marketingQrcodeMapper.delMarketingQrcodeByPlan(updateBy, planId);
        this.regionPlanQrcodeUserMapper.delPlanQrcodeUserByPlanId(corpId, planId, updateBy);
        this.marketingQrcodeService.sendNotSyncQrCodeToKafka(planId);
    }

    private Map<String, PlanQrcodeUserDto> getCurUserDtoMap(String corpId, Long planId, Long planGroupId, Integer onLineType, Integer limitAddFriend) {
        List<PlanQrcodeUserDto> planQrcodeUserDtos;
        if (onLineType.intValue() == OnLineType.DAY_LINE_TYPE.getValue()) {
            planQrcodeUserDtos = this.allDayOnline(corpId, planId, planGroupId);
        } else if (onLineType.intValue() == OnLineType.TIME_LINE_TYPE.getValue()) {
            planQrcodeUserDtos = this.rangeTimeOnline(corpId, planId, planGroupId);
        } else {
            log.info("getCurUserDtoMap, onLineType:{} value is not valid", (Object)onLineType);
            return Maps.newHashMap();
        }
        if (CollectionUtils.isEmpty(planQrcodeUserDtos)) {
            log.info("work cycle user is empty planId: {}", (Object)planId);
            return Maps.newHashMap();
        }
        if (limitAddFriend == 1) {
            log.info("filter limit friends before planQrcodeUserDtos: {}", planQrcodeUserDtos);
            planQrcodeUserDtos = this.filterLimitFriends(corpId, planId, planGroupId, planQrcodeUserDtos);
            log.info("filter limit friends after planQrcodeUserDtos: {}", planQrcodeUserDtos);
        }
        if (CollectionUtils.isEmpty(planQrcodeUserDtos)) {
            log.info("work cycle user is empty planId: {}", (Object)planId);
            return Maps.newHashMap();
        }
        return planQrcodeUserDtos.stream().collect(Collectors.toMap(PlanQrcodeUserDto::getWeworkUserNum, Function.identity()));
    }

    private Map<Long, List<PlanQrcodeUserDto>> groupByRegion(String corpId, Map<String, PlanQrcodeUserDto> userDtoMap) {
        Set<String> curUsers = userDtoMap.keySet();
        Map userRegionGroup = this.departmentService.getWeworkUserRegionGroup(corpId, curUsers);
        HashMap result = Maps.newHashMap();
        userRegionGroup.forEach((regionInfoId, list) -> {
            ArrayList userDtos = Lists.newArrayList();
            for (String weworkUserNum : list) {
                userDtos.add(userDtoMap.get(weworkUserNum));
            }
            result.put(regionInfoId, userDtos);
        });
        return result;
    }

    private void updateQrcode(MarketingQrcode marketingQrcode, List<PlanQrcodeUserDto> regionOfUserDtos) {
        String corpId = marketingQrcode.getCorpId();
        Long planId = marketingQrcode.getPlanId();
        Long bizId = marketingQrcode.getBizId();
        Long userId = marketingQrcode.getUpdateBy();
        List<PlanQrcodeUserDto> curPlanUserDtos = this.getCurQrcodeUser(corpId, planId, marketingQrcode.getId());
        Map curPlanUserMap = curPlanUserDtos.stream().collect(Collectors.toMap(PlanQrcodeUserDto::getWeworkUserNum, Function.identity()));
        boolean userNotChange = true;
        ArrayList addList = Lists.newArrayList();
        for (PlanQrcodeUserDto userDto : regionOfUserDtos) {
            String weworkUserNum = userDto.getWeworkUserNum();
            int autoPass = userDto.getAutoPass();
            PlanQrcodeUserDto configUserDto = (PlanQrcodeUserDto)curPlanUserMap.get(weworkUserNum);
            if (configUserDto == null) {
                userNotChange = false;
                addList.add(this.build(bizId, corpId, planId, marketingQrcode.getId(), weworkUserNum, autoPass, userId));
                continue;
            }
            if (configUserDto.getIsDeleted() == 1 || autoPass != configUserDto.getAutoPass()) {
                userNotChange = false;
                this.regionPlanQrcodeUserMapper.updatePlanQrcodeUserById(configUserDto.getId(), Integer.valueOf(autoPass), userId);
            }
            curPlanUserMap.remove(weworkUserNum);
        }
        if (curPlanUserMap.size() > 0) {
            userNotChange = false;
            List delIds = curPlanUserMap.values().stream().filter(item -> item.getIsDeleted() == 0).map(PlanQrcodeUserDto::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(delIds)) {
                this.regionPlanQrcodeUserMapper.delPlanQrcodeUserByIds(delIds, userId);
            }
        }
        if (addList.size() > 0) {
            this.regionPlanQrcodeUserMapper.batchInsert((Collection)addList);
        }
        if (marketingQrcode.getIsDeleted() == 1) {
            marketingQrcode.setIsDeleted(Integer.valueOf(0));
            userNotChange = false;
        }
        if (!userNotChange) {
            marketingQrcode.setIsSync(Integer.valueOf(0));
            marketingQrcode.setUpdateTime(new Date());
            marketingQrcode.setSyncErrorMsg("");
            this.marketingQrcodeMapper.updateByPrimaryKeySelective((Object)marketingQrcode);
        }
    }

    private void insertRegionPlanQrcodeUser(Long bizId, String corpId, Long planId, Long qrcodeId, List<PlanQrcodeUserDto> regionOfUserDtos, Long userId) {
        ArrayList insertList = Lists.newArrayList();
        for (PlanQrcodeUserDto userDto : regionOfUserDtos) {
            RegionPlanQrcodeUser regionPlanQrcodeUser = this.build(bizId, corpId, planId, qrcodeId, userDto.getWeworkUserNum(), userDto.getAutoPass(), userId);
            insertList.add(regionPlanQrcodeUser);
        }
        if (CollectionUtils.isNotEmpty((Collection)insertList)) {
            this.regionPlanQrcodeUserMapper.batchInsert((Collection)insertList);
        }
    }

    private void delQrcode(String corpId, Long planId, Long updateBy, Collection<MarketingQrcode> delList) {
        List delIds = delList.stream().filter(item -> item.getIsDeleted() == 0).map(item -> item.getId()).collect(Collectors.toList());
        this.marketingQrcodeMapper.delMarketingQrcodeByIds(updateBy, delIds);
        this.regionPlanQrcodeUserMapper.delPlanQrcodeUserByQrcodeId(corpId, planId, updateBy, delIds);
    }

    private RegionPlanQrcodeUser build(Long bizId, String corpId, Long planId, Long qrcodeId, String weworkUserNum, Integer autoPass, Long userId) {
        Date curDate = new Date();
        RegionPlanQrcodeUser qrcodeUser = new RegionPlanQrcodeUser();
        qrcodeUser.setBizId(bizId);
        qrcodeUser.setCorpId(corpId);
        qrcodeUser.setPlanId(planId);
        qrcodeUser.setPlanQrcodeId(qrcodeId);
        qrcodeUser.setWeworkUserNum(weworkUserNum);
        qrcodeUser.setAutoPass(autoPass);
        qrcodeUser.setCreateBy(userId);
        qrcodeUser.setUpdateBy(userId);
        qrcodeUser.setCreateTime(curDate);
        qrcodeUser.setCreateTime(curDate);
        qrcodeUser.setIsDeleted(Integer.valueOf(0));
        return qrcodeUser;
    }

    private List<PlanQrcodeUserDto> allDayOnline(String corpId, Long planId, Long planGroupId) {
        List<String> weworkUsers = this.regionPlanCycleUserService.getCycleUsers(corpId, planId, planGroupId, null);
        ArrayList result = Lists.newArrayList();
        int autoPass = this.regionPlanAutoPassService.curCycleAutoPass(corpId, planId, planGroupId, null);
        weworkUsers.forEach(item -> {
            PlanQrcodeUserDto userDto = new PlanQrcodeUserDto();
            userDto.setWeworkUserNum((String)item);
            userDto.setAutoPass(autoPass);
            result.add(userDto);
        });
        return result;
    }

    private List<PlanQrcodeUserDto> rangeTimeOnline(String corpId, Long planId, Long planGroupId) {
        int todayCycle = DateUtil.getTodayOfWeek();
        Date curTime = new Date();
        Long workCycleId = this.regionPlanWorkCycleMapper.queryCurCycle(corpId, planId, planGroupId, Integer.valueOf(todayCycle), curTime);
        ArrayList result = Lists.newArrayList();
        if (workCycleId == null) {
            return result;
        }
        List<String> weworkUsers = this.regionPlanCycleUserService.getCycleUsers(corpId, planId, planGroupId, workCycleId);
        int autoPass = this.regionPlanAutoPassService.curCycleAutoPass(corpId, planId, planGroupId, workCycleId);
        weworkUsers.forEach(item -> {
            PlanQrcodeUserDto userDto = new PlanQrcodeUserDto();
            userDto.setWeworkUserNum((String)item);
            userDto.setAutoPass(autoPass);
            result.add(userDto);
        });
        return result;
    }

    @Override
    public List<PlanQrcodeUserDto> getCurQrcodeUser(String corpId, Long planId, Long qrcodeId) {
        List qrcodeUsers = this.regionPlanQrcodeUserMapper.queryPlanQrcodeUserAllList(corpId, planId, qrcodeId);
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)qrcodeUsers)) {
            return result;
        }
        qrcodeUsers.forEach(item -> {
            PlanQrcodeUserDto qrcodeUserDto = new PlanQrcodeUserDto();
            qrcodeUserDto.setId(item.getId());
            qrcodeUserDto.setPlanQrcodeId(item.getPlanQrcodeId());
            qrcodeUserDto.setWeworkUserNum(item.getWeworkUserNum());
            qrcodeUserDto.setAutoPass(item.getAutoPass());
            qrcodeUserDto.setIsDeleted(item.getIsDeleted());
            result.add(qrcodeUserDto);
        });
        return result;
    }

    private List<PlanQrcodeUserDto> filterLimitFriends(String corpId, Long planId, Long planGroupId, List<PlanQrcodeUserDto> list) {
        return list.stream().filter(item -> !this.userAddFriendLimitService.isMoreLimit(corpId, planId, planGroupId, item.getWeworkUserNum())).collect(Collectors.toList());
    }

    private Map<Long, List<PlanQrcodeUserDto>> getAlternativeUser(String corpId, Long planId, Long planGroupId) {
        List list = this.regionPlanAlternativeUserMapper.queryRegionAlternativeUser(corpId, planId, planGroupId);
        ArrayList qrcodeUserDtos = Lists.newArrayListWithCapacity((int)list.size());
        for (String weworkUserNum : list) {
            PlanQrcodeUserDto qrcodeUserDto = new PlanQrcodeUserDto();
            qrcodeUserDto.setWeworkUserNum(weworkUserNum);
            qrcodeUserDto.setAutoPass(1);
            qrcodeUserDtos.add(qrcodeUserDto);
        }
        HashMap result = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)qrcodeUserDtos)) {
            result.put(-1L, qrcodeUserDtos);
        }
        return result;
    }
}

