/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.lockcustomer.service;

import cn.kinyun.scrm.page.auth.dto.WoauthUserDto;
import cn.kinyun.scrm.page.auth.utils.WoauthParseUtil;
import com.google.common.collect.Lists;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StrIdAndNameDto;
import com.kuaike.scrm.common.service.ScrmLockCustomerService;
import com.kuaike.scrm.common.service.dto.resp.WeworkUserResp;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.system.entity.LockCustomer;
import com.kuaike.scrm.dal.system.entity.LockCustomerScope;
import com.kuaike.scrm.dal.system.mapper.LockCustomerMapper;
import com.kuaike.scrm.dal.system.mapper.LockCustomerScopeMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.lockcustomer.dto.LockCustomerReqDto;
import com.kuaike.scrm.lockcustomer.dto.LockCustomerRespDto;
import com.kuaike.scrm.lockcustomer.service.LockCustomerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LockCustomerServiceImpl
implements LockCustomerService {
    private static final Logger log = LoggerFactory.getLogger(LockCustomerServiceImpl.class);
    @Autowired
    private LockCustomerMapper lockCustomerMapper;
    @Autowired
    private LockCustomerScopeMapper lockCustomerScopeMapper;
    @Autowired
    private WeworkDepartmentMapper departmentMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WoauthParseUtil woauthParseUtil;
    @Autowired
    private ScrmLockCustomerService scrmLockCustomerService;
    @Autowired
    private IdGen idGen;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void lockCustomerSetting(LockCustomerReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Long bizId = userInfo.getBizId();
        log.info("lockCustomerSetting corpId: {}, bizId: {}, reqDto: {}", new Object[]{corpId, bizId, reqDto});
        reqDto.validate();
        LockCustomer lc = this.lockCustomerMapper.queryLockCustomer(corpId);
        if (lc == null) {
            lc = this.buildLockCustomer(reqDto, corpId, bizId, userInfo.getId());
            this.lockCustomerMapper.insertSelective((Object)lc);
            Long lcId = lc.getId();
            ArrayList scopeList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(reqDto.getWeworkDepIds())) {
                reqDto.getWeworkDepIds().forEach(a -> {
                    LockCustomerScope scope = this.buildLockCustomerScope(corpId, bizId, userInfo.getId(), lcId);
                    scope.setWeworkUserNum(null);
                    scope.setWeworkDepartmentId(a);
                    scope.setType(Integer.valueOf(1));
                    scopeList.add(scope);
                });
            }
            if (CollectionUtils.isNotEmpty(reqDto.getWeworkUserIds())) {
                reqDto.getWeworkUserIds().forEach(a -> {
                    LockCustomerScope scope = this.buildLockCustomerScope(corpId, bizId, userInfo.getId(), lcId);
                    scope.setWeworkUserNum(a);
                    scope.setWeworkDepartmentId(null);
                    scope.setType(Integer.valueOf(2));
                    scopeList.add(scope);
                });
            }
            if (scopeList.size() > 0) {
                this.lockCustomerScopeMapper.insertScopeList((List)scopeList);
            }
        } else {
            LockCustomerScope scope;
            lc.setState(reqDto.getState());
            lc.setAddRule(reqDto.getAddRule());
            lc.setOrderRule(reqDto.getOrderRule());
            lc.setOrderState(reqDto.getOrderState());
            lc.setUpdateBy(userInfo.getId());
            lc.setUpdateTime(new Date());
            this.lockCustomerMapper.updateByPrimaryKeySelective((Object)lc);
            Long lcId = lc.getId();
            List scopeList = this.lockCustomerScopeMapper.queryScopeList(bizId, lcId);
            ArrayList delScopeIdList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)scopeList)) {
                List<LockCustomerScope> weworkUserScopes;
                List<LockCustomerScope> depScopes = scopeList.stream().filter(a -> a.getType() == 1).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(depScopes)) {
                    depScopes.forEach(a -> {
                        if (!reqDto.getWeworkDepIds().contains(a.getWeworkDepartmentId())) {
                            delScopeIdList.add(a.getNum());
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(weworkUserScopes = scopeList.stream().filter(a -> a.getType() == 2).collect(Collectors.toList()))) {
                    weworkUserScopes.forEach(a -> {
                        if (!reqDto.getWeworkUserIds().contains(a.getWeworkUserNum())) {
                            delScopeIdList.add(a.getNum());
                        }
                    });
                }
            }
            ArrayList addScopeList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(reqDto.getWeworkDepIds())) {
                for (Integer depId : reqDto.getWeworkDepIds()) {
                    scope = this.lockCustomerScopeMapper.queryScope(bizId, Integer.valueOf(1), depId, null);
                    if (scope != null) continue;
                    scope = this.buildLockCustomerScope(corpId, bizId, userInfo.getId(), lcId);
                    scope.setWeworkDepartmentId(depId);
                    scope.setType(Integer.valueOf(1));
                    addScopeList.add(scope);
                }
            }
            if (CollectionUtils.isNotEmpty(reqDto.getWeworkUserIds())) {
                for (String userNum : reqDto.getWeworkUserIds()) {
                    scope = this.lockCustomerScopeMapper.queryScope(bizId, Integer.valueOf(2), null, userNum);
                    if (scope != null) continue;
                    scope = this.buildLockCustomerScope(corpId, bizId, userInfo.getId(), lcId);
                    scope.setWeworkUserNum(userNum);
                    scope.setType(Integer.valueOf(2));
                    addScopeList.add(scope);
                }
            }
            log.info("lockCustomerSetting addScope: {}, delScope: {}", (Object)addScopeList, (Object)delScopeIdList);
            if (!addScopeList.isEmpty()) {
                this.lockCustomerScopeMapper.insertScopeList((List)addScopeList);
            }
            if (!delScopeIdList.isEmpty()) {
                this.lockCustomerScopeMapper.delScopeList(bizId, (List)delScopeIdList);
            }
        }
    }

    LockCustomer buildLockCustomer(LockCustomerReqDto reqDto, String corpId, Long bizId, Long userId) {
        LockCustomer lockCustomer = new LockCustomer();
        lockCustomer.setNum(this.idGen.getNum());
        lockCustomer.setBizId(bizId);
        lockCustomer.setCorpId(corpId);
        lockCustomer.setCreateBy(userId);
        lockCustomer.setCreateTime(new Date());
        lockCustomer.setUpdateBy(userId);
        lockCustomer.setUpdateTime(new Date());
        lockCustomer.setState(reqDto.getState());
        lockCustomer.setAddRule(reqDto.getAddRule());
        lockCustomer.setOrderRule(reqDto.getOrderRule());
        lockCustomer.setOrderState(reqDto.getOrderState());
        return lockCustomer;
    }

    LockCustomerScope buildLockCustomerScope(String corpId, Long bizId, Long userId, Long lcId) {
        LockCustomerScope scope = new LockCustomerScope();
        scope.setNum(this.idGen.getNum());
        scope.setBizId(bizId);
        scope.setCorpId(corpId);
        scope.setCreateBy(userId);
        scope.setCreateTime(new Date());
        scope.setUpdateBy(userId);
        scope.setUpdateTime(new Date());
        scope.setIsDeleted(Integer.valueOf(0));
        scope.setLockCustomerId(lcId);
        return scope;
    }

    @Override
    public LockCustomerRespDto lockCustomerDetail() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Long bizId = userInfo.getBizId();
        log.info("lockCustomerDetail corpId: {}, bizId: {}", (Object)corpId, (Object)bizId);
        LockCustomer lc = this.lockCustomerMapper.queryLockCustomer(corpId);
        if (lc == null) {
            return null;
        }
        LockCustomerRespDto respDto = new LockCustomerRespDto();
        respDto.setState(lc.getState());
        respDto.setAddRule(lc.getAddRule());
        respDto.setOrderRule(lc.getOrderRule());
        respDto.setOrderState(lc.getOrderState());
        ArrayList weworkDepDtos = Lists.newArrayList();
        respDto.setWeworkDepDtos(weworkDepDtos);
        ArrayList weworkUserDtos = Lists.newArrayList();
        respDto.setWeworkUserDtos(weworkUserDtos);
        List scopeList = this.lockCustomerScopeMapper.queryScopeList(bizId, lc.getId());
        if (CollectionUtils.isNotEmpty((Collection)scopeList)) {
            List depIds = scopeList.stream().filter(a -> a.getType() == 1).map(LockCustomerScope::getWeworkDepartmentId).collect(Collectors.toList());
            log.info("lockCustomerDetail depIds: {}", depIds);
            if (CollectionUtils.isNotEmpty(depIds)) {
                List departments = this.departmentMapper.queryDeptNames(corpId, depIds);
                departments.forEach(a -> {
                    IdAndNameDto dto = new IdAndNameDto();
                    dto.setId(Long.valueOf(a.getDepartmentId().longValue()));
                    dto.setName(a.getName());
                    weworkDepDtos.add(dto);
                });
            }
            List weworkUserNums = scopeList.stream().filter(a -> a.getType() == 2).map(LockCustomerScope::getWeworkUserNum).collect(Collectors.toList());
            log.info("lockCustomerDetail weworkUserNums: {}", weworkUserNums);
            if (CollectionUtils.isNotEmpty(weworkUserNums)) {
                List userList = this.weworkUserMapper.queryWeworkUsersByNums(corpId, weworkUserNums);
                userList.forEach(a -> {
                    StrIdAndNameDto dto = new StrIdAndNameDto();
                    dto.setId(a.getNum());
                    dto.setName(a.getName());
                    weworkUserDtos.add(dto);
                });
            }
        }
        return respDto;
    }

    @Override
    public WeworkUserResp queryWeworkUserCode(HttpServletRequest request) {
        WoauthUserDto userDto = this.woauthParseUtil.getWoauthInfo(request);
        log.info("queryWeworkUserCode userDto: {}", (Object)userDto);
        if (userDto != null) {
            String contactId = userDto.getExternalUserId();
            String corpId = userDto.getCorpId();
            return this.scrmLockCustomerService.queryWeworkUserCodeByContactId(contactId, corpId);
        }
        return null;
    }
}

