/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.customerupdate.service.impl;

import cn.hutool.core.util.NumberUtil;
import cn.kinyun.crm.common.service.CrmTemplateService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsConfBaseResp;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.enums.ExportTaskType;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.customerupdate.dto.ExportCuContactDto;
import com.kuaike.scrm.customerupdate.dto.req.CuExportReq;
import com.kuaike.scrm.customerupdate.enums.CuHandlerStatusEnum;
import com.kuaike.scrm.customerupdate.enums.TaskTypeEnum;
import com.kuaike.scrm.customerupdate.enums.ValidateStatusEnum;
import com.kuaike.scrm.dal.exporttask.entity.ExportTask;
import com.kuaike.scrm.dal.exporttask.mapper.ExportTaskMapper;
import com.kuaike.scrm.dal.marketing.dto.CustomerUpdateTaskDetailQuery;
import com.kuaike.scrm.dal.marketing.entity.CustomerUpdateTask;
import com.kuaike.scrm.dal.marketing.entity.CustomerUpdateTaskDetail;
import com.kuaike.scrm.dal.marketing.entity.CustomerUpdateTaskDetailTag;
import com.kuaike.scrm.dal.marketing.mapper.CustomerUpdateTaskDetailMapper;
import com.kuaike.scrm.dal.marketing.mapper.CustomerUpdateTaskDetailTagMapper;
import com.kuaike.scrm.dal.marketing.mapper.CustomerUpdateTaskMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.wework.contact.service.impl.AbstractExportService;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="customerUpdate")
public class CustomerUpdateExportServiceImpl
extends AbstractExportService {
    private static final Logger log = LoggerFactory.getLogger(CustomerUpdateExportServiceImpl.class);
    @Resource
    private ExportTaskMapper exportTaskMapper;
    @Resource
    private CustomerUpdateTaskMapper customerUpdateTaskMapper;
    @Resource
    private CrmTemplateService crmTemplateService;
    @Resource
    private CustomerUpdateTaskDetailTagMapper detailTagMapper;
    @Resource
    private UserMapper userMapper;
    private static final Integer BUTCH_SIZE = 300;
    private static final List<String> CRM_FIXED_HEADS = Lists.newArrayList((Object[])new String[]{"\u624b\u673a\u53f7", "\u5ba2\u6237\u540d\u79f0", "\u6807\u7b7e\u7ec4\u540d", "\u6807\u7b7e", "\u7ed1\u5b9a\u4eba", "\u5ba2\u6237\u9636\u6bb5", "\u6570\u636e\u6e20\u9053"});
    private static final List<String> CENTER_HEADER = Lists.newArrayList((Object[])new String[]{"market_user_id"});
    private static final List<String> CRM_POST_HEADS = Lists.newArrayList((Object[])new String[]{"\u6821\u9a8c\u72b6\u6001", "\u66f4\u65b0\u72b6\u6001", "\u539f\u56e0"});
    private static final int CRM_BUSINESS_TYPE = 1;
    @Resource
    private CustomerUpdateTaskDetailMapper customerUpdateTaskDetailMapper;

    protected Runnable buildTask(ExportTask task, String json) {
        return () -> {
            if (task == null) {
                log.info("build task is null");
                return;
            }
            try {
                log.info("run task num: {},json:{}", (Object)task.getNum(), (Object)json);
                String filePath = this.createExportFile(task, json);
                task.setFilePath(filePath);
            }
            catch (BusinessException e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg(e.getMessage());
            }
            catch (Exception e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
            }
            finally {
                task.setStatus(Integer.valueOf(2));
                task.setUpdateTime(new Date());
                this.exportTaskMapper.updateByPrimaryKeySelective((Object)task);
            }
        };
    }

    private String createExportFile(ExportTask task, String json) {
        this.createCorpDir(task.getCorpId());
        String filePath = this.createFilePath(task.getCorpId(), ExportTaskType.CUSTOMER_UPDATE, null);
        String sheetName = ExportTaskType.CUSTOMER_UPDATE.getCNDesc();
        CuExportReq cuExportReq = (CuExportReq)JSON.parseObject((String)json, CuExportReq.class);
        if (Objects.isNull(cuExportReq) || StringUtils.isEmpty((CharSequence)cuExportReq.getTaskId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u524d\u7aef\u53c2\u6570\u5f02\u5e38");
        }
        CustomerUpdateTask customerUpdateTask = this.customerUpdateTaskMapper.selectByNum(cuExportReq.getTaskId());
        if (Objects.isNull(customerUpdateTask)) {
            log.error("\u672a\u627e\u5230\u5ba2\u6237\u66f4\u65b0\u4efb\u52a1 taskId:{}", (Object)cuExportReq.getTaskId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u672a\u627e\u5230\u5ba2\u6237\u66f4\u65b0\u4efb\u52a1 taskId" + cuExportReq.getTaskId());
        }
        int queriedCount = 0;
        ExcelWriter excelWriter = null;
        String url = null;
        try {
            block17: {
                if (TaskTypeEnum.WEWORK_CUSTOMER_UPDATE.getValue() == cuExportReq.getTaskType().intValue()) {
                    excelWriter = EasyExcelFactory.write((String)filePath, ExportCuContactDto.class).build();
                } else if (TaskTypeEnum.MOBILE_CUSTOMER_UPDATE.getValue() == cuExportReq.getTaskType().intValue()) {
                    excelWriter = EasyExcelFactory.write((String)filePath).build();
                } else {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5bfc\u51fa\u4efb\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a taskType" + cuExportReq.getTaskType());
                }
                WriteSheet writeSheet = EasyExcel.writerSheet((String)sheetName).build();
                while (true) {
                    CustomerUpdateTaskDetailQuery query = new CustomerUpdateTaskDetailQuery();
                    query.setOffset(Integer.valueOf(queriedCount));
                    query.setPageSize(BUTCH_SIZE);
                    query.setBizId(task.getBizId());
                    query.setTaskId(customerUpdateTask.getId());
                    query.setMobile(cuExportReq.getMobile());
                    query.setHandleStatus(cuExportReq.getHandleStatus());
                    List taskDetails = this.customerUpdateTaskDetailMapper.selectListByParams(query);
                    int size = CollectionUtils.size((Object)taskDetails);
                    if (size == 0) break block17;
                    queriedCount += size;
                    if (TaskTypeEnum.WEWORK_CUSTOMER_UPDATE.getValue() == cuExportReq.getTaskType().intValue()) {
                        List<ExportCuContactDto> exportScrmDtos = this.convertEntityToExport(taskDetails, task.getBizId());
                        excelWriter.write(exportScrmDtos, writeSheet);
                        continue;
                    }
                    if (TaskTypeEnum.MOBILE_CUSTOMER_UPDATE.getValue() != cuExportReq.getTaskType().intValue()) break;
                    this.exportCrm(excelWriter, writeSheet, taskDetails, customerUpdateTask);
                }
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5bfc\u51fa\u4efb\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a taskType" + cuExportReq.getTaskType());
            }
            excelWriter.finish();
            File file = new File(filePath);
            if (file.exists()) {
                url = this.uploadOss(task.getCorpId(), file);
            }
        }
        catch (BusinessException e) {
            log.error("createExportFile BusinessException error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
        catch (Exception e) {
            log.error("createExportFile error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            File file;
            if (excelWriter != null) {
                excelWriter.finish();
            }
            if ((file = new File(filePath)).exists()) {
                file.delete();
            }
        }
        return url;
    }

    public List<ExportCuContactDto> convertEntityToExport(List<CustomerUpdateTaskDetail> entities, Long bizId) {
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newArrayList();
        }
        Map<Long, List<CustomerUpdateTaskDetailTag>> taskDetailTags = this.buildTaskTagMap(entities, bizId);
        return entities.stream().map(item -> this.entityToScrmExportDto((CustomerUpdateTaskDetail)item, taskDetailTags)).collect(Collectors.toList());
    }

    private ExportCuContactDto entityToScrmExportDto(CustomerUpdateTaskDetail e, Map<Long, List<CustomerUpdateTaskDetailTag>> taskDetailTagMaps) {
        ExportCuContactDto exportDto = new ExportCuContactDto();
        exportDto.setUnionId(e.getUnionid());
        exportDto.setMobile(e.getMobile());
        List<CustomerUpdateTaskDetailTag> taskDetailTags = taskDetailTagMaps.get(e.getId());
        String groupName = "";
        String tagNames = "";
        if (CollectionUtils.isNotEmpty(taskDetailTags)) {
            groupName = taskDetailTags.stream().map(CustomerUpdateTaskDetailTag::getGroupName).filter(StringUtils::isNotBlank).findFirst().orElse("");
            tagNames = taskDetailTags.stream().map(CustomerUpdateTaskDetailTag::getTagName).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
        }
        exportDto.setTagGroupName(groupName);
        exportDto.setTagNames(tagNames);
        exportDto.setRemarkName(e.getRemarkName());
        exportDto.setDesc(e.getDescription());
        exportDto.setStageName(e.getStageName());
        exportDto.setChannelName(e.getChannelName());
        exportDto.setCommunicationMobile(e.getCommunicationMobile());
        ArrayList handlerStatusEnums = Lists.newArrayList();
        handlerStatusEnums.add(CuHandlerStatusEnum.SUCCESS.getValue());
        handlerStatusEnums.add(CuHandlerStatusEnum.FAIL.getValue());
        String handlerStatus = "";
        if (handlerStatusEnums.contains(e.getHandleStatus())) {
            handlerStatus = CuHandlerStatusEnum.getDescById(e.getHandleStatus());
        }
        String validateStatus = ValidateStatusEnum.getDescById(e.getValidateStatus());
        exportDto.setValidateStatus(validateStatus);
        exportDto.setUpdateStatus(handlerStatus);
        String errorMsg = Optional.ofNullable(e.getValidateFailReason()).filter(StringUtils::isNotBlank).orElse(e.getHandleFailReason());
        exportDto.setErrMsg(errorMsg);
        return exportDto;
    }

    public void exportCrm(ExcelWriter excelWriter, WriteSheet writeSheet, List<CustomerUpdateTaskDetail> updateTaskDetails, CustomerUpdateTask task) {
        if (CollectionUtils.isEmpty(updateTaskDetails)) {
            return;
        }
        Long productLineId = task.getProductLineId();
        if (Objects.isNull(productLineId)) {
            log.error("\u5ba2\u6237\u8ddf\u65b0\u4e3b\u8868\u672a\u627e\u5230\u9500\u552e\u7ebf\u7ebf:taskId:{};", (Object)task.getId());
            return;
        }
        List headers = null;
        try {
            headers = this.crmTemplateService.getHeaders(task.getBizId(), productLineId);
            log.info("\u83b7\u53d6crm \u5bfc\u51fa headers:{}", (Object)JSON.toJSONString((Object)headers));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6crm \u4e1a\u52a1\u5b57\u6bb5\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u6cd5\u5bfc\u51fa; bizId:{}; productLine:{}", new Object[]{task.getBizId(), productLineId, e});
        }
        if (CollectionUtils.isEmpty((Collection)headers)) {
            log.error("\u83b7\u53d6crm \u4e1a\u52a1\u5b57\u6bb5\u8868\u5934\u672a\u7a7a; bizId:{}; productLine:{}", (Object)task.getBizId(), (Object)productLineId);
            return;
        }
        ArrayList<String> fields = new ArrayList<String>();
        WriteTable writeTable = this.buildFieldsAndCreateWriteTable(fields, headers);
        Map<Long, List<CustomerUpdateTaskDetailTag>> taskDetailTags = this.buildTaskTagMap(updateTaskDetails, task.getBizId());
        Set bindingUserIds = updateTaskDetails.stream().map(CustomerUpdateTaskDetail::getBindingUserId).filter(Objects::nonNull).collect(Collectors.toSet());
        Set marketUserIds = updateTaskDetails.stream().map(CustomerUpdateTaskDetail::getMarketUserId).filter(Objects::nonNull).collect(Collectors.toSet());
        bindingUserIds.addAll(marketUserIds);
        Map userNameByIds = this.userMapper.queryUserNameByIds(bindingUserIds);
        List<List<String>> lists = this.lineList(updateTaskDetails, fields, taskDetailTags, userNameByIds);
        excelWriter.write(lists, writeSheet, writeTable);
    }

    private WriteTable buildFieldsAndCreateWriteTable(List<String> fields, List<CrmLeadsConfBaseResp> headers) {
        ArrayList<String> headTitle;
        WriteTable writeTable = new WriteTable();
        ArrayList headList = new ArrayList();
        for (String crmFixedHead : CRM_FIXED_HEADS) {
            headTitle = new ArrayList<String>();
            headTitle.add(crmFixedHead);
            headList.add(headTitle);
        }
        for (CrmLeadsConfBaseResp header : headers) {
            if (StringUtils.isBlank((CharSequence)header.getFieldName()) || !CENTER_HEADER.contains(header.getFieldName())) continue;
            headTitle = new ArrayList();
            headTitle.add(header.getName());
            headList.add(headTitle);
            fields.add(header.getFieldName());
        }
        for (CrmLeadsConfBaseResp header : headers) {
            headTitle = new ArrayList();
            if (CRM_FIXED_HEADS.contains(header.getName()) || !this.checkFieldIsBusiness(header)) continue;
            headTitle.add(header.getName());
            headList.add(headTitle);
            fields.add(header.getFieldName());
        }
        for (String crmPostHead : CRM_POST_HEADS) {
            headTitle = new ArrayList();
            headTitle.add(crmPostHead);
            headList.add(headTitle);
        }
        writeTable.setHead(headList);
        return writeTable;
    }

    public Map<Long, List<CustomerUpdateTaskDetailTag>> buildTaskTagMap(List<CustomerUpdateTaskDetail> updateTaskDetails, Long bizId) {
        if (CollectionUtils.isEmpty(updateTaskDetails)) {
            return Maps.newHashMap();
        }
        Set taskDetailIds = updateTaskDetails.stream().map(CustomerUpdateTaskDetail::getId).collect(Collectors.toSet());
        List updateTaskDetailTags = this.detailTagMapper.selectByBizIdAndTaskDetailIds(bizId, taskDetailIds);
        if (CollectionUtils.isEmpty((Collection)updateTaskDetailTags)) {
            return Maps.newHashMap();
        }
        return updateTaskDetailTags.stream().collect(Collectors.groupingBy(CustomerUpdateTaskDetailTag::getTaskDetailId));
    }

    public List<List<String>> lineList(List<CustomerUpdateTaskDetail> updateTaskDetails, List<String> fields, Map<Long, List<CustomerUpdateTaskDetailTag>> taskDetailTagMaps, Map<Long, String> userNameById) {
        log.info("crm customer update export fieldList:{}", fields);
        ArrayList<List<String>> lineList = new ArrayList<List<String>>();
        for (CustomerUpdateTaskDetail detail : updateTaskDetails) {
            ArrayList<String> line = new ArrayList<String>();
            List<CustomerUpdateTaskDetailTag> taskDetailTags = taskDetailTagMaps.get(detail.getId());
            String groupName = "";
            String tagNames = "";
            if (CollectionUtils.isNotEmpty(taskDetailTags)) {
                groupName = taskDetailTags.stream().map(CustomerUpdateTaskDetailTag::getGroupName).filter(StringUtils::isNotBlank).findFirst().orElse("");
                tagNames = taskDetailTags.stream().map(CustomerUpdateTaskDetailTag::getTagName).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
            }
            String bindingUserName = detail.getBindingUserIdentifier();
            if (Objects.nonNull(detail.getBindingUserId())) {
                bindingUserName = userNameById.getOrDefault(detail.getBindingUserId(), detail.getBindingUserIdentifier());
            }
            line.add(detail.getMobile());
            line.add(detail.getCustomerName());
            line.add(groupName);
            line.add(tagNames);
            line.add(bindingUserName);
            line.add(detail.getStageName());
            line.add(detail.getChannelName());
            for (String cen : CENTER_HEADER) {
                if (!fields.contains(cen)) continue;
                String marketUserName = detail.getMarketUserName();
                if (Objects.nonNull(detail.getMarketUserId())) {
                    marketUserName = userNameById.getOrDefault(detail.getMarketUserId(), detail.getMarketUserName());
                }
                line.add(marketUserName);
            }
            for (String field : fields) {
                if (CENTER_HEADER.contains(field)) continue;
                try {
                    Class<?> aClass = detail.getClass();
                    Field declaredField = aClass.getDeclaredField(field);
                    declaredField.setAccessible(true);
                    Object value = declaredField.get(detail);
                    if (value == null) {
                        line.add("");
                        continue;
                    }
                    if (value instanceof Integer) {
                        Integer integer = (Integer)value;
                        line.add(String.valueOf(integer));
                        continue;
                    }
                    if (value instanceof Date) {
                        Date date = (Date)value;
                        line.add(DateUtil.dateToDateString((Date)date));
                        continue;
                    }
                    line.add(String.valueOf(value));
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6crm \u5c5e\u6027\u5931\u8d25", (Throwable)e);
                    line.add("");
                }
            }
            String validateStatus = Optional.ofNullable(ValidateStatusEnum.getDescById(detail.getValidateStatus())).orElse("");
            ArrayList handlerStatusEnums = Lists.newArrayList();
            handlerStatusEnums.add(CuHandlerStatusEnum.SUCCESS.getValue());
            handlerStatusEnums.add(CuHandlerStatusEnum.FAIL.getValue());
            String errMsg = Optional.ofNullable(detail.getValidateFailReason()).filter(StringUtils::isNotBlank).orElse(detail.getHandleFailReason());
            String handlerStatus = "";
            if (handlerStatusEnums.contains(detail.getHandleStatus())) {
                handlerStatus = CuHandlerStatusEnum.getDescById(detail.getHandleStatus());
            }
            line.add(validateStatus);
            line.add(handlerStatus);
            line.add(errMsg);
            lineList.add(line);
        }
        return lineList;
    }

    public boolean checkFieldIsBusiness(CrmLeadsConfBaseResp header) {
        if (Objects.isNull(header)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)header.getFieldName())) {
            return false;
        }
        if (header.getConfigType() != 1) {
            return false;
        }
        if (!StringUtils.startsWith((CharSequence)header.getFieldName(), (CharSequence)"p")) {
            return false;
        }
        String postField = StringUtils.remove((String)header.getFieldName(), (String)"p");
        return NumberUtil.isNumber((CharSequence)postField);
    }
}

