/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.roomPlan.service.impl;

import cn.kinyun.scrm.page.auth.dto.WoauthUserDto;
import cn.kinyun.scrm.page.auth.utils.MpLoginUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.dto.ChannelDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.marketing.dto.RoomPlanChannelResp;
import com.kuaike.scrm.dal.marketing.dto.RoomPlanListQuery;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlanCriteria;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlanGroup;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlanRoomCode;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlanRoomCodeJoinLog;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelReportMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanGroupMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanRoomCodeJoinLogMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanRoomCodeMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.marketing.dto.client.ClientParamsDto;
import com.kuaike.scrm.marketing.service.MarketingChannelService;
import com.kuaike.scrm.marketing.service.MarketingPlanService;
import com.kuaike.scrm.roomPlan.dto.client.ClientGroupParam;
import com.kuaike.scrm.roomPlan.dto.client.RoomCodeInfo;
import com.kuaike.scrm.roomPlan.dto.client.RoomGroupInfo;
import com.kuaike.scrm.roomPlan.dto.client.RoomPlanInfo;
import com.kuaike.scrm.roomPlan.dto.req.RoomBaseReqDto;
import com.kuaike.scrm.roomPlan.dto.req.RoomCodeDesc;
import com.kuaike.scrm.roomPlan.dto.req.RoomEnableReqDto;
import com.kuaike.scrm.roomPlan.dto.req.RoomLiveCodeDesc;
import com.kuaike.scrm.roomPlan.dto.req.RoomPlanInfoReqDto;
import com.kuaike.scrm.roomPlan.dto.req.RoomPlanReqDto;
import com.kuaike.scrm.roomPlan.dto.resp.RoomPlanInfoResp;
import com.kuaike.scrm.roomPlan.service.RoomPlanService;
import com.kuaike.scrm.system.service.ChannelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoomPlanServiceImpl
implements RoomPlanService {
    private static final Logger log = LoggerFactory.getLogger(RoomPlanServiceImpl.class);
    @Resource
    private MarketingPlanMapper marketingPlanMapper;
    @Autowired
    private MarketingChannelService marketingChannelService;
    @Autowired
    private ChannelService channelService;
    @Resource
    private MarketingPlanGroupMapper marketingPlanGroupMapper;
    @Autowired
    private MarketingPlanRoomCodeMapper roomCodeMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private MarketingPlanRoomCodeJoinLogMapper roomCodeJoinLogMapper;
    @Resource
    private MarketingChannelReportMapper marketingChannelReportMapper;
    @Resource
    private MarketingChannelMapper marketingChannelMapper;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private MarketingPlanService marketingPlanService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addRoomPlan(RoomPlanReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        log.info("addRoomPlan bizId: {}, corpId: {}, userId: {}, req: {}", new Object[]{bizId, corpId, userId, reqDto});
        reqDto.validate();
        if (this.marketingPlanService.isRepeatMarketingPlanName(corpId, reqDto.getName(), null, PlanType.ROOM_PLAN)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u540d\u5df2\u88ab\u4f7f\u7528");
        }
        Long planId = this.insertMarketingPlan(reqDto);
        log.info("addRoomPlan planId: {}", (Object)planId);
        Map<String, Long> groupMap = null;
        if (reqDto.getGroupType() == 1) {
            ArrayList groupNames = Lists.newArrayList();
            if (reqDto.getLiveCodeType() == 1 && CollectionUtils.isNotEmpty(reqDto.getRoomCodeSettings())) {
                for (RoomCodeDesc roomCodeDesc : reqDto.getRoomCodeSettings()) {
                    if (groupNames.contains(roomCodeDesc.getGroupName())) continue;
                    groupNames.add(roomCodeDesc.getGroupName());
                }
            }
            if (reqDto.getLiveCodeType() == 2 && CollectionUtils.isNotEmpty(reqDto.getRoomLiveCodeSettings())) {
                for (RoomLiveCodeDesc roomLiveCodeDesc : reqDto.getRoomLiveCodeSettings()) {
                    if (groupNames.contains(roomLiveCodeDesc.getGroupName())) continue;
                    groupNames.add(roomLiveCodeDesc.getGroupName());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)groupNames)) {
                groupMap = this.insertMarketingGroup(groupNames, planId);
                log.info("addRoomPlan groupMap: {}", groupMap);
            }
        }
        if (reqDto.getLiveCodeType() == 1 && CollectionUtils.isNotEmpty(reqDto.getRoomCodeSettings())) {
            this.insertMarketingPlanRoomCode(reqDto.getRoomCodeSettings(), groupMap, planId);
        }
        if (reqDto.getLiveCodeType() == 2 && CollectionUtils.isNotEmpty(reqDto.getRoomLiveCodeSettings())) {
            this.insertMarketingPlanRoomLiveCode(reqDto.getRoomLiveCodeSettings(), groupMap, planId);
        }
        List channelIdList = this.channelService.getChannelIdByNum(reqDto.getChannelIds());
        channelIdList.add(-1L);
        this.marketingChannelService.saveMarketingChannels(bizId, corpId, userId, planId, channelIdList, reqDto.getStatisticType(), PlanType.ROOM_PLAN);
    }

    private Long insertMarketingPlan(RoomPlanReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(this.idGen.getNum());
        marketingPlan.setBizId(userInfo.getBizId());
        marketingPlan.setCorpId(userInfo.getCorpId());
        marketingPlan.setIsDeleted(Integer.valueOf(0));
        marketingPlan.setCreateBy(userInfo.getId());
        marketingPlan.setCreateTime(new Date());
        marketingPlan.setUpdateBy(userInfo.getId());
        marketingPlan.setUpdateTime(new Date());
        marketingPlan.setName(reqDto.getName());
        marketingPlan.setType(Integer.valueOf(PlanType.ROOM_PLAN.getValue()));
        marketingPlan.setIsEnabled(Integer.valueOf(1));
        marketingPlan.setStatsType(reqDto.getStatisticType());
        marketingPlan.setLiveCodeType(reqDto.getLiveCodeType());
        marketingPlan.setBgImg(reqDto.getBgImg());
        marketingPlan.setCustomerServiceCode(reqDto.getCustomerServiceId());
        this.marketingPlanMapper.insertSelective((Object)marketingPlan);
        reqDto.setId(marketingPlan.getNum());
        return marketingPlan.getId();
    }

    private Map<String, Long> insertMarketingGroup(Collection<String> groupNames, Long planId) {
        HashMap<String, Long> marketingGroupNameIds = new HashMap<String, Long>();
        for (String groupName : groupNames) {
            CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
            MarketingPlanGroup marketingPlanGroup = new MarketingPlanGroup();
            marketingPlanGroup.setNum(this.idGen.getNum());
            marketingPlanGroup.setBizId(userInfo.getBizId());
            marketingPlanGroup.setCorpId(userInfo.getCorpId());
            marketingPlanGroup.setPlanId(planId);
            marketingPlanGroup.setName(groupName);
            marketingPlanGroup.setCreateBy(userInfo.getId());
            marketingPlanGroup.setCreateTime(new Date());
            marketingPlanGroup.setUpdateBy(userInfo.getId());
            marketingPlanGroup.setUpdateTime(new Date());
            marketingPlanGroup.setIsDeleted(Integer.valueOf(0));
            this.marketingPlanGroupMapper.insertSelective((Object)marketingPlanGroup);
            Long groupId = marketingPlanGroup.getId();
            marketingGroupNameIds.put(groupName, groupId);
        }
        return marketingGroupNameIds;
    }

    private void insertMarketingPlanRoomCode(List<RoomCodeDesc> roomCodeSettings, Map<String, Long> groupMap, Long planId) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        ArrayList roomCodes = Lists.newArrayList();
        for (RoomCodeDesc codeDesc : roomCodeSettings) {
            MarketingPlanRoomCode roomCode = new MarketingPlanRoomCode();
            roomCode.setNum(this.idGen.getNum());
            roomCode.setBizId(userInfo.getBizId());
            roomCode.setCorpId(userInfo.getCorpId());
            roomCode.setCreateBy(userInfo.getId());
            roomCode.setCreateTime(new Date());
            roomCode.setIsDeleted(Integer.valueOf(0));
            roomCode.setPlanId(planId);
            roomCode.setPlanCodeType(Integer.valueOf(1));
            roomCode.setRoomId(codeDesc.getRoomId());
            roomCode.setRoomName(codeDesc.getRoomName());
            roomCode.setRoomQrcode(codeDesc.getRoomCode());
            roomCode.setExpireTime(codeDesc.getExpireTime());
            roomCode.setCodeStatus(Integer.valueOf(0));
            roomCode.setMaxScanCount(codeDesc.getMaxScanCount());
            if (groupMap != null) {
                Long groupId = groupMap.get(codeDesc.getGroupName());
                roomCode.setPlanGroupId(groupId);
            }
            roomCodes.add(roomCode);
        }
        if (CollectionUtils.isNotEmpty((Collection)roomCodes)) {
            this.roomCodeMapper.insertRoomCodes((List)roomCodes);
        }
    }

    private void insertMarketingPlanRoomLiveCode(List<RoomLiveCodeDesc> roomLiveCodeSettings, Map<String, Long> groupMap, Long planId) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        ArrayList roomCodes = Lists.newArrayList();
        for (RoomLiveCodeDesc codeDesc : roomLiveCodeSettings) {
            MarketingPlanRoomCode roomCode = new MarketingPlanRoomCode();
            roomCode.setNum(this.idGen.getNum());
            roomCode.setBizId(userInfo.getBizId());
            roomCode.setCorpId(userInfo.getCorpId());
            roomCode.setCreateBy(userInfo.getId());
            roomCode.setCreateTime(new Date());
            roomCode.setIsDeleted(Integer.valueOf(0));
            roomCode.setPlanId(planId);
            roomCode.setPlanCodeType(Integer.valueOf(2));
            roomCode.setLiveCode(codeDesc.getWeworkLiveCode());
            roomCode.setLiveCodeDesc(codeDesc.getRemark());
            roomCode.setCodeStatus(Integer.valueOf(0));
            roomCode.setMaxScanCount(codeDesc.getMaxScanCount());
            if (groupMap != null) {
                Long groupId = groupMap.get(codeDesc.getGroupName());
                roomCode.setPlanGroupId(groupId);
            }
            roomCodes.add(roomCode);
        }
        if (CollectionUtils.isNotEmpty((Collection)roomCodes)) {
            this.roomCodeMapper.insertRoomCodes((List)roomCodes);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editRoomPlan(RoomPlanReqDto reqDto) {
        if (StringUtils.isEmpty((CharSequence)reqDto.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        log.info("editRoomPlan bizId: {}, corpId: {}, userId: {}, req: {}", new Object[]{bizId, corpId, userId, reqDto});
        reqDto.validate();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(reqDto.getId());
        marketingPlan.setBizId(bizId);
        marketingPlan.setCorpId(corpId);
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null || marketingPlan.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u53c2\u6570\u4e0d\u5bf9");
        }
        Long planId = marketingPlan.getId();
        if (this.marketingPlanService.isRepeatMarketingPlanName(corpId, reqDto.getName(), marketingPlan.getId(), PlanType.ROOM_PLAN)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u540d\u5df2\u88ab\u4f7f\u7528");
        }
        this.updateMarketingPlan(reqDto);
        HashMap<String, Long> groupMap = new HashMap<String, Long>();
        ArrayList groupNames = Lists.newArrayList();
        if (reqDto.getGroupType() == 1) {
            if (reqDto.getLiveCodeType() == 1 && CollectionUtils.isNotEmpty(reqDto.getRoomCodeSettings())) {
                for (RoomCodeDesc roomCodeDesc : reqDto.getRoomCodeSettings()) {
                    if (groupNames.contains(roomCodeDesc.getGroupName())) continue;
                    groupNames.add(roomCodeDesc.getGroupName());
                }
            }
            if (reqDto.getLiveCodeType() == 2 && CollectionUtils.isNotEmpty(reqDto.getRoomLiveCodeSettings())) {
                for (RoomLiveCodeDesc roomLiveCodeDesc : reqDto.getRoomLiveCodeSettings()) {
                    if (groupNames.contains(roomLiveCodeDesc.getGroupName())) continue;
                    groupNames.add(roomLiveCodeDesc.getGroupName());
                }
            }
        }
        List planGroups = this.marketingPlanGroupMapper.getPlanGroupsByPlanId(planId);
        ArrayList delGroups = Lists.newArrayList();
        for (MarketingPlanGroup group : planGroups) {
            if (groupNames.contains(group.getName())) {
                groupNames.remove(group.getName());
                groupMap.put(group.getName(), group.getId());
                continue;
            }
            delGroups.add(group.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)delGroups)) {
            this.marketingPlanGroupMapper.batchDel(bizId, corpId, planId, userId, (Collection)delGroups);
        }
        if (CollectionUtils.isNotEmpty((Collection)groupNames)) {
            groupMap.putAll(this.insertMarketingGroup(groupNames, planId));
        }
        List existRoomCodes = this.roomCodeMapper.queryRoomCodeByPlanId(planId, corpId, null);
        Set roomCodeNums = existRoomCodes.stream().map(it -> it.getNum()).collect(Collectors.toSet());
        if (reqDto.getLiveCodeType() == 1 && CollectionUtils.isNotEmpty(reqDto.getRoomCodeSettings())) {
            List<RoomCodeDesc> roomCodeList = reqDto.getRoomCodeSettings();
            ArrayList roomCodeAdds = Lists.newArrayList();
            for (RoomCodeDesc roomCodeDesc : roomCodeList) {
                if (StringUtils.isNotEmpty((CharSequence)roomCodeDesc.getId())) {
                    this.updateRoomCode(roomCodeDesc, corpId, (Long)groupMap.get(roomCodeDesc.getGroupName()), userId);
                    roomCodeNums.remove(roomCodeDesc.getId());
                    continue;
                }
                roomCodeAdds.add(roomCodeDesc);
            }
            if (CollectionUtils.isNotEmpty((Collection)roomCodeAdds)) {
                this.insertMarketingPlanRoomCode(roomCodeAdds, groupMap, planId);
            }
            if (CollectionUtils.isNotEmpty(roomCodeNums)) {
                this.roomCodeMapper.delRoomCodeByNums(corpId, planId, roomCodeNums, userId);
            }
        }
        if (reqDto.getLiveCodeType() == 2 && CollectionUtils.isNotEmpty(reqDto.getRoomLiveCodeSettings())) {
            List<RoomLiveCodeDesc> roomLiveCodeList = reqDto.getRoomLiveCodeSettings();
            ArrayList roomLiveCodeAdds = Lists.newArrayList();
            for (RoomLiveCodeDesc roomLiveCodeDesc : roomLiveCodeList) {
                if (StringUtils.isNotEmpty((CharSequence)roomLiveCodeDesc.getId())) {
                    this.updateRoomLiveCode(roomLiveCodeDesc, corpId, (Long)groupMap.get(roomLiveCodeDesc.getGroupName()), userId);
                    roomCodeNums.remove(roomLiveCodeDesc.getId());
                    continue;
                }
                roomLiveCodeAdds.add(roomLiveCodeDesc);
            }
            if (CollectionUtils.isNotEmpty((Collection)roomLiveCodeAdds)) {
                this.insertMarketingPlanRoomLiveCode(roomLiveCodeAdds, groupMap, planId);
            }
            if (CollectionUtils.isNotEmpty(roomCodeNums)) {
                this.roomCodeMapper.delRoomCodeByNums(corpId, planId, roomCodeNums, userId);
            }
        }
        List channelIdList = this.channelService.getChannelIdByNum(reqDto.getChannelIds());
        channelIdList.add(-1L);
        this.marketingChannelService.saveMarketingChannels(bizId, corpId, userId, planId, channelIdList, reqDto.getStatisticType(), PlanType.ROOM_PLAN);
    }

    private void updateRoomCode(RoomCodeDesc roomCodeDesc, String corpId, Long groupId, Long userId) {
        MarketingPlanRoomCode roomCode = new MarketingPlanRoomCode();
        roomCode.setNum(roomCodeDesc.getId());
        roomCode.setCorpId(corpId);
        roomCode = (MarketingPlanRoomCode)this.roomCodeMapper.selectOne((Object)roomCode);
        if (roomCode != null) {
            roomCode.setRoomId(roomCodeDesc.getRoomId());
            roomCode.setRoomName(roomCodeDesc.getRoomName());
            roomCode.setRoomQrcode(roomCodeDesc.getRoomCode());
            roomCode.setExpireTime(roomCodeDesc.getExpireTime());
            roomCode.setCodeStatus(Integer.valueOf(0));
            roomCode.setIsDeleted(Integer.valueOf(0));
            roomCode.setMaxScanCount(roomCodeDesc.getMaxScanCount());
            roomCode.setPlanGroupId(groupId);
            roomCode.setUpdateTime(new Date());
            roomCode.setUpdateBy(userId);
            this.roomCodeMapper.updateByPrimaryKey((Object)roomCode);
        }
    }

    private void updateRoomLiveCode(RoomLiveCodeDesc roomLiveCodeDesc, String corpId, Long groupId, Long userId) {
        MarketingPlanRoomCode roomCode = new MarketingPlanRoomCode();
        roomCode.setNum(roomLiveCodeDesc.getId());
        roomCode.setCorpId(corpId);
        roomCode = (MarketingPlanRoomCode)this.roomCodeMapper.selectOne((Object)roomCode);
        if (roomCode != null) {
            roomCode.setLiveCode(roomLiveCodeDesc.getWeworkLiveCode());
            roomCode.setLiveCodeDesc(roomLiveCodeDesc.getRemark());
            roomCode.setCodeStatus(Integer.valueOf(0));
            roomCode.setIsDeleted(Integer.valueOf(0));
            roomCode.setMaxScanCount(roomLiveCodeDesc.getMaxScanCount());
            roomCode.setPlanGroupId(groupId);
            roomCode.setUpdateTime(new Date());
            roomCode.setUpdateBy(userId);
            this.roomCodeMapper.updateByPrimaryKey((Object)roomCode);
        }
    }

    private void updateMarketingPlan(RoomPlanReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(reqDto.getId());
        marketingPlan.setName(reqDto.getName());
        marketingPlan.setStatsType(reqDto.getStatisticType());
        marketingPlan.setLiveCodeType(reqDto.getLiveCodeType());
        marketingPlan.setBgImg(reqDto.getBgImg());
        marketingPlan.setCustomerServiceCode(reqDto.getCustomerServiceId());
        marketingPlan.setUpdateTime(new Date());
        marketingPlan.setUpdateBy(userInfo.getId());
        MarketingPlanCriteria query = new MarketingPlanCriteria();
        query.createCriteria().andNumEqualTo(reqDto.getId());
        this.marketingPlanMapper.updateByExampleSelective((Object)marketingPlan, (Object)query);
    }

    @Override
    public RoomPlanInfo getPlanInfo(ClientParamsDto params, String uniqId) {
        WeworkUser weworkUser;
        WoauthUserDto userDto = MpLoginUtil.getCurrentUser();
        log.info("getPlanInfo userDto: {}, params: {}", (Object)userDto, (Object)params);
        String num = params.getId();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)num), (Object)"\u6d3b\u52a8id\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        MarketingChannel marketingChannel = this.marketingChannelService.getMarketingChannel(num);
        if (marketingChannel == null || marketingChannel.getIsDeleted() == 1) {
            log.info("getPlanInfo: \u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u8005\u5220\u9664");
            return null;
        }
        Long planId = marketingChannel.getPlanId();
        String corpId = marketingChannel.getCorpId();
        log.info("getPlanInfo get planId: {}, corpId\uff1a{}", (Object)planId, (Object)corpId);
        MarketingPlan plan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)planId);
        if (plan == null || plan.getIsDeleted() == 1 || plan.getIsEnabled() == 0) {
            return null;
        }
        RoomPlanInfo planInfo = new RoomPlanInfo();
        planInfo.setId(plan.getNum());
        planInfo.setBizId(plan.getBizId());
        planInfo.setName(plan.getName());
        planInfo.setLiveCodeType(plan.getLiveCodeType());
        List planGroups = this.marketingPlanGroupMapper.getPlanGroupsByPlanId(planId);
        if (CollectionUtils.isNotEmpty((Collection)planGroups)) {
            List<RoomGroupInfo> groupInfos = planGroups.stream().map(a -> {
                RoomGroupInfo groupInfo = new RoomGroupInfo();
                groupInfo.setGroupId(a.getNum());
                groupInfo.setGroupName(a.getName());
                return groupInfo;
            }).collect(Collectors.toList());
            planInfo.setGroupType(1);
            planInfo.setGroupList(groupInfos);
        } else {
            planInfo.setGroupType(0);
            ClientGroupParam param = new ClientGroupParam();
            param.setPlanId(plan.getNum());
            RoomCodeInfo codeInfo = this.getPlanRoomCodeInfo(param, uniqId);
            planInfo.setCodeInfo(codeInfo);
        }
        planInfo.setBgImg(plan.getBgImg());
        String customerServiceId = plan.getCustomerServiceCode();
        log.info("getPlanInfo customerServiceId: {}", (Object)customerServiceId);
        if (StringUtils.isNotBlank((CharSequence)customerServiceId) && (weworkUser = this.weworkUserMapper.queryWeworkUserByNum(customerServiceId)) != null) {
            planInfo.setCustomerServiceCode(weworkUser.getQrCode());
        }
        log.info("getPlanInfo get planInfo: {}, corpId\uff1a{}", (Object)planInfo, (Object)corpId);
        return planInfo;
    }

    @Override
    public RoomCodeInfo getPlanRoomCodeInfo(ClientGroupParam params, String uniqId) {
        List roomCodes;
        MarketingPlanGroup group;
        log.info("getPlanRoomCodeInfo get planId: {}, groupNum\uff1a{}", (Object)params.getPlanId(), (Object)params.getGroupId());
        MarketingPlan plan = this.marketingPlanMapper.selectByNum(params.getPlanId());
        if (plan == null || plan.getIsDeleted() == 1 || plan.getIsEnabled() == 0) {
            return null;
        }
        Long groupId = null;
        if (params.getGroupId() != null && (group = this.marketingPlanGroupMapper.queryGroupByNum(params.getGroupId())) != null) {
            groupId = group.getId();
        }
        log.info("getPlanRoomCodeInfo get groupId: {}", groupId);
        Long planRoomCodeId = this.roomCodeJoinLogMapper.queryPlanRoomCode(plan.getCorpId(), plan.getId(), groupId, uniqId);
        MarketingPlanRoomCode codeInfo = null;
        if (planRoomCodeId != null) {
            codeInfo = (MarketingPlanRoomCode)this.roomCodeMapper.selectByPrimaryKey((Object)planRoomCodeId);
        }
        if (codeInfo == null && CollectionUtils.isNotEmpty((Collection)(roomCodes = this.roomCodeMapper.queryRoomCodeByPlanId(plan.getId(), plan.getCorpId(), groupId)))) {
            codeInfo = this.selectClientCodeInfo(roomCodes, plan.getCorpId());
            log.info("getPlanRoomCodeInfo get codeInfo: {}", (Object)codeInfo);
            if (codeInfo != null) {
                log.info("getPlanRoomCodeInfo insertRoomCodeJoinLog roomCode Id: {}", (Object)codeInfo.getId());
                int count = this.roomCodeJoinLogMapper.queryLogCount(plan.getCorpId(), codeInfo.getId(), uniqId);
                if (count == 0) {
                    this.insertRoomCodeJoinLog(codeInfo, plan.getBizId(), plan.getCorpId(), uniqId);
                }
            }
        }
        if (codeInfo != null) {
            RoomCodeInfo info = new RoomCodeInfo();
            info.setId(codeInfo.getNum());
            if (plan.getLiveCodeType() == 1) {
                info.setRoomCode(codeInfo.getRoomQrcode());
            } else {
                info.setRoomCode(codeInfo.getLiveCode());
            }
            info.setStatus(0);
            return info;
        }
        return null;
    }

    private MarketingPlanRoomCode selectClientCodeInfo(List<MarketingPlanRoomCode> planRoomCodes, String corpId) {
        if (CollectionUtils.isEmpty(planRoomCodes)) {
            return null;
        }
        log.info("selectClientCodeInfo get planRoomCodes: {}", planRoomCodes);
        List newPlanCodes = planRoomCodes.stream().filter(a -> {
            if (a.getExpireTime() != null) {
                return a.getExpireTime().after(new Date());
            }
            return true;
        }).collect(Collectors.toList());
        log.info("selectClientCodeInfo get newPlanCodes: {}", newPlanCodes);
        if (CollectionUtils.isNotEmpty(newPlanCodes)) {
            List planRoomCodeIds = newPlanCodes.stream().map(MarketingPlanRoomCode::getId).collect(Collectors.toList());
            Map codeCountMap = this.roomCodeJoinLogMapper.getCountByRoomCodeIds(planRoomCodeIds, corpId);
            log.info("selectClientCodeInfo get codeCountMap: {}", (Object)codeCountMap);
            List lastPlanCodes = newPlanCodes.stream().filter(a -> {
                Integer count = (Integer)codeCountMap.get(a.getId());
                if (count == null) {
                    count = 0;
                }
                return a.getMaxScanCount() > (long)count.intValue();
            }).collect(Collectors.toList());
            log.info("selectClientCodeInfo get lastPlanCodes: {}", lastPlanCodes);
            if (lastPlanCodes.size() > 0) {
                return (MarketingPlanRoomCode)lastPlanCodes.get(0);
            }
        }
        return null;
    }

    @Override
    public List<RoomPlanInfoResp> getRoomPlanInfoList(RoomPlanInfoReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        String corpId = currentUser.getCorpId();
        Set userIds = this.userRoleCommonService.getManageUserIds();
        log.info("getRoomPlanInfoList,params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), corpId});
        if (reqDto.getPageDto() == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        RoomPlanListQuery query = new RoomPlanListQuery();
        query.setCorpId(corpId);
        query.setName(reqDto.getName());
        query.setCodeType(reqDto.getLiveCodeType());
        query.setIsEnabled(reqDto.getIsEnabled());
        query.setOffset(Integer.valueOf(reqDto.getPageDto().getOffset()));
        query.setLimit(reqDto.getPageDto().getPageSize());
        query.setUserIds((Collection)userIds);
        List marketingPlans = this.marketingPlanMapper.queryMarketingRoomPlan(query);
        log.info("getRoomPlanInfoList, get marketingPlans size:{}", (Object)marketingPlans.size());
        if (CollectionUtils.isEmpty((Collection)marketingPlans)) {
            return Lists.newArrayList();
        }
        int count = this.marketingPlanMapper.queryMarketingRoomPlanCount(query);
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        reqDto.getPageDto().setCurPageCount(Integer.valueOf(marketingPlans.size()));
        List planIds = marketingPlans.stream().map(MarketingPlan::getId).collect(Collectors.toList());
        log.info("getRoomPlanInfoList, get planIds :{}", planIds);
        Map codeTotalMap = this.roomCodeMapper.queryRoomCodeTotalCountByPlanId(planIds, corpId);
        log.info("getRoomPlanInfoList, get codeTotalMap :{}", (Object)codeTotalMap);
        List planRoomCodeList = this.roomCodeMapper.queryCodeListByPlanIds(planIds, corpId);
        if (CollectionUtils.isNotEmpty((Collection)planRoomCodeList)) {
            List planRoomCodeIds = planRoomCodeList.stream().map(MarketingPlanRoomCode::getId).collect(Collectors.toList());
            Map codeCountMap = this.roomCodeJoinLogMapper.getCountByRoomCodeIds(planRoomCodeIds, corpId);
            log.info("getRoomPlanInfoList get codeCountMap: {}", (Object)codeCountMap);
            planRoomCodeList = planRoomCodeList.stream().filter(a -> {
                Integer actualCount = 0;
                if (a.getPlanCodeType() == 1 && a.getExpireTime() != null && a.getExpireTime().before(new Date())) {
                    return false;
                }
                if (codeCountMap != null) {
                    actualCount = codeCountMap.getOrDefault(a.getId(), 0);
                }
                return a.getMaxScanCount() > (long)actualCount.intValue();
            }).collect(Collectors.toList());
            log.info("getRoomPlanInfoList get planRoomCodeList size: {}", (Object)planRoomCodeList.size());
        }
        Date todayStartTime = DateUtil.getTodayStartTime();
        Date todayEndTime = DateUtil.getTodayEndTime();
        Map totalUvMap = this.marketingChannelReportMapper.queryPlanUvCountMap(corpId, planIds, null, null);
        Map todayUvMap = this.marketingChannelReportMapper.queryPlanUvCountMap(corpId, planIds, todayStartTime, todayEndTime);
        log.info("getRoomPlanInfoList, get totalUvMap :{}, todayUvMap: {}", (Object)totalUvMap, (Object)todayUvMap);
        List createIds = marketingPlans.stream().map(MarketingPlan::getCreateBy).collect(Collectors.toList());
        List userList = this.userMapper.getUserInfoByIds(createIds);
        Map<Long, String> userNameMap = userList.stream().collect(Collectors.toMap(User::getId, User::getName));
        log.info("getRoomPlanInfoList, get userNameMap :{}", userNameMap);
        ArrayList resps = Lists.newArrayList();
        for (MarketingPlan plan : marketingPlans) {
            RoomPlanInfoResp resp = new RoomPlanInfoResp();
            resp.setId(plan.getNum());
            resp.setName(plan.getName());
            resp.setLiveCodeType(plan.getLiveCodeType());
            resp.setEnable(plan.getIsEnabled());
            resp.setCreateTime(plan.getCreateTime());
            resp.setCreateId(plan.getCreateBy());
            resp.setStatisticType(plan.getStatsType());
            if (userNameMap != null) {
                String userName = userNameMap.get(plan.getCreateBy());
                resp.setCreateName(userName);
            }
            if (codeTotalMap != null) {
                Integer codeTotalCount = (Integer)codeTotalMap.get(plan.getId());
                resp.setCodeTotalCount(codeTotalCount);
            }
            if (CollectionUtils.isNotEmpty(planRoomCodeList)) {
                List codeEffientList = planRoomCodeList.stream().filter(a -> a.getPlanId().equals(plan.getId())).collect(Collectors.toList());
                resp.setCodeEfficientCount(codeEffientList.size());
            }
            if (todayUvMap != null) {
                Integer todayCount = todayUvMap.getOrDefault(plan.getId(), 0);
                resp.setTodayCount(todayCount);
            }
            if (totalUvMap != null) {
                Integer totalCount = totalUvMap.getOrDefault(plan.getId(), 0);
                resp.setTotalCount(totalCount);
            }
            resps.add(resp);
        }
        return resps;
    }

    @Override
    public void enableRoomPlan(RoomEnableReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("enableRoomPlan,params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getId()), (Object)"\u6d3b\u52a8ID\u4e0d\u80fd\u4e3a\u7a7a");
        MarketingPlan plan = this.marketingPlanMapper.selectByNum(reqDto.getId());
        if (plan == null || plan.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        if (!plan.getIsEnabled().equals(reqDto.getEnable())) {
            this.marketingPlanMapper.updatePlanEnable(plan.getNum(), reqDto.getEnable(), currentUser.getCorpId());
        }
    }

    @Override
    public RoomPlanReqDto roomPlanDetail(RoomBaseReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("roomPlanDetail,params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getId()), (Object)"\u6d3b\u52a8ID\u4e0d\u80fd\u4e3a\u7a7a");
        MarketingPlan plan = this.marketingPlanMapper.selectByNum(reqDto.getId());
        if (plan == null || plan.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        RoomPlanReqDto dto = new RoomPlanReqDto();
        dto.setId(plan.getNum());
        dto.setName(plan.getName());
        dto.setStatisticType(plan.getStatsType());
        dto.setLiveCodeType(plan.getLiveCodeType());
        dto.setBgImg(plan.getBgImg());
        dto.setGroupType(0);
        ArrayList planIdS = Lists.newArrayList((Object[])new Long[]{plan.getId()});
        Map<Long, List<ChannelDto>> channelMap = this.marketingChannelService.queryPlanOfChannel(currentUser.getCorpId(), planIdS);
        log.info("roomPlanDetail, get channelMap :{}", channelMap);
        if (channelMap != null) {
            List<ChannelDto> channelDtos = channelMap.get(plan.getId());
            dto.setChannelDtos(channelDtos);
        }
        dto.setCustomerServiceId(plan.getCustomerServiceCode());
        WeworkUser user = this.weworkUserMapper.queryWeworkUserByNum(plan.getCustomerServiceCode());
        if (user != null) {
            dto.setCustomerServiceName(user.getName());
            dto.setCustomerServiceAvatar(user.getAvatar());
        }
        List planGroupList = this.marketingPlanGroupMapper.getPlanGroupsByPlanId(plan.getId());
        Map<Long, String> groupNameMap = null;
        if (CollectionUtils.isNotEmpty((Collection)planGroupList)) {
            dto.setGroupType(1);
            groupNameMap = planGroupList.stream().collect(Collectors.toMap(MarketingPlanGroup::getId, MarketingPlanGroup::getName));
        }
        log.info("roomPlanDetail, get groupNameMap :{}", groupNameMap);
        List roomCodeList = this.roomCodeMapper.queryRoomCodeByPlanId(plan.getId(), currentUser.getCorpId(), null);
        List roomCodeIds = roomCodeList.stream().map(MarketingPlanRoomCode::getId).collect(Collectors.toList());
        log.info("roomPlanDetail get roomCodeIds: {}", roomCodeIds);
        Map codeCountMap = this.roomCodeJoinLogMapper.getCountByRoomCodeIds(roomCodeIds, currentUser.getCorpId());
        log.info("roomPlanDetail get codeCountMap: {}", (Object)codeCountMap);
        if (CollectionUtils.isNotEmpty((Collection)roomCodeList)) {
            ArrayList roomCodeDescs = Lists.newArrayList();
            ArrayList roomLiveCodeDescs = Lists.newArrayList();
            for (MarketingPlanRoomCode roomCode : roomCodeList) {
                Object codeDesc;
                if (plan.getLiveCodeType() == 1) {
                    codeDesc = this.setRoomCodeDesc(roomCode, groupNameMap, codeCountMap);
                    roomCodeDescs.add(codeDesc);
                }
                if (plan.getLiveCodeType() != 2) continue;
                codeDesc = this.setRoomLiveCodeDesc(roomCode, groupNameMap, codeCountMap);
                roomLiveCodeDescs.add(codeDesc);
            }
            dto.setRoomCodeSettings(roomCodeDescs);
            dto.setRoomLiveCodeSettings(roomLiveCodeDescs);
        }
        return dto;
    }

    @Override
    public List<RoomPlanChannelResp> getRoomPlanDefaultChannelList(BaseDto params) {
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Set userIds = this.userRoleCommonService.getManageUserIds();
        if (params.getPageDto() != null) {
            int count = this.marketingChannelMapper.queryPlanDefaultChannelCount(corpId, params.getName(), (Collection)userIds);
            params.getPageDto().setCount(Integer.valueOf(count));
        }
        List result = this.marketingChannelMapper.queryPlanDefaultChannelList(corpId, params.getName(), (Collection)userIds, params.getPageDto());
        return result;
    }

    private RoomCodeDesc setRoomCodeDesc(MarketingPlanRoomCode roomCode, Map<Long, String> groupNameMap, Map<Long, Integer> codeCountMap) {
        RoomCodeDesc codeDesc = new RoomCodeDesc();
        codeDesc.setId(roomCode.getNum());
        codeDesc.setRoomId(roomCode.getRoomId());
        codeDesc.setRoomName(roomCode.getRoomName());
        codeDesc.setRoomCode(roomCode.getRoomQrcode());
        codeDesc.setExpireTime(roomCode.getExpireTime());
        codeDesc.setMaxScanCount(roomCode.getMaxScanCount());
        if (groupNameMap != null) {
            String groupName = groupNameMap.get(roomCode.getPlanGroupId());
            codeDesc.setGroupName(groupName);
        }
        boolean isNotExpired = roomCode.getExpireTime().after(new Date());
        int status = 0;
        if (isNotExpired) {
            if (codeCountMap != null) {
                Integer count = codeCountMap.get(roomCode.getId());
                if (count == null) {
                    count = 0;
                }
                status = roomCode.getMaxScanCount() > (long)count.intValue() ? 0 : 1;
            }
        } else {
            status = 1;
        }
        codeDesc.setStatus(status);
        return codeDesc;
    }

    private RoomLiveCodeDesc setRoomLiveCodeDesc(MarketingPlanRoomCode roomCode, Map<Long, String> groupNameMap, Map<Long, Integer> codeCountMap) {
        RoomLiveCodeDesc codeDesc = new RoomLiveCodeDesc();
        codeDesc.setId(roomCode.getNum());
        codeDesc.setWeworkLiveCode(roomCode.getLiveCode());
        codeDesc.setRemark(roomCode.getLiveCodeDesc());
        codeDesc.setMaxScanCount(roomCode.getMaxScanCount());
        if (groupNameMap != null) {
            String groupName = groupNameMap.get(roomCode.getPlanGroupId());
            codeDesc.setGroupName(groupName);
        }
        int status = 0;
        if (codeCountMap != null) {
            Integer count = codeCountMap.get(roomCode.getId());
            if (count == null) {
                count = 0;
            }
            status = roomCode.getMaxScanCount() > (long)count.intValue() ? 0 : 1;
        }
        codeDesc.setStatus(status);
        return codeDesc;
    }

    private void insertRoomCodeJoinLog(MarketingPlanRoomCode planRoomCode, Long bizId, String corpId, String uniqId) {
        MarketingPlanRoomCodeJoinLog joinLog = new MarketingPlanRoomCodeJoinLog();
        joinLog.setNum(this.idGen.getNum());
        joinLog.setBizId(bizId);
        joinLog.setCorpId(corpId);
        joinLog.setCreateBy(Long.valueOf(-1L));
        joinLog.setCreateTime(new Date());
        joinLog.setIsDeleted(Integer.valueOf(0));
        joinLog.setPlanId(planRoomCode.getPlanId());
        joinLog.setPlanRoomCodeId(planRoomCode.getId());
        joinLog.setPlanCodeType(planRoomCode.getPlanCodeType());
        joinLog.setUniqId(uniqId);
        this.roomCodeJoinLogMapper.insertSelective((Object)joinLog);
    }
}

