/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.roomPlan.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.ChannelDto;
import com.kuaike.scrm.roomPlan.dto.req.RoomCodeDesc;
import com.kuaike.scrm.roomPlan.dto.req.RoomLiveCodeDesc;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RoomPlanReqDto {
    private String id;
    private String name;
    private List<String> channelIds;
    private Integer statisticType;
    private Integer liveCodeType;
    private Integer groupType;
    private String bgImg;
    private String customerServiceId;
    private List<RoomCodeDesc> roomCodeSettings;
    private List<RoomLiveCodeDesc> roomLiveCodeSettings;
    private String customerServiceAvatar;
    private String customerServiceName;
    private List<ChannelDto> channelDtos;

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.name.length() <= 20 ? 1 : 0) != 0, (Object)"\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u8fc7\u957f");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.liveCodeType), (Object)"\u6d3b\u7801\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.groupType), (Object)"\u7fa4\u5206\u7ec4\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.bgImg), (Object)"\u80cc\u666f\u56fe\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.liveCodeType == 1) {
            Preconditions.checkArgument((this.roomCodeSettings.size() > 0 ? 1 : 0) != 0, (Object)"\u7fa4\u4e8c\u7ef4\u7801\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
            for (RoomCodeDesc roomCodeDesc : this.roomCodeSettings) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)roomCodeDesc.getRoomId()), (Object)"\u7fa4ID \u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)roomCodeDesc.getRoomCode()), (Object)"\u7fa4\u4e8c\u7ef4\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)Objects.nonNull(roomCodeDesc.getExpireTime()), (Object)"\u8fc7\u671f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)Objects.nonNull(roomCodeDesc.getMaxScanCount()), (Object)"\u8bbf\u95ee\u4eba\u6570\u4e0a\u7ebf\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((roomCodeDesc.getMaxScanCount() < 200L ? 1 : 0) != 0, (Object)"\u6700\u5927\u503c\u4e0d\u80fd\u8d85\u8fc7200");
                if (this.groupType != 1) continue;
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)roomCodeDesc.getGroupName()), (Object)"\u7fa4\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (this.liveCodeType == 2) {
            Preconditions.checkArgument((this.roomLiveCodeSettings.size() > 0 ? 1 : 0) != 0, (Object)"\u7fa4\u6d3b\u7801\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
            for (RoomLiveCodeDesc liveCodeDesc : this.roomLiveCodeSettings) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)liveCodeDesc.getWeworkLiveCode()), (Object)"\u7fa4\u6d3b\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)Objects.nonNull(liveCodeDesc.getMaxScanCount()), (Object)"\u8bbf\u95ee\u4eba\u6570\u4e0a\u7ebf\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((liveCodeDesc.getMaxScanCount() < 1000L ? 1 : 0) != 0, (Object)"\u6700\u5927\u503c\u4e0d\u80fd\u8d85\u8fc71000");
                if (StringUtils.isNotBlank((CharSequence)liveCodeDesc.getRemark())) {
                    Preconditions.checkArgument((liveCodeDesc.getRemark().length() <= 20 ? 1 : 0) != 0, (Object)"\u5907\u6ce8\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57");
                }
                if (this.groupType != 1) continue;
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)liveCodeDesc.getGroupName()), (Object)"\u7fa4\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getChannelIds() {
        return this.channelIds;
    }

    public Integer getStatisticType() {
        return this.statisticType;
    }

    public Integer getLiveCodeType() {
        return this.liveCodeType;
    }

    public Integer getGroupType() {
        return this.groupType;
    }

    public String getBgImg() {
        return this.bgImg;
    }

    public String getCustomerServiceId() {
        return this.customerServiceId;
    }

    public List<RoomCodeDesc> getRoomCodeSettings() {
        return this.roomCodeSettings;
    }

    public List<RoomLiveCodeDesc> getRoomLiveCodeSettings() {
        return this.roomLiveCodeSettings;
    }

    public String getCustomerServiceAvatar() {
        return this.customerServiceAvatar;
    }

    public String getCustomerServiceName() {
        return this.customerServiceName;
    }

    public List<ChannelDto> getChannelDtos() {
        return this.channelDtos;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setChannelIds(List<String> channelIds) {
        this.channelIds = channelIds;
    }

    public void setStatisticType(Integer statisticType) {
        this.statisticType = statisticType;
    }

    public void setLiveCodeType(Integer liveCodeType) {
        this.liveCodeType = liveCodeType;
    }

    public void setGroupType(Integer groupType) {
        this.groupType = groupType;
    }

    public void setBgImg(String bgImg) {
        this.bgImg = bgImg;
    }

    public void setCustomerServiceId(String customerServiceId) {
        this.customerServiceId = customerServiceId;
    }

    public void setRoomCodeSettings(List<RoomCodeDesc> roomCodeSettings) {
        this.roomCodeSettings = roomCodeSettings;
    }

    public void setRoomLiveCodeSettings(List<RoomLiveCodeDesc> roomLiveCodeSettings) {
        this.roomLiveCodeSettings = roomLiveCodeSettings;
    }

    public void setCustomerServiceAvatar(String customerServiceAvatar) {
        this.customerServiceAvatar = customerServiceAvatar;
    }

    public void setCustomerServiceName(String customerServiceName) {
        this.customerServiceName = customerServiceName;
    }

    public void setChannelDtos(List<ChannelDto> channelDtos) {
        this.channelDtos = channelDtos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoomPlanReqDto)) {
            return false;
        }
        RoomPlanReqDto other = (RoomPlanReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$statisticType = this.getStatisticType();
        Integer other$statisticType = other.getStatisticType();
        if (this$statisticType == null ? other$statisticType != null : !((Object)this$statisticType).equals(other$statisticType)) {
            return false;
        }
        Integer this$liveCodeType = this.getLiveCodeType();
        Integer other$liveCodeType = other.getLiveCodeType();
        if (this$liveCodeType == null ? other$liveCodeType != null : !((Object)this$liveCodeType).equals(other$liveCodeType)) {
            return false;
        }
        Integer this$groupType = this.getGroupType();
        Integer other$groupType = other.getGroupType();
        if (this$groupType == null ? other$groupType != null : !((Object)this$groupType).equals(other$groupType)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$channelIds = this.getChannelIds();
        List<String> other$channelIds = other.getChannelIds();
        if (this$channelIds == null ? other$channelIds != null : !((Object)this$channelIds).equals(other$channelIds)) {
            return false;
        }
        String this$bgImg = this.getBgImg();
        String other$bgImg = other.getBgImg();
        if (this$bgImg == null ? other$bgImg != null : !this$bgImg.equals(other$bgImg)) {
            return false;
        }
        String this$customerServiceId = this.getCustomerServiceId();
        String other$customerServiceId = other.getCustomerServiceId();
        if (this$customerServiceId == null ? other$customerServiceId != null : !this$customerServiceId.equals(other$customerServiceId)) {
            return false;
        }
        List<RoomCodeDesc> this$roomCodeSettings = this.getRoomCodeSettings();
        List<RoomCodeDesc> other$roomCodeSettings = other.getRoomCodeSettings();
        if (this$roomCodeSettings == null ? other$roomCodeSettings != null : !((Object)this$roomCodeSettings).equals(other$roomCodeSettings)) {
            return false;
        }
        List<RoomLiveCodeDesc> this$roomLiveCodeSettings = this.getRoomLiveCodeSettings();
        List<RoomLiveCodeDesc> other$roomLiveCodeSettings = other.getRoomLiveCodeSettings();
        if (this$roomLiveCodeSettings == null ? other$roomLiveCodeSettings != null : !((Object)this$roomLiveCodeSettings).equals(other$roomLiveCodeSettings)) {
            return false;
        }
        String this$customerServiceAvatar = this.getCustomerServiceAvatar();
        String other$customerServiceAvatar = other.getCustomerServiceAvatar();
        if (this$customerServiceAvatar == null ? other$customerServiceAvatar != null : !this$customerServiceAvatar.equals(other$customerServiceAvatar)) {
            return false;
        }
        String this$customerServiceName = this.getCustomerServiceName();
        String other$customerServiceName = other.getCustomerServiceName();
        if (this$customerServiceName == null ? other$customerServiceName != null : !this$customerServiceName.equals(other$customerServiceName)) {
            return false;
        }
        List<ChannelDto> this$channelDtos = this.getChannelDtos();
        List<ChannelDto> other$channelDtos = other.getChannelDtos();
        return !(this$channelDtos == null ? other$channelDtos != null : !((Object)this$channelDtos).equals(other$channelDtos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoomPlanReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $statisticType = this.getStatisticType();
        result = result * 59 + ($statisticType == null ? 43 : ((Object)$statisticType).hashCode());
        Integer $liveCodeType = this.getLiveCodeType();
        result = result * 59 + ($liveCodeType == null ? 43 : ((Object)$liveCodeType).hashCode());
        Integer $groupType = this.getGroupType();
        result = result * 59 + ($groupType == null ? 43 : ((Object)$groupType).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $channelIds = this.getChannelIds();
        result = result * 59 + ($channelIds == null ? 43 : ((Object)$channelIds).hashCode());
        String $bgImg = this.getBgImg();
        result = result * 59 + ($bgImg == null ? 43 : $bgImg.hashCode());
        String $customerServiceId = this.getCustomerServiceId();
        result = result * 59 + ($customerServiceId == null ? 43 : $customerServiceId.hashCode());
        List<RoomCodeDesc> $roomCodeSettings = this.getRoomCodeSettings();
        result = result * 59 + ($roomCodeSettings == null ? 43 : ((Object)$roomCodeSettings).hashCode());
        List<RoomLiveCodeDesc> $roomLiveCodeSettings = this.getRoomLiveCodeSettings();
        result = result * 59 + ($roomLiveCodeSettings == null ? 43 : ((Object)$roomLiveCodeSettings).hashCode());
        String $customerServiceAvatar = this.getCustomerServiceAvatar();
        result = result * 59 + ($customerServiceAvatar == null ? 43 : $customerServiceAvatar.hashCode());
        String $customerServiceName = this.getCustomerServiceName();
        result = result * 59 + ($customerServiceName == null ? 43 : $customerServiceName.hashCode());
        List<ChannelDto> $channelDtos = this.getChannelDtos();
        result = result * 59 + ($channelDtos == null ? 43 : ((Object)$channelDtos).hashCode());
        return result;
    }

    public String toString() {
        return "RoomPlanReqDto(id=" + this.getId() + ", name=" + this.getName() + ", channelIds=" + this.getChannelIds() + ", statisticType=" + this.getStatisticType() + ", liveCodeType=" + this.getLiveCodeType() + ", groupType=" + this.getGroupType() + ", bgImg=" + this.getBgImg() + ", customerServiceId=" + this.getCustomerServiceId() + ", roomCodeSettings=" + this.getRoomCodeSettings() + ", roomLiveCodeSettings=" + this.getRoomLiveCodeSettings() + ", customerServiceAvatar=" + this.getCustomerServiceAvatar() + ", customerServiceName=" + this.getCustomerServiceName() + ", channelDtos=" + this.getChannelDtos() + ")";
    }
}

