/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.regionPlan.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.OnLineType;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.region.entity.RegionPlanWorkCycle;
import com.kuaike.scrm.dal.region.mapper.RegionPlanWorkCycleMapper;
import com.kuaike.scrm.regionPlan.dto.AutoPassDto;
import com.kuaike.scrm.regionPlan.dto.RegionPlanDto;
import com.kuaike.scrm.regionPlan.dto.WorkCycleDetailDto;
import com.kuaike.scrm.regionPlan.dto.WorkCycleDto;
import com.kuaike.scrm.regionPlan.service.RegionPlanAutoPassService;
import com.kuaike.scrm.regionPlan.service.RegionPlanCycleUserService;
import com.kuaike.scrm.regionPlan.service.WorkCycleService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkCycleServiceImpl
implements WorkCycleService {
    private static final Logger log = LoggerFactory.getLogger(WorkCycleServiceImpl.class);
    @Resource
    private RegionPlanWorkCycleMapper regionPlanWorkCycleMapper;
    @Autowired
    private RegionPlanAutoPassService regionPlanAutoPassService;
    @Autowired
    private IdGen idGen;
    @Autowired
    private RegionPlanCycleUserService regionPlanCycleUserService;

    @Override
    public void saveWorkCycle(Long planId, Long planGroupId, RegionPlanDto params) {
        if (params.getOnLineType().intValue() == OnLineType.DAY_LINE_TYPE.getValue()) {
            this.allDayOnline(planId, planGroupId, params.getAutoPass(), params.getWeworkUserIds());
        } else if (params.getOnLineType().intValue() == OnLineType.TIME_LINE_TYPE.getValue()) {
            this.timeRangeOnLine(planId, planGroupId, params.getWorkCycles());
        }
    }

    @Override
    public List<RegionPlanWorkCycle> getRegionPlanWorkCycles(String corpId, Long planId, Long planGroupId) {
        return this.regionPlanWorkCycleMapper.queryRegionPlanWorkCycle(corpId, planId, planGroupId);
    }

    @Override
    public List<WorkCycleDetailDto> getRegionPlanWorkCycleInfo(String corpId, Long planId, Long planGroupId) {
        List<RegionPlanWorkCycle> list = this.getRegionPlanWorkCycles(corpId, planId, planGroupId);
        ArrayList result = Lists.newArrayList();
        for (RegionPlanWorkCycle planWorkCycle : list) {
            WorkCycleDetailDto workCycleDetailDto = new WorkCycleDetailDto();
            workCycleDetailDto.setId(planWorkCycle.getNum());
            workCycleDetailDto.setCycle(this.splitCycle(planWorkCycle.getWorkCycle()));
            workCycleDetailDto.setStartTime(DateUtil.dateToDateString((Date)planWorkCycle.getWorkStartTime(), (String)"HH:mm"));
            workCycleDetailDto.setEndTime(DateUtil.dateToDateString((Date)planWorkCycle.getWorkEndTime(), (String)"HH:mm"));
            workCycleDetailDto.setWeworkUserList(this.regionPlanCycleUserService.getCycleUserInfo(corpId, planId, planGroupId, planWorkCycle.getId()));
            workCycleDetailDto.setAutoPass(this.regionPlanAutoPassService.getAutoPassConfig(corpId, planId, planGroupId, planWorkCycle.getId()));
            result.add(workCycleDetailDto);
        }
        return result;
    }

    private Set<Integer> splitCycle(String workCycle) {
        String[] arr = StringUtils.split((String)workCycle, (String)",");
        HashSet result = Sets.newHashSet();
        for (String str : arr) {
            result.add(Integer.parseInt(str));
        }
        return result;
    }

    private void allDayOnline(Long planId, Long planGroupId, AutoPassDto autoPassDto, List<String> weworkUserNum) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        this.regionPlanWorkCycleMapper.delRegionPlanWorkCycle(corpId, planId, planGroupId, userInfo.getId());
        this.regionPlanCycleUserService.saveCycleUser(planId, planGroupId, null, weworkUserNum);
        this.regionPlanAutoPassService.saveAutoPass(planId, planGroupId, null, autoPassDto);
    }

    private void timeRangeOnLine(Long planId, Long planGroupId, List<WorkCycleDto> workCycleDtos) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Long bizId = userInfo.getBizId();
        Long userId = userInfo.getId();
        for (WorkCycleDto workCycleDto : workCycleDtos) {
            Long cycleId;
            String workCycleNum = workCycleDto.getId();
            if (workCycleDto.getId() == null) {
                cycleId = this.insertRegionPlanWorkCycle(bizId, corpId, planId, planGroupId, workCycleDto, userId);
                this.regionPlanCycleUserService.saveCycleUser(planId, planGroupId, cycleId, workCycleDto.getWeworkUserIds());
                this.regionPlanAutoPassService.saveAutoPass(planId, planGroupId, cycleId, workCycleDto.getAutoPass());
                continue;
            }
            if (workCycleDto.getIsDeleted() != null && workCycleDto.getIsDeleted() == 1) {
                this.regionPlanWorkCycleMapper.delRegionPlanWorkCycleByNum(corpId, workCycleNum, userId);
                this.regionPlanCycleUserService.delCycleUser(corpId, planId, planGroupId, workCycleNum, userId);
                this.regionPlanAutoPassService.delCycleAutoPass(corpId, planId, planGroupId, workCycleNum, userId);
                continue;
            }
            if (workCycleDto.getIsDeleted() != null && workCycleDto.getIsDeleted() != 0) continue;
            cycleId = this.updateRegionPlanWorkCycle(corpId, workCycleDto, userId);
            if (cycleId == null) {
                return;
            }
            this.regionPlanCycleUserService.saveCycleUser(planId, planGroupId, cycleId, workCycleDto.getWeworkUserIds());
            this.regionPlanAutoPassService.saveAutoPass(planId, planGroupId, cycleId, workCycleDto.getAutoPass());
        }
    }

    private Long insertRegionPlanWorkCycle(Long bizId, String corpId, Long planId, Long planGroupId, WorkCycleDto workCycleDto, Long userId) {
        Date curDate = new Date();
        RegionPlanWorkCycle workCycle = new RegionPlanWorkCycle();
        workCycle.setNum(this.idGen.getNum());
        workCycle.setBizId(bizId);
        workCycle.setCorpId(corpId);
        workCycle.setPlanId(planId);
        workCycle.setPlanGroupId(planGroupId);
        String cycle = StringUtils.join(workCycleDto.getCycle(), (String)",");
        workCycle.setWorkCycle(cycle);
        workCycle.setWorkStartTime(DateUtil.getDate((String)workCycleDto.getStartTime(), (String)"HH:mm"));
        workCycle.setWorkEndTime(DateUtil.getDate((String)workCycleDto.getEndTime(), (String)"HH:mm"));
        workCycle.setCreateBy(userId);
        workCycle.setUpdateBy(userId);
        workCycle.setCreateTime(curDate);
        workCycle.setUpdateTime(curDate);
        workCycle.setIsDeleted(Integer.valueOf(0));
        this.regionPlanWorkCycleMapper.insertSelective((Object)workCycle);
        return workCycle.getId();
    }

    private Long updateRegionPlanWorkCycle(String corpId, WorkCycleDto workCycleDto, Long userId) {
        RegionPlanWorkCycle workCycle = new RegionPlanWorkCycle();
        workCycle.setNum(workCycleDto.getId());
        workCycle.setCorpId(corpId);
        workCycle = (RegionPlanWorkCycle)this.regionPlanWorkCycleMapper.selectOne((Object)workCycle);
        if (workCycle == null) {
            log.info("work cycle num error corp_id: {}, num: {}", (Object)corpId, (Object)workCycleDto.getId());
            return null;
        }
        String cycle = StringUtils.join(workCycleDto.getCycle(), (String)",");
        Date workStartTime = DateUtil.getDate((String)workCycleDto.getStartTime(), (String)"HH:mm");
        Date workEndTime = DateUtil.getDate((String)workCycleDto.getEndTime(), (String)"HH:mm");
        workCycle.setWorkCycle(cycle);
        workCycle.setWorkStartTime(workStartTime);
        workCycle.setWorkEndTime(workEndTime);
        workCycle.setUpdateBy(userId);
        workCycle.setUpdateTime(new Date());
        this.regionPlanWorkCycleMapper.updateByPrimaryKeySelective((Object)workCycle);
        return workCycle.getId();
    }
}

