/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.regionPlan.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.contactAnalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.region.entity.RegionPlanFriendsLimit;
import com.kuaike.scrm.dal.region.mapper.RegionPlanFriendsLimitMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.regionPlan.dto.WeworkUserLimitDto;
import com.kuaike.scrm.regionPlan.service.UserAddFriendLimitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserAddFriendLimitServiceImpl
implements UserAddFriendLimitService {
    private static final Logger log = LoggerFactory.getLogger(UserAddFriendLimitServiceImpl.class);
    @Resource
    private RegionPlanFriendsLimitMapper regionPlanFriendsLimitMapper;
    @Resource
    private WeworkContactLogMapper weworkContactLogMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;

    @Override
    public void saveAddFriendLimit(Long planId, Long planGroupId, List<WeworkUserLimitDto> limitDtos) {
        if (limitDtos == null) {
            limitDtos = Lists.newArrayList();
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Date curDate = new Date();
        List curList = this.regionPlanFriendsLimitMapper.queryRegionPlanFriendLimit(corpId, planId, planGroupId);
        ArrayList addList = Lists.newArrayList();
        for (WeworkUserLimitDto limitDto : limitDtos) {
            String weworkUserNum = limitDto.getId();
            Integer limitNum = limitDto.getLimitNum();
            RegionPlanFriendsLimit updateDto = null;
            for (int i = 0; i < curList.size(); ++i) {
                if (!weworkUserNum.equals(((RegionPlanFriendsLimit)curList.get(i)).getWeworkUserNum())) continue;
                updateDto = (RegionPlanFriendsLimit)curList.get(i);
                curList.remove(i);
                break;
            }
            if (updateDto != null && updateDto.getLimitNum() != limitNum) {
                updateDto.setUpdateBy(userInfo.getId());
                updateDto.setUpdateTime(curDate);
                updateDto.setLimitNum(limitNum);
                this.regionPlanFriendsLimitMapper.updateByPrimaryKeySelective((Object)updateDto);
                continue;
            }
            if (updateDto != null) continue;
            RegionPlanFriendsLimit limit = this.buildLimit(bizId, corpId, planId, planGroupId, weworkUserNum, limitNum, userInfo.getId());
            addList.add(limit);
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            this.regionPlanFriendsLimitMapper.batchInsert((Collection)addList);
        }
        if (CollectionUtils.isNotEmpty((Collection)curList)) {
            List dels = curList.stream().map(item -> item.getId()).collect(Collectors.toList());
            this.regionPlanFriendsLimitMapper.delRegionPlanFriendLimit(corpId, dels, userInfo.getId());
        }
    }

    private RegionPlanFriendsLimit buildLimit(Long bizId, String corpId, Long planId, Long planGroupId, String weworkUserNum, Integer limitNum, Long userId) {
        Date curDate = new Date();
        RegionPlanFriendsLimit limit = new RegionPlanFriendsLimit();
        limit.setBizId(bizId);
        limit.setCorpId(corpId);
        limit.setPlanId(planId);
        limit.setPlanGroupId(planGroupId);
        limit.setWeworkUserNum(weworkUserNum);
        limit.setLimitNum(limitNum);
        limit.setCreateBy(userId);
        limit.setUpdateBy(userId);
        limit.setCreateTime(curDate);
        limit.setUpdateTime(curDate);
        limit.setIsDeleted(Integer.valueOf(0));
        return limit;
    }

    @Override
    public List<WeworkUserLimitDto> getUserLimit(String corpId, Long planId, Long planGroupId) {
        List list = this.regionPlanFriendsLimitMapper.queryRegionPlanFriendLimit(corpId, planId, planGroupId);
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return result;
        }
        List weworkUserNums = list.stream().map(item -> item.getWeworkUserNum()).collect(Collectors.toList());
        List weworkUsers = this.weworkUserMapper.queryInfoListByNums(weworkUserNums);
        Map userDtoMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getNum, Function.identity()));
        for (RegionPlanFriendsLimit limit : list) {
            WeworkUserLimitDto userLimitDto = new WeworkUserLimitDto();
            WeworkUser userDto = (WeworkUser)userDtoMap.get(limit.getWeworkUserNum());
            userLimitDto.setId(limit.getWeworkUserNum());
            userLimitDto.setLimitNum(limit.getLimitNum());
            userLimitDto.setNickname(userDto.getName());
            userLimitDto.setAvatar(userDto.getAvatar());
            result.add(userLimitDto);
        }
        return result;
    }

    @Override
    public int getWeworkUserNumAddFriends(String corpId, Long planId, String weworkUserNum) {
        Date todayStart = DateUtil.getTodayStartTime();
        Date todayEnd = DateUtil.getTodayEndTime();
        int addNum = this.weworkContactLogMapper.queryAddExternalCount(corpId, planId, todayStart, todayEnd, weworkUserNum);
        return addNum;
    }

    @Override
    public boolean isMoreLimit(String corpId, Long planId, Long planGroupId, String weworkUserNum) {
        int todayFriends = this.getWeworkUserNumAddFriends(corpId, planId, weworkUserNum);
        Integer limitNum = this.regionPlanFriendsLimitMapper.queryLimitNum(corpId, planId, planGroupId, weworkUserNum);
        if (limitNum == null) {
            return false;
        }
        return todayFriends >= limitNum;
    }
}

