/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.regionPlan.dto;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.enums.OnLineType;
import com.kuaike.scrm.common.enums.StatisticType;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.marketing.dto.FriendWelcomeDto;
import com.kuaike.scrm.regionPlan.dto.AutoPassDto;
import com.kuaike.scrm.regionPlan.dto.WeworkUserLimitDto;
import com.kuaike.scrm.regionPlan.dto.WorkCycleDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RegionPlanDto
extends BaseDto {
    private String name;
    private Integer initNumber;
    private List<String> channelIds;
    private Integer statisticType;
    private Integer templateType;
    private Integer onLineType;
    private List<String> weworkUserIds;
    private AutoPassDto autoPass;
    private List<WorkCycleDto> workCycles;
    private Integer limitAddFriend;
    private List<WeworkUserLimitDto> weworkUserLimits;
    private List<String> alternativeWeworkUserIds;
    private List<String> weworkTagIds;
    private String addFriendRemark;
    private FriendWelcomeDto addFriendWelcome;

    public void checkParams() {
        if (this.initNumber == null) {
            this.initNumber = 0;
        }
        if (this.onLineType == null) {
            this.onLineType = OnLineType.DAY_LINE_TYPE.getValue();
        }
        if (this.templateType == null) {
            this.templateType = 1;
        }
        if (this.limitAddFriend == null) {
            this.limitAddFriend = 0;
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"\u6d3b\u52a8\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        this.name = this.name.trim();
        Preconditions.checkArgument((this.initNumber >= 0 ? 1 : 0) != 0, (Object)"\u6d3b\u52a8\u521d\u59cb\u4eba\u6570\u5e94\u8be5\u5927\u4e8e\u7b49\u4e8e0");
        Preconditions.checkArgument((this.statisticType != null ? 1 : 0) != 0, (Object)"pv/uv \u7edf\u8ba1\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.statisticType.intValue() == StatisticType.STATISTIC_PV_UV.getValue() || this.statisticType.intValue() == StatisticType.STATISTIC_UV_DETAIL.getValue() ? 1 : 0) != 0, (Object)"pv/uv \u7edf\u8ba1\u7c7b\u578b\u503c\u4e0d\u5bf9");
        if (this.onLineType.intValue() == OnLineType.DAY_LINE_TYPE.getValue()) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.weworkUserIds), (Object)"\u9009\u62e9\u7684\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.autoPass != null ? 1 : 0) != 0, (Object)"\u81ea\u52a8\u901a\u8fc7\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
            for (String weworkUserNum : this.weworkUserIds) {
                if (!StringUtils.isEmpty((CharSequence)weworkUserNum)) continue;
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6210\u5458\u9009\u62e9\u53c2\u6570\u9519\u8bef");
            }
            this.autoPass.checkParams();
        } else if (this.onLineType.intValue() == OnLineType.TIME_LINE_TYPE.getValue()) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.workCycles), (Object)"\u5de5\u4f5c\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            ArrayList notDelCycle = Lists.newArrayList();
            for (WorkCycleDto workCycleDto : this.workCycles) {
                workCycleDto.checkParams();
                if (workCycleDto.getIsDeleted() != null && workCycleDto.getIsDeleted() == 1) continue;
                notDelCycle.add(workCycleDto);
            }
            for (int i = 0; i < notDelCycle.size(); ++i) {
                WorkCycleDto workCycleDto;
                workCycleDto = (WorkCycleDto)notDelCycle.get(i);
                for (int j = i + 1; j < notDelCycle.size(); ++j) {
                    WorkCycleDto otherCycleDto = (WorkCycleDto)notDelCycle.get(j);
                    Sets.SetView set = Sets.intersection(workCycleDto.getCycle(), otherCycleDto.getCycle());
                    if (!CollectionUtils.isNotEmpty((Collection)set)) continue;
                    Date startOnlineTime = DateUtil.getDate((String)workCycleDto.getStartTime(), (String)"HH:mm");
                    Date endOnlineTime = DateUtil.getDate((String)workCycleDto.getEndTime(), (String)"HH:mm");
                    Date otherStartOnlineTime = DateUtil.getDate((String)otherCycleDto.getStartTime(), (String)"HH:mm");
                    Date otherEndOnlineTime = DateUtil.getDate((String)otherCycleDto.getEndTime(), (String)"HH:mm");
                    if (endOnlineTime.compareTo(otherStartOnlineTime) <= 0 || startOnlineTime.compareTo(otherEndOnlineTime) >= 0) continue;
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5468\u671f\u5b58\u5728\u4ea4\u96c6");
                }
            }
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6210\u5458\u5728\u7ebf\u53c2\u6570\u4e0d\u5bf9");
        }
        Preconditions.checkArgument((this.limitAddFriend == 0 || this.limitAddFriend == 1 ? 1 : 0) != 0, (Object)"\u6210\u5458\u52a0\u597d\u53cb\u9650\u5236\u53c2\u6570\u4e0d\u5bf9");
        if (this.limitAddFriend == 1 && CollectionUtils.isNotEmpty(this.weworkUserLimits)) {
            for (WeworkUserLimitDto userLimitDto : this.weworkUserLimits) {
                userLimitDto.checkParams();
            }
        }
        Preconditions.checkArgument((this.addFriendWelcome != null ? 1 : 0) != 0, (Object)"\u597d\u53cb\u6b22\u8fce\u8bed\u6ca1\u914d\u7f6e");
    }

    public String getName() {
        return this.name;
    }

    public Integer getInitNumber() {
        return this.initNumber;
    }

    public List<String> getChannelIds() {
        return this.channelIds;
    }

    public Integer getStatisticType() {
        return this.statisticType;
    }

    public Integer getTemplateType() {
        return this.templateType;
    }

    public Integer getOnLineType() {
        return this.onLineType;
    }

    public List<String> getWeworkUserIds() {
        return this.weworkUserIds;
    }

    public AutoPassDto getAutoPass() {
        return this.autoPass;
    }

    public List<WorkCycleDto> getWorkCycles() {
        return this.workCycles;
    }

    public Integer getLimitAddFriend() {
        return this.limitAddFriend;
    }

    public List<WeworkUserLimitDto> getWeworkUserLimits() {
        return this.weworkUserLimits;
    }

    public List<String> getAlternativeWeworkUserIds() {
        return this.alternativeWeworkUserIds;
    }

    public List<String> getWeworkTagIds() {
        return this.weworkTagIds;
    }

    public String getAddFriendRemark() {
        return this.addFriendRemark;
    }

    public FriendWelcomeDto getAddFriendWelcome() {
        return this.addFriendWelcome;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInitNumber(Integer initNumber) {
        this.initNumber = initNumber;
    }

    public void setChannelIds(List<String> channelIds) {
        this.channelIds = channelIds;
    }

    public void setStatisticType(Integer statisticType) {
        this.statisticType = statisticType;
    }

    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }

    public void setOnLineType(Integer onLineType) {
        this.onLineType = onLineType;
    }

    public void setWeworkUserIds(List<String> weworkUserIds) {
        this.weworkUserIds = weworkUserIds;
    }

    public void setAutoPass(AutoPassDto autoPass) {
        this.autoPass = autoPass;
    }

    public void setWorkCycles(List<WorkCycleDto> workCycles) {
        this.workCycles = workCycles;
    }

    public void setLimitAddFriend(Integer limitAddFriend) {
        this.limitAddFriend = limitAddFriend;
    }

    public void setWeworkUserLimits(List<WeworkUserLimitDto> weworkUserLimits) {
        this.weworkUserLimits = weworkUserLimits;
    }

    public void setAlternativeWeworkUserIds(List<String> alternativeWeworkUserIds) {
        this.alternativeWeworkUserIds = alternativeWeworkUserIds;
    }

    public void setWeworkTagIds(List<String> weworkTagIds) {
        this.weworkTagIds = weworkTagIds;
    }

    public void setAddFriendRemark(String addFriendRemark) {
        this.addFriendRemark = addFriendRemark;
    }

    public void setAddFriendWelcome(FriendWelcomeDto addFriendWelcome) {
        this.addFriendWelcome = addFriendWelcome;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegionPlanDto)) {
            return false;
        }
        RegionPlanDto other = (RegionPlanDto)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$initNumber = this.getInitNumber();
        Integer other$initNumber = other.getInitNumber();
        if (this$initNumber == null ? other$initNumber != null : !((Object)this$initNumber).equals(other$initNumber)) {
            return false;
        }
        Integer this$statisticType = this.getStatisticType();
        Integer other$statisticType = other.getStatisticType();
        if (this$statisticType == null ? other$statisticType != null : !((Object)this$statisticType).equals(other$statisticType)) {
            return false;
        }
        Integer this$templateType = this.getTemplateType();
        Integer other$templateType = other.getTemplateType();
        if (this$templateType == null ? other$templateType != null : !((Object)this$templateType).equals(other$templateType)) {
            return false;
        }
        Integer this$onLineType = this.getOnLineType();
        Integer other$onLineType = other.getOnLineType();
        if (this$onLineType == null ? other$onLineType != null : !((Object)this$onLineType).equals(other$onLineType)) {
            return false;
        }
        Integer this$limitAddFriend = this.getLimitAddFriend();
        Integer other$limitAddFriend = other.getLimitAddFriend();
        if (this$limitAddFriend == null ? other$limitAddFriend != null : !((Object)this$limitAddFriend).equals(other$limitAddFriend)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$channelIds = this.getChannelIds();
        List<String> other$channelIds = other.getChannelIds();
        if (this$channelIds == null ? other$channelIds != null : !((Object)this$channelIds).equals(other$channelIds)) {
            return false;
        }
        List<String> this$weworkUserIds = this.getWeworkUserIds();
        List<String> other$weworkUserIds = other.getWeworkUserIds();
        if (this$weworkUserIds == null ? other$weworkUserIds != null : !((Object)this$weworkUserIds).equals(other$weworkUserIds)) {
            return false;
        }
        AutoPassDto this$autoPass = this.getAutoPass();
        AutoPassDto other$autoPass = other.getAutoPass();
        if (this$autoPass == null ? other$autoPass != null : !((Object)this$autoPass).equals(other$autoPass)) {
            return false;
        }
        List<WorkCycleDto> this$workCycles = this.getWorkCycles();
        List<WorkCycleDto> other$workCycles = other.getWorkCycles();
        if (this$workCycles == null ? other$workCycles != null : !((Object)this$workCycles).equals(other$workCycles)) {
            return false;
        }
        List<WeworkUserLimitDto> this$weworkUserLimits = this.getWeworkUserLimits();
        List<WeworkUserLimitDto> other$weworkUserLimits = other.getWeworkUserLimits();
        if (this$weworkUserLimits == null ? other$weworkUserLimits != null : !((Object)this$weworkUserLimits).equals(other$weworkUserLimits)) {
            return false;
        }
        List<String> this$alternativeWeworkUserIds = this.getAlternativeWeworkUserIds();
        List<String> other$alternativeWeworkUserIds = other.getAlternativeWeworkUserIds();
        if (this$alternativeWeworkUserIds == null ? other$alternativeWeworkUserIds != null : !((Object)this$alternativeWeworkUserIds).equals(other$alternativeWeworkUserIds)) {
            return false;
        }
        List<String> this$weworkTagIds = this.getWeworkTagIds();
        List<String> other$weworkTagIds = other.getWeworkTagIds();
        if (this$weworkTagIds == null ? other$weworkTagIds != null : !((Object)this$weworkTagIds).equals(other$weworkTagIds)) {
            return false;
        }
        String this$addFriendRemark = this.getAddFriendRemark();
        String other$addFriendRemark = other.getAddFriendRemark();
        if (this$addFriendRemark == null ? other$addFriendRemark != null : !this$addFriendRemark.equals(other$addFriendRemark)) {
            return false;
        }
        FriendWelcomeDto this$addFriendWelcome = this.getAddFriendWelcome();
        FriendWelcomeDto other$addFriendWelcome = other.getAddFriendWelcome();
        return !(this$addFriendWelcome == null ? other$addFriendWelcome != null : !((Object)this$addFriendWelcome).equals(other$addFriendWelcome));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegionPlanDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $initNumber = this.getInitNumber();
        result = result * 59 + ($initNumber == null ? 43 : ((Object)$initNumber).hashCode());
        Integer $statisticType = this.getStatisticType();
        result = result * 59 + ($statisticType == null ? 43 : ((Object)$statisticType).hashCode());
        Integer $templateType = this.getTemplateType();
        result = result * 59 + ($templateType == null ? 43 : ((Object)$templateType).hashCode());
        Integer $onLineType = this.getOnLineType();
        result = result * 59 + ($onLineType == null ? 43 : ((Object)$onLineType).hashCode());
        Integer $limitAddFriend = this.getLimitAddFriend();
        result = result * 59 + ($limitAddFriend == null ? 43 : ((Object)$limitAddFriend).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $channelIds = this.getChannelIds();
        result = result * 59 + ($channelIds == null ? 43 : ((Object)$channelIds).hashCode());
        List<String> $weworkUserIds = this.getWeworkUserIds();
        result = result * 59 + ($weworkUserIds == null ? 43 : ((Object)$weworkUserIds).hashCode());
        AutoPassDto $autoPass = this.getAutoPass();
        result = result * 59 + ($autoPass == null ? 43 : ((Object)$autoPass).hashCode());
        List<WorkCycleDto> $workCycles = this.getWorkCycles();
        result = result * 59 + ($workCycles == null ? 43 : ((Object)$workCycles).hashCode());
        List<WeworkUserLimitDto> $weworkUserLimits = this.getWeworkUserLimits();
        result = result * 59 + ($weworkUserLimits == null ? 43 : ((Object)$weworkUserLimits).hashCode());
        List<String> $alternativeWeworkUserIds = this.getAlternativeWeworkUserIds();
        result = result * 59 + ($alternativeWeworkUserIds == null ? 43 : ((Object)$alternativeWeworkUserIds).hashCode());
        List<String> $weworkTagIds = this.getWeworkTagIds();
        result = result * 59 + ($weworkTagIds == null ? 43 : ((Object)$weworkTagIds).hashCode());
        String $addFriendRemark = this.getAddFriendRemark();
        result = result * 59 + ($addFriendRemark == null ? 43 : $addFriendRemark.hashCode());
        FriendWelcomeDto $addFriendWelcome = this.getAddFriendWelcome();
        result = result * 59 + ($addFriendWelcome == null ? 43 : ((Object)$addFriendWelcome).hashCode());
        return result;
    }

    public String toString() {
        return "RegionPlanDto(name=" + this.getName() + ", initNumber=" + this.getInitNumber() + ", channelIds=" + this.getChannelIds() + ", statisticType=" + this.getStatisticType() + ", templateType=" + this.getTemplateType() + ", onLineType=" + this.getOnLineType() + ", weworkUserIds=" + this.getWeworkUserIds() + ", autoPass=" + this.getAutoPass() + ", workCycles=" + this.getWorkCycles() + ", limitAddFriend=" + this.getLimitAddFriend() + ", weworkUserLimits=" + this.getWeworkUserLimits() + ", alternativeWeworkUserIds=" + this.getAlternativeWeworkUserIds() + ", weworkTagIds=" + this.getWeworkTagIds() + ", addFriendRemark=" + this.getAddFriendRemark() + ", addFriendWelcome=" + this.getAddFriendWelcome() + ")";
    }
}

