/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.regionPlan.dto;

import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.utils.DateUtil;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class AutoPassDto {
    private Integer isAutoPass;
    private Integer type;
    private String startTime;
    private String endTime;

    public void checkParams() {
        if (this.isAutoPass == null) {
            this.isAutoPass = 1;
        }
        if (this.type == null) {
            this.type = 1;
        }
        Preconditions.checkArgument((this.isAutoPass == 1 || this.isAutoPass == 0 ? 1 : 0) != 0, (Object)"\u81ea\u52a8\u901a\u8fc7\u53c2\u6570\u9519\u8bef");
        Preconditions.checkArgument((this.type == 1 || this.type == 2 ? 1 : 0) != 0, (Object)"\u81ea\u52a8\u901a\u8fc7\u7c7b\u578b\u53c2\u6570\u9519\u8bef");
        if (this.type == 1) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.startTime) || StringUtils.isEmpty((CharSequence)this.endTime)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u901a\u8fc7\u65f6\u95f4\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Date startDateTime = DateUtil.getDate((String)this.startTime, (String)"HH:mm");
            Date endDateTime = DateUtil.getDate((String)this.endTime, (String)"HH:mm");
            if (startDateTime == null || endDateTime == null) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u901a\u8fc7\u65f6\u95f4\u6bb5\u53c2\u6570\u4e0d\u5bf9");
            }
            if (endDateTime.before(startDateTime)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u901a\u8fc7\u65f6\u95f4\u6bb5\u7ed3\u675f\u65f6\u95f4\u8981\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4");
            }
        }
        catch (Exception e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u901a\u8fc7\u65f6\u95f4\u6bb5\u53c2\u6570\u4e0d\u5bf9");
        }
    }

    public Integer getIsAutoPass() {
        return this.isAutoPass;
    }

    public Integer getType() {
        return this.type;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setIsAutoPass(Integer isAutoPass) {
        this.isAutoPass = isAutoPass;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoPassDto)) {
            return false;
        }
        AutoPassDto other = (AutoPassDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$isAutoPass = this.getIsAutoPass();
        Integer other$isAutoPass = other.getIsAutoPass();
        if (this$isAutoPass == null ? other$isAutoPass != null : !((Object)this$isAutoPass).equals(other$isAutoPass)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$endTime = this.getEndTime();
        String other$endTime = other.getEndTime();
        return !(this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoPassDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $isAutoPass = this.getIsAutoPass();
        result = result * 59 + ($isAutoPass == null ? 43 : ((Object)$isAutoPass).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        return result;
    }

    public String toString() {
        return "AutoPassDto(isAutoPass=" + this.getIsAutoPass() + ", type=" + this.getType() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }
}

