/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.radar.service.impl;

import cn.kinyun.customer.center.dto.req.event.EventModule;
import cn.kinyun.customer.center.dto.req.event.EventPage;
import cn.kinyun.customer.center.dto.req.event.EventSharer;
import cn.kinyun.customer.center.dto.req.event.EventVisitor;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.scrm.page.auth.dto.WoauthUserDto;
import cn.kinyun.scrm.page.auth.service.ShortUrlService;
import cn.kinyun.scrm.page.auth.utils.WoauthParseUtil;
import cn.kinyun.wework.sdk.api.external.ContactWayApi;
import cn.kinyun.wework.sdk.entity.agent.SendMsgResult;
import cn.kinyun.wework.sdk.entity.external.contactway.ConfigIdResp;
import cn.kinyun.wework.sdk.entity.external.contactway.ContactWay;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JsonUtil;
import com.kuaike.scrm.common.enums.FollowRecordType;
import com.kuaike.scrm.common.enums.RadarShareType;
import com.kuaike.scrm.common.enums.RadarType;
import com.kuaike.scrm.common.service.CommonService;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.service.ScrmLockCustomerService;
import com.kuaike.scrm.common.service.dto.UrlInfoDto;
import com.kuaike.scrm.common.service.dto.UrlParams;
import com.kuaike.scrm.common.service.dto.resp.WeworkUserResp;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.contactAnalyse.entity.WeworkContactLog;
import com.kuaike.scrm.dal.contactAnalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.follow.entity.FollowRecord;
import com.kuaike.scrm.dal.follow.mapper.FollowRecordMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.radar.entity.MarketingRadar;
import com.kuaike.scrm.dal.radar.entity.MarketingRadarAccessLog;
import com.kuaike.scrm.dal.radar.entity.MarketingRadarQrcode;
import com.kuaike.scrm.dal.radar.entity.MarketingRadarShareDetail;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarAccessLogMapper;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarDetailMapper;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarMapper;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarQrcodeMapper;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarShareDetailMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworkTag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.marketing.dto.client.ClientParamsDto;
import com.kuaike.scrm.radar.dto.req.RadarClientReportDto;
import com.kuaike.scrm.radar.dto.req.RadarRecordInfoReqDto;
import com.kuaike.scrm.radar.dto.resp.RadarClientInfoDto;
import com.kuaike.scrm.radar.service.RadarClientService;
import com.kuaike.scrm.radar.utils.StayTimeUtil;
import com.kuaike.scrm.remind.service.RemindService;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import com.kuaike.scrm.wework.contact.dto.ModifyTagDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
public class RadarClientServiceImpl
implements RadarClientService {
    private static final Logger log = LoggerFactory.getLogger(RadarClientServiceImpl.class);
    @Resource
    private MarketingRadarMapper marketingRadarMapper;
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private MarketingRadarDetailMapper marketingRadarDetailMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private MarketingRadarQrcodeMapper marketingRadarQrcodeMapper;
    @Resource
    private MarketingRadarShareDetailMapper marketingRadarShareDetailMapper;
    @Resource
    private WeworkContactLogMapper weworkContactLogMapper;
    @Resource
    private MarketingRadarAccessLogMapper marketingRadarAccessLogMapper;
    @Resource
    private FollowRecordMapper followRecordMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private ContactWayApi contactWayApi;
    @Autowired
    private RemindService remindService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private ContactOpService contactOpService;
    @Value(value="${kafka.topic.scrm_radar}")
    private String topic;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}")
    private String scrmManagerHost;
    @Autowired
    private WoauthParseUtil woauthParseUtil;
    @Autowired
    private CustomerCenterService customerCenterService;
    @Autowired
    private ScrmLockCustomerService scrmLockCustomerService;
    @Autowired
    private ShortUrlService shortUrlService;
    private static final String RADAR_REMIND_CONTENT = "\u3010\u4e92\u52a8\u96f7\u8fbe\u3011\n${customer}\u6b63\u5728\u6d4f\u89c8\u60a8\u5206\u4eab\u7684\u300a${radarTitle}\u300b, \u65f6\u957f${length}, \u9605\u8bfb\u5b8c\u6210\u5ea6${finishPercent}, \u8bf7\u53ca\u65f6\u8ddf\u8fdb\uff01\n \u5ba2\u6237\u7c7b\u578b\uff1a${customerType} \n <a href=\"${radarUrl}\">>>\u67e5\u770b\u5206\u4eab\u94fe\u63a5</a>";
    private static final String RADAR_LINK_REMIND_CONTENT = "\u3010\u4e92\u52a8\u96f7\u8fbe\u3011\n${customer}\u6b63\u5728\u6d4f\u89c8\u60a8\u5206\u4eab\u7684\u300a${radarTitle}\u300b, \u8bf7\u53ca\u65f6\u8ddf\u8fdb\uff01\n \u5ba2\u6237\u7c7b\u578b\uff1a${customerType} \n <a href=\"${radarUrl}\">>>\u67e5\u770b\u5206\u4eab\u94fe\u63a5</a>";
    private static final String CUSTOMER_DETAIL_CONTENT = " <a href=\"${scrmManagerHost}/userDetail?corpId=${corpId}&id=${id}&shareId=${shareId}\">>>\u67e5\u770b\u5ba2\u6237\u8be6\u60c5</a>";

    @Override
    public RadarClientInfoDto info(ClientParamsDto params, HttpServletRequest request) {
        String shareQrcode;
        WoauthUserDto user = this.woauthParseUtil.getWoauthInfo(request);
        log.info("radar client getInfo, params={}, user={}", (Object)params, (Object)user);
        String num = params.getId();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)num), (Object)"\u96f7\u8fbe\u5206\u4eabid\u4e0d\u80fd\u4e3a\u7a7a");
        MarketingRadarShareDetail shareDetail = new MarketingRadarShareDetail();
        shareDetail.setNum(num);
        shareDetail = (MarketingRadarShareDetail)this.marketingRadarShareDetailMapper.selectOne((Object)shareDetail);
        if (shareDetail == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u96f7\u8fbe\u5206\u4eab\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String corpId = shareDetail.getCorpId();
        MarketingRadar radar = new MarketingRadar();
        radar.setCorpId(corpId);
        radar.setNum(shareDetail.getMarketingRadarNum());
        radar = (MarketingRadar)this.marketingRadarMapper.selectOne((Object)radar);
        Enumeration referer = request.getHeaders("Referer");
        if (radar == null || radar.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u96f7\u8fbe\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u5220\u9664");
        }
        RadarClientInfoDto infoDto = new RadarClientInfoDto();
        infoDto.setBizId(radar.getBizId());
        infoDto.setTitle(radar.getTitle());
        infoDto.setType(radar.getType());
        if (radar.getType().intValue() == RadarType.LINK.getValue()) {
            infoDto.setUrl(radar.getUrl());
            MarketingRadarAccessLog accessLog = this.getRadarAccessLog(radar, shareDetail, user, params.getAccessNum());
            this.kafkaTemplate.send(this.topic, (Object)accessLog.getNum(), (Object)accessLog.getNum());
            this.customerCenterService.pushRadarAccessLogCustomer(accessLog);
            this.writeVisitPageEvent(accessLog.getCustomerNum(), accessLog.getNum(), radar, params.getId(), user, (String)referer.nextElement(), shareDetail);
            return infoDto;
        }
        if (radar.getShareType().intValue() != RadarShareType.NOT_LIMIT.getValue()) {
            WeworkUserResp weworkUserResp = this.scrmLockCustomerService.queryWeworkUserCodeByContactId(user.getExternalUserId(), user.getCorpId());
            if (weworkUserResp != null && StringUtils.isNotBlank((CharSequence)weworkUserResp.getWeworkUserId())) {
                infoDto.setIsNeedAddFriend(0);
            } else {
                infoDto.setIsNeedAddFriend(this.isNeedAddFriend(radar, shareDetail, user.getExternalUserId()));
            }
        } else {
            infoDto.setIsNeedAddFriend(0);
        }
        if (infoDto.getIsNeedAddFriend() == 1) {
            shareQrcode = null;
            if (radar.getShareType().intValue() == RadarShareType.ADD_SHARE.getValue()) {
                shareQrcode = this.getRadarShareQrcode(shareDetail.getBizId(), corpId, shareDetail.getShareWeworkUserNum(), radar.getNum());
            } else if (radar.getShareType().intValue() == RadarShareType.ADD_WEWORKUSER.getValue()) {
                shareQrcode = this.getRadarWeworkUserQrcode(corpId, shareDetail.getMarketingRadarNum());
            }
            infoDto.setQrcode(shareQrcode);
            log.info("rd info result: {}", (Object)infoDto);
            return infoDto;
        }
        infoDto.setUrl(radar.getUrl());
        if (radar.getType().intValue() == RadarType.WX_GZH.getValue()) {
            UrlParams urlParams = new UrlParams();
            urlParams.setUrl(radar.getUrl());
            UrlInfoDto urlInfo = this.commonService.getUrlInfo(urlParams);
            if (urlInfo != null) {
                infoDto.setContent(urlInfo.getHtml());
            }
        }
        infoDto.setIsShowShare(radar.getIsShowCard());
        if (infoDto.getIsShowShare() == 1) {
            this.addShareInfo(shareDetail.getShareUserId(), shareDetail.getShareWeworkUserNum(), infoDto);
            shareQrcode = this.getRadarShareQrcode(shareDetail.getBizId(), corpId, shareDetail.getShareWeworkUserNum(), radar.getNum());
            infoDto.setShareQrcode(shareQrcode);
        }
        MarketingRadarAccessLog radarAccessLog = this.getRadarAccessLog(radar, shareDetail, user, params.getAccessNum());
        infoDto.setId(radarAccessLog.getNum());
        this.kafkaTemplate.send(this.topic, (Object)radarAccessLog.getNum(), (Object)radarAccessLog.getNum());
        this.attachTag(radar, shareDetail.getShareWeworkUserNum(), user.getExternalUserId());
        this.customerCenterService.pushRadarAccessLogCustomer(radarAccessLog);
        this.writeVisitPageEvent(radarAccessLog.getCustomerNum(), radarAccessLog.getNum(), radar, params.getId(), user, (String)referer.nextElement(), shareDetail);
        return infoDto;
    }

    private void writeVisitPageEvent(String customerNum, String accessNum, MarketingRadar radar, String shortNum, WoauthUserDto woauthInfo, String referer, MarketingRadarShareDetail shareDetail) {
        if (StringUtils.isBlank((CharSequence)customerNum) || StringUtils.isBlank((CharSequence)accessNum)) {
            log.info("radar write event customerNum or accessNum is empty, {}, {}", (Object)customerNum, (Object)accessNum);
            return;
        }
        EventPage eventPage = new EventPage();
        eventPage.setTitle(radar.getTitle());
        eventPage.setUrl(this.shortUrlService.getOriginUrl(shortNum));
        eventPage.setSourceUrl(radar.getUrl());
        String shortUrl = this.shortUrlService.getShortUlr(shortNum);
        eventPage.setShortUrl(shortUrl);
        EventModule module = new EventModule();
        module.setType(ModuleType.RADAR.getCode());
        module.setName(radar.getTitle());
        module.setNum(radar.getNum());
        EventSharer sharer = new EventSharer();
        WeworkUser weworkUser = null;
        if (StringUtils.isNotBlank((CharSequence)shareDetail.getShareWeworkUserNum())) {
            weworkUser = this.weworkUserMapper.queryWeworkUserByNum(shareDetail.getShareWeworkUserNum());
        }
        if (weworkUser != null) {
            sharer.setName(weworkUser.getName());
            sharer.setWeworkUserId(weworkUser.getWeworkUserId());
        }
        if (StringUtils.isBlank((CharSequence)sharer.getName())) {
            User user = (User)this.userMapper.selectByPrimaryKey((Object)shareDetail.getShareUserId());
            sharer.setName(user.getName());
        }
        sharer.setUserId(shareDetail.getShareUserId());
        sharer.setWeworkUserNum(shareDetail.getShareWeworkUserNum());
        EventVisitor visitor = this.woauthParseUtil.buildVisitor(woauthInfo, referer);
        this.customerCenterService.saveVisitPage(radar.getBizId(), customerNum, accessNum, eventPage, module, sharer, visitor);
    }

    private void attachTag(MarketingRadar radar, String shareWeworkUserNum, String contactId) {
        if (radar.getIsClickTag() == 0) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)shareWeworkUserNum)) {
            return;
        }
        String shareWeworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(shareWeworkUserNum);
        if (StringUtils.isBlank((CharSequence)shareWeworkUserId)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)contactId)) {
            return;
        }
        List tagIds = this.marketingRadarDetailMapper.queryRadarWeworkTagNums(radar.getCorpId(), radar.getNum());
        if (CollectionUtils.isEmpty((Collection)tagIds)) {
            return;
        }
        WeworkContactRelation relation = this.weworkContactRelationMapper.get(radar.getCorpId(), shareWeworkUserId, contactId);
        if (relation == null) {
            return;
        }
        List existTags = this.weworkContactTagMapper.queryWeworkTagIds(radar.getCorpId(), shareWeworkUserId, contactId);
        if (CollectionUtils.isSubCollection((Collection)tagIds, (Collection)existTags)) {
            return;
        }
        ModifyTagDto params = new ModifyTagDto();
        params.setBizId(radar.getBizId());
        params.setCorpId(radar.getCorpId());
        params.setWeworkUserId(shareWeworkUserId);
        params.setContactId(contactId);
        params.setAddTagIds(tagIds);
        log.info("click radar attachTag: \u6253\u6807\u7b7e:{}", (Object)params);
        try {
            this.contactOpService.modifyTag(params);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5ba2\u6237\u6807\u7b7e\u5931\u8d25", (Throwable)e);
        }
    }

    public int isNeedAddFriend(MarketingRadar radar, MarketingRadarShareDetail shareDetail, String contactId) {
        if (radar.getShareType().intValue() == RadarShareType.NOT_LIMIT.getValue()) {
            return 0;
        }
        if (radar.getShareType().intValue() == RadarShareType.ADD_SHARE.getValue()) {
            String shareWorkUserNum = shareDetail.getShareWeworkUserNum();
            String weworkUserId = null;
            if (StringUtils.isNotBlank((CharSequence)shareWorkUserNum)) {
                weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(shareDetail.getShareWeworkUserNum());
            }
            if (StringUtils.isBlank((CharSequence)shareWorkUserNum) || StringUtils.isBlank(weworkUserId)) {
                return 0;
            }
            if (StringUtils.isBlank((CharSequence)contactId)) {
                return 1;
            }
            WeworkContactRelation contactRelation = this.weworkContactRelationMapper.get(radar.getCorpId(), weworkUserId, contactId);
            if (contactRelation != null) {
                return 0;
            }
            return 1;
        }
        if (radar.getShareType().intValue() == RadarShareType.ADD_WEWORKUSER.getValue()) {
            if (StringUtils.isBlank((CharSequence)contactId)) {
                return 1;
            }
            List weworkUserNums = this.marketingRadarDetailMapper.queryRadarWeworkUserNums(radar.getCorpId(), radar.getNum());
            List weworkUserIds = this.weworkUserMapper.queryWeworkUserIdByNums((Collection)weworkUserNums);
            if (CollectionUtils.isEmpty((Collection)weworkUserNums) || CollectionUtils.isEmpty((Collection)weworkUserIds)) {
                return 0;
            }
            int count = this.weworkContactRelationMapper.isFriendRelation(radar.getCorpId(), contactId, (Collection)weworkUserIds);
            if (count > 0) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private MarketingRadarAccessLog getRadarAccessLog(MarketingRadar radar, MarketingRadarShareDetail shareDetail, WoauthUserDto user, String accessNum) {
        MarketingRadarAccessLog accessLog = new MarketingRadarAccessLog();
        if (StringUtils.isNotBlank((CharSequence)accessNum)) {
            accessLog.setNum(accessNum);
        } else {
            accessLog.setNum(this.idGen.getNum());
        }
        accessLog.setBizId(radar.getBizId());
        accessLog.setCorpId(radar.getCorpId());
        accessLog.setMarketingRadarNum(radar.getNum());
        accessLog.setMarketingRadarShareNum(shareDetail.getNum());
        accessLog.setUniqId(user.getUniqId());
        accessLog.setOpenId(user.getOpenId());
        if (StringUtils.isNotBlank((CharSequence)user.getExternalUserId())) {
            String contactId = user.getExternalUserId();
            accessLog.setContactId(contactId);
            WeworkContactLog log = this.weworkContactLogMapper.isRadarAddFriend(radar.getCorpId(), user.getExternalUserId(), radar.getId());
            if (log != null) {
                accessLog.setFriendshipType(Integer.valueOf(1));
                accessLog.setWeworkUserNum(log.getWeworkUserNum());
                accessLog.setVisitorNickName(log.getName());
                accessLog.setVisitorAvatar(log.getAvatar());
            } else {
                WeworkContact contact = this.weworkContactMapper.queryWeworkContact(radar.getBizId(), radar.getCorpId(), user.getExternalUserId());
                if (contact != null) {
                    accessLog.setVisitorNickName(contact.getName());
                    accessLog.setVisitorAvatar(contact.getAvatar());
                }
            }
        }
        Date curTime = new Date();
        accessLog.setVisitBeginTime(curTime);
        accessLog.setVisitEndTime(curTime);
        accessLog.setCreateTime(curTime);
        accessLog.setContactId(user.getExternalUserId());
        this.marketingRadarAccessLogMapper.insertSelective((Object)accessLog);
        return accessLog;
    }

    private void addShareInfo(Long userId, String shareWeworkUserNum, RadarClientInfoDto infoDto) {
        if (StringUtils.isNotEmpty((CharSequence)shareWeworkUserNum)) {
            WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(shareWeworkUserNum);
            if (weworkUser != null) {
                infoDto.setShareName(weworkUser.getName());
                infoDto.setShareMobile(weworkUser.getMobile());
            }
            User user = (User)this.userMapper.selectByPrimaryKey((Object)userId);
            if (StringUtils.isBlank((CharSequence)infoDto.getShareName())) {
                infoDto.setShareName(user.getName());
            }
            if (StringUtils.isBlank((CharSequence)infoDto.getShareMobile())) {
                infoDto.setShareMobile(user.getMobile());
            }
        } else if (userId != null) {
            infoDto.setShareName(this.userMapper.getUserNameByUserId(userId));
        }
    }

    private String getRadarShareQrcode(Long bizId, String corpId, String weworkUserNum, String radarNum) {
        MarketingRadarQrcode radarQrcode = this.marketingRadarQrcodeMapper.queryShareQrcode(corpId, weworkUserNum, radarNum);
        if (radarQrcode == null) {
            radarQrcode = new MarketingRadarQrcode();
            radarQrcode.setBizId(bizId);
            radarQrcode.setCorpId(corpId);
            radarQrcode.setType(Integer.valueOf(1));
            radarQrcode.setState("RD_" + this.idGen.getNum());
            radarQrcode.setWeworkUserNums(weworkUserNum);
            radarQrcode.setMarketingRadarNum(radarNum);
            String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(weworkUserNum);
            this.createQrcode(radarQrcode, Lists.newArrayList((Object[])new String[]{weworkUserId}));
            radarQrcode.setCreateTime(new Date());
            this.marketingRadarQrcodeMapper.insertSelective((Object)radarQrcode);
        }
        return radarQrcode.getQrcodeUrl();
    }

    private String getRadarWeworkUserQrcode(String corpId, String radarNum) {
        MarketingRadarQrcode radarQrcode = this.marketingRadarQrcodeMapper.queryRadarQrcode(corpId, radarNum);
        if (radarQrcode != null) {
            return radarQrcode.getQrcodeUrl();
        }
        return null;
    }

    private void createQrcode(MarketingRadarQrcode radarQrcode, List<String> weworkUserIds) {
        log.info("createQrcode params: {}", (Object)radarQrcode);
        String accessToken = this.customizedTokenService.getAgentAccessToken(radarQrcode.getCorpId());
        ContactWay contactWayConfig = new ContactWay();
        contactWayConfig.setType(Integer.valueOf(1));
        contactWayConfig.setScene(Integer.valueOf(2));
        contactWayConfig.setState(radarQrcode.getState());
        if (CollectionUtils.isEmpty(weworkUserIds)) {
            return;
        }
        contactWayConfig.setUserIds(weworkUserIds);
        contactWayConfig.setIsTemp(Boolean.valueOf(false));
        try {
            ConfigIdResp configIdResp = this.contactWayApi.create(accessToken, contactWayConfig);
            radarQrcode.setConfigId(configIdResp.getConfigId());
            radarQrcode.setQrcodeUrl(configIdResp.getQrCode());
        }
        catch (Exception e) {
            radarQrcode.setErrorMsg(e.getMessage());
        }
    }

    @Override
    public void report(RadarClientReportDto params) {
        if (params == null) {
            log.warn("marketing radar access log report params is null");
            return;
        }
        log.info("report params: {}", (Object)params);
        params.validate();
        MarketingRadarAccessLog accessLog = new MarketingRadarAccessLog();
        accessLog.setNum(params.getId());
        accessLog = (MarketingRadarAccessLog)this.marketingRadarAccessLogMapper.selectOne((Object)accessLog);
        if (accessLog == null) {
            log.warn("marketing radar access log not find report: {} ", (Object)params.getId());
            return;
        }
        accessLog.setVisitBeginTime(params.getVisitBeginTime());
        accessLog.setVisitEndTime(params.getVisitEndTime());
        if (params.getStayTime() == null) {
            accessLog.setStayTime(Long.valueOf(params.getVisitEndTime().getTime() - params.getVisitBeginTime().getTime()));
        } else {
            accessLog.setStayTime(params.getStayTime());
        }
        accessLog.setFinishPercent(params.getFinishPercent());
        this.marketingRadarAccessLogMapper.updateByPrimaryKeySelective((Object)accessLog);
    }

    @Override
    public void sendRadarRemind(MarketingRadarAccessLog accessLog) {
        if (Objects.isNull(accessLog)) {
            return;
        }
        MarketingRadar radar = this.marketingRadarMapper.queryByNum(accessLog.getMarketingRadarNum(), accessLog.getBizId());
        if (radar == null) {
            return;
        }
        if (radar.getIsSendClickMsg() == 0) {
            log.info("radar config not send click msg");
            return;
        }
        String sendTarget = "";
        String sendContent = RADAR_REMIND_CONTENT;
        if (radar.getType().intValue() == RadarType.LINK.getValue()) {
            sendContent = RADAR_LINK_REMIND_CONTENT;
        }
        String radarShareNum = accessLog.getMarketingRadarShareNum();
        MarketingRadarShareDetail shareDetail = new MarketingRadarShareDetail();
        shareDetail.setCorpId(accessLog.getCorpId());
        shareDetail.setNum(radarShareNum);
        shareDetail = (MarketingRadarShareDetail)this.marketingRadarShareDetailMapper.selectOne((Object)shareDetail);
        if (shareDetail == null) {
            log.info("send radar remind share detail is null");
            return;
        }
        sendTarget = shareDetail.getShareWeworkUserNum();
        if (StringUtils.isNotBlank((CharSequence)sendTarget)) {
            sendTarget = this.weworkUserMapper.queryWeworkUserIdByNum(sendTarget);
        }
        if (StringUtils.isBlank((CharSequence)sendTarget)) {
            log.info("send radar remind send target is null");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)accessLog.getContactId())) {
            sendContent = sendContent.replace("${customer}", accessLog.getVisitorNickName());
            sendContent = sendContent.replace("${customerType}", "\u4f01\u4e1a\u5ba2\u6237");
        } else {
            sendContent = sendContent.replace("${customer}", "\u6e38\u5ba2");
            sendContent = sendContent.replace("${customerType}", "\u975e\u4f01\u4e1a\u5ba2\u6237");
        }
        String customerDetailUrl = CUSTOMER_DETAIL_CONTENT.replace("${scrmManagerHost}", this.scrmManagerHost).replace("${corpId}", accessLog.getCorpId()).replace("${id}", accessLog.getMarketingRadarNum()).replace("${shareId}", shareDetail.getShareWeworkUserNum());
        sendContent = sendContent + customerDetailUrl;
        String stayTime = StayTimeUtil.transTime(accessLog.getStayTime());
        String title = radar.getTitle();
        if (StringUtils.isNotBlank((CharSequence)title)) {
            sendContent = sendContent.replace("${radarTitle}", title);
        }
        sendContent = sendContent.replace("${length}", stayTime);
        sendContent = sendContent.replace("${finishPercent}", accessLog.getFinishPercent() + "%");
        String url = radar.getUrl();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            sendContent = sendContent.replace("${radarUrl}", url);
        }
        log.info("sendRadarRemind sendTarget: {}, sendContent: {}", (Object)sendTarget, (Object)sendContent);
        try {
            SendMsgResult result = this.remindService.sendMsg(accessLog.getCorpId(), sendTarget, sendContent);
            log.info("sendRadarRemind SendMsgResult errCode: {}, errMsg: {}", (Object)result.getErrCode(), (Object)result.getErrMsg());
            if (result.getErrCode() == 0 && result.getErrMsg().equals("ok")) {
                log.info("sendRadarRemind success : {}", (Object)result.getErrCode());
                accessLog.setSendRemind(Integer.valueOf(1));
                this.marketingRadarAccessLogMapper.updateByPrimaryKey((Object)accessLog);
            }
        }
        catch (Exception e) {
            log.error("sendRadarRemind error:", (Throwable)e);
        }
    }

    @Override
    public void saveFollowRecord(MarketingRadarAccessLog accessLog) {
        String radarShareNum = accessLog.getMarketingRadarShareNum();
        MarketingRadarShareDetail shareDetail = new MarketingRadarShareDetail();
        shareDetail.setCorpId(accessLog.getCorpId());
        shareDetail.setNum(radarShareNum);
        shareDetail = (MarketingRadarShareDetail)this.marketingRadarShareDetailMapper.selectOne((Object)shareDetail);
        if (shareDetail == null) {
            log.info("radar save follow record share detail is null");
            return;
        }
        MarketingRadar radar = this.marketingRadarMapper.queryByNum(accessLog.getMarketingRadarNum(), accessLog.getBizId());
        if (radar == null) {
            log.info("radar save follow record radar is null");
            return;
        }
        String weworkUserNum = shareDetail.getShareWeworkUserNum();
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            log.info("radar save follow record follow weworkUserNum is null");
            return;
        }
        String shareName = "";
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(weworkUserNum);
        if (Objects.nonNull(weworkUser)) {
            shareName = weworkUser.getName();
        }
        if (StringUtils.isBlank((CharSequence)accessLog.getContactId())) {
            log.info("radar save follow record contactId is null");
            return;
        }
        String content = "\u6d4f\u89c8\u5185\u5bb9\uff1a\u3010" + RadarType.getType((Integer)radar.getType()).getDesc() + "\u3011 \u300a" + radar.getTitle() + "\u300b";
        String stayTime = StayTimeUtil.transTime(accessLog.getStayTime());
        if (radar.getType().intValue() == RadarType.FILE_PDF.getValue() || radar.getType().intValue() == RadarType.WX_GZH.getValue()) {
            content = content + ", \u65f6\u957f" + stayTime + ", \u9605\u8bfb\u5b8c\u6210\u5ea6" + accessLog.getFinishPercent() + "%";
        }
        RadarRecordInfoReqDto recordInfoReqDto = new RadarRecordInfoReqDto();
        recordInfoReqDto.setTitle(radar.getTitle());
        recordInfoReqDto.setFileUrl(radar.getUrl());
        recordInfoReqDto.setDuration(accessLog.getStayTime());
        recordInfoReqDto.setProgress(accessLog.getFinishPercent());
        recordInfoReqDto.setViewTime(accessLog.getVisitBeginTime());
        String radarParam = JsonUtil.toStr((Object)recordInfoReqDto);
        FollowRecord followRecord = new FollowRecord();
        followRecord.setBizId(accessLog.getBizId());
        followRecord.setCorpId(accessLog.getCorpId());
        followRecord.setWeworkUserNum(weworkUserNum);
        followRecord.setWeworkContactId(accessLog.getContactId());
        followRecord.setType(Integer.valueOf(FollowRecordType.CUSTOMER_FOLLOW.getValue()));
        followRecord.setContent(content);
        followRecord.setCreateBy(shareDetail.getShareUserId());
        followRecord.setCreateTime(new Date());
        followRecord.setParams(radarParam);
        this.followRecordMapper.insertSelective((Object)followRecord);
        this.customerCenterService.pushFollowRecord(followRecord, "", shareName);
    }
}

