/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.radar.service.impl;

import cn.kinyun.scrm.page.auth.service.WeworkOauthService;
import cn.kinyun.wework.sdk.api.external.ContactWayApi;
import cn.kinyun.wework.sdk.entity.external.contactway.ConfigIdResp;
import cn.kinyun.wework.sdk.entity.external.contactway.ContactWay;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StrIdAndNameDto;
import com.kuaike.scrm.common.enums.OauthShortUrlTypeEnum;
import com.kuaike.scrm.common.enums.RadarShareType;
import com.kuaike.scrm.common.enums.RadarType;
import com.kuaike.scrm.common.service.CommonService;
import com.kuaike.scrm.common.service.dto.UrlInfoDto;
import com.kuaike.scrm.common.service.dto.UrlParams;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.radar.entity.MarketingRadar;
import com.kuaike.scrm.dal.radar.entity.MarketingRadarAccessLog;
import com.kuaike.scrm.dal.radar.entity.MarketingRadarDetail;
import com.kuaike.scrm.dal.radar.entity.MarketingRadarGroup;
import com.kuaike.scrm.dal.radar.entity.MarketingRadarQrcode;
import com.kuaike.scrm.dal.radar.entity.MarketingRadarShareDetail;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarAccessLogMapper;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarDetailMapper;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarGroupMapper;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarMapper;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarQrcodeMapper;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarShareDetailMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworkTag.mapper.WeworkTagMapper;
import com.kuaike.scrm.radar.dto.req.MarketingAddRadarReqDto;
import com.kuaike.scrm.radar.dto.req.MarketingEditRadarReqDto;
import com.kuaike.scrm.radar.dto.req.MarketingRadarListReqDto;
import com.kuaike.scrm.radar.dto.req.RadarBaseReqDto;
import com.kuaike.scrm.radar.dto.req.RadarDetailReqDto;
import com.kuaike.scrm.radar.dto.req.RadarGroupBaseDto;
import com.kuaike.scrm.radar.dto.req.RadarGroupListReqDto;
import com.kuaike.scrm.radar.dto.req.SidebarRadarListReq;
import com.kuaike.scrm.radar.dto.req.SidebarRadarShareListReq;
import com.kuaike.scrm.radar.dto.resp.MarketingRadarDetailRespDto;
import com.kuaike.scrm.radar.dto.resp.MarketingRadarListRespDto;
import com.kuaike.scrm.radar.dto.resp.RadarCustomerDetailResp;
import com.kuaike.scrm.radar.dto.resp.RadarShareDetailResp;
import com.kuaike.scrm.radar.dto.resp.RadarShareDto;
import com.kuaike.scrm.radar.dto.resp.RadarShareRespDto;
import com.kuaike.scrm.radar.dto.resp.RadarStatisticDto;
import com.kuaike.scrm.radar.dto.resp.SidebarRadarListDto;
import com.kuaike.scrm.radar.dto.resp.SidebarRadarShareListDto;
import com.kuaike.scrm.radar.service.MarketingRadarService;
import com.kuaike.scrm.radar.utils.StayTimeUtil;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.curator.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MarketingRadarServiceImpl
implements MarketingRadarService {
    private static final Logger log = LoggerFactory.getLogger(MarketingRadarServiceImpl.class);
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${radar.pdf.url.format:/radar/pdfRadar?id={0}}")
    private String radarPdfUrlFormat;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${radar.mp.url.format:/radar/mpRadar?id={0}}")
    private String radarMpUrlFormat;
    @Autowired
    private MarketingRadarMapper marketingRadarMapper;
    @Autowired
    private MarketingRadarDetailMapper marketingRadarDetailMapper;
    @Autowired
    private MarketingRadarShareDetailMapper marketingRadarShareDetailMapper;
    @Resource
    private MarketingRadarAccessLogMapper marketingRadarAccessLogMapper;
    @Autowired
    private MarketingRadarGroupMapper marketingRadarGroupMapper;
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Resource
    private MarketingRadarQrcodeMapper marketingRadarQrcodeMapper;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Resource
    private ContactWayApi contactWayApi;
    @Autowired
    private WeworkOauthService weworkOauthService;
    @Autowired
    private CommonService commonService;

    @Override
    @Transactional
    public String add(MarketingAddRadarReqDto req) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        MarketingRadar radar = req.convertToPO(null);
        radar.setBizId(user.getBizId());
        radar.setCorpId(user.getCorpId());
        radar.setCreateby(user.getWeworkUserNum());
        radar.setCreateName(user.getName());
        radar.setNum(this.idGen.getNum());
        radar.setCreateTime(new Date());
        radar.setIsDeleted(NumberUtils.INTEGER_ZERO);
        if (req.getType() == RadarType.WX_GZH.getValue()) {
            UrlParams params = new UrlParams();
            params.setUrl(req.getUrl());
            UrlInfoDto infoDto = this.commonService.getUrlInfo(params);
            if (Objects.nonNull(infoDto)) {
                radar.setContent(infoDto.getHtml());
            }
        }
        this.marketingRadarMapper.insert((Object)radar);
        this.batchInsertRadarDetail(user, req, radar.getNum());
        if (req.getShareType() == RadarShareType.ADD_WEWORKUSER.getValue()) {
            HashSet shareWeworkUserNums = Sets.newHashSet(req.getShareWeworkUserNums());
            this.createRadarWeworkUserQrcode(user.getBizId(), user.getCorpId(), radar.getNum(), shareWeworkUserNums);
        }
        return radar.getNum();
    }

    void batchInsertRadarDetail(CurrentUserInfo user, MarketingAddRadarReqDto req, String marketingRadarNum) {
        ArrayList details = Lists.newArrayList();
        if (req.getIsClickTag() == NumberUtils.INTEGER_ONE.intValue()) {
            MarketingRadarDetail tag = null;
            for (String tagNum : req.getClickTagIds()) {
                tag = new MarketingRadarDetail();
                tag.setBizId(user.getBizId());
                tag.setCorpId(user.getCorpId());
                tag.setFkNum(tagNum);
                tag.setMarketingRadarNum(marketingRadarNum);
                tag.setNum(this.idGen.getNum());
                tag.setType(Integer.valueOf(1));
                tag.setCreateTime(new Date());
                tag.setUpdateTime(new Date());
                tag.setIsDeleted(Integer.valueOf(0));
                tag.setCreateBy(user.getWeworkUserNum());
                details.add(tag);
            }
        }
        if (req.getShareType() == NumberUtils.INTEGER_TWO.intValue()) {
            MarketingRadarDetail shareUser = null;
            for (String weworkUserNum : req.getShareWeworkUserNums()) {
                shareUser = new MarketingRadarDetail();
                shareUser.setBizId(user.getBizId());
                shareUser.setCorpId(user.getCorpId());
                shareUser.setFkNum(weworkUserNum);
                shareUser.setMarketingRadarNum(marketingRadarNum);
                shareUser.setNum(this.idGen.getNum());
                shareUser.setType(Integer.valueOf(2));
                shareUser.setCreateTime(new Date());
                shareUser.setUpdateTime(new Date());
                shareUser.setIsDeleted(Integer.valueOf(0));
                shareUser.setCreateBy(user.getWeworkUserNum());
                details.add(shareUser);
            }
        }
        log.info("MarketingRadarServiceImpl.batchInsertRadarDetail.details:{}", (Object)details);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            this.marketingRadarDetailMapper.batchInsert((List)details);
        }
    }

    @Override
    @Transactional
    public String edit(MarketingEditRadarReqDto req) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        MarketingRadar radar = this.marketingRadarMapper.queryByNum(req.getId(), user.getBizId());
        Preconditions.checkArgument((radar != null ? 1 : 0) != 0, (Object)"\u65e0\u6743\u64cd\u4f5c");
        Preconditions.checkArgument((radar.getIsDeleted().intValue() == NumberUtils.INTEGER_ZERO.intValue() ? 1 : 0) != 0, (Object)"\u5df2\u5220\u9664\u4fe1\u606f\u4e0d\u80fd\u7f16\u8f91");
        radar = req.convertToPO(radar);
        radar.setUpdateTime(new Date());
        radar.setUpdateby(user.getWeworkUserNum());
        if (req.getType() == RadarType.WX_GZH.getValue()) {
            UrlParams params = new UrlParams();
            params.setUrl(req.getUrl());
            UrlInfoDto infoDto = this.commonService.getUrlInfo(params);
            if (Objects.nonNull(infoDto)) {
                radar.setContent(infoDto.getHtml());
            }
        }
        this.deleteAndSave(user, req, radar.getNum());
        this.marketingRadarMapper.updateByPrimaryKey((Object)radar);
        if (req.getShareType() == RadarShareType.ADD_WEWORKUSER.getValue()) {
            MarketingRadarQrcode radarQrcode = this.marketingRadarQrcodeMapper.queryRadarQrcode(user.getCorpId(), radar.getNum());
            HashSet shareWeworkUserNums = Sets.newHashSet(req.getShareWeworkUserNums());
            if (radarQrcode == null || StringUtils.isEmpty((CharSequence)radarQrcode.getConfigId())) {
                this.createRadarWeworkUserQrcode(user.getBizId(), user.getCorpId(), radar.getNum(), shareWeworkUserNums);
            } else {
                this.updateRadarWeworkUserQrcode(radarQrcode, shareWeworkUserNums);
            }
        }
        return radar.getNum();
    }

    void deleteAndSave(CurrentUserInfo user, MarketingAddRadarReqDto req, String marketingRadarNum) {
        log.info("MarketingRadarServiceImpl.deleteAndSave.req:{}", (Object)marketingRadarNum);
        this.marketingRadarDetailMapper.deleteByMarketingRadarNum(marketingRadarNum, user.getBizId());
        this.batchInsertRadarDetail(user, req, marketingRadarNum);
    }

    @Override
    @Transactional
    public void del(String num) {
        log.info("MarketingRadarServiceImpl.del.num:{}", (Object)num);
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        MarketingRadar radar = this.marketingRadarMapper.queryByNum(num, user.getBizId());
        Preconditions.checkArgument((radar != null ? 1 : 0) != 0, (Object)"\u65e0\u6743\u64cd\u4f5c");
        Preconditions.checkArgument((boolean)radar.getCreateby().equals(user.getWeworkUserNum()), (Object)"\u65e0\u6743\u64cd\u4f5c");
        radar.setIsDeleted(NumberUtils.INTEGER_ONE);
        radar.setUpdateTime(new Date());
        this.marketingRadarMapper.updateByPrimaryKey((Object)radar);
        this.marketingRadarDetailMapper.deleteByMarketingRadarNum(radar.getNum(), user.getBizId());
    }

    @Override
    public MarketingRadarDetailRespDto getDetail(String num) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        MarketingRadar radar = this.marketingRadarMapper.queryByNum(num, user.getBizId());
        return this.buildDetail(user, radar);
    }

    MarketingRadarDetailRespDto buildDetail(CurrentUserInfo user, MarketingRadar radar) {
        List details;
        MarketingRadarDetailRespDto respDto = MarketingRadarDetailRespDto.convertPOToDto(radar);
        MarketingRadarGroup radarGroup = this.marketingRadarGroupMapper.queryGroupByNum(radar.getGroupNum(), user.getCorpId());
        if (radarGroup != null) {
            String groupName = radarGroup.getGroupName();
            respDto.setGroupName(groupName);
        }
        if (CollectionUtils.isNotEmpty((Collection)(details = this.marketingRadarDetailMapper.queryByMarketingRadarNum(radar.getNum(), user.getBizId())))) {
            List users;
            Collection userNums;
            Map r;
            Collection tagIds;
            if (radar.getIsClickTag().intValue() == NumberUtils.INTEGER_ONE.intValue() && CollectionUtils.isNotEmpty((Collection)(tagIds = (Collection)details.stream().filter(p -> p.getType().intValue() == NumberUtils.INTEGER_ONE.intValue()).map(MarketingRadarDetail::getFkNum).collect(Collectors.toSet()))) && (r = this.weworkTagMapper.queryTagIdAndName(user.getCorpId(), tagIds)) != null && !r.isEmpty()) {
                List<StrIdAndNameDto> tags = this.buildTagResult(r);
                respDto.setTags(tags);
            }
            if (radar.getShareType().intValue() == NumberUtils.INTEGER_TWO.intValue() && CollectionUtils.isNotEmpty((Collection)(userNums = (Collection)details.stream().filter(p -> p.getType().intValue() == NumberUtils.INTEGER_TWO.intValue()).map(MarketingRadarDetail::getFkNum).collect(Collectors.toSet()))) && CollectionUtils.isNotEmpty((Collection)(users = this.weworkUserMapper.getWeworkUserIdsByNum(user.getCorpId(), userNums)))) {
                List<StrIdAndNameDto> shareUsers = this.buildUserResult(users);
                respDto.setShareUser(shareUsers);
            }
        }
        return respDto;
    }

    List<StrIdAndNameDto> buildUserResult(List<WeworkUser> users) {
        ArrayList shareUsers = Lists.newArrayList();
        StrIdAndNameDto item = null;
        for (WeworkUser user : users) {
            item = new StrIdAndNameDto();
            item.setId(user.getNum());
            item.setName(user.getName());
            shareUsers.add(item);
        }
        return shareUsers;
    }

    List<StrIdAndNameDto> buildTagResult(Map<String, String> r) {
        ArrayList tags = Lists.newArrayList();
        StrIdAndNameDto item = null;
        for (String tagNum : r.keySet()) {
            item = new StrIdAndNameDto();
            item.setId(tagNum);
            item.setName(r.get(tagNum));
            tags.add(item);
        }
        return tags;
    }

    @Override
    public List<MarketingRadarListRespDto> queryList(MarketingRadarListReqDto req) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        ArrayList data = Lists.newArrayList();
        List radars = this.marketingRadarMapper.queryByParams(req.getTitle(), req.getGroupNum(), req.getCreateByNum(), user.getCorpId(), Integer.valueOf(req.getPageDto().getOffset()), req.getPageDto().getPageSize());
        if (CollectionUtils.isEmpty((Collection)radars)) {
            log.warn("queryList, \u672a\u67e5\u8be2\u5230\u96f7\u8fbe\u8bb0\u5f55\u6570\u636e");
            return null;
        }
        int count = this.marketingRadarMapper.queryCountByParams(req.getTitle(), req.getGroupNum(), req.getCreateByNum(), user.getCorpId());
        req.getPageDto().setCount(Integer.valueOf(count));
        req.getPageDto().setCurPageCount(Integer.valueOf(radars.size()));
        List radarNums = radars.stream().map(MarketingRadar::getNum).collect(Collectors.toList());
        Map tagIdsMap = this.marketingRadarDetailMapper.queryNumsByFKnums(radarNums, user.getBizId());
        log.info("queryList, tagNumsMap: {}", (Object)tagIdsMap);
        Map clickCountMap = this.marketingRadarAccessLogMapper.queryClickCount(user.getCorpId(), radarNums);
        log.info("queryList, clickCountMap: {}", (Object)clickCountMap);
        Map personCountMap = this.marketingRadarAccessLogMapper.queryClickPersonsByRadarGroup(user.getCorpId(), radarNums, null, null);
        log.info("queryList, personCountMap: {}", (Object)personCountMap);
        for (MarketingRadar radar : radars) {
            Map r;
            List tagIds;
            MarketingRadarListRespDto detail = new MarketingRadarListRespDto();
            detail.setId(radar.getNum());
            detail.setType(radar.getType());
            detail.setTitle(radar.getTitle());
            detail.setFileName(radar.getFileName());
            detail.setFileSize(radar.getFileSize());
            detail.setUrl(radar.getUrl());
            detail.setSource(radar.getSource());
            detail.setLinkTitle(radar.getLinkTitle());
            detail.setLinkDesc(radar.getLinkDesc());
            detail.setLinkAvatar(radar.getLinkAvatar());
            detail.setCreateByNum(radar.getCreateby());
            detail.setCreateByName(radar.getCreateName());
            detail.setCreateTime(radar.getCreateTime());
            if (personCountMap != null) {
                Integer personCount = (Integer)personCountMap.get(radar.getNum());
                detail.setPersonCount(personCount);
            }
            if (clickCountMap != null) {
                Integer viewCount = (Integer)clickCountMap.get(radar.getNum());
                detail.setViewCount(viewCount);
            }
            if (tagIdsMap != null && CollectionUtils.isNotEmpty((Collection)(tagIds = (List)tagIdsMap.get(radar.getNum()))) && (r = this.weworkTagMapper.queryTagIdAndName(user.getCorpId(), (Collection)tagIds)) != null && !r.isEmpty()) {
                List<StrIdAndNameDto> tags = this.buildTagResult(r);
                detail.setTags(tags);
            }
            data.add(detail);
        }
        return data;
    }

    @Override
    public List<StrIdAndNameDto> queryByName(String title) {
        List radars;
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        ArrayList data = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)title) && CollectionUtils.isNotEmpty((Collection)(radars = this.marketingRadarMapper.queryByTitle(title, user.getBizId())))) {
            for (MarketingRadar radar : radars) {
                StrIdAndNameDto item = new StrIdAndNameDto();
                item.setId(radar.getNum());
                item.setName(radar.getTitle());
                data.add(item);
            }
        }
        return data;
    }

    @Override
    public List<StrIdAndNameDto> radarCreateList() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        ArrayList data = Lists.newArrayList();
        List radars = this.marketingRadarMapper.queryAll(user.getBizId());
        if (CollectionUtils.isNotEmpty((Collection)radars)) {
            ArrayList idList = Lists.newArrayList();
            for (MarketingRadar radar : radars) {
                if (idList.contains(radar.getCreateby())) continue;
                idList.add(radar.getCreateby());
                StrIdAndNameDto item = new StrIdAndNameDto();
                item.setId(radar.getCreateby());
                item.setName(radar.getCreateName());
                data.add(item);
            }
        }
        return data;
    }

    @Override
    public List<StrIdAndNameDto> radarShareUserList(RadarBaseReqDto reqDto) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        ArrayList data = Lists.newArrayList();
        String radarId = reqDto.getRadarId();
        if (StringUtils.isBlank((CharSequence)radarId)) {
            log.info("radarShareUserList radarId is null ");
            return null;
        }
        List shareNums = this.marketingRadarShareDetailMapper.getShareWeworkUserNums(user.getCorpId(), radarId, null, null, null);
        if (CollectionUtils.isEmpty((Collection)shareNums)) {
            log.info("radarShareUserList shareNums is null radarId: {}", (Object)radarId);
            return data;
        }
        Map weworkUserMaps = this.weworkUserMapper.queryWeworkUserNameMapByNums(user.getCorpId(), (Collection)shareNums);
        for (String shareNum : shareNums) {
            StrIdAndNameDto dto = new StrIdAndNameDto();
            dto.setId(shareNum);
            dto.setName((String)weworkUserMaps.get(shareNum));
            data.add(dto);
        }
        return data;
    }

    @Override
    public String share(String num) {
        RadarShareDto radarShareDto = this.sidebarShareRadar(num);
        return radarShareDto.getLink();
    }

    @Override
    @Transactional
    public RadarShareDto sidebarShareRadar(String num) {
        log.info("sidebar shareRadar params: {}", (Object)num);
        if (StringUtils.isBlank((CharSequence)num)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u96f7\u8fbeid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        MarketingRadar radar = new MarketingRadar();
        radar.setCorpId(corpId);
        radar.setNum(num);
        radar = (MarketingRadar)this.marketingRadarMapper.selectOne((Object)radar);
        if (radar == null || radar.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u96f7\u8fbe\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u5220\u9664");
        }
        RadarShareDto result = new RadarShareDto();
        result.setTitle(radar.getTitle());
        if (radar.getType().intValue() == RadarType.FILE_PDF.getValue()) {
            result.setDesc(radar.getFileName());
        } else if (radar.getType().intValue() == RadarType.WX_GZH.getValue()) {
            result.setDesc(radar.getSource());
        } else if (radar.getType().intValue() == RadarType.LINK.getValue()) {
            result.setDesc(radar.getLinkDesc());
            result.setImgUrl(radar.getLinkAvatar());
        }
        List existList = this.marketingRadarShareDetailMapper.queryExistShare(corpId, num, userInfo.getId(), userInfo.getWeworkUserNum());
        if (CollectionUtils.isNotEmpty((Collection)existList)) {
            result.setLink(((MarketingRadarShareDetail)existList.get(0)).getShareUrl());
            return result;
        }
        MarketingRadarShareDetail shareDetail = new MarketingRadarShareDetail();
        shareDetail.setBizId(userInfo.getBizId());
        shareDetail.setCorpId(userInfo.getCorpId());
        shareDetail.setNum(this.idGen.getNum());
        String originUrl = null;
        originUrl = radar.getType().intValue() == RadarType.FILE_PDF.getValue() ? MessageFormat.format(this.radarPdfUrlFormat, shareDetail.getNum()) : (radar.getType().intValue() == RadarType.WX_GZH.getValue() ? MessageFormat.format(this.radarMpUrlFormat, shareDetail.getNum()) : MessageFormat.format(this.radarPdfUrlFormat, shareDetail.getNum()));
        shareDetail.setShareUrl(this.weworkOauthService.wrapUrl(userInfo.getBizId(), userInfo.getCorpId(), originUrl, shareDetail.getNum(), Integer.valueOf(OauthShortUrlTypeEnum.RADAR_URL.getValue())));
        shareDetail.setMarketingRadarNum(radar.getNum());
        shareDetail.setShareWeworkUserNum(userInfo.getWeworkUserNum());
        shareDetail.setShareUserId(userInfo.getId());
        shareDetail.setCreateTime(new Date());
        this.marketingRadarShareDetailMapper.insert((Object)shareDetail);
        result.setLink(shareDetail.getShareUrl());
        return result;
    }

    @Override
    public RadarStatisticDto sidebarRadarStatistic(String num) {
        log.info("sidebar radar statistic params: {}", (Object)num);
        if (StringUtils.isBlank((CharSequence)num)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u96f7\u8fbeid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        MarketingRadar radar = new MarketingRadar();
        radar.setCorpId(corpId);
        radar.setNum(num);
        radar = (MarketingRadar)this.marketingRadarMapper.selectOne((Object)radar);
        if (radar == null || radar.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u96f7\u8fbe\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u5220\u9664");
        }
        Date todayStartTime = DateUtil.getTodayStartTime();
        Date todayEndTime = DateUtil.getTodayEndTime();
        RadarStatisticDto statisticDto = new RadarStatisticDto();
        int todayClickPersons = this.marketingRadarAccessLogMapper.queryClickPersons(corpId, radar.getNum(), todayStartTime, todayEndTime);
        int todayClicks = this.marketingRadarAccessLogMapper.queryClicks(corpId, radar.getNum(), todayStartTime, todayEndTime);
        int totalClickPersons = this.marketingRadarAccessLogMapper.queryClickPersons(corpId, radar.getNum(), null, null);
        int totalClicks = this.marketingRadarAccessLogMapper.queryClicks(corpId, radar.getNum(), null, null);
        statisticDto.setTodayClickPersons(todayClickPersons);
        statisticDto.setTodayClicks(todayClicks);
        statisticDto.setTotalClickPersons(totalClickPersons);
        statisticDto.setTotalClicks(totalClicks);
        return statisticDto;
    }

    @Override
    public List<SidebarRadarListDto> sidebarRadarList(SidebarRadarListReq params) {
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params.getPageDto() == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("sidebar radarList params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        PageDto pageDto = params.getPageDto();
        Page page = PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize()).doSelectPage(() -> this.marketingRadarMapper.querySidebarRadarList(userInfo.getCorpId(), params.getQuery(), params.getGroupId(), params.getType()));
        pageDto.setCount(Integer.valueOf((int)page.getTotal()));
        List list = page.getResult();
        List radarNums = list.stream().map(MarketingRadar::getNum).collect(Collectors.toList());
        Date todayStartTime = DateUtil.getTodayStartTime();
        Date todayEndTime = DateUtil.getTodayEndTime();
        Map radarTodayStatisticMap = this.marketingRadarAccessLogMapper.queryClickPersonsByRadarGroup(userInfo.getCorpId(), radarNums, todayStartTime, todayEndTime);
        Map radarTotalStatisticMap = this.marketingRadarAccessLogMapper.queryClickPersonsByRadarGroup(userInfo.getCorpId(), radarNums, null, null);
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (MarketingRadar radar : list) {
            SidebarRadarListDto dto = new SidebarRadarListDto();
            dto.setId(radar.getNum());
            dto.setTitle(radar.getTitle());
            dto.setType(radar.getType());
            dto.setUrl(radar.getUrl());
            if (radar.getType().intValue() == RadarType.FILE_PDF.getValue()) {
                dto.setFileName(radar.getFileName());
                dto.setFileSize(radar.getFileSize());
            } else if (radar.getType().intValue() == RadarType.WX_GZH.getValue()) {
                dto.setSource(radar.getSource());
            } else if (radar.getType().intValue() == RadarType.LINK.getValue()) {
                dto.setLinkTitle(radar.getLinkTitle());
                dto.setLinkAvatar(radar.getLinkAvatar());
                dto.setLinkDesc(radar.getLinkDesc());
            }
            dto.setTodayClickPersons(radarTodayStatisticMap.getOrDefault(radar.getNum(), 0));
            dto.setTotalClickPersons(radarTotalStatisticMap.getOrDefault(radar.getNum(), 0));
            result.add(dto);
        }
        return result;
    }

    @Override
    public List<SidebarRadarShareListDto> sidebarShareList(SidebarRadarShareListReq params) {
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)params.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        PageDto pageDto = params.getPageDto();
        if (pageDto == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Page page = PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize()).doSelectPage(() -> {
            String shareWeworkUserNum = null;
            if (params.getType() != null && params.getType() == 1) {
                shareWeworkUserNum = userInfo.getWeworkUserNum();
            }
            this.marketingRadarAccessLogMapper.queryShareLogList(corpId, params.getId(), params.getQuery(), shareWeworkUserNum);
        });
        pageDto.setCount(Integer.valueOf((int)page.getTotal()));
        List list = page.getResult();
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        Set radarShareNums = list.stream().map(MarketingRadarAccessLog::getMarketingRadarShareNum).collect(Collectors.toSet());
        Map shareNameMap = this.marketingRadarShareDetailMapper.queryShareNames(corpId, radarShareNums);
        MarketingRadar radar = this.marketingRadarMapper.queryByNum(params.getId(), userInfo.getBizId());
        Set contactIds = list.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getContactId())).map(MarketingRadarAccessLog::getContactId).collect(Collectors.toSet());
        Map contactMap = this.weworkContactRelationMapper.queryWeworkUserOfContacts(corpId, userInfo.getWeworkUserId(), contactIds);
        Map contactCorpNameMap = this.weworkContactMapper.queryContactCorpNameMap(corpId, contactIds);
        for (MarketingRadarAccessLog accessLog : list) {
            SidebarRadarShareListDto dto = new SidebarRadarShareListDto();
            dto.setId(accessLog.getNum());
            dto.setTitle(radar.getTitle());
            dto.setContactId(accessLog.getContactId());
            dto.setName(accessLog.getVisitorNickName());
            dto.setAvatar(accessLog.getVisitorAvatar());
            dto.setIsCommunication(accessLog.getIsCommunication());
            dto.setVisitBeginTime(accessLog.getVisitBeginTime());
            dto.setFinishPercent(accessLog.getFinishPercent());
            dto.setStayTime(accessLog.getStayTime());
            dto.setShareName((String)shareNameMap.get(accessLog.getMarketingRadarShareNum()));
            if (StringUtils.isNotBlank((CharSequence)accessLog.getContactId())) {
                dto.setIsSelfCustomer(contactMap.getOrDefault(accessLog.getContactId(), 0));
                dto.setCorpName((String)contactCorpNameMap.get(accessLog.getContactId()));
            } else {
                dto.setIsSelfCustomer(0);
            }
            result.add(dto);
        }
        return result;
    }

    @Override
    @Transactional
    public void updateCommunication(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MarketingRadarAccessLog accessLog = new MarketingRadarAccessLog();
        accessLog.setNum(num);
        accessLog = (MarketingRadarAccessLog)this.marketingRadarAccessLogMapper.selectOne((Object)accessLog);
        if (accessLog == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6d4f\u89c8\u8bb0\u5f55");
        }
        accessLog.setIsCommunication(Integer.valueOf(1));
        this.marketingRadarAccessLogMapper.updateByPrimaryKeySelective((Object)accessLog);
    }

    @Override
    public List<RadarCustomerDetailResp> queryCustomerList(RadarDetailReqDto reqDto) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        log.info("queryCustomerList getCorpId: {}, userId: {}", (Object)user.getCorpId(), (Object)user.getId());
        reqDto.validate();
        ArrayList resps = Lists.newArrayList();
        List accessLogs = this.marketingRadarAccessLogMapper.queryShareListByCustomer(user.getCorpId(), reqDto.getRadarId(), reqDto.getShareStartTime(), reqDto.getShareEndTime(), reqDto.getShareUserNum(), reqDto.getCustomerNickName(), Integer.valueOf(reqDto.getPageDto().getOffset()), reqDto.getPageDto().getPageSize());
        if (CollectionUtils.isEmpty((Collection)accessLogs)) {
            log.info("queryCustomerList \u672a\u67e5\u8be2\u5230\u8bb0\u5f55");
            return resps;
        }
        Integer count = this.marketingRadarAccessLogMapper.queryShareListCountByCustomer(user.getCorpId(), reqDto.getRadarId(), reqDto.getShareStartTime(), reqDto.getShareEndTime(), reqDto.getShareUserNum(), reqDto.getCustomerNickName());
        reqDto.getPageDto().setCount(count);
        reqDto.getPageDto().setCurPageCount(Integer.valueOf(accessLogs.size()));
        List weworkUserNums = accessLogs.stream().map(MarketingRadarAccessLog::getWeworkUserNum).collect(Collectors.toList());
        Map weworkUserMap = this.weworkUserMapper.queryWeworkUserNameMapByNums(user.getCorpId(), weworkUserNums);
        log.info("queryCustomerList weworkUserMap : {}", (Object)weworkUserMap);
        Set radarShareNum = accessLogs.stream().map(MarketingRadarAccessLog::getMarketingRadarShareNum).collect(Collectors.toSet());
        Map shareNumMap = this.marketingRadarShareDetailMapper.queryShareNames(user.getCorpId(), radarShareNum);
        log.info("queryCustomerList shareNumMap : {}", (Object)shareNumMap);
        Set contactIds = accessLogs.stream().map(MarketingRadarAccessLog::getContactId).collect(Collectors.toSet());
        Map contactCorpNameMap = this.weworkContactMapper.queryContactCorpNameMap(user.getCorpId(), contactIds);
        log.info("queryCustomerList contactCorpNameMap : {}", (Object)contactCorpNameMap);
        for (MarketingRadarAccessLog accessLog : accessLogs) {
            RadarCustomerDetailResp detailResp = new RadarCustomerDetailResp();
            detailResp.setContactAvatar(accessLog.getVisitorAvatar());
            detailResp.setContactNickName(accessLog.getVisitorNickName());
            detailResp.setContactId(accessLog.getContactId());
            if (contactCorpNameMap != null && StringUtils.isNotBlank((CharSequence)accessLog.getContactId())) {
                String corpName = (String)contactCorpNameMap.get(accessLog.getContactId());
                detailResp.setContactTips(corpName);
            }
            detailResp.setIsNewFriend(accessLog.getFriendshipType());
            detailResp.setAddWeworkNum(accessLog.getWeworkUserNum());
            if (weworkUserMap != null) {
                String weworkUserName = (String)weworkUserMap.get(accessLog.getWeworkUserNum());
                detailResp.setAddWeworkName(weworkUserName);
            }
            detailResp.setViewTime(accessLog.getVisitBeginTime());
            Long stayTime = accessLog.getStayTime();
            detailResp.setViewLength(StayTimeUtil.transTime(stayTime));
            detailResp.setViewPercent(accessLog.getFinishPercent());
            if (shareNumMap != null) {
                String shareName = (String)shareNumMap.get(accessLog.getMarketingRadarShareNum());
                detailResp.setShareWeworkName(shareName);
            }
            resps.add(detailResp);
        }
        return resps;
    }

    @Override
    public RadarShareRespDto queryShareList(RadarDetailReqDto reqDto) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        log.info("queryCustomerList getCorpId: {}, userId: {}", (Object)user.getCorpId(), (Object)user.getId());
        reqDto.validate();
        RadarShareRespDto respDto = new RadarShareRespDto();
        List shareNums = this.marketingRadarShareDetailMapper.getShareWeworkUserNums(user.getCorpId(), reqDto.getRadarId(), reqDto.getShareStartTime(), reqDto.getShareEndTime(), reqDto.getShareUserNum());
        if (CollectionUtils.isEmpty((Collection)shareNums)) {
            log.info("queryCustomerList  \u672a\u67e5\u8be2\u5230\u5206\u4eab\u4eba\u8bb0\u5f55");
            return null;
        }
        Map shareNameMap = this.weworkUserMapper.queryWeworkUserNameMapByNums(user.getCorpId(), (Collection)shareNums);
        ArrayList resps = Lists.newArrayList();
        Integer memberCount = 0;
        Integer viewCount = 0;
        Integer addCount = 0;
        for (String shareWeworkNum : shareNums) {
            List accessLogs = this.marketingRadarAccessLogMapper.queryShareListByShareMember(user.getCorpId(), reqDto.getRadarId(), reqDto.getShareStartTime(), reqDto.getShareEndTime(), shareWeworkNum);
            RadarShareDetailResp resp = new RadarShareDetailResp();
            Integer shareCount = accessLogs.stream().map(MarketingRadarAccessLog::getContactId).collect(Collectors.toSet()).size();
            memberCount = memberCount + shareCount;
            resp.setShareCount(shareCount);
            viewCount = viewCount + accessLogs.size();
            resp.setViewCount(accessLogs.size());
            Integer newAddCount = accessLogs.stream().filter(a -> a.getFriendshipType() == 1).collect(Collectors.toSet()).size();
            addCount = addCount + newAddCount;
            resp.setAddCount(newAddCount);
            resp.setShareWeworkNum(shareWeworkNum);
            resp.setShareWeworkName((String)shareNameMap.get(shareWeworkNum));
            resps.add(resp);
        }
        respDto.setShareDetailResps(resps);
        respDto.setTotalShareMemberCount(memberCount);
        respDto.setTotalShareViewCount(viewCount);
        respDto.setTotalAddCount(addCount);
        return respDto;
    }

    @Override
    public void groupAdd(RadarGroupBaseDto dto) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)dto.getName()), (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((dto.getName().length() <= 10 ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc710\u4e2a\u5b57");
        this.insertRadarGroup(user, dto.getName());
    }

    private void insertRadarGroup(CurrentUserInfo user, String groupName) {
        boolean repeatName = this.containGroupName(groupName, user.getCorpId(), null);
        Preconditions.checkArgument((!repeatName ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        MarketingRadarGroup radarGroup = new MarketingRadarGroup();
        radarGroup.setNum(this.idGen.getNum());
        radarGroup.setBizId(user.getBizId());
        radarGroup.setCorpId(user.getCorpId());
        radarGroup.setCreateby(user.getWeworkUserNum());
        radarGroup.setCreateTime(new Date());
        radarGroup.setUpdateTime(new Date());
        radarGroup.setIsDeleted(Integer.valueOf(0));
        radarGroup.setGroupName(groupName);
        radarGroup.setType(Integer.valueOf(0));
        this.marketingRadarGroupMapper.insert((Object)radarGroup);
    }

    @Override
    public void groupMod(RadarGroupBaseDto dto) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)dto.getId()), (Object)"\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)dto.getName()), (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((dto.getName().length() <= 10 ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc710\u4e2a\u5b57");
        boolean repeatName = this.containGroupName(dto.getName(), user.getCorpId(), dto.getId());
        Preconditions.checkArgument((!repeatName ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        MarketingRadarGroup radarGroup = this.marketingRadarGroupMapper.queryGroupByNum(dto.getId(), user.getCorpId());
        if (radarGroup == null) {
            log.info("groupMod\uff1a \u67e5\u8be2\u7684\u5206\u7ec4\u4e0d\u5b58\u5728\uff0c num: {}", (Object)dto.getId());
            return;
        }
        Preconditions.checkArgument((radarGroup.getType() != 1 ? 1 : 0) != 0, (Object)"\u7cfb\u7edf\u5206\u7ec4\u65e0\u6cd5\u4fee\u6539");
        radarGroup.setGroupName(dto.getName());
        radarGroup.setUpdateTime(new Date());
        radarGroup.setUpdateby(user.getWeworkUserNum());
        this.marketingRadarGroupMapper.updateByPrimaryKey((Object)radarGroup);
    }

    private boolean containGroupName(String groupName, String corpId, String groupId) {
        List groupList = this.marketingRadarGroupMapper.queryAllGroup(corpId, null);
        if (CollectionUtils.isEmpty((Collection)groupList)) {
            return false;
        }
        for (MarketingRadarGroup radarGroup : groupList) {
            if (!radarGroup.getGroupName().equals(groupName) || groupId != null && groupId.equals(radarGroup.getNum())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void groupDel(RadarGroupBaseDto dto) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)dto.getId()), (Object)"\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        MarketingRadarGroup radarGroup = this.marketingRadarGroupMapper.queryGroupByNum(dto.getId(), user.getCorpId());
        if (radarGroup == null) {
            log.info("groupMod\uff1a \u67e5\u8be2\u7684\u5206\u7ec4\u4e0d\u5b58\u5728\uff0c num: {}", (Object)dto.getId());
            return;
        }
        List radars = this.marketingRadarMapper.queryCountByGroupNum(dto.getId(), user.getCorpId());
        if (CollectionUtils.isNotEmpty((Collection)radars)) {
            log.info("groupMod\uff1a \u67e5\u8be2\u7684\u5206\u7ec4\u4e0b\u6709\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\uff0c num: {}", (Object)dto.getId());
            Preconditions.checkArgument((radars.size() == 0 ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u4e0b\u6709\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        Preconditions.checkArgument((radarGroup.getType() != 1 ? 1 : 0) != 0, (Object)"\u7cfb\u7edf\u5206\u7ec4\u65e0\u6cd5\u5220\u9664");
        this.marketingRadarGroupMapper.delGroupByNum(dto.getId(), user.getWeworkUserNum(), user.getCorpId());
    }

    @Override
    public List<RadarGroupBaseDto> groupList(RadarGroupListReqDto reqDto) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        List groupList = this.marketingRadarGroupMapper.queryAllGroup(user.getCorpId(), reqDto.getGroupName());
        if (CollectionUtils.isEmpty((Collection)groupList)) {
            return null;
        }
        List groupNums = groupList.stream().map(MarketingRadarGroup::getNum).collect(Collectors.toList());
        Map groupNumMaps = this.marketingRadarMapper.getCountByGroupNum(groupNums, user.getCorpId());
        log.info("groupList groupNumMaps: {}", (Object)groupNumMaps);
        ArrayList list = Lists.newArrayList();
        for (MarketingRadarGroup dto : groupList) {
            Integer count;
            RadarGroupBaseDto resp = new RadarGroupBaseDto();
            resp.setId(dto.getNum());
            resp.setType(dto.getType());
            resp.setName(dto.getGroupName());
            resp.setEnableDel(1);
            if (groupNumMaps != null && (count = (Integer)groupNumMaps.get(dto.getNum())) != null && count > 0) {
                resp.setEnableDel(0);
            }
            if (dto.getType() == 1) {
                resp.setEnableDel(0);
            }
            list.add(resp);
        }
        return list;
    }

    @Override
    public void initGroupNames(Long bizId, String corpId) {
        this.initRadarGroup(bizId, corpId, "\u5168\u90e8\u5206\u7ec4", false);
        this.initRadarGroup(bizId, corpId, "\u9ed8\u8ba4\u5206\u7ec4", true);
    }

    private void initRadarGroup(Long bizId, String corpId, String groupName, boolean isDefault) {
        boolean repeatName = this.containGroupName(groupName, corpId, null);
        Preconditions.checkArgument((!repeatName ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        MarketingRadarGroup radarGroup = new MarketingRadarGroup();
        if (isDefault) {
            radarGroup.setNum(this.idGen.getNum());
        } else {
            radarGroup.setNum("");
        }
        radarGroup.setBizId(bizId);
        radarGroup.setCorpId(corpId);
        radarGroup.setCreateby("");
        radarGroup.setCreateTime(new Date());
        radarGroup.setUpdateTime(new Date());
        radarGroup.setIsDeleted(Integer.valueOf(0));
        radarGroup.setGroupName(groupName);
        radarGroup.setType(Integer.valueOf(1));
        this.marketingRadarGroupMapper.insert((Object)radarGroup);
    }

    private void createRadarWeworkUserQrcode(Long bizId, String corpId, String radarNum, Set<String> weworkUserNums) {
        MarketingRadarQrcode radarQrcode = new MarketingRadarQrcode();
        radarQrcode.setBizId(bizId);
        radarQrcode.setCorpId(corpId);
        radarQrcode.setType(Integer.valueOf(2));
        radarQrcode.setState("RD_" + this.idGen.getNum());
        radarQrcode.setWeworkUserNums(Joiner.on((String)",").join(weworkUserNums));
        radarQrcode.setMarketingRadarNum(radarNum);
        List weworkUserIds = this.weworkUserMapper.queryWeworkUserIdByNums(weworkUserNums);
        String accessToken = this.customizedTokenService.getAgentAccessToken(radarQrcode.getCorpId());
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        ContactWay contactWayConfig = new ContactWay();
        contactWayConfig.setType(Integer.valueOf(2));
        contactWayConfig.setScene(Integer.valueOf(2));
        contactWayConfig.setState(radarQrcode.getState());
        if (CollectionUtils.isEmpty((Collection)weworkUserIds)) {
            return;
        }
        contactWayConfig.setUserIds(weworkUserIds);
        contactWayConfig.setIsTemp(Boolean.valueOf(false));
        try {
            ConfigIdResp configIdResp = this.contactWayApi.create(accessToken, contactWayConfig);
            radarQrcode.setConfigId(configIdResp.getConfigId());
            radarQrcode.setQrcodeUrl(configIdResp.getQrCode());
        }
        catch (Exception e) {
            radarQrcode.setErrorMsg(e.getMessage());
        }
        radarQrcode.setCreateTime(new Date());
        this.marketingRadarQrcodeMapper.insertSelective((Object)radarQrcode);
    }

    private void updateRadarWeworkUserQrcode(MarketingRadarQrcode radarQrcode, Set<String> weworkUserNums) {
        List originWeworkUserNums = Splitter.on((String)",").splitToList((CharSequence)radarQrcode.getWeworkUserNums());
        if (CollectionUtils.isEqualCollection((Collection)originWeworkUserNums, weworkUserNums)) {
            log.info("update radar weworkUser qrcode weworkUserNums not change");
            return;
        }
        radarQrcode.setWeworkUserNums(Joiner.on((String)",").join(weworkUserNums));
        List weworkUserIds = this.weworkUserMapper.queryWeworkUserIdByNums(weworkUserNums);
        ContactWay contactWayConfig = new ContactWay();
        if (CollectionUtils.isEmpty((Collection)weworkUserIds) || StringUtils.isBlank((CharSequence)radarQrcode.getConfigId())) {
            log.warn("update radar qrcode weworkUserIds is null or configId is null");
            return;
        }
        String accessToken = this.customizedTokenService.getAgentAccessToken(radarQrcode.getCorpId());
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)radarQrcode.getCorpId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        contactWayConfig.setUserIds(weworkUserIds);
        contactWayConfig.setConfigId(radarQrcode.getConfigId());
        try {
            this.contactWayApi.update(accessToken, contactWayConfig);
            radarQrcode.setErrorMsg("");
            this.marketingRadarQrcodeMapper.updateByPrimaryKeySelective((Object)radarQrcode);
        }
        catch (Exception e) {
            log.error("update radar qrcode error: {}", (Throwable)e);
        }
    }
}

