/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.radar.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class RadarClientReportDto
implements Serializable {
    private String id;
    private Date visitBeginTime;
    private Date visitEndTime;
    private Long stayTime;
    private Integer finishPercent;
    private Integer pageClose = 0;

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.id), (Object)"\u5206\u4eab\u6d4f\u89c8\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.visitBeginTime == null || this.visitEndTime == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d4f\u89c8\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.visitBeginTime.compareTo(this.visitEndTime) > 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bbf\u95ee\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        if (this.finishPercent == null) {
            this.finishPercent = 0;
        }
        if (this.finishPercent == null || this.finishPercent < 0 || this.finishPercent > 100) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b8c\u6210\u767e\u5206\u6bd4\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u5c11\u4e8e0\u6216\u5927\u4e8e100");
        }
        if (this.pageClose == null) {
            this.pageClose = 0;
        }
    }

    public String getId() {
        return this.id;
    }

    public Date getVisitBeginTime() {
        return this.visitBeginTime;
    }

    public Date getVisitEndTime() {
        return this.visitEndTime;
    }

    public Long getStayTime() {
        return this.stayTime;
    }

    public Integer getFinishPercent() {
        return this.finishPercent;
    }

    public Integer getPageClose() {
        return this.pageClose;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setVisitBeginTime(Date visitBeginTime) {
        this.visitBeginTime = visitBeginTime;
    }

    public void setVisitEndTime(Date visitEndTime) {
        this.visitEndTime = visitEndTime;
    }

    public void setStayTime(Long stayTime) {
        this.stayTime = stayTime;
    }

    public void setFinishPercent(Integer finishPercent) {
        this.finishPercent = finishPercent;
    }

    public void setPageClose(Integer pageClose) {
        this.pageClose = pageClose;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RadarClientReportDto)) {
            return false;
        }
        RadarClientReportDto other = (RadarClientReportDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$stayTime = this.getStayTime();
        Long other$stayTime = other.getStayTime();
        if (this$stayTime == null ? other$stayTime != null : !((Object)this$stayTime).equals(other$stayTime)) {
            return false;
        }
        Integer this$finishPercent = this.getFinishPercent();
        Integer other$finishPercent = other.getFinishPercent();
        if (this$finishPercent == null ? other$finishPercent != null : !((Object)this$finishPercent).equals(other$finishPercent)) {
            return false;
        }
        Integer this$pageClose = this.getPageClose();
        Integer other$pageClose = other.getPageClose();
        if (this$pageClose == null ? other$pageClose != null : !((Object)this$pageClose).equals(other$pageClose)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Date this$visitBeginTime = this.getVisitBeginTime();
        Date other$visitBeginTime = other.getVisitBeginTime();
        if (this$visitBeginTime == null ? other$visitBeginTime != null : !((Object)this$visitBeginTime).equals(other$visitBeginTime)) {
            return false;
        }
        Date this$visitEndTime = this.getVisitEndTime();
        Date other$visitEndTime = other.getVisitEndTime();
        return !(this$visitEndTime == null ? other$visitEndTime != null : !((Object)this$visitEndTime).equals(other$visitEndTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RadarClientReportDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $stayTime = this.getStayTime();
        result = result * 59 + ($stayTime == null ? 43 : ((Object)$stayTime).hashCode());
        Integer $finishPercent = this.getFinishPercent();
        result = result * 59 + ($finishPercent == null ? 43 : ((Object)$finishPercent).hashCode());
        Integer $pageClose = this.getPageClose();
        result = result * 59 + ($pageClose == null ? 43 : ((Object)$pageClose).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Date $visitBeginTime = this.getVisitBeginTime();
        result = result * 59 + ($visitBeginTime == null ? 43 : ((Object)$visitBeginTime).hashCode());
        Date $visitEndTime = this.getVisitEndTime();
        result = result * 59 + ($visitEndTime == null ? 43 : ((Object)$visitEndTime).hashCode());
        return result;
    }

    public String toString() {
        return "RadarClientReportDto(id=" + this.getId() + ", visitBeginTime=" + this.getVisitBeginTime() + ", visitEndTime=" + this.getVisitEndTime() + ", stayTime=" + this.getStayTime() + ", finishPercent=" + this.getFinishPercent() + ", pageClose=" + this.getPageClose() + ")";
    }
}

