/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.radar.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.RadarType;
import com.kuaike.scrm.dal.radar.entity.MarketingRadar;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class MarketingAddRadarReqDto {
    private int type = NumberUtils.INTEGER_ZERO;
    private String groupNum;
    private String title;
    private String fileName;
    private Long fileSize;
    private String url;
    private String source;
    private String content;
    private String linkTitle;
    private String linkDesc;
    private String linkAvatar;
    private int shareType = NumberUtils.INTEGER_ZERO;
    private List<String> shareWeworkUserNums;
    private int isShowCard = NumberUtils.INTEGER_ZERO;
    private int isSendClickMsg = NumberUtils.INTEGER_ZERO;
    private int isClickTag = NumberUtils.INTEGER_ZERO;
    private List<String> clickTagIds;

    public MarketingRadar convertToPO(MarketingRadar target) {
        if (target == null) {
            target = new MarketingRadar();
        }
        target.setType(Integer.valueOf(this.type));
        target.setTitle(this.title);
        target.setUrl(this.url);
        if (this.type == RadarType.LINK.getValue()) {
            target.setLinkTitle(this.linkTitle);
            target.setLinkDesc(this.linkDesc);
            target.setLinkAvatar(this.linkAvatar);
        } else if (this.type == RadarType.FILE_PDF.getValue()) {
            target.setFileName(this.fileName);
            target.setFileSize(this.fileSize);
        } else if (this.type == RadarType.WX_GZH.getValue()) {
            target.setSource(this.source);
        }
        target.setGroupNum(this.groupNum);
        target.setShareType(Integer.valueOf(this.shareType));
        target.setIsShowCard(Integer.valueOf(this.isShowCard));
        target.setIsSendClickMsg(Integer.valueOf(this.isSendClickMsg));
        target.setIsClickTag(Integer.valueOf(this.isClickTag));
        return target;
    }

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.title), (Object)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((RadarType.getType((Integer)this.type) != null ? 1 : 0) != 0, (Object)"\u4e0d\u652f\u6301\u7684\u5185\u5bb9\u7c7b\u578b");
        if (this.isClickTag == NumberUtils.INTEGER_ONE) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.clickTagIds), (Object)"\u8bf7\u9009\u62e9\u6807\u7b7e");
        }
        if (this.shareType == NumberUtils.INTEGER_TWO) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.shareWeworkUserNums), (Object)"\u8bf7\u9009\u62e9\u6210\u5458");
        }
        switch (RadarType.getType((Integer)this.type)) {
            case FILE_PDF: {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.url), (Object)"PDF\u6587\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((this.fileSize != null ? 1 : 0) != 0, (Object)"\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case WX_GZH: {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.url), (Object)"\u516c\u4f17\u53f7\u6587\u7ae0\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.source), (Object)"\u8f6c\u8f7d\u51fa\u5904\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case LINK: {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.url), (Object)"\u94fe\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.linkTitle), (Object)"\u94fe\u63a5\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.linkDesc), (Object)"\u94fe\u63a5\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.linkAvatar), (Object)"\u5361\u7247\u5c01\u9762\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
        }
        if (this.shareType == NumberUtils.INTEGER_TWO) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.shareWeworkUserNums), (Object)"\u8bf7\u9009\u62e9\u6210\u5458");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.url), (Object)"");
    }

    public int getType() {
        return this.type;
    }

    public String getGroupNum() {
        return this.groupNum;
    }

    public String getTitle() {
        return this.title;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSource() {
        return this.source;
    }

    public String getContent() {
        return this.content;
    }

    public String getLinkTitle() {
        return this.linkTitle;
    }

    public String getLinkDesc() {
        return this.linkDesc;
    }

    public String getLinkAvatar() {
        return this.linkAvatar;
    }

    public int getShareType() {
        return this.shareType;
    }

    public List<String> getShareWeworkUserNums() {
        return this.shareWeworkUserNums;
    }

    public int getIsShowCard() {
        return this.isShowCard;
    }

    public int getIsSendClickMsg() {
        return this.isSendClickMsg;
    }

    public int getIsClickTag() {
        return this.isClickTag;
    }

    public List<String> getClickTagIds() {
        return this.clickTagIds;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setGroupNum(String groupNum) {
        this.groupNum = groupNum;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setLinkTitle(String linkTitle) {
        this.linkTitle = linkTitle;
    }

    public void setLinkDesc(String linkDesc) {
        this.linkDesc = linkDesc;
    }

    public void setLinkAvatar(String linkAvatar) {
        this.linkAvatar = linkAvatar;
    }

    public void setShareType(int shareType) {
        this.shareType = shareType;
    }

    public void setShareWeworkUserNums(List<String> shareWeworkUserNums) {
        this.shareWeworkUserNums = shareWeworkUserNums;
    }

    public void setIsShowCard(int isShowCard) {
        this.isShowCard = isShowCard;
    }

    public void setIsSendClickMsg(int isSendClickMsg) {
        this.isSendClickMsg = isSendClickMsg;
    }

    public void setIsClickTag(int isClickTag) {
        this.isClickTag = isClickTag;
    }

    public void setClickTagIds(List<String> clickTagIds) {
        this.clickTagIds = clickTagIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarketingAddRadarReqDto)) {
            return false;
        }
        MarketingAddRadarReqDto other = (MarketingAddRadarReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.getShareType() != other.getShareType()) {
            return false;
        }
        if (this.getIsShowCard() != other.getIsShowCard()) {
            return false;
        }
        if (this.getIsSendClickMsg() != other.getIsSendClickMsg()) {
            return false;
        }
        if (this.getIsClickTag() != other.getIsClickTag()) {
            return false;
        }
        Long this$fileSize = this.getFileSize();
        Long other$fileSize = other.getFileSize();
        if (this$fileSize == null ? other$fileSize != null : !((Object)this$fileSize).equals(other$fileSize)) {
            return false;
        }
        String this$groupNum = this.getGroupNum();
        String other$groupNum = other.getGroupNum();
        if (this$groupNum == null ? other$groupNum != null : !this$groupNum.equals(other$groupNum)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$linkTitle = this.getLinkTitle();
        String other$linkTitle = other.getLinkTitle();
        if (this$linkTitle == null ? other$linkTitle != null : !this$linkTitle.equals(other$linkTitle)) {
            return false;
        }
        String this$linkDesc = this.getLinkDesc();
        String other$linkDesc = other.getLinkDesc();
        if (this$linkDesc == null ? other$linkDesc != null : !this$linkDesc.equals(other$linkDesc)) {
            return false;
        }
        String this$linkAvatar = this.getLinkAvatar();
        String other$linkAvatar = other.getLinkAvatar();
        if (this$linkAvatar == null ? other$linkAvatar != null : !this$linkAvatar.equals(other$linkAvatar)) {
            return false;
        }
        List<String> this$shareWeworkUserNums = this.getShareWeworkUserNums();
        List<String> other$shareWeworkUserNums = other.getShareWeworkUserNums();
        if (this$shareWeworkUserNums == null ? other$shareWeworkUserNums != null : !((Object)this$shareWeworkUserNums).equals(other$shareWeworkUserNums)) {
            return false;
        }
        List<String> this$clickTagIds = this.getClickTagIds();
        List<String> other$clickTagIds = other.getClickTagIds();
        return !(this$clickTagIds == null ? other$clickTagIds != null : !((Object)this$clickTagIds).equals(other$clickTagIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MarketingAddRadarReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getType();
        result = result * 59 + this.getShareType();
        result = result * 59 + this.getIsShowCard();
        result = result * 59 + this.getIsSendClickMsg();
        result = result * 59 + this.getIsClickTag();
        Long $fileSize = this.getFileSize();
        result = result * 59 + ($fileSize == null ? 43 : ((Object)$fileSize).hashCode());
        String $groupNum = this.getGroupNum();
        result = result * 59 + ($groupNum == null ? 43 : $groupNum.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $linkTitle = this.getLinkTitle();
        result = result * 59 + ($linkTitle == null ? 43 : $linkTitle.hashCode());
        String $linkDesc = this.getLinkDesc();
        result = result * 59 + ($linkDesc == null ? 43 : $linkDesc.hashCode());
        String $linkAvatar = this.getLinkAvatar();
        result = result * 59 + ($linkAvatar == null ? 43 : $linkAvatar.hashCode());
        List<String> $shareWeworkUserNums = this.getShareWeworkUserNums();
        result = result * 59 + ($shareWeworkUserNums == null ? 43 : ((Object)$shareWeworkUserNums).hashCode());
        List<String> $clickTagIds = this.getClickTagIds();
        result = result * 59 + ($clickTagIds == null ? 43 : ((Object)$clickTagIds).hashCode());
        return result;
    }

    public String toString() {
        return "MarketingAddRadarReqDto(type=" + this.getType() + ", groupNum=" + this.getGroupNum() + ", title=" + this.getTitle() + ", fileName=" + this.getFileName() + ", fileSize=" + this.getFileSize() + ", url=" + this.getUrl() + ", source=" + this.getSource() + ", content=" + this.getContent() + ", linkTitle=" + this.getLinkTitle() + ", linkDesc=" + this.getLinkDesc() + ", linkAvatar=" + this.getLinkAvatar() + ", shareType=" + this.getShareType() + ", shareWeworkUserNums=" + this.getShareWeworkUserNums() + ", isShowCard=" + this.getIsShowCard() + ", isSendClickMsg=" + this.getIsSendClickMsg() + ", isClickTag=" + this.getIsClickTag() + ", clickTagIds=" + this.getClickTagIds() + ")";
    }
}

