/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.utils;

import java.util.Base64;
import java.util.Date;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketingUtil {
    private static final Logger log = LoggerFactory.getLogger(MarketingUtil.class);
    private static final int N = 2;
    private static final long DELAY = 3600000L;

    private MarketingUtil() {
        throw new UnsupportedOperationException("This class should not be instantiated.");
    }

    public static boolean validToken(String token) {
        if (token == null || token.trim().length() == 0) {
            log.warn("token is empty");
            return false;
        }
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] data = null;
        try {
            data = decoder.decode(token);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("invalid token, decode failed, token={}", (Object)token);
            return false;
        }
        int tail = data.length - 2;
        if (tail < 2) {
            log.warn("data too short, len={}", (Object)data.length);
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            byte tmp = data[i];
            data[i] = data[tail + i];
            data[tail + i] = tmp;
        }
        String val = new String(data);
        long value = 0L;
        try {
            value = Long.parseLong(val);
        }
        catch (Exception e) {
            log.error("Not a number, str={}", (Object)val);
            return false;
        }
        long timestamp = value / 10000L;
        long rand = value % 10000L;
        log.info("decrypted timestamp:{}, rand={}", (Object)timestamp, (Object)rand);
        long delay = System.currentTimeMillis() - timestamp;
        if (Math.abs(delay) > 3600000L) {
            log.warn("Delay too large, delay={}", (Object)delay);
            return false;
        }
        return true;
    }

    public static String getToken() {
        long timestamp = new Date().getTime();
        int rand = new Random().nextInt(10000);
        long value = timestamp * 10000L + (long)rand;
        String valueStr = String.valueOf(value);
        byte[] data = valueStr.getBytes();
        int tail = data.length - 2;
        for (int i = 0; i < 2; ++i) {
            byte tmp = data[i];
            data[i] = data[tail + i];
            data[tail + i] = tmp;
        }
        Base64.Encoder encoder = Base64.getEncoder();
        data = encoder.encode(data);
        return new String(data);
    }

    public static void main(String[] args) {
        System.out.println(MarketingUtil.getToken());
    }
}

