/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.marketing.dto.PlanWeworkUserDto;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlanGroupUser;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanGroupUserMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkUserDto;
import com.kuaike.scrm.marketing.service.MarketingUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MarketingUserServiceImp
implements MarketingUserService {
    private static final Logger log = LoggerFactory.getLogger(MarketingUserServiceImp.class);
    @Resource
    private MarketingPlanGroupUserMapper marketingPlanGroupUserMapper;
    @Autowired
    private IdGen idGen;

    @Override
    @Transactional
    public boolean saveMarketingUser(Long bizId, String corpId, Long userId, Long planId, Long planGroupId, List<String> weworkUserNums) {
        List<MarketingPlanGroupUser> list = this.queryGroupUser(bizId, corpId, planId, planGroupId);
        boolean isUpdateGroupUser = false;
        ArrayList insertList = Lists.newArrayList();
        ArrayList delList = Lists.newArrayList();
        for (MarketingPlanGroupUser planGroupUser : list) {
            String weworkUserId = planGroupUser.getWeworkUserNum();
            if (!weworkUserNums.contains(weworkUserId)) {
                delList.add(weworkUserId);
                continue;
            }
            weworkUserNums.remove(weworkUserId);
        }
        insertList.addAll(weworkUserNums);
        if (!CollectionUtils.isEmpty((Collection)insertList) || !CollectionUtils.isEmpty((Collection)delList)) {
            isUpdateGroupUser = true;
        }
        this.delMarketingUser(bizId, corpId, userId, planId, planGroupId, delList);
        this.insertMarketingUser(bizId, corpId, userId, planId, planGroupId, insertList);
        return isUpdateGroupUser;
    }

    @Override
    public List<MarketingPlanGroupUser> queryGroupUser(Long bizId, String corpId, Long planId, Long planGroupId) {
        return this.marketingPlanGroupUserMapper.queryGroupUser(bizId, corpId, planId, planGroupId);
    }

    @Override
    public void insertMarketingUser(Long bizId, String corpId, Long userId, Long planId, Long planGroupId, List<String> weworkUserNums) {
        if (CollectionUtils.isEmpty(weworkUserNums)) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        for (String weworkUserId : weworkUserNums) {
            MarketingPlanGroupUser marketingPlanGroupUser = new MarketingPlanGroupUser();
            marketingPlanGroupUser.setNum(this.idGen.getNum());
            marketingPlanGroupUser.setBizId(bizId);
            marketingPlanGroupUser.setCorpId(corpId);
            marketingPlanGroupUser.setPlanId(planId);
            marketingPlanGroupUser.setPlanGroupId(planGroupId);
            marketingPlanGroupUser.setWeworkUserNum(weworkUserId);
            marketingPlanGroupUser.setCreateBy(userId);
            marketingPlanGroupUser.setCreateTime(new Date());
            marketingPlanGroupUser.setUpdateBy(userId);
            marketingPlanGroupUser.setUpdateTime(new Date());
            marketingPlanGroupUser.setIsDeleted(Integer.valueOf(0));
            list.add(marketingPlanGroupUser);
        }
        this.marketingPlanGroupUserMapper.batchInsert((Collection)list);
    }

    @Override
    public void delMarketingUser(Long bizId, String corpId, Long userId, Long planId, Long planGroupId, List<String> weworkUserNums) {
        if (!CollectionUtils.isEmpty(weworkUserNums)) {
            this.marketingPlanGroupUserMapper.batchDel(bizId, corpId, planId, planGroupId, userId, weworkUserNums);
        }
    }

    @Override
    public void delMarketingUserByPlanGroup(Long bizId, String corpId, Long userId, Long planId, List<Long> planGroupIds) {
        if (!CollectionUtils.isEmpty(planGroupIds)) {
            this.marketingPlanGroupUserMapper.delByPlanGroupId(bizId, corpId, planId, planGroupIds, userId);
        }
    }

    @Override
    public Map<Long, List<WeworkUserDto>> getPlanOfWeworkUser(String corpId, List<Long> planIds) {
        List list = this.marketingPlanGroupUserMapper.queryPlanOfWeworkUser(corpId, planIds);
        HashMap<Long, List<WeworkUserDto>> result = new HashMap<Long, List<WeworkUserDto>>();
        for (PlanWeworkUserDto planWeworkUserDto : list) {
            Long planId = planWeworkUserDto.getPlanId();
            WeworkUserDto weworkUserDto = new WeworkUserDto();
            weworkUserDto.setId(planWeworkUserDto.getWeworkUserNum());
            weworkUserDto.setNickname(planWeworkUserDto.getNickname());
            weworkUserDto.setAvatar(planWeworkUserDto.getAvatar());
            if (result.containsKey(planId)) {
                ((List)result.get(planId)).add(weworkUserDto);
                continue;
            }
            ArrayList values = Lists.newArrayList();
            values.add(weworkUserDto);
            result.put(planId, values);
        }
        return result;
    }

    @Override
    public List<WeworkUserDto> getPlanGroupUserInfo(Long planId, Long planGroupId) {
        List list = this.marketingPlanGroupUserMapper.queryPlanGroupUserInfo(planId, planGroupId);
        ArrayList result = Lists.newArrayList();
        for (PlanWeworkUserDto planWeworkUserDto : list) {
            WeworkUserDto weworkUserDto = new WeworkUserDto();
            weworkUserDto.setId(planWeworkUserDto.getWeworkUserNum());
            weworkUserDto.setAvatar(planWeworkUserDto.getAvatar());
            weworkUserDto.setNickname(planWeworkUserDto.getNickname());
            result.add(weworkUserDto);
        }
        return result;
    }
}

