/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import cn.kinyun.wework.sdk.api.external.ContactWayApi;
import cn.kinyun.wework.sdk.entity.external.contactway.ConfigIdResp;
import cn.kinyun.wework.sdk.entity.external.contactway.ContactWay;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.marketing.dto.PlanGroupQrcodeDto;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.MarketingQrcode;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanGroupMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanGroupUserMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingQrcodeMapper;
import com.kuaike.scrm.dal.region.mapper.RegionPlanQrcodeUserMapper;
import com.kuaike.scrm.marketing.dto.ConfigQrcodeError;
import com.kuaike.scrm.marketing.dto.client.ClientParamsDto;
import com.kuaike.scrm.marketing.dto.client.MarketingGroupInfoDto;
import com.kuaike.scrm.marketing.service.MarketingQrcodeService;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MarketingQrcodeServiceImp
implements MarketingQrcodeService {
    private static final Logger log = LoggerFactory.getLogger(MarketingQrcodeServiceImp.class);
    @Value(value="${kafka.topic.task_config_contact_way}")
    private String configContactWayTaskTopic;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Resource
    private MarketingQrcodeMapper marketingQrcodeMapper;
    @Resource
    private MarketingPlanMapper marketingPlanMapper;
    @Resource
    private RegionPlanQrcodeUserMapper regionPlanQrcodeUserMapper;
    @Resource
    private MarketingPlanGroupMapper marketingPlanGroupMapper;
    @Resource
    private MarketingChannelMapper marketingChannelMapper;
    @Resource
    private MarketingPlanGroupUserMapper marketingPlanGroupUserMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private ContactWayApi contactWayApi;
    @Autowired
    private CustomizedTokenService customizedTokenService;

    @Override
    public List<MarketingGroupInfoDto> queryPlanGroupInfo(Long planId, Long channelId) {
        List list = this.marketingQrcodeMapper.getPlanGroupQrcodeInfo(planId, channelId);
        ArrayList result = Lists.newArrayList();
        for (PlanGroupQrcodeDto groupQrcodeDto : list) {
            MarketingGroupInfoDto groupInfoDto = new MarketingGroupInfoDto();
            groupInfoDto.setId(groupQrcodeDto.getState());
            groupInfoDto.setName(groupQrcodeDto.getName());
            result.add(groupInfoDto);
        }
        return result;
    }

    @Override
    public String getQrcode(ClientParamsDto params) {
        String num = params.getId();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)num), (Object)"\u6d3b\u52a8\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        MarketingQrcode marketingQrcode = new MarketingQrcode();
        marketingQrcode.setState(num);
        marketingQrcode = (MarketingQrcode)this.marketingQrcodeMapper.selectOne((Object)marketingQrcode);
        if (marketingQrcode == null || marketingQrcode.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6e20\u9053\u6d3b\u7801\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u88ab\u5220\u9664");
        }
        return marketingQrcode.getQrCodeUrl();
    }

    @Override
    public void saveMarketingQrcode(Long bizId, String corpId, Long userId, Long planId, Set<Long> planGroupIds) {
        List groups = this.marketingPlanGroupMapper.getPlanGroupIdsByPlanId(planId);
        List marketingChannels = this.marketingChannelMapper.queryPlanOfChannel(corpId, planId);
        Map<String, Long> qrcodeMap = this.getMarketingQrCodeMap(planId);
        ArrayList adds = Lists.newArrayList();
        Collection<Long> dels = null;
        for (MarketingChannel channel : marketingChannels) {
            for (Long groupId : groups) {
                String key = channel.getChannelId() + "-" + groupId;
                if (!qrcodeMap.containsKey(key)) {
                    MarketingQrcode marketingQrcode = this.buildMarketingQrcode(bizId, corpId, planId, channel.getChannelId(), groupId, userId);
                    adds.add(marketingQrcode);
                    continue;
                }
                qrcodeMap.remove(key);
            }
        }
        dels = qrcodeMap.values();
        if (CollectionUtils.isNotEmpty(planGroupIds)) {
            this.marketingQrcodeMapper.updateMarktingQrcodeByGroup(userId, planId, planGroupIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)adds)) {
            Lists.partition((List)adds, (int)100).forEach(list -> this.marketingQrcodeMapper.batchInsert((Collection)list));
        }
        if (CollectionUtils.isNotEmpty(dels)) {
            this.marketingQrcodeMapper.delMarketingQrcodeByIds(userId, dels);
        }
    }

    @Override
    public void saveMarketingQrcode(Long bizId, String corpId, Long userId, Long planId, Boolean weworkUserChange) {
        List marketingChannels = this.marketingChannelMapper.queryPlanOfChannel(corpId, planId);
        List marketingQrcodes = this.marketingQrcodeMapper.getPlanGroupQrcodeByPlanId(planId);
        HashMap qrcodeMap = Maps.newHashMap();
        for (MarketingQrcode marketingQrcode : marketingQrcodes) {
            qrcodeMap.put(marketingQrcode.getChannelId(), marketingQrcode.getId());
        }
        ArrayList adds = Lists.newArrayList();
        for (MarketingChannel channel : marketingChannels) {
            Long channelId = channel.getChannelId();
            if (qrcodeMap.containsKey(channelId)) continue;
            adds.add(this.buildMarketingQrcode(bizId, corpId, planId, channelId, -1L, userId));
        }
        if (CollectionUtils.isNotEmpty((Collection)adds)) {
            Lists.partition((List)adds, (int)100).forEach(list -> this.marketingQrcodeMapper.batchInsert((Collection)list));
        }
        if (weworkUserChange.booleanValue() && CollectionUtils.isNotEmpty((Collection)marketingQrcodes)) {
            this.marketingQrcodeMapper.updateMarktingQrcodeByGroup(userId, planId, (Collection)Lists.newArrayList((Object[])new Long[]{-1L}));
        }
    }

    private MarketingQrcode buildMarketingQrcode(Long bizId, String corpId, Long planId, Long channelId, Long planGroupId, Long userId) {
        MarketingQrcode marketingQrcode = new MarketingQrcode();
        marketingQrcode.setBizId(bizId);
        marketingQrcode.setCorpId(corpId);
        marketingQrcode.setPlanId(planId);
        marketingQrcode.setState(this.idGen.getNum());
        marketingQrcode.setChannelId(channelId);
        marketingQrcode.setPlanGroupId(planGroupId);
        marketingQrcode.setQrCodeUrl("");
        marketingQrcode.setQrConfigId("");
        marketingQrcode.setIsDeleted(Integer.valueOf(0));
        marketingQrcode.setIsSync(Integer.valueOf(0));
        marketingQrcode.setCreateBy(userId);
        marketingQrcode.setCreateTime(new Date());
        marketingQrcode.setUpdateBy(userId);
        marketingQrcode.setUpdateTime(new Date());
        return marketingQrcode;
    }

    private Map<String, Long> getMarketingQrCodeMap(Long planId) {
        List marketingQrcodes = this.marketingQrcodeMapper.getPlanGroupQrcodeByPlanId(planId);
        HashMap qrcodeMap = Maps.newHashMap();
        for (MarketingQrcode marketingQrcode : marketingQrcodes) {
            String key = marketingQrcode.getChannelId() + "-" + marketingQrcode.getPlanGroupId();
            qrcodeMap.put(key, marketingQrcode.getId());
        }
        return qrcodeMap;
    }

    @Override
    public void delMarketingQrcodeByGroup(Long userId, Long planId, Set<Long> planGroupIds) {
        if (CollectionUtils.isNotEmpty(planGroupIds)) {
            this.marketingQrcodeMapper.delMarketingQrcodeByGroup(userId, planId, planGroupIds);
        }
    }

    @Override
    public void delMarketingQrcodeByChannel(Long userId, Long planId, Set<Long> channelIds) {
        if (CollectionUtils.isNotEmpty(channelIds)) {
            this.marketingQrcodeMapper.delMarketingQrcodeByChannel(userId, planId, channelIds);
        }
    }

    @Override
    public void delMarketingQrcodeByPlan(Long userId, Long planId) {
        this.marketingQrcodeMapper.delMarketingQrcodeByPlan(userId, planId);
    }

    @Override
    @Transactional
    public void configQrcode(MarketingQrcode marketingQrcode) {
        Long planId = marketingQrcode.getPlanId();
        MarketingPlan marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)planId);
        if (marketingPlan.getType().intValue() == PlanType.CHANNEL_PLAN.getValue() || marketingPlan.getType().intValue() == PlanType.FRIEND_FISSION_PLAN.getValue()) {
            this.handConfigChannelPlan(marketingQrcode);
        } else if (marketingPlan.getType().intValue() == PlanType.REGION_PLAN.getValue()) {
            this.handConfigRegionPlan(marketingQrcode);
        }
    }

    private void handConfigChannelPlan(MarketingQrcode marketingQrcode) {
        if (marketingQrcode.getIsDeleted() == 1) {
            this.delQrcode(marketingQrcode);
        } else if (StringUtils.isNotBlank((CharSequence)marketingQrcode.getQrConfigId())) {
            this.updateQrcode(marketingQrcode);
        } else {
            this.addQrcode(marketingQrcode);
        }
    }

    private void handConfigRegionPlan(MarketingQrcode marketingQrcode) {
        if (marketingQrcode.getIsDeleted() == 1) {
            this.delQrcode(marketingQrcode);
        } else if (StringUtils.isNotBlank((CharSequence)marketingQrcode.getQrConfigId())) {
            this.updateRegionQrcode(marketingQrcode);
        } else {
            this.addRegionQrcode(marketingQrcode);
        }
    }

    @Override
    public MarketingQrcode getMarketingQrcode(Long bizId, String corpId, String state) {
        return this.marketingQrcodeMapper.queryMarketingQrcodeByState(bizId, corpId, state);
    }

    @Override
    public void sendNotSyncQrCodeToKafka(Long planId) {
        List ids = this.marketingQrcodeMapper.queryMarketingQrcodeIdByPlan(planId);
        for (Long id : ids) {
            this.kafkaTemplate.send(this.configContactWayTaskTopic, (Object)(id + ""), (Object)(id + ""));
        }
    }

    @Override
    public void resetMarketQrcodeByPlan(Long bizId, String corpId, Long userId, Long planId) {
        this.saveMarketingQrcode(bizId, corpId, userId, planId, Sets.newHashSet());
    }

    @Override
    public List<ConfigQrcodeError> getConfigQrcodeErrors(Long planId) {
        Map planGroupNameMap = this.marketingPlanGroupMapper.getPlanGroupNameMap(planId);
        List list = this.marketingQrcodeMapper.queryConfigQrcodeNotSync(planId);
        HashMap map = Maps.newHashMap();
        for (MarketingQrcode marketingQrcode : list) {
            String errorMsg;
            if (StringUtils.isEmpty((CharSequence)marketingQrcode.getSyncErrorMsg()) || (errorMsg = marketingQrcode.getSyncErrorMsg()).indexOf(":") < 0) continue;
            String[] errorArr = errorMsg.split(":");
            String errorCode = errorArr[0];
            if (map.containsKey(marketingQrcode.getPlanGroupId())) continue;
            ConfigQrcodeError qrcodeError = new ConfigQrcodeError();
            qrcodeError.setGroupName((String)planGroupNameMap.get(marketingQrcode.getPlanGroupId()));
            qrcodeError.setErrorMsg(this.getConfigErrorMsg(errorCode, errorArr[1]));
            map.put(marketingQrcode.getPlanGroupId(), qrcodeError);
        }
        return map.values().stream().collect(Collectors.toList());
    }

    @Override
    public Map<String, MarketingQrcode> getPlanOfQrcode(String corpId, Long planId) {
        List list = this.marketingQrcodeMapper.getPlanGroupQrcodeByPlanIdAll(planId);
        HashMap result = Maps.newHashMap();
        for (MarketingQrcode marketingQrcode : list) {
            String key = MessageFormat.format("channelId:{0}-regionInfoId:{1}", marketingQrcode.getChannelId(), marketingQrcode.getRegionInfoId());
            result.put(key, marketingQrcode);
        }
        return result;
    }

    @Override
    public MarketingQrcode buildRegionQrcode(Long bizId, String corpId, Long planId, Long planGroupId, Long channelId, Long regionInfoId, Long userId) {
        Date curDate = new Date();
        MarketingQrcode marketingQrcode = new MarketingQrcode();
        marketingQrcode.setBizId(bizId);
        marketingQrcode.setCorpId(corpId);
        marketingQrcode.setPlanId(planId);
        marketingQrcode.setState(this.idGen.getNum());
        marketingQrcode.setChannelId(channelId);
        marketingQrcode.setPlanGroupId(planGroupId);
        marketingQrcode.setQrCodeUrl("");
        marketingQrcode.setQrConfigId("");
        marketingQrcode.setIsDeleted(Integer.valueOf(0));
        marketingQrcode.setIsSync(Integer.valueOf(0));
        marketingQrcode.setCreateBy(userId);
        marketingQrcode.setCreateTime(curDate);
        marketingQrcode.setUpdateBy(userId);
        marketingQrcode.setUpdateTime(curDate);
        marketingQrcode.setRegionInfoId(regionInfoId);
        return marketingQrcode;
    }

    private String getConfigErrorMsg(String errorCode, String errorMsg) {
        String result = errorMsg;
        if (errorCode.equals("error(40098)")) {
            result = "\u5b58\u5728\u6210\u5458\u6ca1\u5b9e\u540d";
        } else if (errorCode.equals("error(41054)")) {
            result = "\u5b58\u5728\u6210\u5458\u6ca1\u6fc0\u6d3b";
        }
        return result;
    }

    private void delQrcode(MarketingQrcode marketingQrcode) {
        log.info("delQrcode params: {}", (Object)marketingQrcode);
        if (StringUtils.isNotBlank((CharSequence)marketingQrcode.getQrConfigId())) {
            String accessToken = this.getAccessToken(marketingQrcode.getCorpId());
            this.contactWayApi.delete(accessToken, marketingQrcode.getQrConfigId());
        }
        marketingQrcode.setIsDeleted(Integer.valueOf(1));
        marketingQrcode.setIsSync(Integer.valueOf(1));
        marketingQrcode.setUpdateTime(new Date());
        marketingQrcode.setQrCodeUrl("");
        marketingQrcode.setQrConfigId("");
        this.marketingQrcodeMapper.updateByPrimaryKeySelective((Object)marketingQrcode);
    }

    private void addQrcode(MarketingQrcode marketingQrcode) {
        log.info("addQrcode params: {}", (Object)marketingQrcode);
        String accessToken = this.getAccessToken(marketingQrcode.getCorpId());
        ContactWay contactWayConfig = new ContactWay();
        contactWayConfig.setType(Integer.valueOf(2));
        contactWayConfig.setScene(Integer.valueOf(2));
        contactWayConfig.setState(marketingQrcode.getState());
        List weworkUserIds = this.marketingPlanGroupUserMapper.queryGroupUserIds(marketingQrcode.getPlanId(), marketingQrcode.getPlanGroupId());
        if (CollectionUtils.isEmpty((Collection)weworkUserIds)) {
            return;
        }
        contactWayConfig.setUserIds(weworkUserIds);
        contactWayConfig.setIsTemp(Boolean.valueOf(false));
        ConfigIdResp configIdResp = this.contactWayApi.create(accessToken, contactWayConfig);
        marketingQrcode.setIsSync(Integer.valueOf(1));
        marketingQrcode.setUpdateTime(new Date());
        marketingQrcode.setQrCodeUrl(configIdResp.getQrCode());
        marketingQrcode.setQrConfigId(configIdResp.getConfigId());
        this.marketingQrcodeMapper.updateByPrimaryKeySelective((Object)marketingQrcode);
    }

    private void updateQrcode(MarketingQrcode marketingQrcode) {
        log.info("updateQrcode params: {}", (Object)marketingQrcode);
        if (StringUtils.isBlank((CharSequence)marketingQrcode.getQrConfigId())) {
            log.warn("updateQrcode qrconfigid is null");
            return;
        }
        ContactWay contactWayConfig = new ContactWay();
        List weworkUserIds = this.marketingPlanGroupUserMapper.queryGroupUserIds(marketingQrcode.getPlanId(), marketingQrcode.getPlanGroupId());
        if (CollectionUtils.isEmpty((Collection)weworkUserIds)) {
            log.warn("updateQrcode weworkUserIds is null");
            return;
        }
        String accessToken = this.getAccessToken(marketingQrcode.getCorpId());
        contactWayConfig.setUserIds(weworkUserIds);
        contactWayConfig.setConfigId(marketingQrcode.getQrConfigId());
        this.contactWayApi.update(accessToken, contactWayConfig);
        marketingQrcode.setIsSync(Integer.valueOf(1));
        marketingQrcode.setUpdateTime(new Date());
        marketingQrcode.setSyncErrorMsg("");
        this.marketingQrcodeMapper.updateByPrimaryKeySelective((Object)marketingQrcode);
    }

    private void updateRegionQrcode(MarketingQrcode marketingQrcode) {
        Long qrcodeId;
        Long planId;
        log.info("update region qrcode params: {}", (Object)marketingQrcode);
        if (StringUtils.isBlank((CharSequence)marketingQrcode.getQrConfigId())) {
            log.warn("update region qrcode configId is null");
            return;
        }
        String corpId = marketingQrcode.getCorpId();
        Map userMap = this.regionPlanQrcodeUserMapper.queryPlanCurQrcodeUserMap(corpId, planId = marketingQrcode.getPlanId(), qrcodeId = marketingQrcode.getId());
        List weworkUserIds = userMap.keySet().stream().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(weworkUserIds)) {
            log.warn("update region qrcode weworkUserIds is null");
            return;
        }
        Integer autoPass = (Integer)userMap.get(weworkUserIds.get(0));
        ContactWay contactWayConfig = new ContactWay();
        String accessToken = this.getAccessToken(marketingQrcode.getCorpId());
        contactWayConfig.setUserIds(weworkUserIds);
        contactWayConfig.setConfigId(marketingQrcode.getQrConfigId());
        if (autoPass == 1) {
            contactWayConfig.setSkipVerify(true);
        } else {
            contactWayConfig.setSkipVerify(false);
        }
        this.contactWayApi.update(accessToken, contactWayConfig);
        marketingQrcode.setIsSync(Integer.valueOf(1));
        marketingQrcode.setUpdateTime(new Date());
        marketingQrcode.setSyncErrorMsg("");
        this.marketingQrcodeMapper.updateByPrimaryKeySelective((Object)marketingQrcode);
    }

    private void addRegionQrcode(MarketingQrcode marketingQrcode) {
        log.info("addRegionQrcode params: {}", (Object)marketingQrcode);
        String accessToken = this.getAccessToken(marketingQrcode.getCorpId());
        ContactWay contactWayConfig = new ContactWay();
        contactWayConfig.setType(Integer.valueOf(2));
        contactWayConfig.setScene(Integer.valueOf(2));
        contactWayConfig.setState(marketingQrcode.getState());
        Map userMap = this.regionPlanQrcodeUserMapper.queryPlanCurQrcodeUserMap(marketingQrcode.getCorpId(), marketingQrcode.getPlanId(), marketingQrcode.getId());
        List weworkUserIds = userMap.keySet().stream().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(weworkUserIds)) {
            return;
        }
        Integer autoPass = (Integer)userMap.get(weworkUserIds.get(0));
        contactWayConfig.setUserIds(weworkUserIds);
        contactWayConfig.setIsTemp(Boolean.valueOf(false));
        if (autoPass == 1) {
            contactWayConfig.setSkipVerify(true);
        } else {
            contactWayConfig.setSkipVerify(false);
        }
        ConfigIdResp configIdResp = this.contactWayApi.create(accessToken, contactWayConfig);
        marketingQrcode.setIsSync(Integer.valueOf(1));
        marketingQrcode.setUpdateTime(new Date());
        marketingQrcode.setQrCodeUrl(configIdResp.getQrCode());
        marketingQrcode.setQrConfigId(configIdResp.getConfigId());
        this.marketingQrcodeMapper.updateByPrimaryKeySelective((Object)marketingQrcode);
    }

    private String getAccessToken(String corpId) {
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        return accessToken;
    }
}

