/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.dto.ChannelDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.IsDraft;
import com.kuaike.scrm.common.enums.MarketingConfigType;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.marketing.dto.MarketingPlanListItenDto;
import com.kuaike.scrm.dal.marketing.dto.QueryPlanListParams;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.entity.MarketingConfig;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlanCriteria;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlanDraft;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanDraftMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkUserDto;
import com.kuaike.scrm.marketing.dto.ConfigQrcodeError;
import com.kuaike.scrm.marketing.dto.FriendWelcomeDto;
import com.kuaike.scrm.marketing.dto.MarketingListItemDto;
import com.kuaike.scrm.marketing.dto.MarketingListParams;
import com.kuaike.scrm.marketing.dto.MarketingPlanDetailDto;
import com.kuaike.scrm.marketing.dto.MarketingPlanDto;
import com.kuaike.scrm.marketing.dto.MarketingPlanGroupDetailDto;
import com.kuaike.scrm.marketing.dto.MarketingPlanGroupDto;
import com.kuaike.scrm.marketing.dto.MarketingPlanSwitchParams;
import com.kuaike.scrm.marketing.dto.PlanDto;
import com.kuaike.scrm.marketing.dto.client.ClientParamsDto;
import com.kuaike.scrm.marketing.dto.client.MarketingInfoDto;
import com.kuaike.scrm.marketing.service.MarketingChannelService;
import com.kuaike.scrm.marketing.service.MarketingConfigService;
import com.kuaike.scrm.marketing.service.MarketingPlanGroupService;
import com.kuaike.scrm.marketing.service.MarketingPlanService;
import com.kuaike.scrm.marketing.service.MarketingPlanStatisticService;
import com.kuaike.scrm.marketing.service.MarketingQrcodeService;
import com.kuaike.scrm.marketing.service.MarketingUserService;
import com.kuaike.scrm.system.service.ChannelService;
import com.kuaike.scrm.system.service.UserService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class MarketingPlanServiceImp
implements MarketingPlanService {
    private static final Logger log = LoggerFactory.getLogger(MarketingPlanServiceImp.class);
    @Resource
    private MarketingPlanMapper marketingPlanMapper;
    @Resource
    private MarketingPlanDraftMapper marketingPlanDraftMapper;
    @Autowired
    private MarketingPlanGroupService marketingPlanGroupService;
    @Autowired
    private MarketingChannelService marketingChannelService;
    @Autowired
    private MarketingUserService marketingUserService;
    @Autowired
    private MarketingConfigService marketingConfigService;
    @Autowired
    private MarketingPlanStatisticService marketingPlanStatisticService;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private MarketingQrcodeService marketingQrcodeService;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private UserService userService;
    @Autowired
    private IdGen idGen;

    @Override
    @Transactional
    public String addMarketingPlan(MarketingPlanDto marketingPlanDto) {
        log.info("addMarketingPlan params: {}", (Object)marketingPlanDto);
        if (marketingPlanDto == null) {
            return null;
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        marketingPlanDto.checkParams();
        if (this.isRepeatMarketingPlanName(corpId, marketingPlanDto.getName(), null, PlanType.CHANNEL_PLAN)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u540d\u5df2\u88ab\u4f7f\u7528");
        }
        Long planId = this.insertMarketingPlan(marketingPlanDto);
        this.marketingPlanGroupService.addMarketingPlanGroup(bizId, corpId, userId, planId, marketingPlanDto.getGroups());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.AUTO_REMARK.getValue(), marketingPlanDto.getAddFriendRemark());
        String configJson = JacksonUtil.obj2Str((Object)marketingPlanDto.getAddFriendWelcome());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.FRIEND_WELCOME.getValue(), configJson);
        List channelIdList = this.channelService.getChannelIdByNum(marketingPlanDto.getChannelIds());
        if (CollectionUtils.isEmpty((Collection)channelIdList)) {
            channelIdList.add(-1L);
        }
        this.marketingChannelService.saveMarketingChannels(bizId, corpId, userId, planId, channelIdList, marketingPlanDto.getStatisticType(), PlanType.CHANNEL_PLAN);
        this.marketingQrcodeService.saveMarketingQrcode(bizId, corpId, userId, planId, Sets.newHashSet());
        this.marketingQrcodeService.sendNotSyncQrCodeToKafka(planId);
        return marketingPlanDto.getId();
    }

    @Override
    @Transactional
    public String editMarketingPlan(MarketingPlanDto marketingPlanDto) {
        if (StringUtils.isEmpty((Object)marketingPlanDto.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        marketingPlanDto.checkParams();
        this.updateMarketingPlan(marketingPlanDto);
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(marketingPlanDto.getId());
        marketingPlan.setBizId(bizId);
        marketingPlan.setCorpId(corpId);
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null || marketingPlan.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u53c2\u6570\u4e0d\u5bf9");
        }
        Long planId = marketingPlan.getId();
        if (this.isRepeatMarketingPlanName(corpId, marketingPlanDto.getName(), planId, PlanType.CHANNEL_PLAN)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u540d\u5df2\u88ab\u4f7f\u7528");
        }
        ArrayList addGroups = Lists.newArrayList();
        ArrayList updateGroups = Lists.newArrayList();
        ArrayList delGroups = Lists.newArrayList();
        for (MarketingPlanGroupDto groupDto2 : marketingPlanDto.getGroups()) {
            if (StringUtils.isEmpty((Object)groupDto2.getId())) {
                addGroups.add(groupDto2);
                continue;
            }
            if (groupDto2.getIsDeleted() != null && groupDto2.getIsDeleted() == 1) {
                delGroups.add(groupDto2);
                continue;
            }
            updateGroups.add(groupDto2);
        }
        this.marketingPlanGroupService.addMarketingPlanGroup(bizId, corpId, userId, planId, addGroups);
        this.marketingPlanGroupService.updateMarketingPlanGroup(bizId, corpId, userId, planId, updateGroups);
        List<String> delNums = delGroups.stream().map(item -> item.getId()).collect(Collectors.toList());
        List<Long> planGroupIds = this.marketingPlanGroupService.getPlanGroupIdsByNum(delNums);
        this.marketingPlanGroupService.delMarketingPlanGorup(bizId, corpId, userId, planId, planGroupIds);
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.AUTO_REMARK.getValue(), marketingPlanDto.getAddFriendRemark());
        String configJson = JacksonUtil.obj2Str((Object)marketingPlanDto.getAddFriendWelcome());
        this.marketingConfigService.save(bizId, corpId, userId, planId, (Integer)MarketingConfigType.FRIEND_WELCOME.getValue(), configJson);
        List channelIdList = this.channelService.getChannelIdByNum(marketingPlanDto.getChannelIds());
        if (CollectionUtils.isEmpty((Collection)channelIdList)) {
            channelIdList.add(-1L);
        }
        this.marketingChannelService.saveMarketingChannels(bizId, corpId, userId, planId, channelIdList, marketingPlanDto.getStatisticType(), PlanType.CHANNEL_PLAN);
        Set<Long> updateGroupIds = updateGroups.stream().filter(groupDto -> groupDto.getGroupId() != null).map(item -> item.getGroupId()).collect(Collectors.toSet());
        this.marketingQrcodeService.saveMarketingQrcode(bizId, corpId, userId, planId, updateGroupIds);
        if (marketingPlan.getIsEnabled() == 1) {
            this.marketingQrcodeService.sendNotSyncQrCodeToKafka(planId);
        }
        return marketingPlanDto.getId();
    }

    @Override
    @Transactional
    public void delMarketingPlan(BaseDto params) {
        if (StringUtils.isEmpty((Object)params.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(params.getId());
        marketingPlan.setBizId(bizId);
        marketingPlan.setCorpId(corpId);
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u53c2\u6570\u4e0d\u5bf9");
        }
        marketingPlan.setIsDeleted(Integer.valueOf(1));
        marketingPlan.setUpdateBy(userId);
        marketingPlan.setUpdateTime(new Date());
        this.marketingPlanMapper.updateByPrimaryKeySelective((Object)marketingPlan);
        Long planId = marketingPlan.getId();
        if (marketingPlan.getIsDraft().intValue() == IsDraft.IS_DRAFT.getValue()) {
            this.marketingPlanDraftMapper.delDraft(planId, userId);
            return;
        }
        List<Long> delGroupIds = this.marketingPlanGroupService.getGroupIdsByPlanId(planId);
        this.marketingPlanGroupService.delMarketingPlanGorup(bizId, corpId, userId, planId, delGroupIds);
        this.marketingConfigService.delMarketingConfig(planId, userId);
        this.marketingChannelService.delMarketingChannelOfPlan(bizId, corpId, userId, planId);
        this.marketingQrcodeService.delMarketingQrcodeByPlan(userId, planId);
        this.marketingQrcodeService.sendNotSyncQrCodeToKafka(planId);
    }

    @Override
    @Transactional
    public String draftMarketing(String draft) {
        String planNum = null;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        JSONObject draftJson = JSONObject.parseObject((String)draft);
        String id = draftJson.getString("id");
        String name = draftJson.getString("name");
        if (StringUtils.isEmpty((Object)id)) {
            MarketingPlan marketingPlan = new MarketingPlan();
            marketingPlan.setNum(this.idGen.getNum());
            marketingPlan.setBizId(bizId);
            marketingPlan.setCorpId(corpId);
            String planName = name;
            if (StringUtils.isEmpty((Object)planName)) {
                planName = "";
            }
            marketingPlan.setName(planName);
            marketingPlan.setType(Integer.valueOf(1));
            marketingPlan.setInitNumbers(Integer.valueOf(0));
            marketingPlan.setStatsType(Integer.valueOf(1));
            marketingPlan.setTemplateType(Integer.valueOf(1));
            marketingPlan.setIsDraft(Integer.valueOf(1));
            marketingPlan.setIsDeleted(Integer.valueOf(0));
            marketingPlan.setIsEnabled(Integer.valueOf(1));
            marketingPlan.setCreateBy(userId);
            marketingPlan.setCreateTime(new Date());
            marketingPlan.setUpdateBy(userId);
            marketingPlan.setUpdateTime(new Date());
            this.marketingPlanMapper.insertSelective((Object)marketingPlan);
            planNum = marketingPlan.getNum();
            draftJson.put("id", (Object)planNum);
            MarketingPlanDraft marketingPlanDraft = new MarketingPlanDraft();
            marketingPlanDraft.setBizId(bizId);
            marketingPlanDraft.setCorpId(corpId);
            marketingPlanDraft.setNum(this.idGen.getNum());
            marketingPlanDraft.setPlanId(marketingPlan.getId());
            marketingPlanDraft.setParamsJson(draftJson.toJSONString());
            marketingPlanDraft.setCreateBy(userId);
            marketingPlanDraft.setCreateTime(new Date());
            marketingPlanDraft.setUpdateBy(userId);
            marketingPlanDraft.setUpdateTime(new Date());
            marketingPlanDraft.setIsDeleted(Integer.valueOf(0));
            this.marketingPlanDraftMapper.insertSelective((Object)marketingPlanDraft);
        } else {
            planNum = id;
            MarketingPlan marketingPlan = new MarketingPlan();
            marketingPlan.setNum(planNum);
            marketingPlan.setBizId(bizId);
            marketingPlan.setCorpId(corpId);
            marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
            if (marketingPlan == null) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u53c2\u6570\u4e0d\u5bf9");
            }
            if (!StringUtils.isEmpty((Object)name)) {
                marketingPlan.setName(name);
            }
            this.marketingPlanMapper.updateByPrimaryKeySelective((Object)marketingPlan);
            this.marketingPlanDraftMapper.updateMarketingDraft(userId, marketingPlan.getId(), draft);
        }
        return planNum;
    }

    @Override
    @Transactional
    public void enable(MarketingPlanSwitchParams params) {
        log.info("openOrClose params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(params.getId());
        marketingPlan.setCorpId(corpId);
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null || marketingPlan.getIsDeleted() == 1 || marketingPlan.getIsDraft() == 1 || marketingPlan.getIsEnabled() == params.getIsEnabled()) {
            return;
        }
        params.checkParams();
        this.marketingPlanMapper.marketingIsEnableControl(bizId, corpId, userId, params.getId(), params.getIsEnabled());
        if (params.getIsEnabled() == 0) {
            this.marketingQrcodeService.delMarketingQrcodeByPlan(userId, marketingPlan.getId());
        } else {
            this.marketingQrcodeService.resetMarketQrcodeByPlan(bizId, corpId, userId, marketingPlan.getId());
        }
        this.marketingQrcodeService.sendNotSyncQrCodeToKafka(marketingPlan.getId());
    }

    @Override
    public List<MarketingListItemDto> list(MarketingListParams params) {
        List list;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Set userIds = this.userRoleCommonService.getManageUserIds();
        QueryPlanListParams planListParams = new QueryPlanListParams();
        planListParams.setBizId(bizId);
        planListParams.setCorpId(corpId);
        planListParams.setIsEnabled(params.getIsEnabled());
        planListParams.setName(params.getName());
        planListParams.setCreateEndTime(params.getCreateEndTime());
        planListParams.setCreateStartTime(params.getCreateStartTime());
        planListParams.setCreatorId(params.getCreatorId());
        planListParams.setUpdateStartTime(params.getUpdateStartTime());
        planListParams.setUpdateEndTime(params.getUpdateEndTime());
        planListParams.setUpdateId(params.getUpdateId());
        planListParams.setWeworkUserNum(params.getWeworkUserId());
        planListParams.setUserIds(userIds);
        planListParams.setPageDto(params.getPageDto());
        planListParams.setType(params.getType());
        if (params.getPageDto() != null) {
            int count = this.marketingPlanMapper.queryMarketingPlanListCount(planListParams);
            params.getPageDto().setCount(Integer.valueOf(count));
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.marketingPlanMapper.queryMarketingPlanList(planListParams)))) {
            return Lists.newArrayList();
        }
        List<Long> planIds = list.stream().map(item -> item.getId()).collect(Collectors.toList());
        Map<Long, List<ChannelDto>> channelDtos = this.marketingChannelService.queryPlanOfChannel(corpId, planIds);
        Map<Long, List<WeworkUserDto>> weworkUserDtos = this.marketingUserService.getPlanOfWeworkUser(corpId, planIds);
        Map<Long, Integer> pvMap = this.marketingPlanStatisticService.getPlanPv(planIds);
        Map<Long, Integer> uvMap = this.marketingPlanStatisticService.getPlanUv(planIds);
        Map<Long, Integer> addFriendMap = this.marketingPlanStatisticService.getPlanAddFriends(planIds, corpId);
        HashSet userSet = Sets.newHashSet();
        list.forEach(item -> {
            userSet.add(item.getCreatorId());
            userSet.add(item.getUpdateId());
        });
        Map userNameMap = this.userService.getUserIdAndNameByUserIds((Set)userSet);
        ArrayList result = Lists.newArrayList();
        for (MarketingPlanListItenDto planListItenDto : list) {
            Long planId = planListItenDto.getId();
            MarketingListItemDto marketingListItemDto = new MarketingListItemDto();
            marketingListItemDto.setId(planListItenDto.getNum());
            marketingListItemDto.setName(planListItenDto.getName());
            marketingListItemDto.setCreateTime(planListItenDto.getCreateTime());
            marketingListItemDto.setCreatorId(planListItenDto.getCreatorId());
            marketingListItemDto.setCreatorName((String)userNameMap.get(planListItenDto.getCreatorId()));
            marketingListItemDto.setUpdateId(planListItenDto.getUpdateId());
            marketingListItemDto.setUpdateName((String)userNameMap.get(planListItenDto.getUpdateId()));
            marketingListItemDto.setUpdateTime(planListItenDto.getUpdateTime());
            marketingListItemDto.setIsDraft(planListItenDto.getIsDraft());
            marketingListItemDto.setIsEnabled(planListItenDto.getIsEnabled());
            marketingListItemDto.setAddFriendsCount(addFriendMap.getOrDefault(planId, 0));
            marketingListItemDto.setPv(pvMap.getOrDefault(planId, 0));
            marketingListItemDto.setUv(uvMap.getOrDefault(planId, 0));
            marketingListItemDto.setChannelList(channelDtos.getOrDefault(planId, Lists.newArrayList()));
            marketingListItemDto.setWeworkUserList(weworkUserDtos.get(planId));
            marketingListItemDto.setOnLineType(planListItenDto.getOnLineType());
            marketingListItemDto.setPlanId(planId);
            marketingListItemDto.setStatisticType(planListItenDto.getStatisticType());
            if (planListItenDto.getIsDraft() != 1 && planListItenDto.getIsEnabled() == 1) {
                List<ConfigQrcodeError> configQrcodeErrors = this.marketingQrcodeService.getConfigQrcodeErrors(planId);
                marketingListItemDto.setConfigQrcodeErrors(configQrcodeErrors);
            } else {
                marketingListItemDto.setConfigQrcodeErrors(Lists.newArrayList());
            }
            result.add(marketingListItemDto);
        }
        return result;
    }

    @Override
    public Object getMarketingPlan(BaseDto params) {
        log.info("getMarketingPlan params: {}", (Object)params);
        if (StringUtils.isEmpty((Object)params.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(params.getId());
        marketingPlan.setBizId(bizId);
        marketingPlan.setCorpId(corpId);
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u53c2\u6570\u4e0d\u5bf9");
        }
        if (marketingPlan.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        Long planId = marketingPlan.getId();
        if (marketingPlan.getIsDraft().intValue() == IsDraft.IS_DRAFT.getValue()) {
            String paramsConfig = this.marketingPlanDraftMapper.queryDraftJson(planId);
            return JSONObject.parseObject((String)paramsConfig);
        }
        MarketingPlanDetailDto result = new MarketingPlanDetailDto();
        result.setId(marketingPlan.getNum());
        result.setName(marketingPlan.getName());
        result.setInitNumber(marketingPlan.getInitNumbers());
        result.setStatisticType(marketingPlan.getStatsType());
        result.setTemplateType(marketingPlan.getTemplateType());
        result.setIsDraft(marketingPlan.getIsDraft());
        result.setIsEnabled(marketingPlan.getIsEnabled());
        result.setQrcodeType(marketingPlan.getQrcodeType());
        MarketingConfig marketingConfig = this.marketingConfigService.getMarketingPlanConfig(bizId, corpId, planId, MarketingConfigType.AUTO_REMARK.getValue());
        if (marketingConfig != null) {
            result.setAddFriendRemark(marketingConfig.getConfigJson());
        }
        marketingConfig = this.marketingConfigService.getMarketingPlanConfig(bizId, corpId, planId, MarketingConfigType.FRIEND_WELCOME.getValue());
        try {
            if (marketingConfig != null) {
                FriendWelcomeDto friendWelcomeDto = (FriendWelcomeDto)JacksonUtil.str2Obj((String)marketingConfig.getConfigJson(), FriendWelcomeDto.class);
                result.setAddFriendWelcome(friendWelcomeDto);
            }
        }
        catch (IOException e) {
            log.error("getMarketingPlan json error: {}", (Throwable)e);
        }
        Map<Long, List<ChannelDto>> channelDtoMap = this.marketingChannelService.queryPlanOfChannel(corpId, Lists.newArrayList((Object[])new Long[]{planId}));
        result.setChannelList(channelDtoMap.getOrDefault(planId, Lists.newArrayList()));
        List<MarketingPlanGroupDetailDto> groups = this.marketingPlanGroupService.getMarketingGroupDetail(planId);
        result.setGroups(groups);
        return result;
    }

    @Override
    public MarketingInfoDto getMarketingInfo(ClientParamsDto params) {
        String num = params.getId();
        Preconditions.checkArgument((!StringUtils.isEmpty((Object)num) ? 1 : 0) != 0, (Object)"\u6d3b\u52a8id\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        MarketingChannel marketingChannel = this.marketingChannelService.getMarketingChannel(num);
        if (marketingChannel == null || marketingChannel.getIsDeleted() == 1) {
            return null;
        }
        Long planId = marketingChannel.getPlanId();
        String corpId = marketingChannel.getCorpId();
        MarketingPlan marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)planId);
        if (marketingPlan == null || marketingPlan.getIsDeleted() == 1 || marketingPlan.getIsEnabled() == 0 || marketingPlan.getIsDraft() == 1) {
            return null;
        }
        MarketingInfoDto marketingInfoDto = new MarketingInfoDto();
        marketingInfoDto.setId(marketingPlan.getNum());
        marketingInfoDto.setBizId(marketingPlan.getBizId());
        marketingInfoDto.setName(marketingPlan.getName());
        marketingInfoDto.setTemplateType(marketingPlan.getTemplateType());
        marketingInfoDto.setType(marketingPlan.getType());
        int activeNumber = marketingPlan.getInitNumbers() + this.marketingPlanStatisticService.getPlanAddFriends(Lists.newArrayList((Object[])new Long[]{planId}), corpId).getOrDefault(planId, 0);
        marketingInfoDto.setActiveNumber(activeNumber);
        if (marketingPlan.getType().intValue() == PlanType.CHANNEL_PLAN.getValue()) {
            marketingInfoDto.setGroups(this.marketingQrcodeService.queryPlanGroupInfo(planId, marketingChannel.getChannelId()));
        }
        return marketingInfoDto;
    }

    private Long insertMarketingPlan(MarketingPlanDto marketingPlanDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(this.idGen.getNum());
        marketingPlan.setBizId(userInfo.getBizId());
        marketingPlan.setCorpId(userInfo.getCorpId());
        marketingPlan.setName(marketingPlanDto.getName());
        marketingPlan.setType(Integer.valueOf(1));
        marketingPlan.setTemplateType(marketingPlanDto.getTemplateType());
        marketingPlan.setInitNumbers(marketingPlanDto.getInitNumber());
        marketingPlan.setStatsType(marketingPlanDto.getStatisticType());
        marketingPlan.setIsDeleted(Integer.valueOf(0));
        marketingPlan.setIsDraft(Integer.valueOf(0));
        marketingPlan.setIsEnabled(Integer.valueOf(1));
        marketingPlan.setCreateBy(userInfo.getId());
        marketingPlan.setCreateTime(new Date());
        marketingPlan.setUpdateBy(userInfo.getId());
        marketingPlan.setUpdateTime(new Date());
        marketingPlan.setQrcodeType(marketingPlanDto.getQrcodeType());
        this.marketingPlanMapper.insertSelective((Object)marketingPlan);
        marketingPlanDto.setId(marketingPlan.getNum());
        return marketingPlan.getId();
    }

    private void updateMarketingPlan(MarketingPlanDto marketingPlanDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(marketingPlanDto.getId());
        marketingPlan.setName(marketingPlanDto.getName());
        marketingPlan.setTemplateType(marketingPlanDto.getTemplateType());
        marketingPlan.setInitNumbers(marketingPlanDto.getInitNumber());
        marketingPlan.setStatsType(marketingPlanDto.getStatisticType());
        marketingPlan.setUpdateBy(userInfo.getId());
        marketingPlan.setUpdateTime(new Date());
        marketingPlan.setIsDraft(Integer.valueOf(0));
        marketingPlan.setQrcodeType(marketingPlanDto.getQrcodeType());
        MarketingPlanCriteria query = new MarketingPlanCriteria();
        query.createCriteria().andNumEqualTo(marketingPlanDto.getId());
        this.marketingPlanMapper.updateByExampleSelective((Object)marketingPlan, (Object)query);
    }

    @Override
    public boolean isRepeatMarketingPlanName(String corpId, String name, Long planId, PlanType planType) {
        int count = this.marketingPlanMapper.queryMarketingPlanName(corpId, name, planId, Integer.valueOf(planType.getValue()));
        return count > 0;
    }

    @Override
    public List<PlanDto> planList(MarketingListParams params) {
        List list;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Set userIds = this.userRoleCommonService.getManageUserIds();
        QueryPlanListParams planListParams = new QueryPlanListParams();
        planListParams.setBizId(bizId);
        planListParams.setCorpId(corpId);
        planListParams.setIsEnabled(Integer.valueOf(1));
        planListParams.setName(params.getName());
        planListParams.setUserIds(userIds);
        planListParams.setPageDto(params.getPageDto());
        planListParams.setTypeList((List)Lists.newArrayList((Object[])new Integer[]{PlanType.CHANNEL_PLAN.getValue(), PlanType.REGION_PLAN.getValue()}));
        if (params.getPageDto() != null) {
            int count = this.marketingPlanMapper.queryMarketingPlanListCount(planListParams);
            params.getPageDto().setCount(Integer.valueOf(count));
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.marketingPlanMapper.queryMarketingPlanList(planListParams)))) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (MarketingPlanListItenDto planListItenDto : list) {
            PlanDto planDto = new PlanDto();
            planDto.setId(planListItenDto.getNum());
            planDto.setName(planListItenDto.getName());
            planDto.setType(planListItenDto.getPlanType());
            result.add(planDto);
        }
        return result;
    }
}

