/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.marketing.entity.MarketingQrcode;
import com.kuaike.scrm.dal.marketing.mapper.MarketingQrcodeMapper;
import com.kuaike.scrm.marketing.service.ConfigMarketQrcodeTaskService;
import com.kuaike.scrm.marketing.service.MarketingQrcodeService;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigMarketQrcodeTaskServiceImpl
implements ConfigMarketQrcodeTaskService {
    private static final Logger log = LoggerFactory.getLogger(ConfigMarketQrcodeTaskServiceImpl.class);
    @Resource
    private MarketingQrcodeMapper marketingQrcodeMapper;
    @Autowired
    private MarketingQrcodeService marketingQrcodeService;
    private ExecutorService executeService = new ThreadPoolExecutor(5, 5, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(500), (ThreadFactory)new NamedThreadFactory("ConfigMarketQrcodeExecuteService"));

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.executeService);
    }

    @Override
    public void handTask(Long id) {
        if (id == null) {
            return;
        }
        MarketingQrcode marketingQrcode = (MarketingQrcode)this.marketingQrcodeMapper.selectByPrimaryKey((Object)id);
        if (marketingQrcode == null) {
            log.warn("marketingQrcode is null, id: {}", (Object)id);
            return;
        }
        if (marketingQrcode.getIsSync() == 1) {
            log.warn("marketingQrcode is sync, id: {}", (Object)id);
            return;
        }
        this.runTask(marketingQrcode);
    }

    private void runTask(final MarketingQrcode marketingQrcode) {
        this.executeService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ConfigMarketQrcodeTaskServiceImpl.this.marketingQrcodeService.configQrcode(marketingQrcode);
                }
                catch (Exception e) {
                    log.error("config qrcode error: ", (Throwable)e);
                    log.error("config qrcode id: {}", (Object)marketingQrcode.getId());
                    marketingQrcode.setSyncErrorMsg(e.getMessage());
                    marketingQrcode.setUpdateTime(new Date());
                    if (marketingQrcode.getIsDeleted() == 1) {
                        marketingQrcode.setIsSync(Integer.valueOf(1));
                        marketingQrcode.setQrConfigId("");
                        marketingQrcode.setQrCodeUrl("");
                    }
                    ConfigMarketQrcodeTaskServiceImpl.this.marketingQrcodeMapper.updateByPrimaryKeySelective((Object)marketingQrcode);
                }
            }
        });
    }
}

