/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.dto;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.enums.StatisticType;
import com.kuaike.scrm.marketing.dto.FriendWelcomeDto;
import com.kuaike.scrm.marketing.dto.MarketingPlanGroupDto;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class MarketingPlanDto
extends BaseDto {
    private String name;
    private Integer initNumber = 0;
    private List<String> channelIds;
    private Integer statisticType;
    private Integer templateType = 1;
    private String addFriendRemark;
    private FriendWelcomeDto addFriendWelcome;
    private List<MarketingPlanGroupDto> groups;
    private Integer qrcodeType;

    public void checkParams() {
        if (this.initNumber == null) {
            this.initNumber = 0;
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"\u6d3b\u52a8\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        this.name = this.name.trim();
        Preconditions.checkArgument((this.initNumber >= 0 ? 1 : 0) != 0, (Object)"\u6d3b\u52a8\u521d\u59cb\u4eba\u6570\u5e94\u8be5\u5927\u4e8e\u7b49\u4e8e0");
        Preconditions.checkArgument((this.statisticType != null ? 1 : 0) != 0, (Object)"pv/uv \u7edf\u8ba1\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.statisticType.intValue() == StatisticType.STATISTIC_PV_UV.getValue() || this.statisticType.intValue() == StatisticType.STATISTIC_UV_DETAIL.getValue() ? 1 : 0) != 0, (Object)"pv/uv \u7edf\u8ba1\u7c7b\u578b\u503c\u4e0d\u5bf9");
        Preconditions.checkArgument((this.addFriendWelcome != null ? 1 : 0) != 0, (Object)"\u597d\u53cb\u6b22\u8fce\u8bed\u6ca1\u914d\u7f6e");
        Preconditions.checkArgument((!CollectionUtils.isEmpty(this.groups) ? 1 : 0) != 0, (Object)"\u6d3b\u52a8\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.qrcodeType == null) {
            this.qrcodeType = 1;
        }
        HashSet groupNameSet = Sets.newHashSet();
        if (this.groups.size() > 1) {
            int curGroupCount = 0;
            for (MarketingPlanGroupDto groupDto : this.groups) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)groupDto.getName()), (Object)"\u591a\u4e2a\u5206\u7ec4\u65f6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                groupDto.checkParams();
                if (groupDto.getIsDeleted() != null && groupDto.getIsDeleted() != 0) continue;
                groupNameSet.add(groupDto.getName());
                ++curGroupCount;
            }
            if (groupNameSet.size() < curGroupCount) {
                Preconditions.checkArgument((boolean)false, (Object)"\u6d3b\u52a8\u5206\u7ec4\u540d\u4e0d\u80fd\u91cd\u590d");
            }
        } else {
            this.groups.get(0).checkParams();
        }
    }

    public String getName() {
        return this.name;
    }

    public Integer getInitNumber() {
        return this.initNumber;
    }

    public List<String> getChannelIds() {
        return this.channelIds;
    }

    public Integer getStatisticType() {
        return this.statisticType;
    }

    public Integer getTemplateType() {
        return this.templateType;
    }

    public String getAddFriendRemark() {
        return this.addFriendRemark;
    }

    public FriendWelcomeDto getAddFriendWelcome() {
        return this.addFriendWelcome;
    }

    public List<MarketingPlanGroupDto> getGroups() {
        return this.groups;
    }

    public Integer getQrcodeType() {
        return this.qrcodeType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInitNumber(Integer initNumber) {
        this.initNumber = initNumber;
    }

    public void setChannelIds(List<String> channelIds) {
        this.channelIds = channelIds;
    }

    public void setStatisticType(Integer statisticType) {
        this.statisticType = statisticType;
    }

    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }

    public void setAddFriendRemark(String addFriendRemark) {
        this.addFriendRemark = addFriendRemark;
    }

    public void setAddFriendWelcome(FriendWelcomeDto addFriendWelcome) {
        this.addFriendWelcome = addFriendWelcome;
    }

    public void setGroups(List<MarketingPlanGroupDto> groups) {
        this.groups = groups;
    }

    public void setQrcodeType(Integer qrcodeType) {
        this.qrcodeType = qrcodeType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarketingPlanDto)) {
            return false;
        }
        MarketingPlanDto other = (MarketingPlanDto)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$initNumber = this.getInitNumber();
        Integer other$initNumber = other.getInitNumber();
        if (this$initNumber == null ? other$initNumber != null : !((Object)this$initNumber).equals(other$initNumber)) {
            return false;
        }
        Integer this$statisticType = this.getStatisticType();
        Integer other$statisticType = other.getStatisticType();
        if (this$statisticType == null ? other$statisticType != null : !((Object)this$statisticType).equals(other$statisticType)) {
            return false;
        }
        Integer this$templateType = this.getTemplateType();
        Integer other$templateType = other.getTemplateType();
        if (this$templateType == null ? other$templateType != null : !((Object)this$templateType).equals(other$templateType)) {
            return false;
        }
        Integer this$qrcodeType = this.getQrcodeType();
        Integer other$qrcodeType = other.getQrcodeType();
        if (this$qrcodeType == null ? other$qrcodeType != null : !((Object)this$qrcodeType).equals(other$qrcodeType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$channelIds = this.getChannelIds();
        List<String> other$channelIds = other.getChannelIds();
        if (this$channelIds == null ? other$channelIds != null : !((Object)this$channelIds).equals(other$channelIds)) {
            return false;
        }
        String this$addFriendRemark = this.getAddFriendRemark();
        String other$addFriendRemark = other.getAddFriendRemark();
        if (this$addFriendRemark == null ? other$addFriendRemark != null : !this$addFriendRemark.equals(other$addFriendRemark)) {
            return false;
        }
        FriendWelcomeDto this$addFriendWelcome = this.getAddFriendWelcome();
        FriendWelcomeDto other$addFriendWelcome = other.getAddFriendWelcome();
        if (this$addFriendWelcome == null ? other$addFriendWelcome != null : !((Object)this$addFriendWelcome).equals(other$addFriendWelcome)) {
            return false;
        }
        List<MarketingPlanGroupDto> this$groups = this.getGroups();
        List<MarketingPlanGroupDto> other$groups = other.getGroups();
        return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MarketingPlanDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $initNumber = this.getInitNumber();
        result = result * 59 + ($initNumber == null ? 43 : ((Object)$initNumber).hashCode());
        Integer $statisticType = this.getStatisticType();
        result = result * 59 + ($statisticType == null ? 43 : ((Object)$statisticType).hashCode());
        Integer $templateType = this.getTemplateType();
        result = result * 59 + ($templateType == null ? 43 : ((Object)$templateType).hashCode());
        Integer $qrcodeType = this.getQrcodeType();
        result = result * 59 + ($qrcodeType == null ? 43 : ((Object)$qrcodeType).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $channelIds = this.getChannelIds();
        result = result * 59 + ($channelIds == null ? 43 : ((Object)$channelIds).hashCode());
        String $addFriendRemark = this.getAddFriendRemark();
        result = result * 59 + ($addFriendRemark == null ? 43 : $addFriendRemark.hashCode());
        FriendWelcomeDto $addFriendWelcome = this.getAddFriendWelcome();
        result = result * 59 + ($addFriendWelcome == null ? 43 : ((Object)$addFriendWelcome).hashCode());
        List<MarketingPlanGroupDto> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        return result;
    }

    public String toString() {
        return "MarketingPlanDto(name=" + this.getName() + ", initNumber=" + this.getInitNumber() + ", channelIds=" + this.getChannelIds() + ", statisticType=" + this.getStatisticType() + ", templateType=" + this.getTemplateType() + ", addFriendRemark=" + this.getAddFriendRemark() + ", addFriendWelcome=" + this.getAddFriendWelcome() + ", groups=" + this.getGroups() + ", qrcodeType=" + this.getQrcodeType() + ")";
    }
}

