/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.lockCustomer.service;

import cn.kinyun.customer.center.dto.resp.CustomerOrderWeworkInfoResp;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.service.ScrmLockCustomerService;
import com.kuaike.scrm.common.service.dto.resp.WeworkUserResp;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.entity.LockCustomer;
import com.kuaike.scrm.dal.system.entity.LockCustomerScope;
import com.kuaike.scrm.dal.system.mapper.LockCustomerMapper;
import com.kuaike.scrm.dal.system.mapper.LockCustomerScopeMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.wework.department.service.DepartmentService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScrmLockCustomerServiceImpl
implements ScrmLockCustomerService {
    private static final Logger log = LoggerFactory.getLogger(ScrmLockCustomerServiceImpl.class);
    @Autowired
    private LockCustomerMapper lockCustomerMapper;
    @Autowired
    private LockCustomerScopeMapper lockCustomerScopeMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkDepartmentUserMapper departmentUserMapper;
    @Autowired
    private CcCustomerOrderService ccCustomerOrderService;
    @Autowired
    private WeworkContactRelationMapper contactRelationMapper;
    @Autowired
    private DepartmentService departmentService;

    public WeworkUserResp queryWeworkUserCodeByContactId(String contactId, String corpId) {
        List<Long> orderUserIds;
        log.info("queryWeworkUserCodeByContactId corpId: {}, contactId: {}", (Object)corpId, (Object)contactId);
        if (StringUtils.isBlank((CharSequence)contactId) || StringUtils.isBlank((CharSequence)corpId)) {
            log.warn("queryWeworkUserCodeByContactId get param is null");
            return null;
        }
        LockCustomer lc = this.lockCustomerMapper.queryLockCustomer(corpId);
        if (lc == null || lc.getState() == 0) {
            log.warn("queryWeworkUserCodeByContactId get lc is null or state is 0");
            return null;
        }
        Long bizId = lc.getBizId();
        List scopeList = this.lockCustomerScopeMapper.queryScopeList(bizId, lc.getId());
        ArrayList weworkUserIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)scopeList)) {
            List userList;
            List userNums = scopeList.stream().filter(a -> a.getType() == 2).map(LockCustomerScope::getWeworkUserNum).collect(Collectors.toList());
            log.info("queryWeworkUserCodeByContactId userNums: {}", userNums);
            if (CollectionUtils.isNotEmpty(userNums) && CollectionUtils.isNotEmpty((Collection)(userList = this.weworkUserMapper.queryWeworkUsersByNums(corpId, userNums)))) {
                userList.forEach(a -> weworkUserIds.add(a.getWeworkUserId()));
            }
            Set depIds = scopeList.stream().filter(a -> a.getType() == 1).map(LockCustomerScope::getWeworkDepartmentId).collect(Collectors.toSet());
            Set departments = this.departmentService.getAllFlatDepartment(corpId, depIds, true);
            log.info("queryWeworkUserCodeByContactId depIds: {}, departments: {}", depIds, (Object)departments);
            if (CollectionUtils.isNotEmpty(depIds)) {
                Set depWeworkUserIds = this.departmentUserMapper.selectWeworkUserId(corpId, (Collection)departments);
                weworkUserIds.addAll(depWeworkUserIds);
            }
        }
        log.info("queryWeworkUserCodeByContactId get weworkUserIds: {}", (Object)weworkUserIds);
        String selectWeworkUserId = "";
        if (lc.getOrderState() == 1 && (orderUserIds = this.queryOrderSelectId(weworkUserIds, corpId, bizId, contactId)) != null && !orderUserIds.isEmpty()) {
            Long selectId = null;
            if (lc.getOrderRule() == 0) {
                selectId = orderUserIds.get(0);
            } else if (lc.getOrderRule() == 1) {
                selectId = orderUserIds.get(orderUserIds.size() - 1);
            } else {
                int index = new Random().nextInt(orderUserIds.size());
                selectId = orderUserIds.get(index);
            }
            log.info("queryWeworkUserCodeByContactId selectId: {}", (Object)selectId);
            if (selectId != null) {
                User user = this.userMapper.getUserInfoById(selectId);
                selectWeworkUserId = user.getWeworkUserId();
            }
        }
        log.info("queryWeworkUserCodeByContactId selectWeworkUserId: {}", (Object)selectWeworkUserId);
        if (StringUtils.isBlank((CharSequence)selectWeworkUserId)) {
            List contactRelations = this.contactRelationMapper.queryListByContactId(corpId, contactId);
            if (CollectionUtils.isEmpty((Collection)contactRelations)) {
                selectWeworkUserId = "";
            }
            contactRelations = contactRelations.stream().filter(a -> weworkUserIds.contains(a.getWeworkUserId())).collect(Collectors.toList());
            log.info("queryWeworkUserCodeByContactId get contactId: {}\uff0c contactRelations: {}", (Object)contactId, contactRelations);
            if (contactRelations.size() > 0) {
                WeworkContactRelation relation = null;
                if (lc.getAddRule() == 0) {
                    relation = (WeworkContactRelation)contactRelations.get(0);
                } else if (lc.getAddRule() == 1) {
                    relation = (WeworkContactRelation)contactRelations.get(contactRelations.size() - 1);
                } else {
                    int index = new Random().nextInt(contactRelations.size());
                    relation = (WeworkContactRelation)contactRelations.get(index);
                }
                selectWeworkUserId = relation.getWeworkUserId();
            }
        }
        log.info("queryWeworkUserCodeByContactId corpId: {} selectWeworkUserId : {}", (Object)corpId, (Object)selectWeworkUserId);
        if (StringUtils.isBlank((CharSequence)selectWeworkUserId)) {
            return null;
        }
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, selectWeworkUserId);
        WeworkUserResp respDto = new WeworkUserResp();
        if (weworkUser != null) {
            respDto.setName(weworkUser.getName());
            respDto.setWeworkUserId(weworkUser.getWeworkUserId());
            respDto.setAvatar(weworkUser.getAvatar());
            respDto.setQrCode(weworkUser.getQrCode());
            respDto.setMobile(weworkUser.getMobile());
        }
        return respDto;
    }

    private List<Long> queryOrderSelectId(List<String> weworkUserIds, String corpId, Long bizId, String contactId) {
        WeworkContact contact = this.weworkContactMapper.queryContactByContactId(corpId, contactId);
        if (contact == null) {
            log.info("queryWeworkUserCodeByContactId query contact is null");
            return null;
        }
        String customerNum = contact.getCustomerNum();
        List orderUserIdList = this.ccCustomerOrderService.queryCustomerOrderList(bizId, customerNum);
        log.info("queryWeworkUserCodeByContactId customerNum: {}, orderUserIdList: {}", (Object)customerNum, (Object)orderUserIdList);
        if (CollectionUtils.isEmpty((Collection)orderUserIdList)) {
            log.info("queryWeworkUserCodeByContactId query orderUserIds is empty");
            return null;
        }
        List<Long> orderUserIds = orderUserIdList.stream().map(CustomerOrderWeworkInfoResp::getUserId).collect(Collectors.toList());
        List userList = this.userMapper.getUserInfoByIds(orderUserIds);
        if (CollectionUtils.isEmpty((Collection)userList)) {
            log.info("queryWeworkUserCodeByContactId query userList is empty");
            return null;
        }
        userList = userList.stream().filter(a -> weworkUserIds.contains(a.getWeworkUserId())).collect(Collectors.toList());
        List selectUserIds = userList.stream().map(User::getId).collect(Collectors.toList());
        log.info("queryWeworkUserCodeByContactId selectUserIds : {}", selectUserIds);
        if (selectUserIds.size() == 0) {
            log.info("queryWeworkUserCodeByContactId query selectUserIds is empty");
            return null;
        }
        orderUserIds = orderUserIds.stream().filter(a -> selectUserIds.contains(a)).collect(Collectors.toList());
        log.info("queryWeworkUserCodeByContactId orderUserIds: {}", orderUserIds);
        return orderUserIds;
    }
}

