/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.friendFission.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.dto.WeworkUserDto;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.marketing.dto.BasicStatisticDto;
import com.kuaike.scrm.dal.marketing.dto.ChannelAnalyzeDto;
import com.kuaike.scrm.dal.marketing.dto.ContactAnalyzeDto;
import com.kuaike.scrm.dal.marketing.dto.ContactHelpDetailDto;
import com.kuaike.scrm.dal.marketing.dto.DayContactCountDto;
import com.kuaike.scrm.dal.marketing.dto.FriendFissionFunnel;
import com.kuaike.scrm.dal.marketing.dto.HierarchicalDataDto;
import com.kuaike.scrm.dal.marketing.dto.MemberAnalyzeDto;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.MarketingRewardStage;
import com.kuaike.scrm.dal.marketing.mapper.MarketingAddFriendLogMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingJoinMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingRewardMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingRewardStageMapper;
import com.kuaike.scrm.dal.wework.dto.ContactWeworkNumPair;
import com.kuaike.scrm.dal.wework.dto.WeworkContactRelationDto;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.friendFission.dto.ContactAnalyzeReq;
import com.kuaike.scrm.friendFission.dto.ContactHelpDetailReq;
import com.kuaike.scrm.friendFission.dto.ContactHelpDetailResp;
import com.kuaike.scrm.friendFission.dto.PlanRewardStage;
import com.kuaike.scrm.friendFission.dto.PlanStatisticsReq;
import com.kuaike.scrm.friendFission.dto.ReachCountRate;
import com.kuaike.scrm.friendFission.dto.resp.PlanBasicDataRespDto;
import com.kuaike.scrm.friendFission.dto.resp.StatisticsBasicInfoRespDto;
import com.kuaike.scrm.friendFission.service.FriendFissionStatisticService;
import com.kuaike.scrm.friendFission.utils.Object2MapUtils;
import com.kuaike.scrm.wework.contact.service.ContactService;
import com.kuaike.scrm.wework.weworkUser.service.WeworkUserService;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FriendFissionStatisticServiceImpl
implements FriendFissionStatisticService {
    private static final Logger log = LoggerFactory.getLogger(FriendFissionStatisticServiceImpl.class);
    @Autowired
    private MarketingJoinMapper marketingJoinMapper;
    @Autowired
    private MarketingRewardMapper marketingRewardMapper;
    @Autowired
    private MarketingAddFriendLogMapper marketingAddFriendLogMapper;
    @Autowired
    private MarketingPlanMapper marketingPlanMapper;
    @Autowired
    private MarketingRewardStageMapper marketingRewardStageMapper;
    @Autowired
    private ChannelMapper channelMapper;
    @Autowired
    private MarketingChannelMapper marketingChannelMapper;
    @Autowired
    private WeworkUserService weworkUserService;
    @Autowired
    private ContactService contactService;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    private final String[] CHANNEL_ANALYZE_HEADER = new String[]{"\u6e20\u9053\u540d\u79f0", "\u53c2\u4e0e\u5ba2\u6237\u6570", "\u51c0\u589e\u5ba2\u6237\u6570", "\u6709\u6548\u5206\u4eab\u4eba\u6570", "\u88c2\u53d8\u7387", "\u7559\u5b58\u7387", "\u5206\u4eab\u7387", "\u4e00\u9636\u8fbe\u6210\u4eba\u6570/\u8fbe\u6210\u7387", "\u4e8c\u9636\u8fbe\u6210\u4eba\u6570/\u8fbe\u6210\u7387", "\u4e09\u9636\u8fbe\u6210\u4eba\u6570/\u8fbe\u6210\u7387"};
    private final String[] CONTACT_ANALYZE_HEADER = new String[]{"\u5ba2\u6237\u6635\u79f0", "\u5ba2\u6237\u5c42\u7ea7", "\u6709\u6548\u52a9\u529b\u4eba\u6570", "\u5386\u53f2\u6700\u9ad8\u52a9\u529b\u4eba\u6570", "\u8fbe\u6210\u9636\u68af\u7b49\u7ea7", "\u662f\u5426\u597d\u53cb", "\u6e20\u9053\u6765\u6e90", "\u4e00\u9636\u5956\u54c1", "\u4e8c\u9636\u5956\u54c1", "\u4e09\u9636\u5956\u54c1"};

    @Override
    public StatisticsBasicInfoRespDto statisticBasicInfo(PlanStatisticsReq params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("statisticBasicInfo, params:{}, operatorId:{}", (Object)params, (Object)currentUserInfo.getId());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u6d3b\u52a8\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        Date todayStartTime = DateUtil.getTodayStartTime();
        BasicStatisticDto basicStatisticDto = new BasicStatisticDto();
        basicStatisticDto.setCorpId(currentUserInfo.getCorpId());
        basicStatisticDto.setPlanNum(params.getId());
        basicStatisticDto.setContainDel(Integer.valueOf(1));
        int totalCount = this.marketingJoinMapper.getCountByParams(basicStatisticDto);
        basicStatisticDto.setContainDel(Integer.valueOf(1));
        basicStatisticDto.setStartTime(todayStartTime);
        int todayTotalCount = this.marketingJoinMapper.getCountByParams(basicStatisticDto);
        basicStatisticDto.setContainDel(Integer.valueOf(0));
        basicStatisticDto.setStartTime(null);
        basicStatisticDto.setIsNewCustomer(NumberUtils.INTEGER_ONE);
        int incrementCount = this.marketingJoinMapper.getCountByParams(basicStatisticDto);
        basicStatisticDto.setContainDel(Integer.valueOf(0));
        basicStatisticDto.setStartTime(todayStartTime);
        int todayIncrementCount = this.marketingJoinMapper.getCountByParams(basicStatisticDto);
        int levelOneCount = this.marketingJoinMapper.getLevelOneCount(currentUserInfo.getCorpId(), params.getId());
        int delCount = this.marketingJoinMapper.getDelWeworkUserCount(currentUserInfo.getCorpId(), params.getId());
        int spreadRate = 0;
        int reserveRate = 0;
        if (totalCount > 0) {
            spreadRate = (totalCount - levelOneCount) * 10000 / totalCount;
            reserveRate = (totalCount - delCount) * 10000 / totalCount;
        }
        StatisticsBasicInfoRespDto statisticsBasicInfoRespDto = new StatisticsBasicInfoRespDto();
        statisticsBasicInfoRespDto.setTotalCount(totalCount);
        statisticsBasicInfoRespDto.setTodayCount(todayTotalCount);
        statisticsBasicInfoRespDto.setIncrementCount(incrementCount);
        statisticsBasicInfoRespDto.setTodayIncrementCount(todayIncrementCount);
        statisticsBasicInfoRespDto.setSpreadRate(spreadRate);
        statisticsBasicInfoRespDto.setReserveRate(reserveRate);
        return statisticsBasicInfoRespDto;
    }

    @Override
    public PlanBasicDataRespDto planBasicData(PlanStatisticsReq params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("planBasicData,params:{}, operatorId:{}", (Object)params, (Object)currentUserInfo.getId());
        params.validate();
        String planNum = params.getId();
        MarketingPlan marketingPlan = this.marketingPlanMapper.selectByNum(planNum);
        Preconditions.checkArgument((boolean)Objects.nonNull(marketingPlan), (Object)"\u6d3b\u52a8id\u4e0d\u5408\u6cd5");
        BasicStatisticDto basicStatisticDto = new BasicStatisticDto();
        basicStatisticDto.setCorpId(currentUserInfo.getCorpId());
        basicStatisticDto.setPlanNum(planNum);
        basicStatisticDto.setStartTime(params.getStartTime());
        basicStatisticDto.setEndTime(params.getEndTime());
        List stages = this.marketingRewardStageMapper.selectPlanCurrentStagesByPlanId(marketingPlan.getId());
        Set stageNums = stages.stream().map(MarketingRewardStage::getStage).collect(Collectors.toSet());
        Set totalContactIds = this.marketingJoinMapper.getJoinContactIds(basicStatisticDto);
        basicStatisticDto.setStageNums(stageNums);
        Map stageNum2ReachCountMap = this.marketingRewardMapper.getStageNumAndReachCount(basicStatisticDto);
        int totalCount = 0;
        if (CollectionUtils.isNotEmpty((Collection)totalContactIds)) {
            totalCount = totalContactIds.size();
            basicStatisticDto.setContactIds(totalContactIds);
        }
        int validShareCount = this.marketingAddFriendLogMapper.getValidShareCount(basicStatisticDto);
        int shareRate = totalCount == 0 ? 0 : validShareCount * 10000 / totalCount;
        PlanBasicDataRespDto planBasicDataRespDto = new PlanBasicDataRespDto();
        planBasicDataRespDto.setId(planNum);
        planBasicDataRespDto.setPlanName(marketingPlan.getName());
        planBasicDataRespDto.setShareRate(shareRate);
        ArrayList rewardStages = Lists.newArrayList();
        planBasicDataRespDto.setStageList(rewardStages);
        for (MarketingRewardStage rewardStage : stages) {
            PlanRewardStage planRewardStage = new PlanRewardStage();
            rewardStages.add(planRewardStage);
            planRewardStage.setStageNum(rewardStage.getStage());
            planRewardStage.setHelpCount(rewardStage.getInviteCount());
            int reachCount = 0;
            if (MapUtils.isNotEmpty((Map)stageNum2ReachCountMap)) {
                reachCount = Objects.isNull(stageNum2ReachCountMap.get(rewardStage.getStage())) ? 0 : (Integer)stageNum2ReachCountMap.get(rewardStage.getStage());
            }
            planRewardStage.setReachCount(reachCount);
        }
        return planBasicDataRespDto;
    }

    @Override
    public List<Map<String, Object>> queryCustomerHierarchicalDto(PlanStatisticsReq req) {
        log.info("queryCustomerHierarchicalDto with req={}", (Object)req);
        req.validate();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        List marketingPlans = this.marketingPlanMapper.queryByNums((Collection)Lists.newArrayList((Object[])new String[]{req.getId()}));
        if (CollectionUtils.isEmpty((Collection)marketingPlans)) {
            return Lists.newArrayList();
        }
        MarketingPlan plan = (MarketingPlan)marketingPlans.get(0);
        int allCount = this.marketingJoinMapper.countHierarchicalData(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime());
        if (allCount == 0) {
            return Lists.newArrayList();
        }
        List eachLevelCountList = this.marketingJoinMapper.queryHierarchicalData(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime(), req.getPageDto());
        if (req.getPageDto() != null) {
            req.getPageDto().setCount(Integer.valueOf(allCount));
            req.getPageDto().setCurPageCount(Integer.valueOf(eachLevelCountList.size()));
        }
        Map level2Stage2Count = this.marketingRewardMapper.queryLevelStageCount(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime());
        List rewardStages = this.marketingRewardStageMapper.queryFissionStages(currentUserInfo.getCorpId(), plan.getId(), null);
        Optional<Integer> stageOptional = rewardStages.stream().map(a -> a.getStage()).max(Integer::compareTo);
        int maxStage = stageOptional.isPresent() ? stageOptional.get() : 0;
        ArrayList result = Lists.newArrayList();
        for (HierarchicalDataDto dto : eachLevelCountList) {
            Map item = Object2MapUtils.object2Map(dto);
            Map stage2Count = level2Stage2Count.getOrDefault(dto.getLevel(), Maps.newHashMap());
            for (int i = maxStage; i >= 1; --i) {
                int count = stage2Count.getOrDefault(i, 0);
                ReachCountRate rate = new ReachCountRate();
                rate.setReachCount(count);
                rate.setReachRate(dto.getCount() == 0 ? 0 : count * 10000 / dto.getCount());
                item.put("stage" + i, rate);
            }
            result.add(item);
        }
        return result;
    }

    @Override
    public List<DayContactCountDto> queryCustomerIncrementTrend(PlanStatisticsReq req) {
        log.info("queryCustomerIncrementTrend with req={}", (Object)req);
        req.validate();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        List marketingPlans = this.marketingPlanMapper.queryByNums((Collection)Lists.newArrayList((Object[])new String[]{req.getId()}));
        if (CollectionUtils.isEmpty((Collection)marketingPlans)) {
            return Lists.newArrayList();
        }
        MarketingPlan plan = (MarketingPlan)marketingPlans.get(0);
        if (Objects.isNull(req.getStartTime())) {
            req.setStartTime(plan.getCreateTime());
            req.setEndTime(new Date());
        }
        List list = this.marketingJoinMapper.queryDayContactCount(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime(), req.getPageDto());
        if (req.getPageDto() != null) {
            req.getPageDto().setCurPageCount(Integer.valueOf(list.size()));
            int count = this.marketingJoinMapper.countDayContactCount(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime());
            req.getPageDto().setCount(Integer.valueOf(count));
        }
        Map<Date, Integer> date2Count = list.stream().collect(Collectors.toMap(a -> a.getDate(), a -> a.getContactCount()));
        Date startTime = DateUtils.ceiling((Date)req.getStartTime(), (int)5);
        Date endTime = DateUtils.ceiling((Date)req.getEndTime(), (int)5);
        ArrayList result = Lists.newArrayList();
        Date i = startTime;
        while (i.getTime() <= endTime.getTime()) {
            Integer count = date2Count.getOrDefault(i, 0);
            result.add(new DayContactCountDto(i, count));
            i = DateUtils.addDays((Date)i, (int)1);
        }
        return result;
    }

    @Override
    public FriendFissionFunnel queryFunnel(PlanStatisticsReq req) {
        log.info("queryFunnel with req={}", (Object)req);
        req.validate();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Integer totalCount = this.marketingJoinMapper.queryFunnelTotalCount(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime());
        Integer incrementCount = this.marketingJoinMapper.queryFunnelIncrementCount(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime());
        return new FriendFissionFunnel(req.getId(), totalCount, incrementCount);
    }

    @Override
    public List<Map<String, Object>> channelAnalyzeInfo(PlanStatisticsReq req) {
        log.info("channelAnalyzeInfo with req={}", (Object)req);
        req.validate();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        List marketingPlans = this.marketingPlanMapper.queryByNums((Collection)Lists.newArrayList((Object[])new String[]{req.getId()}));
        if (CollectionUtils.isEmpty((Collection)marketingPlans)) {
            return Lists.newArrayList();
        }
        MarketingPlan plan = (MarketingPlan)marketingPlans.get(0);
        List channels = this.marketingChannelMapper.queryChannelsOfPlan(currentUserInfo.getCorpId(), plan.getId(), req.getPageDto());
        List list = this.marketingJoinMapper.queryChannelAnalyzeInfo(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime(), req.getPageDto());
        Set channelIds = channels.stream().map(a -> a.getId()).collect(Collectors.toSet());
        Map channelId2Level1Count = this.marketingJoinMapper.queryChannelLevel1Count(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime(), channelIds);
        if (CollectionUtils.isEmpty((Collection)channels)) {
            return Lists.newArrayList();
        }
        if (req.getPageDto() != null) {
            req.getPageDto().setCount(this.marketingChannelMapper.countPlanChannels(currentUserInfo.getCorpId(), plan.getId()));
            req.getPageDto().setCurPageCount(Integer.valueOf(list.size()));
        }
        Map<Long, ChannelAnalyzeDto> channelId2Dto = list.stream().collect(Collectors.toMap(a -> a.getChannelId(), a -> a));
        Map<Long, String> channelId2Name = channels.stream().filter(a -> !Objects.isNull(a.getName())).collect(Collectors.toMap(a -> a.getId(), a -> a.getName()));
        Map channelId2IncrementCount = this.marketingJoinMapper.queryChannelIncrementCount(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime());
        Map channelId2DelCount = this.marketingJoinMapper.queryChannelDelCount(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime());
        Map channel2Stage2Count = this.marketingRewardMapper.queryChannelStageCount(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime());
        List rewardStages = this.marketingRewardStageMapper.queryFissionStages(currentUserInfo.getCorpId(), plan.getId(), null);
        Optional<Integer> stageOptional = rewardStages.stream().map(a -> a.getStage()).max(Integer::compareTo);
        int maxStage = stageOptional.isPresent() ? stageOptional.get() : 0;
        ArrayList result = Lists.newArrayList();
        for (Channel channel : channels) {
            ChannelAnalyzeDto dto = channelId2Dto.getOrDefault(channel.getId(), new ChannelAnalyzeDto(channel.getId()));
            Integer level1Count = channelId2Level1Count.getOrDefault(channel.getId(), 0);
            Map stage2Count = channel2Stage2Count.getOrDefault(dto.getChannelId(), Maps.newHashMap());
            Map mapItem = Object2MapUtils.object2Map(dto);
            mapItem.put("channelName", channelId2Name.getOrDefault(dto.getChannelId(), "\u4f01\u4e1a\u5fae\u4fe1"));
            mapItem.put("incrementCount", channelId2IncrementCount.getOrDefault(dto.getChannelId(), 0));
            mapItem.put("spreadRate", dto.getContactCount() == 0 ? 0 : (dto.getContactCount() - level1Count) * 10000 / dto.getContactCount());
            mapItem.put("reserveRate", dto.getContactCount() == 0 ? 0 : (dto.getContactCount() - channelId2DelCount.getOrDefault(dto.getChannelId(), 0)) * 10000 / dto.getContactCount());
            mapItem.put("shareRate", dto.getContactCount() == 0 ? 0 : dto.getEffectShareCount() * 10000 / dto.getContactCount());
            for (int i = maxStage; i >= 1; --i) {
                int count = stage2Count.getOrDefault(i, 0);
                ReachCountRate rate = new ReachCountRate();
                rate.setReachCount(count);
                rate.setReachRate(dto.getContactCount() == 0 ? 0 : count * 10000 / dto.getContactCount());
                mapItem.put("stage" + i, rate);
            }
            result.add(mapItem);
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> memberAnalyzeInfo(PlanStatisticsReq req) {
        log.info("channelAnalyzeInfo with req={}", (Object)req);
        req.validate();
        List marketingPlans = this.marketingPlanMapper.queryByNums((Collection)Lists.newArrayList((Object[])new String[]{req.getId()}));
        if (CollectionUtils.isEmpty((Collection)marketingPlans)) {
            return Lists.newArrayList();
        }
        MarketingPlan plan = (MarketingPlan)marketingPlans.get(0);
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        List list = this.marketingJoinMapper.queryMemberAnalyzeInfo(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime(), req.getPageDto());
        Set weworkUserNums = list.stream().map(a -> a.getWeworkUserNum()).collect(Collectors.toSet());
        Map weworkUserNum2Level2Count = this.marketingJoinMapper.queryWeworkUserNumLevel2Count(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime(), weworkUserNums);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        if (req.getPageDto() != null) {
            req.getPageDto().setCount(this.marketingJoinMapper.countMemberAnalyzeInfo(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime()));
            req.getPageDto().setCurPageCount(Integer.valueOf(list.size()));
        }
        List weworkUserDtos = this.weworkUserService.queryWeworkUserInfoByNums((List)Lists.newArrayList(weworkUserNums));
        Map<String, WeworkUserDto> weworkUser2Dto = weworkUserDtos.stream().collect(Collectors.toMap(a -> a.getWeworkNum(), a -> a));
        Map weworkUserNum2IncrementCount = this.marketingJoinMapper.queryWeworkUserContactIncrementCount(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime());
        Map weworkUser2Stage2Count = this.marketingRewardMapper.queryWeworkUserStageCount(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime());
        List rewardStages = this.marketingRewardStageMapper.queryFissionStages(currentUserInfo.getCorpId(), plan.getId(), null);
        Optional<Integer> stageOptional = rewardStages.stream().map(a -> a.getStage()).max(Integer::compareTo);
        int maxStage = stageOptional.isPresent() ? stageOptional.get() : 0;
        ArrayList result = Lists.newArrayList();
        for (MemberAnalyzeDto dto : list) {
            Map stage2Count = weworkUser2Stage2Count.getOrDefault(dto.getWeworkUserNum(), Maps.newHashMap());
            Map mapItem = Object2MapUtils.object2Map(dto);
            Integer level1Count = weworkUserNum2Level2Count.getOrDefault(dto.getWeworkUserNum(), 0);
            WeworkUserDto weworkUserDto = weworkUser2Dto.getOrDefault(dto.getWeworkUserNum(), new WeworkUserDto());
            mapItem.put("weworkUserName", weworkUserDto.getWeworkName());
            mapItem.put("weworkUserAvatar", weworkUserDto.getWeworkAvatar());
            mapItem.put("incrementCount", weworkUserNum2IncrementCount.getOrDefault(dto.getWeworkUserNum(), 0));
            mapItem.put("spreadRate", dto.getContactCount() == 0 ? 0 : (dto.getContactCount() - level1Count) * 10000 / dto.getContactCount());
            mapItem.put("shareRate", dto.getContactCount() == 0 ? 0 : dto.getEffectShareCount() * 10000 / dto.getContactCount());
            for (int i = maxStage; i >= 1; --i) {
                int count = stage2Count.getOrDefault(i, 0);
                ReachCountRate rate = new ReachCountRate();
                rate.setReachCount(count);
                rate.setReachRate(dto.getContactCount() == 0 ? 0 : count * 10000 / dto.getContactCount());
                mapItem.put("stage" + i, rate);
            }
            result.add(mapItem);
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> contactAnalyzeInfo(ContactAnalyzeReq req) {
        log.info("contactAnalyzeInfo with req={}", (Object)req);
        req.validate();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Long bizId = currentUserInfo.getBizId();
        List list = this.marketingJoinMapper.queryContactAnalyzeDto(currentUserInfo.getCorpId(), req.getId(), req.getContactQuery(), req.getStartTime(), req.getEndTime(), req.getPageDto());
        if (req.getPageDto() != null) {
            req.getPageDto().setCount(this.marketingJoinMapper.countContactAnalyzeDto(currentUserInfo.getCorpId(), req.getId(), req.getContactQuery(), req.getStartTime(), req.getEndTime()));
            req.getPageDto().setCurPageCount(Integer.valueOf(list.size()));
        }
        List contactIds = list.stream().map(a -> a.getContactId()).collect(Collectors.toList());
        List contactList = this.contactService.queryContactByContactIds(currentUserInfo.getCorpId(), contactIds);
        Map<String, WeworkContact> contactId2Entity = contactList.stream().collect(Collectors.toMap(a -> a.getContactId(), a -> a));
        Set contactWeworkPairs = list.stream().map(a -> new ContactWeworkNumPair(a.getWeworkUserNum(), a.getContactId())).collect(Collectors.toSet());
        List relations = this.weworkContactRelationMapper.queryContactRelationByPair(currentUserInfo.getCorpId(), contactWeworkPairs);
        Map<String, WeworkContactRelationDto> weworkUserNum2Relation = relations.stream().collect(Collectors.toMap(a -> StringUtils.join((Object[])new String[]{a.getWeworkUserNum(), a.getContactId()}, (String)"$$"), a -> a));
        List channelIds = list.stream().map(a -> a.getChannelId()).distinct().collect(Collectors.toList());
        Map<Long, String> channelId2Name = this.channelMapper.queryChannels(bizId, channelIds).stream().collect(Collectors.toMap(a -> a.getId(), a -> a.getName()));
        Map contactId2ShareCount = this.marketingJoinMapper.queryAvailableShareCount(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime(), Integer.valueOf(0), contactIds);
        Map contactId2MaxShareCount = this.marketingJoinMapper.queryAvailableShareCount(currentUserInfo.getCorpId(), req.getId(), null, null, Integer.valueOf(1), contactIds);
        Map contactId2Stage2Content = this.marketingRewardMapper.queryEveryStageReward(currentUserInfo.getCorpId(), req.getId(), req.getStartTime(), req.getEndTime(), contactIds);
        ArrayList result = Lists.newArrayList();
        for (ContactAnalyzeDto dto : list) {
            String key = StringUtils.join((Object[])new String[]{dto.getWeworkUserNum(), dto.getContactId()}, (String)"$$");
            WeworkContactRelationDto relationDto = weworkUserNum2Relation.get(key);
            WeworkContact weworkContact = contactId2Entity.getOrDefault(dto.getContactId(), new WeworkContact());
            dto.setContactAvatar(weworkContact.getAvatar());
            dto.setContactName(relationDto != null && StringUtils.isNotBlank((CharSequence)relationDto.getRemark()) ? relationDto.getRemark() : weworkContact.getName());
            dto.setChannelName(channelId2Name.getOrDefault(dto.getChannelId(), "\u4f01\u4e1a\u5fae\u4fe1"));
            dto.setEffectShareCount(contactId2ShareCount.getOrDefault(dto.getContactId(), 0));
            dto.setMaxShareCount(contactId2MaxShareCount.getOrDefault(dto.getContactId(), 0));
            Map mapItem = Object2MapUtils.object2Map(dto);
            if (relationDto != null) {
                if (relationDto.getIsZombieFans() == 1 || relationDto.getIsDeleted() == 1) {
                    mapItem.put("isAddFriend", 0);
                } else {
                    mapItem.put("isAddFriend", 1);
                }
            } else if (weworkContact != null && weworkContact.getIsDeleted() == 0) {
                mapItem.put("isAddFriend", 1);
            } else {
                mapItem.put("isAddFriend", 0);
            }
            Map stage2Content = contactId2Stage2Content.getOrDefault(dto.getContactId(), Maps.newHashMap());
            for (int i = 1; i <= 3; ++i) {
                String content = stage2Content.getOrDefault(i, "");
                mapItem.put("stage" + i + "Code", content);
            }
            result.add(mapItem);
        }
        return result;
    }

    @Override
    public List<ContactHelpDetailResp> contactHelpDetailList(ContactHelpDetailReq req) {
        log.info("contactHelpDetailList with req={}", (Object)req);
        req.validate();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        List list = this.marketingJoinMapper.queryContactHelpDetail(currentUserInfo.getCorpId(), req.getId(), req.getContactId(), req.getType(), req.getStartTime(), req.getEndTime(), req.getPageDto());
        if (req.getPageDto() != null) {
            req.getPageDto().setCurPageCount(Integer.valueOf(list.size()));
            req.getPageDto().setCount(this.marketingJoinMapper.countContactHelpDetail(currentUserInfo.getCorpId(), req.getId(), req.getContactId(), req.getType(), req.getStartTime(), req.getEndTime()));
        }
        Set contactWeworkPairs = list.stream().map(a -> new ContactWeworkNumPair(a.getWeworkUserNum(), a.getContactId())).collect(Collectors.toSet());
        List relations = this.weworkContactRelationMapper.queryContactRelationByPair(currentUserInfo.getCorpId(), contactWeworkPairs);
        Map<String, WeworkContactRelationDto> weworkUserNum2Relation = relations.stream().collect(Collectors.toMap(a -> StringUtils.join((Object[])new String[]{a.getWeworkUserNum(), a.getContactId()}, (String)"$$"), a -> a));
        List contactIds = list.stream().map(a -> a.getContactId()).distinct().collect(Collectors.toList());
        Map<String, WeworkContact> contactId2Entity = this.contactService.queryContactByContactIds(currentUserInfo.getCorpId(), contactIds).stream().collect(Collectors.toMap(a -> a.getContactId(), a -> a));
        ArrayList result = Lists.newArrayList();
        for (ContactHelpDetailDto dto : list) {
            String key = StringUtils.join((Object[])new String[]{dto.getWeworkUserNum(), dto.getContactId()}, (String)"$$");
            WeworkContactRelationDto relationDto = weworkUserNum2Relation.get(key);
            ContactHelpDetailResp item = new ContactHelpDetailResp();
            WeworkContact contact = contactId2Entity.getOrDefault(dto.getContactId(), new WeworkContact());
            item.setContactAvatar(contact.getAvatar());
            item.setContactName(relationDto != null && StringUtils.isNotBlank((CharSequence)relationDto.getRemark()) ? relationDto.getRemark() : contact.getName());
            item.setContactId(dto.getContactId());
            item.setAddFriendTime(dto.getAddFriendTime());
            if (relationDto != null && (relationDto.getIsZombieFans() == 1 || relationDto.getIsDeleted() == 1)) {
                item.setIsAddFriend(0);
            } else {
                item.setIsAddFriend(1);
            }
            result.add(item);
        }
        return result;
    }

    @Override
    public void exportChannelAnalyzeInfo(PlanStatisticsReq params, HttpServletResponse response) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("exportChannelAnalyzeInfo,params:{}, operatorId:{}, corpId:{}", new Object[]{params, currentUser.getId(), currentUser.getCorpId()});
        params.validate();
        MarketingPlan marketingPlan = this.marketingPlanMapper.selectByNum(params.getId());
        Preconditions.checkArgument((boolean)Objects.nonNull(marketingPlan), (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        List<Map<String, Object>> dataList = this.channelAnalyzeInfo(params);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("\u6e20\u9053\u5206\u6790");
        this.addHeader(workbook, sheet, this.CHANNEL_ANALYZE_HEADER);
        HSSFCellStyle hssfCellStyle = workbook.createCellStyle();
        hssfCellStyle.setAlignment(HorizontalAlignment.LEFT);
        int rowNum = 1;
        int spreadRate = 0;
        int reserveRate = 0;
        int shareRate = 0;
        for (Map<String, Object> data : dataList) {
            HSSFRow row = sheet.createRow(rowNum);
            row.createCell(0).setCellValue((String)data.get("channelName"));
            HSSFCell hssfCell = row.createCell(1);
            hssfCell.setCellStyle(hssfCellStyle);
            hssfCell.setCellValue(Objects.nonNull(data.get("contactCount")) ? (double)((Integer)data.get("contactCount")).intValue() : 0.0);
            hssfCell = row.createCell(2);
            hssfCell.setCellStyle(hssfCellStyle);
            hssfCell.setCellValue(Objects.nonNull(data.get("incrementCount")) ? (double)((Integer)data.get("incrementCount")).intValue() : 0.0);
            hssfCell = row.createCell(3);
            hssfCell.setCellStyle(hssfCellStyle);
            hssfCell.setCellValue(Objects.nonNull(data.get("effectShareCount")) ? (double)((Integer)data.get("effectShareCount")).intValue() : 0.0);
            if (Objects.nonNull(data.get("spreadRate"))) {
                spreadRate = (Integer)data.get("spreadRate");
            }
            if (spreadRate == 0) {
                row.createCell(4).setCellValue(0.0);
            } else if (spreadRate % 100 == 0) {
                row.createCell(4).setCellValue(spreadRate / 100 + "%");
            } else {
                row.createCell(4).setCellValue((float)spreadRate / 100.0f + "%");
            }
            if (Objects.nonNull(data.get("reserveRate"))) {
                reserveRate = (Integer)data.get("reserveRate");
            }
            if (reserveRate == 0) {
                row.createCell(5).setCellValue(0.0);
            } else if (reserveRate % 100 == 0) {
                row.createCell(5).setCellValue(reserveRate / 100 + "%");
            } else {
                row.createCell(5).setCellValue((float)reserveRate / 100.0f + "%");
            }
            if (Objects.nonNull(data.get("shareRate"))) {
                shareRate = (Integer)data.get("shareRate");
            }
            if (shareRate == 0) {
                row.createCell(6).setCellValue(0.0);
            } else if (shareRate % 100 == 0) {
                row.createCell(6).setCellValue(shareRate / 100 + "%");
            } else {
                row.createCell(6).setCellValue((float)shareRate / 100.0f + "%");
            }
            for (int i = 1; i <= 3; ++i) {
                Object stage = data.get("stage" + i);
                if (Objects.nonNull(stage)) {
                    ReachCountRate rate = (ReachCountRate)stage;
                    int reachCount = rate.getReachCount() != null ? rate.getReachCount() : 0;
                    String reachRate = "0";
                    if (rate.getReachRate() != 0) {
                        reachRate = rate.getReachRate() % 100 == 0 ? rate.getReachRate() / 100 + "%" : (float)rate.getReachRate().intValue() / 100.0f + "%";
                    }
                    row.createCell(6 + i).setCellValue(reachCount + "/" + reachRate);
                    continue;
                }
                row.createCell(6 + i).setCellValue("0/0");
            }
            ++rowNum;
        }
        String fileName = marketingPlan.getName() + "_\u6e20\u9053\u5206\u6790.xls";
        this.setDownloadResponse((Workbook)workbook, response, fileName);
    }

    @Override
    public void exportContactAnalyzeInfo(ContactAnalyzeReq params, HttpServletResponse response) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("exportContactAnalyzeInfo,params:{}, operatorId:{}, corpId:{}", new Object[]{params, currentUser.getId(), currentUser.getCorpId()});
        params.validate();
        MarketingPlan marketingPlan = this.marketingPlanMapper.selectByNum(params.getId());
        Preconditions.checkArgument((boolean)Objects.nonNull(marketingPlan), (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        List<Map<String, Object>> dataList = this.contactAnalyzeInfo(params);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("\u5ba2\u6237\u5206\u6790");
        this.addHeader(workbook, sheet, this.CONTACT_ANALYZE_HEADER);
        HSSFCellStyle hssfCellStyle = workbook.createCellStyle();
        hssfCellStyle.setAlignment(HorizontalAlignment.LEFT);
        int rowNum = 1;
        for (Map<String, Object> data : dataList) {
            HSSFRow row = sheet.createRow(rowNum);
            row.setRowStyle(hssfCellStyle);
            row.createCell(0).setCellValue((String)data.get("contactName"));
            HSSFCell hssfCell = row.createCell(1);
            hssfCell.setCellStyle(hssfCellStyle);
            hssfCell.setCellValue(Objects.nonNull(data.get("level")) ? (double)((Integer)data.get("level")).intValue() : 0.0);
            hssfCell = row.createCell(2);
            hssfCell.setCellStyle(hssfCellStyle);
            hssfCell.setCellValue(Objects.nonNull(data.get("effectShareCount")) ? (double)((Integer)data.get("effectShareCount")).intValue() : 0.0);
            hssfCell = row.createCell(3);
            hssfCell.setCellStyle(hssfCellStyle);
            hssfCell.setCellValue(Objects.nonNull(data.get("maxShareCount")) ? (double)((Integer)data.get("maxShareCount")).intValue() : 0.0);
            hssfCell = row.createCell(4);
            hssfCell.setCellStyle(hssfCellStyle);
            hssfCell.setCellValue(Objects.nonNull(data.get("reachStage")) ? (double)((Integer)data.get("reachStage")).intValue() : 0.0);
            int isAddFriend = (Integer)data.get("isAddFriend");
            row.createCell(5).setCellValue(isAddFriend == 1 ? "\u662f" : "\u5426");
            row.createCell(6).setCellValue((String)data.get("channelName"));
            for (int i = 1; i <= 3; ++i) {
                String code = (String)data.get("stage" + i + "Code");
                row.createCell(6 + i).setCellValue(code);
            }
            ++rowNum;
        }
        String fileName = marketingPlan.getName() + "_\u5ba2\u6237\u5206\u6790.xls";
        this.setDownloadResponse((Workbook)workbook, response, fileName);
    }

    private void addHeader(HSSFWorkbook workbook, HSSFSheet sheet, String[] header) {
        HSSFRow row = sheet.createRow(0);
        row.setZeroHeight(false);
        row.setHeight((short)360);
        HSSFCellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFFont headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)12);
        headerCellStyle.setFont((Font)headerFont);
        for (int i = 0; i < header.length; ++i) {
            sheet.setColumnWidth(i, 6400);
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(headerCellStyle);
            HSSFRichTextString text = new HSSFRichTextString(header[i]);
            cell.setCellValue((RichTextString)text);
        }
    }

    private void setDownloadResponse(Workbook workbook, HttpServletResponse response, String fileName) {
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.flushBuffer();
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

