/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.friendFission.service.impl;

import cn.kinyun.scrm.page.auth.dto.WoauthUserDto;
import cn.kinyun.scrm.page.auth.utils.MpLoginUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.dal.marketing.dto.ContactBoostDetailDto;
import com.kuaike.scrm.dal.marketing.dto.ContactHelpDetailDto;
import com.kuaike.scrm.dal.marketing.entity.MarketingAddFriendLog;
import com.kuaike.scrm.dal.marketing.entity.MarketingBounsCodeSub;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.entity.MarketingJoin;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.MarketingQrcode;
import com.kuaike.scrm.dal.marketing.entity.MarketingReward;
import com.kuaike.scrm.dal.marketing.entity.MarketingRewardStage;
import com.kuaike.scrm.dal.marketing.entity.MarketingTagRuleLog;
import com.kuaike.scrm.dal.marketing.mapper.MarketingAddFriendLogMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingJoinMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingQrcodeMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingRewardMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingRewardStageMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingTagRuleItemMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingTagRuleLogMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworkTag.mapper.WeworkTagMapper;
import com.kuaike.scrm.friendFission.dto.BillboardResultDto;
import com.kuaike.scrm.friendFission.dto.CreateBillboardReqDto;
import com.kuaike.scrm.friendFission.dto.FissionBillboardDto;
import com.kuaike.scrm.friendFission.dto.FissionStageReqDto;
import com.kuaike.scrm.friendFission.dto.FissionSwitchDto;
import com.kuaike.scrm.friendFission.dto.resp.FessionInviteStage;
import com.kuaike.scrm.friendFission.dto.resp.FissionBoostRespDto;
import com.kuaike.scrm.friendFission.dto.resp.FissionContactRespDto;
import com.kuaike.scrm.friendFission.dto.resp.FissionInviteInfoRespDto;
import com.kuaike.scrm.friendFission.dto.resp.FissionStageRewardRespDto;
import com.kuaike.scrm.friendFission.dto.resp.InfoRespDto;
import com.kuaike.scrm.friendFission.service.FissionPlanService;
import com.kuaike.scrm.friendFission.service.FriendFissionClientService;
import com.kuaike.scrm.marketing.dto.BounsAwardReqDto;
import com.kuaike.scrm.marketing.dto.client.ClientParamsDto;
import com.kuaike.scrm.marketing.service.MarketingBounsService;
import com.kuaike.scrm.marketing.service.MarketingChannelService;
import com.kuaike.scrm.marketing.service.MarketingConfigService;
import com.kuaike.scrm.remind.service.RemindService;
import com.kuaike.scrm.wework.contact.dto.ModifyTagDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FriendFissionClientServiceImpl
implements FriendFissionClientService {
    private static final Logger log = LoggerFactory.getLogger(FriendFissionClientServiceImpl.class);
    @Autowired
    private MarketingPlanMapper marketingPlanMapper;
    @Autowired
    private MarketingChannelMapper marketingChannelMapper;
    @Autowired
    private MarketingQrcodeMapper marketingQrcodeMapper;
    @Autowired
    private FissionPlanService fissionPlanService;
    @Autowired
    private MarketingJoinMapper marketingJoinMapper;
    @Autowired
    private MarketingConfigService marketingConfigService;
    @Autowired
    private MarketingRewardMapper rewardMapper;
    @Autowired
    private MarketingRewardStageMapper rewardStageMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private MarketingChannelService marketingChannelService;
    @Autowired
    private MarketingBounsService marketingBounsService;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private RemindService remindService;
    @Autowired
    private MarketingTagRuleItemMapper tagRuleItemMapper;
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private ContactOpService contactOpService;
    @Autowired
    private MarketingTagRuleLogMapper tagRuleLogMapper;
    @Autowired
    private MarketingAddFriendLogMapper addFriendLogMapper;
    private Random random = new Random();

    private MarketingChannel getMarketingChannel(ClientParamsDto params) {
        String num = params.getId();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)num), (Object)"\u6d3b\u52a8id\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        WoauthUserDto userDto = MpLoginUtil.getCurrentUser();
        log.info("getInviteInfo userDto: {}, params: {}", (Object)userDto, (Object)params);
        if (StringUtils.isNotBlank((CharSequence)userDto.getUserId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u6210\u5458\u4e0d\u53ef\u53c2\u4e0e\u6d3b\u52a8");
        }
        MarketingChannel marketingChannel = this.marketingChannelService.getMarketingChannel(num);
        if (marketingChannel == null || marketingChannel.getIsDeleted() == 1) {
            log.info("getInviteInfo: \u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u8005\u5220\u9664");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u8005\u5220\u9664");
        }
        return marketingChannel;
    }

    @Override
    public InfoRespDto info(ClientParamsDto params) {
        WoauthUserDto user = MpLoginUtil.getCurrentUser();
        log.info("getInfo, params={}, user={}", (Object)params, (Object)user);
        String num = params.getId();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)num), (Object)"\u6d3b\u52a8id\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        MarketingChannel channel = this.marketingChannelService.getMarketingChannel(num);
        if (channel == null || channel.getIsDeleted() == 1) {
            log.info("getInviteInfo: \u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u8005\u5220\u9664");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u8005\u5220\u9664");
        }
        Long channelId = channel.getChannelId();
        Long planId = channel.getPlanId();
        String corpId = channel.getCorpId();
        MarketingPlan plan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)planId);
        if (plan == null || plan.getIsDeleted() == 1 || plan.getIsDraft() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        InfoRespDto result = new InfoRespDto();
        result.setTitle(plan.getName());
        result.setEndTime(plan.getEndTime());
        Date now = new Date();
        if (plan.getEndTime() != null && now.after(plan.getEndTime()) && plan.getStatus() == 1) {
            plan.setStatus(Integer.valueOf(2));
            plan.setUpdateTime(now);
            this.marketingPlanMapper.updateByPrimaryKeySelective((Object)plan);
        }
        if (StringUtils.isNotBlank((CharSequence)user.getUserId())) {
            result.setIsMember(1);
            result.setIsFriend(0);
            log.info("\u4f01\u4e1a\u6210\u5458\u4e0d\u53ef\u626b\u7801\u53c2\u4e0e\u6d3b\u52a8, planId:{}, corpId:{}, userId:{}", new Object[]{planId, corpId, user.getUserId()});
            return result;
        }
        result.setIsMember(0);
        if (plan.getIsEnabled() != 0 && plan.getStatus() == 1) {
            result.setIsActive(1);
        } else {
            result.setIsActive(0);
        }
        if (StringUtils.isBlank((CharSequence)user.getExternalUserId())) {
            result.setIsFriend(0);
            MarketingQrcode qrcode = this.marketingQrcodeMapper.queryFriendFissionQrcode(planId, channelId);
            if (qrcode != null && StringUtils.isNotBlank((CharSequence)qrcode.getQrCodeUrl())) {
                result.setQrcode(qrcode.getQrCodeUrl());
            } else {
                log.warn("\u6e20\u9053\u4e8c\u7ef4\u7801\u4e0d\u5b58\u5728, planId:{}, channelId:{}", (Object)planId, (Object)channelId);
            }
        } else {
            result.setIsFriend(1);
            result.setContactName(user.getName());
            result.setContactAvatar(user.getAvatar());
            String contactId = user.getExternalUserId();
            MarketingJoin join = this.marketingJoinMapper.selectByCorpIdPlanIdAndContactId(corpId, planId, contactId);
            if (join == null) {
                result.setRank(null);
            } else {
                Long id = join.getId();
                Integer addCount = join.getAddCount();
                Integer rank = this.marketingJoinMapper.queryRank(planId, id, addCount);
                result.setRank(rank);
                if (result.getIsActive() == 1 && this.runoutReward(corpId, planId, contactId)) {
                    log.info("\u6d3b\u52a8\u5269\u4f59\u5956\u52b1\u6570\u91cf\u4e3a0\uff0c\u6d3b\u52a8\u72b6\u6001\u6807\u8bb0\u4e3a\u5df2\u7ed3\u675f\u3002");
                    result.setIsActive(0);
                }
            }
        }
        return result;
    }

    private boolean runoutReward(String corpId, Long planId, String contactId) {
        List rewardList = this.rewardMapper.getRewardList(corpId, planId, contactId);
        if (CollectionUtils.isEmpty((Collection)rewardList)) {
            return false;
        }
        int remainCount = 0;
        Map stageCountMap = this.rewardMapper.getReceiveStageRewardCountByPlanId(planId);
        for (MarketingReward it : rewardList) {
            int count = stageCountMap.getOrDefault(it.getStage(), 0);
            count = it.getRewardCount() - count;
            if (count <= 0) continue;
            remainCount += count;
        }
        return remainCount == 0;
    }

    @Override
    public String getBillBoard(ClientParamsDto params) {
        log.info("getBillBoard,params:{}", (Object)params);
        WoauthUserDto user = MpLoginUtil.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(user), (Object)"\u7528\u6237\u672a\u6388\u6743,\u6682\u4e0d\u80fd\u83b7\u53d6\u4e13\u5c5e\u6d77\u62a5");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getExternalUserId()), (Object)"\u5ba2\u6237id\u4e3a\u7a7a,\u6682\u4e0d\u80fd\u83b7\u53d6\u4e13\u5c5e\u6d77\u62a5");
        String num = params.getId();
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)num) ? 1 : 0) != 0, (Object)"\u6d3b\u52a8id\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        MarketingChannel channel = this.marketingChannelMapper.getByNum(num);
        if (channel == null || channel.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        Long channelId = channel.getChannelId();
        Long planId = channel.getPlanId();
        String corpId = channel.getCorpId();
        MarketingPlan plan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)planId);
        if (plan == null || plan.getIsDeleted() == 1 || plan.getIsDraft() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        String billboardUrl = this.marketingJoinMapper.selectBgResultUrlByCorpIdPlanIdAndContactId(corpId, planId, user.getExternalUserId());
        if (StringUtils.isNotBlank((CharSequence)billboardUrl)) {
            return billboardUrl;
        }
        CreateBillboardReqDto createBillboardReqDto = new CreateBillboardReqDto();
        createBillboardReqDto.setModel(2);
        createBillboardReqDto.setMarketingPlan(plan);
        createBillboardReqDto.setContactId(user.getExternalUserId());
        createBillboardReqDto.setChannelId(channelId);
        List<FissionBillboardDto> fissionBillboardDtos = this.marketingConfigService.getBillboardConfig(corpId, planId);
        FissionBillboardDto fissionBillboardDto = fissionBillboardDtos.get(this.random.nextInt(fissionBillboardDtos.size()));
        createBillboardReqDto.setFissionBillboardDto(fissionBillboardDto);
        try {
            BillboardResultDto billboardResultDto = this.fissionPlanService.createBillboard(createBillboardReqDto);
            return billboardResultDto.getPicUrl();
        }
        catch (Exception ex) {
            log.info("billboardResultDto:{}\u751f\u6210\u4e13\u5c5e\u6d77\u62a5\u5931\u8d25:", (Object)createBillboardReqDto, (Object)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u4e13\u5c5e\u6d77\u62a5\u5931\u8d25");
        }
    }

    @Override
    public FissionInviteInfoRespDto getInviteInfo(ClientParamsDto params) {
        WoauthUserDto userDto = MpLoginUtil.getCurrentUser();
        log.info("getInviteInfo userDto: {}, params: {}", (Object)userDto, (Object)params);
        MarketingChannel marketingChannel = this.getMarketingChannel(params);
        Long planId = marketingChannel.getPlanId();
        String corpId = marketingChannel.getCorpId();
        log.info("getInviteInfo get planId: {}, corpId\uff1a{}", (Object)planId, (Object)corpId);
        if (StringUtils.isBlank((CharSequence)userDto.getExternalUserId())) {
            log.info("getInviteInfo contactId is null ");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0d\u662f\u5916\u90e8\u8054\u7cfb\u4eba\uff0c\u8bf7\u5148\u626b\u7801\u52a0\u597d\u53cb");
        }
        Integer inviteCount = this.marketingJoinMapper.queryCountContact(corpId, userDto.getExternalUserId(), planId);
        log.info("getInviteInfo get inviteCount: {}", (Object)inviteCount);
        if (Objects.isNull(inviteCount)) {
            inviteCount = 0;
        }
        Integer reachStage = 0;
        Integer needInviteCount = 0;
        ArrayList inviteStages = Lists.newArrayList();
        List rewards = this.rewardMapper.getRewardList(corpId, planId, userDto.getExternalUserId());
        log.info("getInviteInfo rewards: {}", (Object)rewards);
        if (CollectionUtils.isNotEmpty((Collection)rewards)) {
            for (Object reward : rewards) {
                int remindCount;
                FessionInviteStage inviteStage = new FessionInviteStage();
                inviteStage.setStage(reward.getStage());
                inviteStage.setInviteTotal(reward.getInviteCount());
                inviteStage.setRewardTotal(reward.getRewardCount());
                inviteStage.setIsDone(reward.getIsReach());
                inviteStage.setIsOpen(reward.getIsReceive());
                Integer rewardCount = this.rewardMapper.queryReceiveNumByType(corpId, planId, reward.getStage());
                log.info("getInviteInfo planId: {}, RewardType: {}, Stage: {}, rewardCount: {}", new Object[]{planId, reward.getRewardType(), reward.getStage(), rewardCount});
                if (Objects.isNull(rewardCount)) {
                    rewardCount = 0;
                }
                if ((remindCount = reward.getRewardCount() - rewardCount) < 0) {
                    remindCount = 0;
                }
                inviteStage.setRemainCount(remindCount);
                if (inviteCount >= reward.getInviteCount()) {
                    reachStage = reward.getStage();
                } else if (needInviteCount == 0) {
                    needInviteCount = reward.getInviteCount() - inviteCount;
                }
                inviteStages.add(inviteStage);
            }
        } else {
            List rewardStages = this.rewardStageMapper.getRewarrdStage(corpId, planId);
            if (CollectionUtils.isNotEmpty((Collection)rewardStages)) {
                for (MarketingRewardStage rewardStage : rewardStages) {
                    int remindCount;
                    FessionInviteStage inviteStage = new FessionInviteStage();
                    inviteStage.setStage(rewardStage.getStage());
                    inviteStage.setInviteTotal(rewardStage.getInviteCount());
                    inviteStage.setRewardTotal(rewardStage.getRewardCount());
                    inviteStage.setIsDone(0);
                    inviteStage.setIsOpen(0);
                    Integer rewardCount = this.rewardMapper.queryReceiveNumByType(corpId, planId, rewardStage.getStage());
                    log.info("getInviteInfo planId: {}, RewardType: {}, Stage: {}, rewardCount: {}", new Object[]{planId, rewardStage.getType(), rewardStage.getStage(), rewardCount});
                    if (Objects.isNull(rewardCount)) {
                        rewardCount = 0;
                    }
                    if ((remindCount = rewardStage.getRewardCount() - rewardCount) < 0) {
                        remindCount = 0;
                    }
                    inviteStage.setRemainCount(remindCount);
                    inviteStages.add(inviteStage);
                    if (needInviteCount != 0) continue;
                    needInviteCount = rewardStage.getInviteCount();
                }
            } else {
                log.info("getInviteInfo rewardStages is null");
            }
        }
        MarketingPlan plan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)planId);
        if (plan == null || plan.getIsDeleted() == 1 || plan.getIsDraft() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        String customerReply = plan.getCustomizeReply();
        if (StringUtils.isNotBlank((CharSequence)customerReply) && customerReply.contains("${count}")) {
            customerReply = customerReply.replace("${count}", "" + needInviteCount);
        }
        FissionInviteInfoRespDto respDto = new FissionInviteInfoRespDto();
        respDto.setReachStage(reachStage);
        respDto.setInviteCount(inviteCount);
        respDto.setNeedInviteCount(needInviteCount);
        respDto.setStageInfo(inviteStages);
        respDto.setCustomerReply(customerReply);
        log.info("getInviteInfo get respDto: {}", (Object)respDto);
        return respDto;
    }

    @Override
    public List<FissionContactRespDto> getFissionContactList(ClientParamsDto params) {
        WoauthUserDto userDto = MpLoginUtil.getCurrentUser();
        log.info("getFissionContactList userDto: {}, params: {}", (Object)userDto, (Object)params);
        MarketingChannel marketingChannel = this.getMarketingChannel(params);
        Long planId = marketingChannel.getPlanId();
        String corpId = marketingChannel.getCorpId();
        log.info("getFissionContactList get planId: {}, corpId\uff1a{}", (Object)planId, (Object)corpId);
        if (StringUtils.isBlank((CharSequence)userDto.getExternalUserId())) {
            log.info("getInviteInfo contactId is null ");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0d\u662f\u5916\u90e8\u8054\u7cfb\u4eba\uff0c\u8bf7\u5148\u626b\u7801\u52a0\u597d\u53cb");
        }
        List contactHelpDetailDtos = this.marketingJoinMapper.queryContactDetails(corpId, userDto.getExternalUserId(), planId);
        if (CollectionUtils.isEmpty((Collection)contactHelpDetailDtos)) {
            log.info("getFissionContactList contactHelpDetailDtos is empty");
            return Collections.emptyList();
        }
        Set contactIds = contactHelpDetailDtos.stream().map(ContactHelpDetailDto::getContactId).collect(Collectors.toSet());
        log.info("getFissionContactList get contactIds: {}", contactIds);
        Map<String, WeworkContact> marketingContactMap = null;
        if (CollectionUtils.isNotEmpty(contactIds)) {
            List weworkContacts = this.weworkContactMapper.selectByCorpIdAndContactIds(corpId, contactIds);
            log.info("getFissionContactList get weworkContacts: {}", (Object)weworkContacts);
            if (CollectionUtils.isNotEmpty((Collection)weworkContacts)) {
                marketingContactMap = weworkContacts.stream().collect(Collectors.toMap(WeworkContact::getContactId, a -> a));
            } else {
                log.info("getFissionContactList weworkContacts is empty");
            }
        }
        ArrayList respDtos = Lists.newArrayList();
        if (Objects.nonNull(marketingContactMap)) {
            for (ContactHelpDetailDto detailDto : contactHelpDetailDtos) {
                FissionContactRespDto respDto = new FissionContactRespDto();
                WeworkContact contact = marketingContactMap.get(detailDto.getContactId());
                if (Objects.nonNull(contact)) {
                    respDto.setContactName(contact.getName());
                    respDto.setContactAvatar(contact.getAvatar());
                    respDto.setAddFriendTime(detailDto.getAddFriendTime());
                }
                respDtos.add(respDto);
            }
        } else {
            log.info("getFissionContactList marketingContactMap is null ");
        }
        log.info("getFissionContactList get respDtos: {}", (Object)respDtos);
        return respDtos;
    }

    @Override
    public List<FissionBoostRespDto> getFissionBoostList(ClientParamsDto params) {
        WoauthUserDto userDto = MpLoginUtil.getCurrentUser();
        log.info("getFissionBoostList userDto: {}, params: {}", (Object)userDto, (Object)params);
        MarketingChannel marketingChannel = this.getMarketingChannel(params);
        Long planId = marketingChannel.getPlanId();
        String corpId = marketingChannel.getCorpId();
        log.info("getFissionBoostList get planId: {}, corpId\uff1a{}", (Object)planId, (Object)corpId);
        List boostDetailDtos = this.marketingJoinMapper.queryBosstList(corpId, planId);
        if (CollectionUtils.isEmpty((Collection)boostDetailDtos)) {
            return Collections.emptyList();
        }
        Set contactIds = boostDetailDtos.stream().map(ContactBoostDetailDto::getContactId).collect(Collectors.toSet());
        log.info("getFissionBoostList get contactIDs: {}", contactIds);
        Map<String, WeworkContact> marketingContactMap = null;
        if (CollectionUtils.isNotEmpty(contactIds)) {
            List weworkContacts = this.weworkContactMapper.selectByCorpIdAndContactIds(corpId, contactIds);
            log.info("getFissionBoostList get weworkContacts: {}", (Object)weworkContacts);
            if (CollectionUtils.isNotEmpty((Collection)weworkContacts)) {
                marketingContactMap = weworkContacts.stream().collect(Collectors.toMap(WeworkContact::getContactId, a -> a));
            } else {
                log.info("getFissionBoostList weworkContacts is empty");
            }
        }
        ArrayList respDtos = Lists.newArrayList();
        if (Objects.nonNull(marketingContactMap)) {
            for (ContactBoostDetailDto detailDto : boostDetailDtos) {
                FissionBoostRespDto respDto = new FissionBoostRespDto();
                WeworkContact contact = marketingContactMap.get(detailDto.getContactId());
                if (Objects.nonNull(contact)) {
                    respDto.setContactName(contact.getName());
                    respDto.setContactAvatar(contact.getAvatar());
                }
                respDto.setJoinCount(detailDto.getAddCount());
                respDtos.add(respDto);
            }
        } else {
            log.info("getFissionBoostList marketingContactMap is null ");
        }
        log.info("getFissionBoostList get respDtos: {}", (Object)respDtos);
        return respDtos;
    }

    @Override
    public FissionStageRewardRespDto getStageReward(FissionStageReqDto reqDto) {
        WoauthUserDto userDto = MpLoginUtil.getCurrentUser();
        log.info("getStageReward userDto: {}, params: {}", (Object)userDto, (Object)reqDto);
        Preconditions.checkArgument((boolean)Objects.nonNull(reqDto.getStage()), (Object)"\u9636\u6bb5ID\u4e0d\u80fd\u4e3a\u7a7a");
        MarketingChannel marketingChannel = this.getMarketingChannel(reqDto);
        Long planId = marketingChannel.getPlanId();
        String corpId = marketingChannel.getCorpId();
        log.info("getStageReward get planId: {}, corpId\uff1a{}", (Object)planId, (Object)corpId);
        if (StringUtils.isBlank((CharSequence)userDto.getExternalUserId())) {
            log.info("getStageReward contactId is null ");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0d\u662f\u5916\u90e8\u8054\u7cfb\u4eba\uff0c\u8bf7\u5148\u626b\u7801\u52a0\u597d\u53cb");
        }
        MarketingReward reward = this.rewardMapper.getReward(corpId, planId, userDto.getExternalUserId(), reqDto.getStage());
        log.info("getStageReward reward: {}", (Object)reward);
        FissionStageRewardRespDto respDto = new FissionStageRewardRespDto();
        if (Objects.nonNull(reward)) {
            respDto.setType(reward.getRewardType());
            if (reward.getIsReceive() == 1) {
                switch (reward.getRewardType()) {
                    case 1: {
                        respDto.setUrl(reward.getContent());
                        break;
                    }
                    case 2: {
                        respDto.setContent(reward.getContent());
                        respDto.setCode(reward.getRewardCode());
                        break;
                    }
                }
            } else {
                Integer rewardCount = this.rewardMapper.queryReceiveNumByType(corpId, planId, reward.getStage());
                log.info("getStageReward planId: {}, RewardType: {}, Stage: {}, rewardCount: {}", new Object[]{planId, reward.getRewardType(), reward.getStage(), rewardCount});
                if (Objects.isNull(rewardCount)) {
                    rewardCount = 0;
                }
                int remindCount = reward.getRewardCount() - rewardCount;
                log.info("getStageReward reward remindCount: {}, planId: {},  Stage: {}", new Object[]{remindCount, planId, reward.getStage()});
                if (remindCount > 0) {
                    switch (reward.getRewardType()) {
                        case 1: {
                            respDto.setUrl(reward.getContent());
                            this.rewardMapper.updateRewardInfo(corpId, planId, userDto.getExternalUserId(), reward.getStage(), null);
                            break;
                        }
                        case 2: {
                            String contactId = userDto.getExternalUserId();
                            WeworkContact contact = this.weworkContactMapper.selectByCorpIdAndContactId(corpId, contactId);
                            log.info("getStageReward get contact: {}", (Object)contact);
                            if (!Objects.nonNull(contact)) break;
                            BounsAwardReqDto bounsAwardReqDto = new BounsAwardReqDto();
                            bounsAwardReqDto.setBounsId(reward.getCodeId());
                            bounsAwardReqDto.setContactName(contact.getName());
                            bounsAwardReqDto.setContactId(contactId);
                            bounsAwardReqDto.setMarketingType(0);
                            bounsAwardReqDto.setMarketingId(reward.getPlanId());
                            MarketingBounsCodeSub bounsCodeSub = this.marketingBounsService.getBounsCode(bounsAwardReqDto, corpId);
                            log.info("getStageReward bounsCodeSub: {}", (Object)bounsCodeSub);
                            String bounsCodeContent = "";
                            respDto.setContent(reward.getContent());
                            if (Objects.nonNull(bounsCodeSub)) {
                                bounsCodeContent = bounsCodeSub.getContent();
                                respDto.setCode(bounsCodeContent);
                            }
                            this.rewardMapper.updateRewardInfo(corpId, planId, userDto.getExternalUserId(), reward.getStage(), bounsCodeContent);
                            break;
                        }
                    }
                }
            }
        }
        this.fissionPlanService.checkUpdatePlanStatus(planId);
        log.info("getStageReward get respDto: {}", (Object)respDto);
        return respDto;
    }

    @Override
    public String qrInfo(ClientParamsDto params) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"id\u4e0d\u80fd\u4e3a\u7a7a");
        MarketingJoin marketingJoin = new MarketingJoin();
        marketingJoin.setNum(params.getId());
        marketingJoin = (MarketingJoin)this.marketingJoinMapper.selectOne((Object)marketingJoin);
        if (marketingJoin != null) {
            return marketingJoin.getQrcodeUrl();
        }
        return null;
    }

    @Override
    public void success(ClientParamsDto reqDto) {
        boolean isFissionSuccess;
        boolean isNewCustomer;
        log.info("success reqDto: {}", (Object)reqDto);
        WoauthUserDto user = MpLoginUtil.getCurrentUser();
        String num = reqDto.getId();
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)num) ? 1 : 0) != 0, (Object)"id\u4e0d\u80fd\u4e3a\u7a7a");
        MarketingJoin query = new MarketingJoin();
        query.setNum(num);
        MarketingJoin join = (MarketingJoin)this.marketingJoinMapper.selectOne((Object)query);
        if (join == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "id\u4e0d\u5b58\u5728\uff0c\u8bf7\u4f20\u6b63\u786e\u7684id");
        }
        MarketingPlan plan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)join.getPlanId());
        if (plan == null || plan.getIsDeleted() == 1 || plan.getIsDraft() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        String state = join.getQrcodeState();
        if (!StringUtils.isBlank((CharSequence)state)) {
            MarketingQrcode marketingQrcode = new MarketingQrcode();
            marketingQrcode.setBizId(user.getBizId());
            marketingQrcode.setCorpId(user.getCorpId());
            marketingQrcode.setState(state);
            marketingQrcode = (MarketingQrcode)this.marketingQrcodeMapper.selectOne((Object)marketingQrcode);
            if (marketingQrcode != null && marketingQrcode.getIsDeleted() != 0) {
                return;
            }
            if (this.isMarketingEndTime(plan) || this.isMarketingNoReward(plan)) {
                if (plan.getStatus() == 1) {
                    plan.setStatus(Integer.valueOf(2));
                    plan.setUpdateTime(new Date());
                    this.marketingPlanMapper.updateByPrimaryKeySelective((Object)plan);
                }
                return;
            }
            if (plan.getIsDraft() == 1 || plan.getIsDeleted() == 1 || plan.getIsEnabled() == 0 || plan.getStatus() == 2) {
                return;
            }
        }
        if (plan.getType() == null || plan.getType().intValue() != PlanType.FRIEND_FISSION_PLAN.getValue()) {
            return;
        }
        String pContactId = join.getContactId();
        String contactId = user.getExternalUserId();
        if (join.getContactId().equals(contactId)) {
            log.info("\u52a9\u529b\u4e0d\u6210\u529f2:{}", (Object)contactId);
            return;
        }
        boolean isNewCustomerOpen = this.isNewCustomerOpen(user.getCorpId(), plan.getId());
        log.info("getReplyType: \u65b0\u5ba2\u6237\u624d\u80fd\u52a9\u529b\u5f00\u5173\uff1a{}", (Object)isNewCustomerOpen);
        WeworkContact existContact = this.weworkContactMapper.queryWeworkContact(user.getBizId(), user.getCorpId(), user.getExternalUserId());
        boolean bl = isNewCustomer = existContact == null;
        boolean bl2 = !isNewCustomerOpen ? true : (isFissionSuccess = isNewCustomer);
        if (!isFissionSuccess || StringUtils.isBlank((CharSequence)pContactId)) {
            log.info("\u52a9\u529b\u4e0d\u6210\u529f pContactId\u4e3a\u7a7a:{}", (Object)contactId);
            return;
        }
        if (isNewCustomerOpen && contactId.equals(pContactId)) {
            log.info("\u52a9\u529b\u4e0d\u6210\u529f:{}", (Object)contactId);
            return;
        }
        MarketingJoin marketingJoin = this.marketingJoinMapper.selectByCorpIdPlanIdAndContactId(join.getCorpId(), join.getPlanId(), user.getExternalUserId());
        if (marketingJoin != null) {
            log.info("\u5df2\u53c2\u52a0\u8fc7\u8be5\u6d3b\u52a8\uff0c\u52a9\u529b\u4e0d\u6210\u529f:{}", (Object)contactId);
            return;
        }
        log.info("success marketingJoin:{}", (Object)marketingJoin);
        CreateBillboardReqDto createBillboardReqDto = new CreateBillboardReqDto();
        createBillboardReqDto.setModel(3);
        createBillboardReqDto.setMarketingPlan(plan);
        createBillboardReqDto.setContactId(user.getExternalUserId());
        createBillboardReqDto.setPContactId(join.getContactId());
        createBillboardReqDto.setChannelId(join.getChannelId());
        createBillboardReqDto.setAssistantSuccess(isFissionSuccess);
        createBillboardReqDto.setIsNewCustomer(isNewCustomer ? 1 : 0);
        createBillboardReqDto.setAddFriendTime(new Date());
        createBillboardReqDto.setWeworkUserNum(join.getWeworkUserNum());
        List<FissionBillboardDto> fissionBillboardDtos = this.marketingConfigService.getBillboardConfig(join.getCorpId(), join.getPlanId());
        FissionBillboardDto fissionBillboardDto = fissionBillboardDtos.get(this.random.nextInt(fissionBillboardDtos.size()));
        createBillboardReqDto.setFissionBillboardDto(fissionBillboardDto);
        try {
            this.fissionPlanService.createBillboard(createBillboardReqDto);
        }
        catch (Exception ex) {
            log.info("billboardResultDto:{}\u751f\u6210\u4e13\u5c5e\u6d77\u62a5\u5931\u8d25:", (Object)createBillboardReqDto, (Object)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u4e13\u5c5e\u6d77\u62a5\u5931\u8d25");
        }
        marketingJoin = this.marketingJoinMapper.selectByCorpIdPlanIdAndContactId(join.getCorpId(), join.getPlanId(), user.getExternalUserId());
        log.info("success insert marketingJoin:{}", (Object)marketingJoin);
        this.addFriendLog(marketingJoin, isFissionSuccess);
        boolean reachStage = this.tryReachStage(join);
        if (reachStage) {
            this.remindReachStage(join);
        }
        this.addTag(marketingJoin, plan);
    }

    public boolean isMarketingEndTime(MarketingPlan marketingPlan) {
        Long planId = marketingPlan.getId();
        if (Objects.nonNull(marketingPlan) && Objects.nonNull(marketingPlan.getEndTime()) && marketingPlan.getEndTime().before(new Date())) {
            log.info("isMarketingEnd: \u6d3b\u52a8\u5df2\u5230\u671f\uff0cplanId:{}", (Object)planId);
            return true;
        }
        return false;
    }

    public boolean isMarketingNoReward(MarketingPlan marketingPlan) {
        Long planId;
        String corpId = marketingPlan.getCorpId();
        List rewardStages = this.rewardStageMapper.getRewarrdStage(corpId, planId = marketingPlan.getId());
        if (CollectionUtils.isEmpty((Collection)rewardStages)) {
            return false;
        }
        int remainCount = 0;
        Map stageCountMap = this.rewardMapper.getStageReceivedRewardCount(corpId, planId);
        for (MarketingRewardStage it : rewardStages) {
            int count = stageCountMap.getOrDefault(it.getStage(), 0);
            count = it.getRewardCount() - count;
            if (count <= 0) continue;
            remainCount += count;
        }
        boolean ret = remainCount == 0;
        log.info("isMarketingNoReward: \u6d3b\u52a8\u662f\u5426\u7ed3\u675f:{}, planId:{}", (Object)ret, (Object)planId);
        return ret;
    }

    private boolean isNewCustomerOpen(String corpId, Long planId) {
        FissionSwitchDto fissionSwitchDto = this.marketingConfigService.getSwitchConfig(corpId, planId);
        return Objects.nonNull(fissionSwitchDto) && Objects.nonNull(fissionSwitchDto.getIsLimitNewCustomer()) && fissionSwitchDto.getIsLimitNewCustomer().equals(NumberUtils.INTEGER_ONE);
    }

    private boolean tryReachStage(MarketingJoin join) {
        boolean flag = false;
        Date now = new Date();
        int count = join.getAddCount() + 1;
        join.setAddCount(Integer.valueOf(count));
        join.setUpdateTime(now);
        List reachedStages = this.rewardMapper.isReachStage(join.getPlanId(), join.getCorpId(), join.getContactId(), count, now);
        if (CollectionUtils.isNotEmpty((Collection)reachedStages)) {
            List ids = reachedStages.stream().map(it -> it.getId()).collect(Collectors.toList());
            this.rewardMapper.updateReachStage(ids, now);
            int reachStage = ((MarketingReward)reachedStages.get(0)).getStage();
            join.setReachStage(Integer.valueOf(reachStage));
            flag = true;
        }
        this.marketingJoinMapper.updateByPrimaryKeySelective((Object)join);
        return flag;
    }

    private void remindReachStage(MarketingJoin join) {
        if (StringUtils.isBlank((CharSequence)join.getWeworkUserNum())) {
            log.info("\u672a\u627e\u5230\u5ba2\u6237\u5206\u914d\u7684\u6210\u5458\uff0c\u4e0d\u63a8\u9001\u63d0\u9192\u3002");
            return;
        }
        String corpId = join.getCorpId();
        String contactId = join.getContactId();
        String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(join.getWeworkUserNum());
        String format = "\u6d3b\u52a8\u5b8c\u6210\u901a\u77e5\n\u5ba2\u6237\u6635\u79f0\uff1a{0}\n\u6d3b\u52a8\u540d\u79f0\uff1a{1}\n\u5b8c\u6210\u9636\u68af\uff1a{2}\n\u9080\u8bf7\u4eba\u6570\uff1a{3}\n\u5b8c\u6210\u65f6\u95f4\uff1a{4}";
        WeworkContact contact = this.weworkContactMapper.queryWeworkContact(join.getBizId(), corpId, contactId);
        MarketingPlan plan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)join.getPlanId());
        String datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String message = MessageFormat.format(format, contact.getName(), plan.getName(), join.getReachStage(), join.getAddCount(), datetime);
        log.info("\u5ba2\u6237\u8fbe\u6210\u4e86\u9636\u6bb5\u5956\u52b1\uff0c\u7ed9\u6210\u5458\u63a8\u9001\u63d0\u9192. stage={}, planId={}, contactId={}, weworkUserId={}", new Object[]{join.getReachStage(), join.getPlanId(), contactId, weworkUserId});
        try {
            this.remindService.sendMsg(join.getCorpId(), weworkUserId, message);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u767e\u5bb6\u4e91\u63d0\u9192\u5931\u8d25, message:{}", (Object)message, (Object)e);
        }
    }

    private void addTag(MarketingJoin join, MarketingPlan plan) {
        String corpId = join.getCorpId();
        Long planId = join.getPlanId();
        String pContactId = join.getPContactId();
        Long bizId = join.getBizId();
        String weworkUserId = join.getWeworkUserNum();
        boolean isAutoTagOpen = this.isAutoTagOpen(corpId, planId);
        if (!isAutoTagOpen) {
            log.info("addTag\uff1a\u81ea\u52a8\u6253\u6807\u7b7e\u5f00\u5173\u5df2\u5173\u95ed, planId:{}", (Object)planId);
            return;
        }
        Integer inviteCount = join.getAddCount();
        log.info("addTag: \u5df2\u7ecf\u52a9\u529b\u6210\u529f\u7684\u4eba\u6570\uff1a{}, planId:{}", (Object)inviteCount, (Object)planId);
        Integer reachStage = join.getReachStage();
        log.info("addTag: \uff1a\u5df2\u7ecf\u8fbe\u6210\u7684\u9636\u68af:{}, planId:{}", (Object)reachStage, (Object)planId);
        List tagList = this.tagRuleItemMapper.queryTagsByInviteAndStage(corpId, planId, inviteCount, reachStage, pContactId);
        if (CollectionUtils.isEmpty((Collection)tagList)) {
            log.warn("addTag: tag list is empty, join: {}", (Object)join);
            return;
        }
        if (CollectionUtils.isEmpty((Collection)(tagList = this.weworkTagMapper.filterIsDeletedTag(corpId, (Collection)tagList)))) {
            log.warn("addTag: {}\u6ca1\u6709\u53ef\u7528\u7684\u6807\u7b7e\u914d\u7f6e, planId:{}", (Object)join.getWeworkUserNum(), (Object)planId);
            return;
        }
        log.info("addTag: \u6ee1\u8db3\u6761\u4ef6\u7684\u6807\u7b7e\u5217\u8868\uff1a{}, join:{}", (Object)tagList, (Object)join);
        ModifyTagDto params = new ModifyTagDto();
        params.setBizId(bizId);
        params.setCorpId(corpId);
        params.setWeworkUserId(weworkUserId);
        params.setContactId(pContactId);
        params.setAddTagIds(tagList);
        log.info("addTag: \u6253\u6807\u7b7e:{}", (Object)params);
        try {
            this.contactOpService.modifyTag(params);
            this.addTagLog(plan, tagList, pContactId);
        }
        catch (Exception e) {
            log.error("addTag: \u4fee\u6539\u5ba2\u6237\u6807\u7b7e\u5931\u8d25", (Throwable)e);
        }
    }

    private boolean isAutoTagOpen(String corpId, Long planId) {
        FissionSwitchDto fissionSwitchDto = this.marketingConfigService.getSwitchConfig(corpId, planId);
        return Objects.nonNull(fissionSwitchDto) && Objects.nonNull(fissionSwitchDto.getEnableAttachTag()) && fissionSwitchDto.getEnableAttachTag().equals(NumberUtils.INTEGER_ONE);
    }

    public void addTagLog(MarketingPlan plan, List<String> tagList, String contactId) {
        Long planId = plan.getId();
        Integer planType = plan.getType();
        String corpId = plan.getCorpId();
        if (planId == null) {
            log.info("addTagLog: \u6d3b\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
            return;
        }
        if (Objects.isNull(planType) || planType.intValue() != PlanType.FRIEND_FISSION_PLAN.getValue()) {
            log.info("addTagLog: \u5f53\u524d\u975e\u597d\u53cb\u88c2\u53d8, planId:{}", (Object)planId);
            return;
        }
        List tagRuleIds = this.tagRuleItemMapper.queryTagRuleIdsByTagList(corpId, planId, tagList);
        if (CollectionUtils.isEmpty((Collection)tagRuleIds)) {
            log.info("addTagLog: \u65e0\u6807\u7b7e\u89c4\u5219id, planId:{}", (Object)planId);
            return;
        }
        ArrayList logList = Lists.newArrayList();
        for (Long tagRuleId : tagRuleIds) {
            MarketingTagRuleLog log = this.newRuleTagLog(plan, tagRuleId, contactId);
            logList.add(log);
        }
        this.tagRuleLogMapper.batchInsert((Collection)logList);
    }

    private MarketingTagRuleLog newRuleTagLog(MarketingPlan plan, Long tagRuleId, String contactId) {
        MarketingTagRuleLog ruleLog = new MarketingTagRuleLog();
        ruleLog.setBizId(plan.getBizId());
        ruleLog.setCorpId(plan.getCorpId());
        ruleLog.setPlanId(plan.getId());
        ruleLog.setContactId(contactId);
        ruleLog.setTagRuleId(tagRuleId);
        ruleLog.setCreateTime(new Date());
        ruleLog.setUpdateTime(new Date());
        ruleLog.setIsDeleted(Integer.valueOf(0));
        return ruleLog;
    }

    private void addFriendLog(MarketingJoin join, boolean isFissionSuccess) {
        log.info("\u8bb0\u5f55\u6d3b\u52a8\u52a0\u597d\u53cb\u65e5\u5fd7, join={}", (Object)join);
        MarketingAddFriendLog record = new MarketingAddFriendLog();
        record.setBizId(join.getBizId());
        record.setCorpId(join.getCorpId());
        record.setWeworkUserNum(join.getWeworkUserNum());
        record.setContactId(join.getContactId());
        record.setAddFriendTime(join.getAddFriendTime());
        record.setPlanId(join.getPlanId());
        record.setPlanNum(join.getPlanNum());
        record.setChannelId(join.getChannelId());
        record.setPContactId(join.getPContactId());
        record.setIsNewCustomer(join.getIsNewCustomer());
        record.setIsSuccess(Boolean.valueOf(isFissionSuccess));
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        record.setIsDeleted(Integer.valueOf(0));
        record.setDeleteTime(null);
        this.addFriendLogMapper.insertSelective((Object)record);
    }
}

