/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.friendFission.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.marketing.entity.MarketingBounsCode;
import com.kuaike.scrm.dal.marketing.entity.MarketingRewardStage;
import com.kuaike.scrm.dal.marketing.mapper.MarketingBounsCodeMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingRewardMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingRewardStageMapper;
import com.kuaike.scrm.friendFission.dto.FissionPlanStageDto;
import com.kuaike.scrm.friendFission.service.FissionStageService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FissionStageServiceImpl
implements FissionStageService {
    private static final Logger log = LoggerFactory.getLogger(FissionStageServiceImpl.class);
    @Resource
    private MarketingRewardStageMapper marketingRewardStageMapper;
    @Resource
    private MarketingRewardMapper marketingRewardMapper;
    @Resource
    private MarketingBounsCodeMapper marketingBounsCodeMapper;

    @Override
    public void save(Long planId, List<FissionPlanStageDto> stages, Boolean isAdd) {
        List delIds;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        List rewardStages = this.marketingRewardStageMapper.queryFissionStages(corpId, planId, null);
        Map<Long, MarketingRewardStage> stageMap = rewardStages.stream().collect(Collectors.toMap(MarketingRewardStage::getId, Function.identity()));
        ArrayList insertList = Lists.newArrayList();
        for (FissionPlanStageDto stageDto : stages) {
            if (stageDto.getId() == null || isAdd.booleanValue()) {
                insertList.add(this.buildStage(planId, stageDto));
                continue;
            }
            this.updateRewardStage(stageMap, stageDto);
            stageMap.remove(stageDto.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)insertList)) {
            this.marketingRewardStageMapper.batchInsert((List)insertList);
        }
        if (CollectionUtils.isNotEmpty(delIds = stageMap.values().stream().filter(it -> it.getIsDeleted() == 0).map(it -> it.getId()).collect(Collectors.toList()))) {
            this.marketingRewardStageMapper.delRewardStage(userInfo.getId(), delIds);
        }
    }

    @Override
    public List<FissionPlanStageDto> getList(String corpId, Long planId) {
        List rewardStages = this.marketingRewardStageMapper.queryFissionStages(corpId, planId, Integer.valueOf(0));
        ArrayList result = Lists.newArrayListWithCapacity((int)rewardStages.size());
        for (MarketingRewardStage rewardStage : rewardStages) {
            FissionPlanStageDto stageDto = new FissionPlanStageDto();
            stageDto.setId(rewardStage.getId());
            stageDto.setStage(rewardStage.getStage());
            stageDto.setInviteCount(rewardStage.getInviteCount());
            stageDto.setRewardCount(rewardStage.getRewardCount());
            stageDto.setType(rewardStage.getType());
            if (stageDto.getType() == 1) {
                stageDto.setRedirectUrl(rewardStage.getContent());
            } else if (stageDto.getType() == 2) {
                stageDto.setExchangeCodeRule(rewardStage.getContent());
                MarketingBounsCode bounsCode = (MarketingBounsCode)this.marketingBounsCodeMapper.selectByPrimaryKey((Object)rewardStage.getExchangeCodeId());
                if (bounsCode != null) {
                    stageDto.setExchangeCodeId(bounsCode.getNum());
                    stageDto.setExchangeCodeName(bounsCode.getName());
                }
            }
            Integer rewardCount = this.marketingRewardMapper.getRewardCount(corpId, planId, stageDto.getStage());
            int remainRewardCount = stageDto.getRewardCount() - rewardCount;
            stageDto.setRemainRewardCount(remainRewardCount < 0 ? 0 : remainRewardCount);
            result.add(stageDto);
        }
        return result;
    }

    public MarketingRewardStage buildStage(Long planId, FissionPlanStageDto stageDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        MarketingRewardStage rewardStage = new MarketingRewardStage();
        rewardStage.setBizId(userInfo.getBizId());
        rewardStage.setCorpId(userInfo.getCorpId());
        rewardStage.setPlanId(planId);
        rewardStage.setStage(stageDto.getStage());
        rewardStage.setInviteCount(stageDto.getInviteCount());
        rewardStage.setRewardCount(stageDto.getRewardCount());
        rewardStage.setType(stageDto.getType());
        if (rewardStage.getType() == 1) {
            rewardStage.setContent(stageDto.getRedirectUrl());
        } else if (rewardStage.getType() == 2) {
            rewardStage.setContent(stageDto.getExchangeCodeRule());
            MarketingBounsCode bounsCode = this.marketingBounsCodeMapper.getBounsByNum(stageDto.getExchangeCodeId(), userInfo.getCorpId());
            if (bounsCode != null) {
                rewardStage.setExchangeCodeId(bounsCode.getId());
            }
        }
        rewardStage.setCreateBy(userInfo.getId());
        rewardStage.setUpdateBy(userInfo.getId());
        rewardStage.setCreateTime(new Date());
        rewardStage.setUpdateTime(new Date());
        rewardStage.setIsDeleted(Integer.valueOf(0));
        return rewardStage;
    }

    private void updateRewardStage(Map<Long, MarketingRewardStage> stageMap, FissionPlanStageDto stageDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        MarketingRewardStage updateStage = stageMap.get(stageDto.getId());
        if (updateStage == null) {
            return;
        }
        updateStage.setStage(stageDto.getStage());
        updateStage.setInviteCount(stageDto.getInviteCount());
        updateStage.setRewardCount(stageDto.getRewardCount());
        updateStage.setType(stageDto.getType());
        if (updateStage.getType() == 1) {
            updateStage.setContent(stageDto.getRedirectUrl());
        } else if (updateStage.getType() == 2) {
            updateStage.setContent(stageDto.getExchangeCodeRule());
            MarketingBounsCode bounsCode = this.marketingBounsCodeMapper.getBounsByNum(stageDto.getExchangeCodeId(), userInfo.getCorpId());
            if (bounsCode != null) {
                updateStage.setExchangeCodeId(bounsCode.getId());
            }
        }
        updateStage.setUpdateBy(userInfo.getId());
        updateStage.setUpdateTime(new Date());
        updateStage.setIsDeleted(Integer.valueOf(0));
        this.marketingRewardStageMapper.updateByPrimaryKeySelective((Object)updateStage);
    }
}

