/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.friendFission.dto;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.dal.wework.dto.WeworkUserDto;
import com.kuaike.scrm.friendFission.dto.FissionAttachTagRuleDto;
import com.kuaike.scrm.friendFission.dto.FissionBillboardDto;
import com.kuaike.scrm.friendFission.dto.FissionPlanStageDto;
import com.kuaike.scrm.marketing.dto.FriendWelcomeDto;
import java.util.Date;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class FissionPlanDto {
    private String id;
    private String name;
    private Date endTime;
    private List<String> weworkUserIds;
    private List<WeworkUserDto> weworkUsers;
    private List<FissionPlanStageDto> stages;
    private FriendWelcomeDto spreadReply;
    private FriendWelcomeDto successInviteReply;
    private FriendWelcomeDto repeatInviteReply;
    private FriendWelcomeDto finishReply;
    private String customizeReply;
    private List<FissionBillboardDto> billboard;
    private Integer isLimitNewCustomer;
    private FriendWelcomeDto limitNewCustomerReply;
    private Integer invalidOnDisfollow;
    private Integer enableAttachTag;
    private List<FissionAttachTagRuleDto> attachTagRules;
    private String addFriendRemark;
    private Integer inviteQrcodeType;

    public void checkParams() {
        Preconditions.checkArgument((!StringUtils.isEmpty((Object)this.name) ? 1 : 0) != 0, (Object)"\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.endTime != null && this.endTime.after(new Date()) ? 1 : 0) != 0, (Object)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
        Preconditions.checkArgument((!CollectionUtils.isEmpty(this.weworkUserIds) ? 1 : 0) != 0, (Object)"\u6d3b\u52a8\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((!CollectionUtils.isEmpty(this.stages) ? 1 : 0) != 0, (Object)"\u6d3b\u52a8\u9636\u68af\u5956\u52b1\u4e0d\u80fd\u4e3a\u7a7a");
        for (FissionPlanStageDto stageDto : this.stages) {
            stageDto.checkParams();
        }
        Preconditions.checkArgument((this.spreadReply != null && !StringUtils.isEmpty((Object)this.spreadReply.getText()) ? 1 : 0) != 0, (Object)"\u88c2\u53d8\u63a8\u5e7f\u8bdd\u672f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.successInviteReply != null && !StringUtils.isEmpty((Object)this.successInviteReply.getText()) ? 1 : 0) != 0, (Object)"\u6210\u529f\u52a9\u529b\u8bdd\u672f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.repeatInviteReply != null && !StringUtils.isEmpty((Object)this.repeatInviteReply.getText()) ? 1 : 0) != 0, (Object)"\u91cd\u590d\u52a9\u529b\u63d0\u9192\u8bdd\u672f\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.finishReply == null) {
            this.finishReply = new FriendWelcomeDto();
        }
        Preconditions.checkArgument((!StringUtils.isEmpty((Object)this.customizeReply) ? 1 : 0) != 0, (Object)"\u81ea\u5b9a\u4e49\u8bdd\u672f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.customizeReply.length() <= 100 ? 1 : 0) != 0, (Object)"\u81ea\u5b9a\u4e49\u8bdd\u672f\u4e0d\u80fd\u8d85\u8fc7100\u5b57");
        Preconditions.checkArgument((!CollectionUtils.isEmpty(this.billboard) ? 1 : 0) != 0, (Object)"\u6d3b\u52a8\u6d77\u62a5\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        for (FissionBillboardDto billboardDto : this.billboard) {
            billboardDto.checkParams();
        }
        if (this.enableAttachTag == 1) {
            Preconditions.checkArgument((!CollectionUtils.isEmpty(this.attachTagRules) ? 1 : 0) != 0, (Object)"\u6807\u7b7e\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
            for (FissionAttachTagRuleDto attachTagRuleDto : this.attachTagRules) {
                attachTagRuleDto.checkParams();
            }
        }
        if (this.isLimitNewCustomer == null) {
            this.isLimitNewCustomer = 0;
        }
        if (this.limitNewCustomerReply == null) {
            this.limitNewCustomerReply = new FriendWelcomeDto();
        }
        Preconditions.checkArgument((this.isLimitNewCustomer == 0 || this.isLimitNewCustomer == 1 ? 1 : 0) != 0, (Object)"\u65b0\u5ba2\u6237\u52a9\u529b\u914d\u7f6e\u53c2\u6570\u9519\u8bef");
        if (this.invalidOnDisfollow == null) {
            this.invalidOnDisfollow = 0;
        }
        Preconditions.checkArgument((this.invalidOnDisfollow == 0 || this.invalidOnDisfollow == 1 ? 1 : 0) != 0, (Object)"\u5220\u9664\u597d\u53cb\u52a9\u529b\u5931\u6548\u53c2\u6570\u9519\u8bef");
        if (this.enableAttachTag == null) {
            this.enableAttachTag = 0;
        }
        Preconditions.checkArgument((this.enableAttachTag == 0 || this.enableAttachTag == 1 ? 1 : 0) != 0, (Object)"\u81ea\u52a8\u6253\u6807\u7b7e\u53c2\u6570\u9519\u8bef");
        if (this.inviteQrcodeType == null) {
            this.inviteQrcodeType = 1;
        }
        Preconditions.checkArgument((this.inviteQrcodeType == 1 || this.inviteQrcodeType == 2 ? 1 : 0) != 0, (Object)"\u751f\u6210\u4e13\u5c5e\u7801\u7c7b\u578b\u53c2\u6570\u9519\u8bef");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public List<String> getWeworkUserIds() {
        return this.weworkUserIds;
    }

    public List<WeworkUserDto> getWeworkUsers() {
        return this.weworkUsers;
    }

    public List<FissionPlanStageDto> getStages() {
        return this.stages;
    }

    public FriendWelcomeDto getSpreadReply() {
        return this.spreadReply;
    }

    public FriendWelcomeDto getSuccessInviteReply() {
        return this.successInviteReply;
    }

    public FriendWelcomeDto getRepeatInviteReply() {
        return this.repeatInviteReply;
    }

    public FriendWelcomeDto getFinishReply() {
        return this.finishReply;
    }

    public String getCustomizeReply() {
        return this.customizeReply;
    }

    public List<FissionBillboardDto> getBillboard() {
        return this.billboard;
    }

    public Integer getIsLimitNewCustomer() {
        return this.isLimitNewCustomer;
    }

    public FriendWelcomeDto getLimitNewCustomerReply() {
        return this.limitNewCustomerReply;
    }

    public Integer getInvalidOnDisfollow() {
        return this.invalidOnDisfollow;
    }

    public Integer getEnableAttachTag() {
        return this.enableAttachTag;
    }

    public List<FissionAttachTagRuleDto> getAttachTagRules() {
        return this.attachTagRules;
    }

    public String getAddFriendRemark() {
        return this.addFriendRemark;
    }

    public Integer getInviteQrcodeType() {
        return this.inviteQrcodeType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setWeworkUserIds(List<String> weworkUserIds) {
        this.weworkUserIds = weworkUserIds;
    }

    public void setWeworkUsers(List<WeworkUserDto> weworkUsers) {
        this.weworkUsers = weworkUsers;
    }

    public void setStages(List<FissionPlanStageDto> stages) {
        this.stages = stages;
    }

    public void setSpreadReply(FriendWelcomeDto spreadReply) {
        this.spreadReply = spreadReply;
    }

    public void setSuccessInviteReply(FriendWelcomeDto successInviteReply) {
        this.successInviteReply = successInviteReply;
    }

    public void setRepeatInviteReply(FriendWelcomeDto repeatInviteReply) {
        this.repeatInviteReply = repeatInviteReply;
    }

    public void setFinishReply(FriendWelcomeDto finishReply) {
        this.finishReply = finishReply;
    }

    public void setCustomizeReply(String customizeReply) {
        this.customizeReply = customizeReply;
    }

    public void setBillboard(List<FissionBillboardDto> billboard) {
        this.billboard = billboard;
    }

    public void setIsLimitNewCustomer(Integer isLimitNewCustomer) {
        this.isLimitNewCustomer = isLimitNewCustomer;
    }

    public void setLimitNewCustomerReply(FriendWelcomeDto limitNewCustomerReply) {
        this.limitNewCustomerReply = limitNewCustomerReply;
    }

    public void setInvalidOnDisfollow(Integer invalidOnDisfollow) {
        this.invalidOnDisfollow = invalidOnDisfollow;
    }

    public void setEnableAttachTag(Integer enableAttachTag) {
        this.enableAttachTag = enableAttachTag;
    }

    public void setAttachTagRules(List<FissionAttachTagRuleDto> attachTagRules) {
        this.attachTagRules = attachTagRules;
    }

    public void setAddFriendRemark(String addFriendRemark) {
        this.addFriendRemark = addFriendRemark;
    }

    public void setInviteQrcodeType(Integer inviteQrcodeType) {
        this.inviteQrcodeType = inviteQrcodeType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FissionPlanDto)) {
            return false;
        }
        FissionPlanDto other = (FissionPlanDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$isLimitNewCustomer = this.getIsLimitNewCustomer();
        Integer other$isLimitNewCustomer = other.getIsLimitNewCustomer();
        if (this$isLimitNewCustomer == null ? other$isLimitNewCustomer != null : !((Object)this$isLimitNewCustomer).equals(other$isLimitNewCustomer)) {
            return false;
        }
        Integer this$invalidOnDisfollow = this.getInvalidOnDisfollow();
        Integer other$invalidOnDisfollow = other.getInvalidOnDisfollow();
        if (this$invalidOnDisfollow == null ? other$invalidOnDisfollow != null : !((Object)this$invalidOnDisfollow).equals(other$invalidOnDisfollow)) {
            return false;
        }
        Integer this$enableAttachTag = this.getEnableAttachTag();
        Integer other$enableAttachTag = other.getEnableAttachTag();
        if (this$enableAttachTag == null ? other$enableAttachTag != null : !((Object)this$enableAttachTag).equals(other$enableAttachTag)) {
            return false;
        }
        Integer this$inviteQrcodeType = this.getInviteQrcodeType();
        Integer other$inviteQrcodeType = other.getInviteQrcodeType();
        if (this$inviteQrcodeType == null ? other$inviteQrcodeType != null : !((Object)this$inviteQrcodeType).equals(other$inviteQrcodeType)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        List<String> this$weworkUserIds = this.getWeworkUserIds();
        List<String> other$weworkUserIds = other.getWeworkUserIds();
        if (this$weworkUserIds == null ? other$weworkUserIds != null : !((Object)this$weworkUserIds).equals(other$weworkUserIds)) {
            return false;
        }
        List<WeworkUserDto> this$weworkUsers = this.getWeworkUsers();
        List<WeworkUserDto> other$weworkUsers = other.getWeworkUsers();
        if (this$weworkUsers == null ? other$weworkUsers != null : !((Object)this$weworkUsers).equals(other$weworkUsers)) {
            return false;
        }
        List<FissionPlanStageDto> this$stages = this.getStages();
        List<FissionPlanStageDto> other$stages = other.getStages();
        if (this$stages == null ? other$stages != null : !((Object)this$stages).equals(other$stages)) {
            return false;
        }
        FriendWelcomeDto this$spreadReply = this.getSpreadReply();
        FriendWelcomeDto other$spreadReply = other.getSpreadReply();
        if (this$spreadReply == null ? other$spreadReply != null : !((Object)this$spreadReply).equals(other$spreadReply)) {
            return false;
        }
        FriendWelcomeDto this$successInviteReply = this.getSuccessInviteReply();
        FriendWelcomeDto other$successInviteReply = other.getSuccessInviteReply();
        if (this$successInviteReply == null ? other$successInviteReply != null : !((Object)this$successInviteReply).equals(other$successInviteReply)) {
            return false;
        }
        FriendWelcomeDto this$repeatInviteReply = this.getRepeatInviteReply();
        FriendWelcomeDto other$repeatInviteReply = other.getRepeatInviteReply();
        if (this$repeatInviteReply == null ? other$repeatInviteReply != null : !((Object)this$repeatInviteReply).equals(other$repeatInviteReply)) {
            return false;
        }
        FriendWelcomeDto this$finishReply = this.getFinishReply();
        FriendWelcomeDto other$finishReply = other.getFinishReply();
        if (this$finishReply == null ? other$finishReply != null : !((Object)this$finishReply).equals(other$finishReply)) {
            return false;
        }
        String this$customizeReply = this.getCustomizeReply();
        String other$customizeReply = other.getCustomizeReply();
        if (this$customizeReply == null ? other$customizeReply != null : !this$customizeReply.equals(other$customizeReply)) {
            return false;
        }
        List<FissionBillboardDto> this$billboard = this.getBillboard();
        List<FissionBillboardDto> other$billboard = other.getBillboard();
        if (this$billboard == null ? other$billboard != null : !((Object)this$billboard).equals(other$billboard)) {
            return false;
        }
        FriendWelcomeDto this$limitNewCustomerReply = this.getLimitNewCustomerReply();
        FriendWelcomeDto other$limitNewCustomerReply = other.getLimitNewCustomerReply();
        if (this$limitNewCustomerReply == null ? other$limitNewCustomerReply != null : !((Object)this$limitNewCustomerReply).equals(other$limitNewCustomerReply)) {
            return false;
        }
        List<FissionAttachTagRuleDto> this$attachTagRules = this.getAttachTagRules();
        List<FissionAttachTagRuleDto> other$attachTagRules = other.getAttachTagRules();
        if (this$attachTagRules == null ? other$attachTagRules != null : !((Object)this$attachTagRules).equals(other$attachTagRules)) {
            return false;
        }
        String this$addFriendRemark = this.getAddFriendRemark();
        String other$addFriendRemark = other.getAddFriendRemark();
        return !(this$addFriendRemark == null ? other$addFriendRemark != null : !this$addFriendRemark.equals(other$addFriendRemark));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FissionPlanDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $isLimitNewCustomer = this.getIsLimitNewCustomer();
        result = result * 59 + ($isLimitNewCustomer == null ? 43 : ((Object)$isLimitNewCustomer).hashCode());
        Integer $invalidOnDisfollow = this.getInvalidOnDisfollow();
        result = result * 59 + ($invalidOnDisfollow == null ? 43 : ((Object)$invalidOnDisfollow).hashCode());
        Integer $enableAttachTag = this.getEnableAttachTag();
        result = result * 59 + ($enableAttachTag == null ? 43 : ((Object)$enableAttachTag).hashCode());
        Integer $inviteQrcodeType = this.getInviteQrcodeType();
        result = result * 59 + ($inviteQrcodeType == null ? 43 : ((Object)$inviteQrcodeType).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        List<String> $weworkUserIds = this.getWeworkUserIds();
        result = result * 59 + ($weworkUserIds == null ? 43 : ((Object)$weworkUserIds).hashCode());
        List<WeworkUserDto> $weworkUsers = this.getWeworkUsers();
        result = result * 59 + ($weworkUsers == null ? 43 : ((Object)$weworkUsers).hashCode());
        List<FissionPlanStageDto> $stages = this.getStages();
        result = result * 59 + ($stages == null ? 43 : ((Object)$stages).hashCode());
        FriendWelcomeDto $spreadReply = this.getSpreadReply();
        result = result * 59 + ($spreadReply == null ? 43 : ((Object)$spreadReply).hashCode());
        FriendWelcomeDto $successInviteReply = this.getSuccessInviteReply();
        result = result * 59 + ($successInviteReply == null ? 43 : ((Object)$successInviteReply).hashCode());
        FriendWelcomeDto $repeatInviteReply = this.getRepeatInviteReply();
        result = result * 59 + ($repeatInviteReply == null ? 43 : ((Object)$repeatInviteReply).hashCode());
        FriendWelcomeDto $finishReply = this.getFinishReply();
        result = result * 59 + ($finishReply == null ? 43 : ((Object)$finishReply).hashCode());
        String $customizeReply = this.getCustomizeReply();
        result = result * 59 + ($customizeReply == null ? 43 : $customizeReply.hashCode());
        List<FissionBillboardDto> $billboard = this.getBillboard();
        result = result * 59 + ($billboard == null ? 43 : ((Object)$billboard).hashCode());
        FriendWelcomeDto $limitNewCustomerReply = this.getLimitNewCustomerReply();
        result = result * 59 + ($limitNewCustomerReply == null ? 43 : ((Object)$limitNewCustomerReply).hashCode());
        List<FissionAttachTagRuleDto> $attachTagRules = this.getAttachTagRules();
        result = result * 59 + ($attachTagRules == null ? 43 : ((Object)$attachTagRules).hashCode());
        String $addFriendRemark = this.getAddFriendRemark();
        result = result * 59 + ($addFriendRemark == null ? 43 : $addFriendRemark.hashCode());
        return result;
    }

    public String toString() {
        return "FissionPlanDto(id=" + this.getId() + ", name=" + this.getName() + ", endTime=" + this.getEndTime() + ", weworkUserIds=" + this.getWeworkUserIds() + ", weworkUsers=" + this.getWeworkUsers() + ", stages=" + this.getStages() + ", spreadReply=" + this.getSpreadReply() + ", successInviteReply=" + this.getSuccessInviteReply() + ", repeatInviteReply=" + this.getRepeatInviteReply() + ", finishReply=" + this.getFinishReply() + ", customizeReply=" + this.getCustomizeReply() + ", billboard=" + this.getBillboard() + ", isLimitNewCustomer=" + this.getIsLimitNewCustomer() + ", limitNewCustomerReply=" + this.getLimitNewCustomerReply() + ", invalidOnDisfollow=" + this.getInvalidOnDisfollow() + ", enableAttachTag=" + this.getEnableAttachTag() + ", attachTagRules=" + this.getAttachTagRules() + ", addFriendRemark=" + this.getAddFriendRemark() + ", inviteQrcodeType=" + this.getInviteQrcodeType() + ")";
    }
}

