/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.enums.SopTemplateTaskTypeEnum;
import com.kuaike.scrm.sop.dto.req.BatchAddFriendDto;
import com.kuaike.scrm.sop.dto.req.GroupSendDto;
import com.kuaike.scrm.sop.dto.req.ManualCallDto;
import com.kuaike.scrm.sop.dto.req.SmsDto;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class TemplateTimesTaskDto {
    private String id;
    private Integer taskType;
    private String taskTime;
    private String remindTime;
    private String expectCompleteTime;
    private GroupSendDto groupSendDto;
    private ManualCallDto manualCallDto;
    private SmsDto smsDto;
    private BatchAddFriendDto batchAddFriendDto;
    private String jsonContent;

    public void validateParams() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.taskType), (Object)"\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        SopTemplateTaskTypeEnum sopTemplateTaskTypeEnum = SopTemplateTaskTypeEnum.get((int)this.taskType);
        Preconditions.checkArgument((boolean)Objects.nonNull(sopTemplateTaskTypeEnum), (Object)"\u4efb\u52a1\u7c7b\u578b\u503c\u4e0d\u5408\u6cd5");
        this.jsonContent = "";
        switch (sopTemplateTaskTypeEnum) {
            case WEWORK_GROUP_SEND: {
                this.validateWeworkGroupSendParams();
                this.jsonContent = JacksonUtil.obj2Str((Object)this.groupSendDto);
                break;
            }
            case MANUAL_CALL: {
                this.validateManualCallParams();
                if (!Objects.nonNull(this.manualCallDto)) break;
                this.jsonContent = JacksonUtil.obj2Str((Object)this.manualCallDto);
                break;
            }
            case SMS: {
                this.validateSmsParams();
                if (!Objects.nonNull(this.smsDto)) break;
                this.jsonContent = JacksonUtil.obj2Str((Object)this.smsDto);
                break;
            }
            case BATCH_ADD_FRIEND: {
                List<String> tagIds;
                this.validateBatchAddFriendParams();
                if (!Objects.nonNull(this.batchAddFriendDto)) break;
                this.batchAddFriendDto.setTagList(null);
                this.jsonContent = JacksonUtil.obj2Str((Object)this.batchAddFriendDto);
                if (!CollectionUtils.isNotEmpty(this.batchAddFriendDto.getTagIds()) || !CollectionUtils.isNotEmpty(tagIds = this.batchAddFriendDto.getTagIds().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList()))) break;
                this.batchAddFriendDto.setTagIds(tagIds);
                break;
            }
        }
    }

    private void validateWeworkGroupSendParams() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.groupSendDto), (Object)"\u4f01\u5fae\u7fa4\u53d1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.groupSendDto.validateParams();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.taskTime), (Object)"\u53d1\u9001\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        this.remindTime = "";
        this.expectCompleteTime = "";
        if (Objects.isNull(this.groupSendDto.getFkType())) {
            this.groupSendDto.setFkType(NumberUtils.INTEGER_ZERO);
        }
    }

    private void validateManualCallParams() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.manualCallDto), (Object)"\u4eba\u5de5\u5916\u547c\u4efb\u52a1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.manualCallDto.validateParams();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.taskTime), (Object)"\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        this.remindTime = this.taskTime;
        if (this.expectCompleteTime == null) {
            this.expectCompleteTime = "";
        }
    }

    private void validateSmsParams() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.taskTime), (Object)"\u53d1\u9001\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.smsDto), (Object)"\u77ed\u4fe1\u4efb\u52a1\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.smsDto.validateParams();
        this.remindTime = "";
        this.expectCompleteTime = "";
    }

    private void validateBatchAddFriendParams() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.taskTime), (Object)"\u4efb\u52a1\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        this.remindTime = this.taskTime;
        this.expectCompleteTime = "";
    }

    public String getId() {
        return this.id;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public String getTaskTime() {
        return this.taskTime;
    }

    public String getRemindTime() {
        return this.remindTime;
    }

    public String getExpectCompleteTime() {
        return this.expectCompleteTime;
    }

    public GroupSendDto getGroupSendDto() {
        return this.groupSendDto;
    }

    public ManualCallDto getManualCallDto() {
        return this.manualCallDto;
    }

    public SmsDto getSmsDto() {
        return this.smsDto;
    }

    public BatchAddFriendDto getBatchAddFriendDto() {
        return this.batchAddFriendDto;
    }

    public String getJsonContent() {
        return this.jsonContent;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public void setTaskTime(String taskTime) {
        this.taskTime = taskTime;
    }

    public void setRemindTime(String remindTime) {
        this.remindTime = remindTime;
    }

    public void setExpectCompleteTime(String expectCompleteTime) {
        this.expectCompleteTime = expectCompleteTime;
    }

    public void setGroupSendDto(GroupSendDto groupSendDto) {
        this.groupSendDto = groupSendDto;
    }

    public void setManualCallDto(ManualCallDto manualCallDto) {
        this.manualCallDto = manualCallDto;
    }

    public void setSmsDto(SmsDto smsDto) {
        this.smsDto = smsDto;
    }

    public void setBatchAddFriendDto(BatchAddFriendDto batchAddFriendDto) {
        this.batchAddFriendDto = batchAddFriendDto;
    }

    public void setJsonContent(String jsonContent) {
        this.jsonContent = jsonContent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateTimesTaskDto)) {
            return false;
        }
        TemplateTimesTaskDto other = (TemplateTimesTaskDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$taskType = this.getTaskType();
        Integer other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)this$taskType).equals(other$taskType)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$taskTime = this.getTaskTime();
        String other$taskTime = other.getTaskTime();
        if (this$taskTime == null ? other$taskTime != null : !this$taskTime.equals(other$taskTime)) {
            return false;
        }
        String this$remindTime = this.getRemindTime();
        String other$remindTime = other.getRemindTime();
        if (this$remindTime == null ? other$remindTime != null : !this$remindTime.equals(other$remindTime)) {
            return false;
        }
        String this$expectCompleteTime = this.getExpectCompleteTime();
        String other$expectCompleteTime = other.getExpectCompleteTime();
        if (this$expectCompleteTime == null ? other$expectCompleteTime != null : !this$expectCompleteTime.equals(other$expectCompleteTime)) {
            return false;
        }
        GroupSendDto this$groupSendDto = this.getGroupSendDto();
        GroupSendDto other$groupSendDto = other.getGroupSendDto();
        if (this$groupSendDto == null ? other$groupSendDto != null : !((Object)this$groupSendDto).equals(other$groupSendDto)) {
            return false;
        }
        ManualCallDto this$manualCallDto = this.getManualCallDto();
        ManualCallDto other$manualCallDto = other.getManualCallDto();
        if (this$manualCallDto == null ? other$manualCallDto != null : !((Object)this$manualCallDto).equals(other$manualCallDto)) {
            return false;
        }
        SmsDto this$smsDto = this.getSmsDto();
        SmsDto other$smsDto = other.getSmsDto();
        if (this$smsDto == null ? other$smsDto != null : !((Object)this$smsDto).equals(other$smsDto)) {
            return false;
        }
        BatchAddFriendDto this$batchAddFriendDto = this.getBatchAddFriendDto();
        BatchAddFriendDto other$batchAddFriendDto = other.getBatchAddFriendDto();
        if (this$batchAddFriendDto == null ? other$batchAddFriendDto != null : !((Object)this$batchAddFriendDto).equals(other$batchAddFriendDto)) {
            return false;
        }
        String this$jsonContent = this.getJsonContent();
        String other$jsonContent = other.getJsonContent();
        return !(this$jsonContent == null ? other$jsonContent != null : !this$jsonContent.equals(other$jsonContent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TemplateTimesTaskDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)$taskType).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $taskTime = this.getTaskTime();
        result = result * 59 + ($taskTime == null ? 43 : $taskTime.hashCode());
        String $remindTime = this.getRemindTime();
        result = result * 59 + ($remindTime == null ? 43 : $remindTime.hashCode());
        String $expectCompleteTime = this.getExpectCompleteTime();
        result = result * 59 + ($expectCompleteTime == null ? 43 : $expectCompleteTime.hashCode());
        GroupSendDto $groupSendDto = this.getGroupSendDto();
        result = result * 59 + ($groupSendDto == null ? 43 : ((Object)$groupSendDto).hashCode());
        ManualCallDto $manualCallDto = this.getManualCallDto();
        result = result * 59 + ($manualCallDto == null ? 43 : ((Object)$manualCallDto).hashCode());
        SmsDto $smsDto = this.getSmsDto();
        result = result * 59 + ($smsDto == null ? 43 : ((Object)$smsDto).hashCode());
        BatchAddFriendDto $batchAddFriendDto = this.getBatchAddFriendDto();
        result = result * 59 + ($batchAddFriendDto == null ? 43 : ((Object)$batchAddFriendDto).hashCode());
        String $jsonContent = this.getJsonContent();
        result = result * 59 + ($jsonContent == null ? 43 : $jsonContent.hashCode());
        return result;
    }

    public String toString() {
        return "TemplateTimesTaskDto(id=" + this.getId() + ", taskType=" + this.getTaskType() + ", taskTime=" + this.getTaskTime() + ", remindTime=" + this.getRemindTime() + ", expectCompleteTime=" + this.getExpectCompleteTime() + ", groupSendDto=" + this.getGroupSendDto() + ", manualCallDto=" + this.getManualCallDto() + ", smsDto=" + this.getSmsDto() + ", batchAddFriendDto=" + this.getBatchAddFriendDto() + ", jsonContent=" + this.getJsonContent() + ")";
    }
}

