/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.SmsContentTypeEnum;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SmsDto {
    private String content;
    private Integer contentType;
    private String reason;
    private String signatureId;
    private String templateId;
    private String templateContent;
    private List<String> acquisitionLinkIds;

    public void validateParams() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.signatureId), (Object)"\u77ed\u4fe1\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.contentType), (Object)"\u77ed\u4fe1\u5185\u5bb9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        SmsContentTypeEnum smsContentTypeEnum = SmsContentTypeEnum.get((int)this.contentType);
        Preconditions.checkArgument((boolean)Objects.nonNull(smsContentTypeEnum), (Object)"\u77ed\u4fe1\u5185\u5bb9\u7c7b\u578b\u503c\u4e0d\u5408\u6cd5");
        if (SmsContentTypeEnum.CUSTOMER_DEFINE_SMS == smsContentTypeEnum) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.content), (Object)"\u77ed\u4fe1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.templateId), (Object)"\u77ed\u4fe1\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.templateContent), (Object)"\u6a21\u677f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public String getContent() {
        return this.content;
    }

    public Integer getContentType() {
        return this.contentType;
    }

    public String getReason() {
        return this.reason;
    }

    public String getSignatureId() {
        return this.signatureId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getTemplateContent() {
        return this.templateContent;
    }

    public List<String> getAcquisitionLinkIds() {
        return this.acquisitionLinkIds;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setContentType(Integer contentType) {
        this.contentType = contentType;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setSignatureId(String signatureId) {
        this.signatureId = signatureId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setTemplateContent(String templateContent) {
        this.templateContent = templateContent;
    }

    public void setAcquisitionLinkIds(List<String> acquisitionLinkIds) {
        this.acquisitionLinkIds = acquisitionLinkIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmsDto)) {
            return false;
        }
        SmsDto other = (SmsDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$contentType = this.getContentType();
        Integer other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !((Object)this$contentType).equals(other$contentType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$signatureId = this.getSignatureId();
        String other$signatureId = other.getSignatureId();
        if (this$signatureId == null ? other$signatureId != null : !this$signatureId.equals(other$signatureId)) {
            return false;
        }
        String this$templateId = this.getTemplateId();
        String other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !this$templateId.equals(other$templateId)) {
            return false;
        }
        String this$templateContent = this.getTemplateContent();
        String other$templateContent = other.getTemplateContent();
        if (this$templateContent == null ? other$templateContent != null : !this$templateContent.equals(other$templateContent)) {
            return false;
        }
        List<String> this$acquisitionLinkIds = this.getAcquisitionLinkIds();
        List<String> other$acquisitionLinkIds = other.getAcquisitionLinkIds();
        return !(this$acquisitionLinkIds == null ? other$acquisitionLinkIds != null : !((Object)this$acquisitionLinkIds).equals(other$acquisitionLinkIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmsDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : ((Object)$contentType).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $signatureId = this.getSignatureId();
        result = result * 59 + ($signatureId == null ? 43 : $signatureId.hashCode());
        String $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : $templateId.hashCode());
        String $templateContent = this.getTemplateContent();
        result = result * 59 + ($templateContent == null ? 43 : $templateContent.hashCode());
        List<String> $acquisitionLinkIds = this.getAcquisitionLinkIds();
        result = result * 59 + ($acquisitionLinkIds == null ? 43 : ((Object)$acquisitionLinkIds).hashCode());
        return result;
    }

    public String toString() {
        return "SmsDto(content=" + this.getContent() + ", contentType=" + this.getContentType() + ", reason=" + this.getReason() + ", signatureId=" + this.getSignatureId() + ", templateId=" + this.getTemplateId() + ", templateContent=" + this.getTemplateContent() + ", acquisitionLinkIds=" + this.getAcquisitionLinkIds() + ")";
    }
}

