/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.service.impl;

import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.OperatorResultCustomerType;
import com.kuaike.scrm.common.enums.sop.SopTaskType;
import com.kuaike.scrm.common.enums.sop.TaskRunStatusEnum;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.call.entity.CallRecord;
import com.kuaike.scrm.dal.call.entity.CallRecordCriteria;
import com.kuaike.scrm.dal.call.mapper.CallRecordMapper;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTask;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendTaskMapper;
import com.kuaike.scrm.dal.marketing.dto.sop.SopCustomerTaskQuery;
import com.kuaike.scrm.dal.marketing.entity.SopContent;
import com.kuaike.scrm.dal.marketing.entity.SopTaskDetail;
import com.kuaike.scrm.dal.marketing.entity.SopTemplate;
import com.kuaike.scrm.dal.marketing.entity.SopTemplateTimes;
import com.kuaike.scrm.dal.marketing.mapper.SopConditionMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopContentMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopTaskDetailMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopTemplateMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopTemplateTimesMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopTemplateTimesTaskMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.sms.entity.SmsTask;
import com.kuaike.scrm.dal.sms.entity.SmsTaskCriteria;
import com.kuaike.scrm.dal.sms.mapper.SmsTaskMapper;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskDetailMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.sop.dto.req.SopTaskReqDto;
import com.kuaike.scrm.sop.dto.resp.SopTaskDetailRespDto;
import com.kuaike.scrm.sop.dto.resp.SopTaskRespDto;
import com.kuaike.scrm.sop.service.SopTaskDetailService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SopTaskDetailServiceImpl
implements SopTaskDetailService {
    private static final Logger log = LoggerFactory.getLogger(SopTaskDetailServiceImpl.class);
    @Resource
    private SopTaskDetailMapper sopTaskDetailMapper;
    @Resource
    private SmsTaskMapper smsTaskMapper;
    @Resource
    private CallRecordMapper callRecordMapper;
    @Resource
    private TelAddFriendTaskDetailMapper telAddFriendTaskDetailMapper;
    @Resource
    private MessageGroupSendTaskMapper messageGroupSendTaskMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private SopConditionMapper sopConditionMapper;
    @Resource
    private SopTemplateMapper sopTemplateMapper;
    @Resource
    private SopTemplateTimesMapper sopTemplateTimesMapper;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private CcCustomerDetailService ccCustomerDetailService;
    @Resource
    private SopContentMapper sopContentMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private SopTemplateTimesTaskMapper sopTemplateTimesTaskMapper;
    @Autowired
    private SettingService settingService;

    @Override
    public SopTaskRespDto list(String customerNum) {
        log.info("list customerNum:{}", (Object)customerNum);
        List customerNums = this.ccCustomerNumService.getCustomerNums(LoginUtils.getCurrentUserBizId(), customerNum);
        ArrayList statusList = Lists.newArrayList((Object[])new Integer[]{TaskRunStatusEnum.EXECUTED.getStatus(), TaskRunStatusEnum.SUCCESS.getStatus()});
        List sopTaskDetails = this.sopTaskDetailMapper.selectSopListByCustomerNums(LoginUtils.getCurrentUserBizId(), (Collection)customerNums, (Collection)statusList);
        if (CollectionUtils.isEmpty((Collection)sopTaskDetails)) {
            return null;
        }
        return this.buildSopTaskRespDto((SopTaskDetail)sopTaskDetails.get(0));
    }

    @Override
    public List<SopTaskDetailRespDto> detail(SopTaskReqDto params) {
        log.info("detail params:{}", (Object)params);
        List customerNums = this.ccCustomerNumService.getCustomerNums(LoginUtils.getCurrentUserBizId(), params.getCustomerNum());
        ArrayList statusList = Lists.newArrayList((Object[])new Integer[]{TaskRunStatusEnum.EXECUTED.getStatus(), TaskRunStatusEnum.SUCCESS.getStatus()});
        List sopTaskDetails = this.sopTaskDetailMapper.selectSopDetailByCustomerNums(LoginUtils.getCurrentUserBizId(), (Collection)customerNums, (Collection)statusList, params.getSopId(), params.getPageDto());
        if (CollectionUtils.isEmpty((Collection)sopTaskDetails)) {
            return Collections.emptyList();
        }
        if (params.getPageDto() != null) {
            int total = this.sopTaskDetailMapper.selectSopDetailCountByCustomerNums(LoginUtils.getCurrentUserBizId(), (Collection)Lists.newArrayList((Object[])new String[]{params.getCustomerNum()}), (Collection)statusList, params.getSopId());
            params.getPageDto().setCount(Integer.valueOf(total));
        }
        return this.buildSopTaskDetailRespDtoList(sopTaskDetails, Maps.newHashMap(), Maps.newHashMap());
    }

    @Override
    public List<SopTaskRespDto> sopCustomerList(SopTaskReqDto params) {
        List sopTaskDetails;
        log.info("sopCustomerList params:{}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params.getPageDto() == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        if (CollectionUtils.isEmpty((Collection)manageUserIds)) {
            return Lists.newArrayList();
        }
        SopCustomerTaskQuery query = this.getCustomerTaskQuery(userInfo.getBizId(), params, manageUserIds, userInfo.getWeworkUserId());
        query.setStatusList((List)Lists.newArrayList((Object[])new Integer[]{TaskRunStatusEnum.EXECUTED.getStatus(), TaskRunStatusEnum.SUCCESS.getStatus()}));
        if (params.getPageDto() != null) {
            int total = this.sopTaskDetailMapper.customerTaskListCount(query);
            params.getPageDto().setCount(Integer.valueOf(total));
        }
        if (CollectionUtils.isEmpty((Collection)(sopTaskDetails = this.sopTaskDetailMapper.customerTaskList(query)))) {
            return Lists.newArrayList();
        }
        List userIds = sopTaskDetails.stream().map(SopTaskDetail::getUserId).collect(Collectors.toList());
        Map userMap = this.userMapper.selectUserIdAndNameByIds(userInfo.getBizId(), userInfo.getCorpId(), userIds);
        ArrayList result = Lists.newArrayList();
        sopTaskDetails.forEach(sopTaskDetail -> result.add(this.buildSopTaskRespDto(userInfo.getBizId(), (SopTaskDetail)sopTaskDetail, (String)userMap.get(sopTaskDetail.getUserId()))));
        return result;
    }

    @Override
    public List<SopTaskDetailRespDto> sopCustomerDetailList(SopTaskReqDto params) {
        log.info("sopCustomerDetailList params:{}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        ArrayList statusList = Lists.newArrayList((Object[])new Integer[]{TaskRunStatusEnum.EXECUTED.getStatus(), TaskRunStatusEnum.SUCCESS.getStatus()});
        List sopTaskDetails = this.sopTaskDetailMapper.selectSopDetailByCustomerNums(userInfo.getBizId(), (Collection)Lists.newArrayList((Object[])new String[]{params.getCustomerNum()}), (Collection)statusList, params.getSopId(), params.getPageDto());
        log.info("sopCustomerDetailList sopTaskDetails:{}", (Object)sopTaskDetails);
        if (CollectionUtils.isEmpty((Collection)sopTaskDetails)) {
            return Lists.newArrayList();
        }
        if (params.getPageDto() != null) {
            int total = this.sopTaskDetailMapper.selectSopDetailCountByCustomerNums(userInfo.getBizId(), (Collection)Lists.newArrayList((Object[])new String[]{params.getCustomerNum()}), (Collection)statusList, params.getSopId());
            params.getPageDto().setCount(Integer.valueOf(total));
        }
        Set sopTemplateIds = sopTaskDetails.stream().filter(sopTaskDetail -> sopTaskDetail.getSopTaskTemplateId() != null).map(SopTaskDetail::getSopTaskTemplateId).collect(Collectors.toSet());
        Set sopTaskTemplateTimesIds = sopTaskDetails.stream().filter(sopTaskDetail -> sopTaskDetail.getSopTaskTemplateTimesTaskId() != null).map(SopTaskDetail::getSopTaskTemplateTimesTaskId).collect(Collectors.toSet());
        List sopTemplates = this.sopTemplateMapper.queryByIds(userInfo.getBizId(), sopTemplateIds);
        Map<Long, String> sopTemplateMap = sopTemplates.stream().collect(Collectors.toMap(SopTemplate::getId, SopTemplate::getTemplateName));
        Map sopTaskTemplateTimesIdsMap = this.sopTemplateTimesTaskMapper.queryIds(sopTaskTemplateTimesIds);
        List sopTemplateTimes = this.sopTemplateTimesMapper.queryByIds(userInfo.getBizId(), sopTaskTemplateTimesIdsMap.values());
        Map<Long, String> temMap = sopTemplateTimes.stream().collect(Collectors.toMap(SopTemplateTimes::getId, SopTemplateTimes::getName));
        HashMap sopTemplateTimesMap = Maps.newHashMap();
        for (Long sopTaskTemplateTimeId : sopTaskTemplateTimesIds) {
            Long sopTemplateTimesId = (Long)sopTaskTemplateTimesIdsMap.get(sopTaskTemplateTimeId);
            sopTemplateTimesMap.put(sopTaskTemplateTimeId, temMap.get(sopTemplateTimesId));
        }
        return this.buildSopTaskDetailRespDtoList(sopTaskDetails, sopTemplateMap, sopTemplateTimesMap);
    }

    private SopCustomerTaskQuery getCustomerTaskQuery(Long bizId, SopTaskReqDto params, Set<Long> userIds, String weworkUserId) {
        SopCustomerTaskQuery query = new SopCustomerTaskQuery();
        query.setBizId(bizId);
        query.setSopName(params.getSopName());
        query.setQuery(params.getQuery());
        query.setWeworkUserId(weworkUserId);
        query.setUserIds(userIds);
        query.setPageDto(params.getPageDto());
        return query;
    }

    private SopTaskRespDto buildSopTaskRespDto(Long bizId, SopTaskDetail sopTaskDetail, String userName) {
        WeworkContact weworkContact;
        String corpId = LoginUtils.getCurrentUserCorpId();
        SopTaskRespDto sopTaskRespDto = new SopTaskRespDto();
        sopTaskRespDto.setSopId(sopTaskDetail.getSopNum());
        sopTaskRespDto.setSopName(sopTaskDetail.getSopName());
        List sopContents = this.sopContentMapper.sopStageListBySeq(bizId, sopTaskDetail.getSopId(), sopTaskDetail.getStageSeq());
        sopTaskRespDto.setStageName(sopTaskDetail.getStageName());
        if (CollectionUtils.isNotEmpty((Collection)sopContents) && sopContents.size() == 1) {
            sopTaskRespDto.setStageName(((SopContent)sopContents.get(0)).getStageName());
        }
        sopTaskRespDto.setCustomerNum(sopTaskDetail.getCustomerNum());
        boolean mobileEncrypt = this.settingService.getMobileEncrypt(bizId);
        if (sopTaskDetail.getCustomerType() == OperatorResultCustomerType.MOBILE.getType()) {
            sopTaskRespDto.setMobile(sopTaskDetail.getCustomerId());
        } else {
            sopTaskRespDto.setContactId(sopTaskDetail.getCustomerId());
        }
        if (mobileEncrypt) {
            sopTaskRespDto.setMobile(MobileUtils.encryptMobile((String)sopTaskRespDto.getMobile()));
        }
        sopTaskRespDto.setCustomerType(sopTaskDetail.getCustomerType());
        sopTaskRespDto.setCustomerId(sopTaskDetail.getCustomerId());
        sopTaskRespDto.setUserName(userName);
        CustomerDetailResp customerDetailResp = this.ccCustomerDetailService.queryCustomerDetail(bizId, sopTaskDetail.getCustomerNum());
        sopTaskRespDto.setAvatar(customerDetailResp.getAvatar());
        sopTaskRespDto.setCorpName(customerDetailResp.getCorpName());
        if (StringUtils.isNotBlank((CharSequence)sopTaskRespDto.getContactId()) && (weworkContact = this.weworkContactMapper.queryContactByContactId(corpId, sopTaskRespDto.getContactId())) != null && weworkContact.getType() == 2) {
            sopTaskRespDto.setCorpName(weworkContact.getCorpName());
        }
        if (StringUtils.isBlank((CharSequence)sopTaskDetail.getName())) {
            sopTaskRespDto.setNickname(customerDetailResp.getName());
        } else {
            sopTaskRespDto.setNickname(sopTaskDetail.getName());
        }
        if (StringUtils.isBlank((CharSequence)sopTaskDetail.getRemarkName())) {
            sopTaskRespDto.setRemarkName(customerDetailResp.getRemark());
        } else {
            sopTaskRespDto.setRemarkName(sopTaskDetail.getRemarkName());
        }
        return sopTaskRespDto;
    }

    private SopTaskRespDto buildSopTaskRespDto(SopTaskDetail sopTaskDetail) {
        SopTaskRespDto sopTaskRespDto = new SopTaskRespDto();
        sopTaskRespDto.setSopId(sopTaskDetail.getSopNum());
        sopTaskRespDto.setSopName(sopTaskDetail.getSopName());
        sopTaskRespDto.setStageName(sopTaskDetail.getStageName());
        return sopTaskRespDto;
    }

    private List<SopTaskDetailRespDto> buildSopTaskDetailRespDtoList(List<SopTaskDetail> sopTaskDetails, Map<Long, String> sopTemplateMap, Map<Long, String> sopTemplateTimesMap) {
        Map<Long, Long> smsTaskIdMap = sopTaskDetails.stream().filter(sopTaskDetail -> sopTaskDetail.getTaskType().equals(3)).collect(Collectors.toMap(SopTaskDetail::getId, SopTaskDetail::getFkId));
        List smsTasks = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(smsTaskIdMap.values())) {
            SmsTaskCriteria smsTaskCriteria = new SmsTaskCriteria();
            smsTaskCriteria.createCriteria().andIdIn((List)Lists.newArrayList(smsTaskIdMap.values()));
            smsTasks = this.smsTaskMapper.selectByExample((Object)smsTaskCriteria);
        }
        Map<Long, Long> callTaskDetailIdMap = sopTaskDetails.stream().filter(sopTaskDetail -> sopTaskDetail.getTaskType().equals(2)).collect(Collectors.toMap(SopTaskDetail::getId, SopTaskDetail::getFkId2));
        List callRecords = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(callTaskDetailIdMap.values())) {
            CallRecordCriteria callRecordCriteria = new CallRecordCriteria();
            callRecordCriteria.createCriteria().andCallTaskDetailIdIn((List)Lists.newArrayList(callTaskDetailIdMap.values()));
            callRecordCriteria.setOrderByClause("id desc");
            callRecords = this.callRecordMapper.selectByExample((Object)callRecordCriteria);
        }
        Map<Long, Long> groupSendIdMap = sopTaskDetails.stream().filter(sopTaskDetail -> sopTaskDetail.getTaskType().equals(1)).collect(Collectors.toMap(SopTaskDetail::getId, SopTaskDetail::getFkId));
        List messageGroupSendTasks = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(groupSendIdMap.values())) {
            messageGroupSendTasks = this.messageGroupSendTaskMapper.queryByIds(groupSendIdMap.values());
        }
        ArrayList result = Lists.newArrayList();
        for (SopTaskDetail sopTaskDetail2 : sopTaskDetails) {
            SopTaskDetailRespDto sopTaskDetailRespDto = new SopTaskDetailRespDto();
            sopTaskDetailRespDto.setTaskType(sopTaskDetail2.getTaskType());
            sopTaskDetailRespDto.setTaskTypeDesc(SopTaskType.getDescByValue((Integer)sopTaskDetail2.getTaskType()));
            sopTaskDetailRespDto.setRunTime(sopTaskDetail2.getRunTime());
            sopTaskDetailRespDto.setSopName(sopTaskDetail2.getSopName());
            sopTaskDetailRespDto.setStageName(sopTaskDetail2.getStageName());
            sopTaskDetailRespDto.setTemplateName(sopTemplateMap.get(sopTaskDetail2.getSopTaskTemplateId()));
            sopTaskDetailRespDto.setTemplateTimesName(sopTemplateTimesMap.get(sopTaskDetail2.getSopTaskTemplateTimesTaskId()));
            switch (SopTaskType.getType((Integer)sopTaskDetail2.getTaskType())) {
                case GROUP_SEND: {
                    MessageGroupSendTask task = messageGroupSendTasks.stream().filter(item -> item.getId().equals(sopTaskDetail2.getFkId())).findFirst().orElse(new MessageGroupSendTask());
                    SopTaskDetailRespDto.GroupSendRespDto groupSendRespDto = new SopTaskDetailRespDto.GroupSendRespDto();
                    groupSendRespDto.setContent(task.getContent());
                    sopTaskDetailRespDto.setGroupSendInfo(groupSendRespDto);
                    break;
                }
                case CALL: {
                    CallRecord callRecord = callRecords.stream().filter(item -> item.getCallTaskDetailId().equals(sopTaskDetail2.getFkId2())).findFirst().orElse(new CallRecord());
                    SopTaskDetailRespDto.CallRespDto callRespDto = new SopTaskDetailRespDto.CallRespDto();
                    callRespDto.setCallDuration(callRecord.getCallDuration());
                    callRespDto.setStatus(callRecord.getStatus());
                    callRespDto.setVoiceUrl(callRecord.getVoiceUrl());
                    sopTaskDetailRespDto.setCallInfo(callRespDto);
                    break;
                }
                case SMS: {
                    SmsTask smsTask = smsTasks.stream().filter(item -> item.getId().equals(sopTaskDetail2.getFkId())).findFirst().orElse(new SmsTask());
                    SopTaskDetailRespDto.SmsRespDto smsRespDto = new SopTaskDetailRespDto.SmsRespDto();
                    smsRespDto.setContent(smsTask.getContent());
                    smsRespDto.setSignature(smsTask.getSignatureId());
                    sopTaskDetailRespDto.setSmsInfo(smsRespDto);
                    break;
                }
                case TEL_ADD_FRIEND: {
                    SopTaskDetailRespDto.FriendRespDto friendRespDto = new SopTaskDetailRespDto.FriendRespDto();
                    friendRespDto.setPhone(sopTaskDetail2.getCustomerId());
                    friendRespDto.setRemark("\u7533\u8bf7\u52a0\u597d\u53cb");
                    sopTaskDetailRespDto.setAddFriendInfo(friendRespDto);
                    break;
                }
            }
            result.add(sopTaskDetailRespDto);
        }
        return result;
    }
}

