/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.service;

import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.component.CommonDelayQueueManager;
import com.kuaike.scrm.common.component.DistributedLock;
import com.kuaike.scrm.common.component.IDelayQueueHandler;
import com.kuaike.scrm.common.dto.OperatorNoticeDto;
import com.kuaike.scrm.common.dto.OperatorResult;
import com.kuaike.scrm.common.dto.SopTaskEvent;
import com.kuaike.scrm.common.enums.DelayHandleType;
import com.kuaike.scrm.common.enums.OperatorResultStatus;
import com.kuaike.scrm.common.utils.ThreadTools;
import com.kuaike.scrm.dal.marketing.entity.SopCalTask;
import com.kuaike.scrm.dal.marketing.entity.SopCalTaskDetail;
import com.kuaike.scrm.dal.marketing.mapper.SopCalTaskMapper;
import com.kuaike.scrm.sop.operators.functions.OperatorInvokeService;
import com.kuaike.scrm.sop.service.OperatorConvertService;
import com.kuaike.scrm.sop.service.OperatorResultService;
import com.kuaike.scrm.sop.service.SopCalTaskDetailService;
import com.kuaike.scrm.sop.service.SopCalTaskService;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
public class OperatorEngineService
implements IDelayQueueHandler {
    private static final Logger log = LoggerFactory.getLogger(OperatorEngineService.class);
    @Autowired
    private SopCalTaskMapper sopCalTaskMapper;
    @Autowired
    private SopCalTaskDetailService sopCalTaskDetailService;
    @Autowired
    private OperatorResultService operatorResultService;
    @Autowired
    private OperatorInvokeService operatorInvokeService;
    @Autowired
    private OperatorConvertService operatorConvertService;
    @Autowired
    private SopCalTaskService sopCalTaskService;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private DistributedLock lock;
    @Autowired
    private CommonDelayQueueManager delayQueueManager;
    @Value(value="${kafka.topic.sopTaskEvent}")
    private String sopTaskEventTopic;
    @Value(value="${sopCalTaskDetail.zombieInvokeGap:120000}")
    private Long zombieInvokeGap;

    public void startTask(Long taskId) {
        log.info("start operator task,taskId={}", (Object)taskId);
        if (Objects.isNull(taskId)) {
            log.info("taskId is null, exit");
            return;
        }
        SopCalTask sopCalTask = (SopCalTask)this.sopCalTaskMapper.selectByPrimaryKey((Object)taskId);
        if (Objects.isNull(sopCalTask) || sopCalTask.getIsDeleted().booleanValue()) {
            log.info("sopCallTask not exists,taskId={}", (Object)taskId);
            return;
        }
        if (sopCalTask.getTaskStatus() > OperatorResultStatus.WAITING.getStatus()) {
            log.info("sopCallTask have start,taskId={}, status={}", (Object)taskId, (Object)OperatorResultStatus.getByStatus((Integer)sopCalTask.getTaskStatus()));
            return;
        }
        this.sopCalTaskDetailService.logicDelete(taskId);
        List<SopCalTaskDetail> detailList = this.sopCalTaskService.splitTaskDetail(taskId);
        this.sopCalTaskDetailService.batchInsertDetail(detailList);
        for (SopCalTaskDetail sopCalTaskDetail : detailList) {
            ThreadTools.getIoTaskThreadPool().submit(() -> {
                try {
                    this.callConditionOperator(sopCalTaskDetail.getId());
                }
                catch (Exception e) {
                    log.error("callConditionOperator with error", (Throwable)e);
                }
            });
        }
    }

    public void callConditionOperator(Long detailId) {
        String requestId;
        OperatorResult operatorResult;
        log.info("callConditionOperator with detailId={}", (Object)detailId);
        if (Objects.isNull(detailId)) {
            log.info("detailId is null, exit");
            return;
        }
        SopCalTaskDetail detail = this.sopCalTaskDetailService.queryById(detailId);
        if (Objects.isNull(detail) || detail.getIsDeleted().booleanValue()) {
            log.info("detail is not exists, detailId={}, exit", (Object)detailId);
            return;
        }
        boolean needExec = false;
        if (Objects.equals(OperatorResultStatus.WAITING.getStatus(), detail.getStatus())) {
            needExec = true;
        } else if (Objects.equals(OperatorResultStatus.EXECUTING.getStatus(), detail.getStatus()) && Objects.equals((operatorResult = this.operatorResultService.queryByRequestId(detail.getResultRequestId())).getStatus(), OperatorResultStatus.EXECUTING.getStatus()) && Objects.nonNull(operatorResult.getUpdateTime()) && System.currentTimeMillis() - operatorResult.getUpdateTime().getTime() > this.zombieInvokeGap) {
            needExec = true;
        }
        if (needExec && Objects.nonNull(requestId = this.operatorInvokeService.conditionIdExecute(detail.getSopConditionId()))) {
            detail.setUpdateBy(Long.valueOf(-1L));
            detail.setUpdateTime(new Date());
            detail.setStatus(OperatorResultStatus.EXECUTING.getStatus());
            detail.setResultRequestId(requestId);
            this.sopCalTaskDetailService.updateDetail(detail);
            log.info("update sopCalTaskDetail requestId={}", (Object)requestId);
            this.sopCalTaskMapper.updateStatusAndLastTaskDetailId(detail.getTaskId(), OperatorResultStatus.EXECUTING.getStatus(), new Date(), null);
        }
    }

    public void dealOperatorResult(OperatorNoticeDto notice) {
        log.info("dealOperatorResult with notice={}", (Object)notice);
        if (Objects.isNull(notice) || Objects.isNull(notice.getRequestId())) {
            log.info("notice is null or requestId is null");
            return;
        }
        if (!this.checkExistAndUpdate(notice)) {
            String json = JacksonUtil.obj2Str((Object)notice);
            this.delayQueueManager.addQueue(DelayHandleType.SOP_CAL_TASK_DETAIL_REQUEST_ID, json, 1L, TimeUnit.SECONDS, Integer.valueOf(3), Long.valueOf(4000L));
        }
    }

    public DelayHandleType getType() {
        return DelayHandleType.SOP_CAL_TASK_DETAIL_REQUEST_ID;
    }

    public boolean handleDelayItemContent(String content) {
        OperatorNoticeDto notice = null;
        try {
            notice = (OperatorNoticeDto)JacksonUtil.str2Obj((String)content, OperatorNoticeDto.class);
        }
        catch (IOException e) {
            log.error("parse json with error", (Throwable)e);
        }
        return this.checkExistAndUpdate(notice);
    }

    private boolean checkExistAndUpdate(OperatorNoticeDto notice) {
        SopCalTaskDetail detail = this.sopCalTaskDetailService.queryByRequestId(notice.getRequestId());
        if (Objects.isNull(detail) || detail.getIsDeleted().booleanValue()) {
            log.info("detail is not exist,requestId={}", (Object)notice.getRequestId());
            return false;
        }
        detail.setStatus(notice.getStatus());
        detail.setUpdateTime(notice.getTime());
        this.sopCalTaskDetailService.updateDetail(detail);
        if (Objects.equals(notice.getStatus(), OperatorResultStatus.FINISH.getStatus())) {
            this.updateTask(detail.getTaskId());
        } else {
            this.sopCalTaskMapper.updateStatusAndLastTaskDetailId(detail.getTaskId(), OperatorResultStatus.FAIL.getStatus(), notice.getTime(), null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTask(Long taskId) {
        String lockKey = "sopCalTaskUpdateLock_" + taskId;
        try {
            this.lock.lock(lockKey, 10L, 15L, TimeUnit.SECONDS);
            this.handleTaskCal(taskId);
        }
        catch (Exception e) {
            log.error("handleTaskCal with error", (Throwable)e);
        }
        finally {
            this.lock.unlock(lockKey);
        }
    }

    public void handleTaskCal(Long taskId) {
        SopCalTask task = (SopCalTask)this.sopCalTaskMapper.selectByPrimaryKey((Object)taskId);
        if (Objects.isNull(task) || task.getIsDeleted().booleanValue()) {
            log.info("task is not exists");
            return;
        }
        if (task.getTaskStatus() > OperatorResultStatus.EXECUTING.getStatus()) {
            log.info("task have been finished");
            return;
        }
        SopCalTaskDetail latestNeedMergeDetail = this.sopCalTaskDetailService.queryLatestNeedMergeDetail(taskId, task.getLastTaskDetailId());
        OperatorResult result = this.operatorResultService.queryByRequestId(task.getResultRequestId());
        log.info("before op result requestId={}, list size={}", (Object)result.getRequestId(), (Object)CollectionUtils.size((Object)result.getList()));
        while (Objects.nonNull(latestNeedMergeDetail)) {
            OperatorResult currentResult = this.operatorResultService.queryByRequestId(latestNeedMergeDetail.getResultRequestId());
            currentResult = this.operatorConvertService.resultConvert(currentResult, task.getWantedResultType());
            log.info("before op currentResult requestId={}, list size={}", (Object)currentResult.getRequestId(), (Object)CollectionUtils.size((Object)currentResult.getList()));
            if (Objects.nonNull(task.getLastTaskDetailId()) && task.getLastTaskDetailId() > 0L || StringUtils.isNotBlank((CharSequence)task.getPreRequestId())) {
                log.info("not first execute, resultRequestId={}, detailRequestId={}, detailId={}", new Object[]{task.getResultRequestId(), latestNeedMergeDetail.getResultRequestId(), latestNeedMergeDetail.getId()});
                result = this.operatorInvokeService.execConditionOp(result.getRequestId(), result, currentResult, latestNeedMergeDetail.getSopConditionId());
            } else {
                log.info("first execute, resultRequestId={}, detailRequestId={}, detailId={}", new Object[]{task.getResultRequestId(), latestNeedMergeDetail.getResultRequestId(), latestNeedMergeDetail.getId()});
                result.setList(currentResult.getList());
                result.setCustomerType(currentResult.getCustomerType());
                result.setMemberType(currentResult.getMemberType());
            }
            task.setLastTaskDetailId(latestNeedMergeDetail.getId());
            log.info("after op result requestId={}, list size={}", (Object)result.getRequestId(), (Object)CollectionUtils.size((Object)result.getList()));
            latestNeedMergeDetail = this.sopCalTaskDetailService.queryLatestNeedMergeDetail(taskId, task.getLastTaskDetailId());
        }
        SopCalTask dbTask = (SopCalTask)this.sopCalTaskMapper.selectByPrimaryKey((Object)taskId);
        if (Objects.equals(dbTask.getLastTaskDetailId(), task.getLastTaskDetailId())) {
            log.info("sopCalTask not change, taskId={}", (Object)taskId);
            return;
        }
        Integer taskStatus = task.getTaskStatus();
        boolean finish = this.sopCalTaskDetailService.ifTaskFinish(task);
        if (finish) {
            taskStatus = OperatorResultStatus.FINISH.getStatus();
        }
        this.sopCalTaskMapper.updateStatusAndLastTaskDetailId(task.getId(), taskStatus, new Date(), task.getLastTaskDetailId());
        result.setStatus(taskStatus);
        log.info("result requestId={} list size={}", (Object)result.getRequestId(), (Object)CollectionUtils.size((Object)result.getList()));
        this.operatorResultService.updateResult(result);
        if (Objects.equals(taskStatus, OperatorResultStatus.FINISH.getStatus())) {
            this.sendEvent(task.getResultRequestId(), taskStatus, task.getId());
        }
    }

    public OperatorResult execute(String baseRequestId, String rightRequestId, Long conditionId) {
        OperatorResult result = this.operatorResultService.queryByRequestId(baseRequestId);
        OperatorResult currentResult = this.operatorResultService.queryByRequestId(rightRequestId);
        result = this.operatorInvokeService.execConditionOp(result.getRequestId(), result, currentResult, conditionId);
        return result;
    }

    private void sendEvent(String requestId, Integer status, Long taskId) {
        log.info("send sopCalTaskEvent to kafka: requestId={}, status={}, taskId={}", new Object[]{requestId, status, taskId});
        SopTaskEvent sopTaskEvent = new SopTaskEvent();
        sopTaskEvent.setStatus(status);
        sopTaskEvent.setRequestId(requestId);
        sopTaskEvent.setTaskId(taskId);
        this.kafkaTemplate.send(this.sopTaskEventTopic, (Object)requestId, (Object)JacksonUtil.obj2Str((Object)sopTaskEvent));
    }
}

