/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.operators.functions.impl;

import cn.kinyun.customer.center.dto.req.operator.NewCustomerQueryReq;
import cn.kinyun.customer.center.service.CcOperatorService;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.dal.marketing.mapper.SopUserMapper;
import com.kuaike.scrm.sop.dto.OperatorCommonDto;
import com.kuaike.scrm.sop.dto.req.SopNewCustomerParseDto;
import com.kuaike.scrm.sop.enums.ConditionTypeEnum;
import com.kuaike.scrm.sop.operators.functions.AbstractOperatorInvoker;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewCustomerQueryInvoker
extends AbstractOperatorInvoker<SopNewCustomerParseDto> {
    private static final Logger log = LoggerFactory.getLogger(NewCustomerQueryInvoker.class);
    @Autowired
    private SopUserMapper sopUserMapper;
    @Autowired
    private CcOperatorService ccOperatorService;

    @Override
    public String invoke(OperatorCommonDto commonDto, SopNewCustomerParseDto conditionDto) {
        log.info("new customer query invoker op commonDto:{}, conditionDto: {}", (Object)commonDto, (Object)conditionDto);
        if (conditionDto == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "sopCondition \u4e3a\u7a7a");
        }
        if (conditionDto.getQyNewCustomer() == null && conditionDto.getNewLeads() == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        if (conditionDto.getQyNewCustomer() == null) {
            conditionDto.setQyNewCustomer(0);
        }
        if (conditionDto.getNewLeads() == null) {
            conditionDto.setNewLeads(0);
        }
        NewCustomerQueryReq req = new NewCustomerQueryReq();
        req.setBizId(commonDto.getBizId());
        req.setUserIds(commonDto.getUserIds());
        int customerType = 0;
        req.setAddFriendStart(conditionDto.getAddFriendStart());
        req.setAddFriendEnd(conditionDto.getAddFriendEnd());
        req.setBindStart(conditionDto.getBindStart());
        req.setBindEnd(conditionDto.getBindEnd());
        if (conditionDto.getQyNewCustomer() == 1) {
            customerType = 1;
        }
        if (conditionDto.getNewLeads() == 1) {
            customerType = 2;
        }
        if (conditionDto.getQyNewCustomer() == 1 && conditionDto.getNewLeads() == 1) {
            customerType = 3;
        }
        req.setCustomerType(customerType);
        return this.ccOperatorService.newCustomerAsync(req);
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.NEW_CUSTOMER;
    }

    @Override
    public SopNewCustomerParseDto getParam(String json) {
        try {
            return (SopNewCustomerParseDto)JacksonUtil.str2Obj((String)json, SopNewCustomerParseDto.class);
        }
        catch (IOException e) {
            log.error("parse json with error", (Throwable)e);
            return null;
        }
    }

    @Override
    public void validate(SopNewCustomerParseDto newCustomerParseDto) {
        Preconditions.checkArgument((newCustomerParseDto != null ? 1 : 0) != 0, (Object)"\u6761\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((newCustomerParseDto.getQyNewCustomer() != null ? 1 : 0) != 0, (Object)"\u662f\u5426\u4f01\u4e1a\u65b0\u5ba2\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((newCustomerParseDto.getAddFriendStart() != null ? 1 : 0) != 0, (Object)"\u4f01\u4e1a\u65b0\u5ba2\u6dfb\u52a0\u597d\u53cb\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((newCustomerParseDto.getAddFriendEnd() != null ? 1 : 0) != 0, (Object)"\u4f01\u4e1a\u65b0\u5ba2\u6dfb\u52a0\u597d\u53cb\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((newCustomerParseDto.getNewLeads() != null ? 1 : 0) != 0, (Object)"\u662f\u5426\u662f\u65b0\u7ed1\u5b9a\u7ebf\u7d22\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((newCustomerParseDto.getBindStart() != null ? 1 : 0) != 0, (Object)"\u7ebf\u7d22\u7ed1\u5b9a\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((newCustomerParseDto.getBindEnd() != null ? 1 : 0) != 0, (Object)"\u7ebf\u7d22\u7ed1\u5b9a\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

