/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.dto;

import cn.kinyun.customer.center.dto.req.IdAndNameDto;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.sop.dto.SopBaseReq;
import com.kuaike.scrm.sop.dto.SopConditionReq;
import com.kuaike.scrm.sop.dto.SopStageReq;
import com.kuaike.scrm.sop.dto.req.SopConditionParseDto;
import com.kuaike.scrm.sop.dto.req.SopNewCustomerParseDto;
import com.kuaike.scrm.sop.dto.req.SopStageParseDto;
import com.kuaike.scrm.sop.dto.req.SopTagParseDto;
import com.kuaike.scrm.sop.enums.ConditionTypeEnum;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SopAddOrModReq
extends SopBaseReq {
    private static final Logger log = LoggerFactory.getLogger(SopAddOrModReq.class);
    private String sopName;
    private Integer sopType;
    private Integer isEnable;
    private List<IdAndNameDto> users;
    private List<SopStageReq> stages;

    public void validateParam() {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.sopName), (Object)"\u8425\u9500\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.sopType != null ? 1 : 0) != 0, (Object)"\u5708\u8bfe\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.users != null && this.users.size() > 0 ? 1 : 0) != 0, (Object)"\u9009\u62e9\u5458\u5de5\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.stages != null && this.stages.size() > 0 ? 1 : 0) != 0, (Object)"\u65c5\u7a0b\u9636\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        for (SopStageReq stageReq : this.stages) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)stageReq.getStageName()), (Object)"\u9636\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((stageReq.getStageSeq() != null ? 1 : 0) != 0, (Object)"\u9636\u6bb5\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(stageReq.getConditions()), (Object)"\u9636\u6bb5\u8fdb\u5165\u6761\u4ef6\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
            if (StringUtils.isNotEmpty((CharSequence)stageReq.getRemindContent())) {
                Preconditions.checkArgument((stageReq.getRemindContent().length() < 200 ? 1 : 0) != 0, (Object)"\u63d0\u9192\u5185\u5bb9\u4e0d\u80fd\u8fc7\u957f");
            }
            for (SopConditionReq conditionReq : stageReq.getConditions()) {
                ConditionTypeEnum typeEnum = ConditionTypeEnum.get(conditionReq.getConditionType());
                this.checkConditionContent(typeEnum, conditionReq.getConditionContent());
            }
        }
    }

    private void checkConditionContent(ConditionTypeEnum typeEnum, String conditionContent) {
        SopConditionParseDto parseDto;
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)conditionContent), (Object)"\u8fdb\u5165\u6761\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            parseDto = (SopConditionParseDto)JSON.parseObject((String)conditionContent, SopConditionParseDto.class);
        }
        catch (Exception e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u89e3\u6790\u53c2\u6570\u5f02\u5e38");
        }
        Preconditions.checkArgument((parseDto != null ? 1 : 0) != 0, (Object)"parseDto \u89e3\u6790\u7684\u53c2\u6570\u5f02\u5e38");
        String paramJson = JSON.toJSONString((Object)parseDto.getParam());
        log.info("checkConditionContent paramJson: {}", (Object)paramJson);
        switch (typeEnum) {
            case CUSTOMER_TAG: {
                List tagDtoList = (List)JSON.parseObject((String)paramJson, List.class);
                Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)tagDtoList), (Object)"\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
                for (Object dto : tagDtoList) {
                    String tagParseStr = JSON.toJSONString(dto);
                    SopTagParseDto tagParseDto = (SopTagParseDto)JSON.parseObject((String)tagParseStr, SopTagParseDto.class);
                    Preconditions.checkArgument((tagParseDto != null ? 1 : 0) != 0, (Object)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
                    Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tagParseDto.getTagId()), (Object)"tagId\u4e0d\u80fd\u4e3a\u7a7a");
                    Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tagParseDto.getGroupId()), (Object)"groupId\u4e0d\u80fd\u4e3a\u7a7a");
                    Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tagParseDto.getName()), (Object)"tagName\u4e0d\u80fd\u4e3a\u7a7a");
                }
                break;
            }
            case CUSTOMER_STAGE: {
                List stageDtoList = (List)JSON.parseObject((String)paramJson, List.class);
                Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)stageDtoList), (Object)"\u9636\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                for (Object dto : stageDtoList) {
                    String stageParseStr = JSON.toJSONString(dto);
                    SopStageParseDto stageParseDto = (SopStageParseDto)JSON.parseObject((String)stageParseStr, SopStageParseDto.class);
                    Preconditions.checkArgument((stageParseDto != null ? 1 : 0) != 0, (Object)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
                    Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)stageParseDto.getId()), (Object)"stageId\u4e0d\u80fd\u4e3a\u7a7a");
                    Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)stageParseDto.getName()), (Object)"stageName\u4e0d\u80fd\u4e3a\u7a7a");
                }
                break;
            }
            case NEW_CUSTOMER: {
                SopNewCustomerParseDto newCustomerParseDto = (SopNewCustomerParseDto)JSON.parseObject((String)paramJson, SopNewCustomerParseDto.class);
                Preconditions.checkArgument((newCustomerParseDto != null ? 1 : 0) != 0, (Object)"\u6761\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((newCustomerParseDto.getQyNewCustomer() != null && newCustomerParseDto.getQyNewCustomer() != 0 || newCustomerParseDto.getNewLeads() != null && newCustomerParseDto.getNewLeads() != 0 ? 1 : 0) != 0, (Object)"\u662f\u5426\u662f\u4f01\u4e1a\u65b0\u5ba2\u6216\u9996\u6b21\u7ed1\u5b9a\u7ebf\u7d22\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                break;
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SopAddOrModReq)) {
            return false;
        }
        SopAddOrModReq other = (SopAddOrModReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$sopType = this.getSopType();
        Integer other$sopType = other.getSopType();
        if (this$sopType == null ? other$sopType != null : !((Object)this$sopType).equals(other$sopType)) {
            return false;
        }
        Integer this$isEnable = this.getIsEnable();
        Integer other$isEnable = other.getIsEnable();
        if (this$isEnable == null ? other$isEnable != null : !((Object)this$isEnable).equals(other$isEnable)) {
            return false;
        }
        String this$sopName = this.getSopName();
        String other$sopName = other.getSopName();
        if (this$sopName == null ? other$sopName != null : !this$sopName.equals(other$sopName)) {
            return false;
        }
        List<IdAndNameDto> this$users = this.getUsers();
        List<IdAndNameDto> other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        List<SopStageReq> this$stages = this.getStages();
        List<SopStageReq> other$stages = other.getStages();
        return !(this$stages == null ? other$stages != null : !((Object)this$stages).equals(other$stages));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SopAddOrModReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $sopType = this.getSopType();
        result = result * 59 + ($sopType == null ? 43 : ((Object)$sopType).hashCode());
        Integer $isEnable = this.getIsEnable();
        result = result * 59 + ($isEnable == null ? 43 : ((Object)$isEnable).hashCode());
        String $sopName = this.getSopName();
        result = result * 59 + ($sopName == null ? 43 : $sopName.hashCode());
        List<IdAndNameDto> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        List<SopStageReq> $stages = this.getStages();
        result = result * 59 + ($stages == null ? 43 : ((Object)$stages).hashCode());
        return result;
    }

    public String getSopName() {
        return this.sopName;
    }

    public Integer getSopType() {
        return this.sopType;
    }

    public Integer getIsEnable() {
        return this.isEnable;
    }

    public List<IdAndNameDto> getUsers() {
        return this.users;
    }

    public List<SopStageReq> getStages() {
        return this.stages;
    }

    public void setSopName(String sopName) {
        this.sopName = sopName;
    }

    public void setSopType(Integer sopType) {
        this.sopType = sopType;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public void setUsers(List<IdAndNameDto> users) {
        this.users = users;
    }

    public void setStages(List<SopStageReq> stages) {
        this.stages = stages;
    }

    @Override
    public String toString() {
        return "SopAddOrModReq(sopName=" + this.getSopName() + ", sopType=" + this.getSopType() + ", isEnable=" + this.getIsEnable() + ", users=" + this.getUsers() + ", stages=" + this.getStages() + ")";
    }
}

