/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.initData.service.impl;

import cn.kinyun.crm.common.enums.RawLeadsAllocRule;
import cn.kinyun.crm.common.enums.SourceType;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsReq;
import cn.kinyun.customer.center.dto.req.BatchSetBindingReq;
import cn.kinyun.customer.center.dto.req.BatchSetStageReq;
import cn.kinyun.customer.center.dto.req.BatchSetTagReq;
import cn.kinyun.customer.center.dto.req.CustomerBindReq;
import cn.kinyun.customer.center.dto.req.CustomerDetailReq;
import cn.kinyun.customer.center.dto.req.CustomerEventReq;
import cn.kinyun.customer.center.dto.req.CustomerStageReq;
import cn.kinyun.customer.center.dto.req.CustomerTagReq;
import cn.kinyun.customer.center.dto.req.ModMobileReq;
import cn.kinyun.customer.center.dto.req.SetTagReq;
import cn.kinyun.customer.center.dto.req.event.AccessInfo;
import cn.kinyun.customer.center.dto.req.event.EventData;
import cn.kinyun.customer.center.dto.req.event.EventModule;
import cn.kinyun.customer.center.dto.req.event.EventPage;
import cn.kinyun.customer.center.dto.req.event.EventSharer;
import cn.kinyun.customer.center.dto.req.event.EventVisitor;
import cn.kinyun.customer.center.dto.req.follow.FollowReq;
import cn.kinyun.customer.center.dto.req.follow.FormSubmitDto;
import cn.kinyun.customer.center.dto.req.follow.JsonContentDto;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.enums.EventType;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.enums.VisitorType;
import cn.kinyun.customer.center.service.CcCustomerBindService;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerEventService;
import cn.kinyun.customer.center.service.CcCustomerFollowRecordService;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.CcCustomerStageService;
import cn.kinyun.customer.center.service.CcCustomerTagService;
import cn.kinyun.scrm.initData.service.CustomerCenterDataInitService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.enums.SysChannelEnum;
import com.kuaike.scrm.common.enums.SystemTypeEnum;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.service.dto.req.FollowRecordParamReqDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.contactStage.entity.WeworkContactStage;
import com.kuaike.scrm.dal.contactStage.mapper.WeworkContactStageMapper;
import com.kuaike.scrm.dal.dynamicForm.entity.DynamicForm;
import com.kuaike.scrm.dal.dynamicForm.entity.DynamicFormAccessLog;
import com.kuaike.scrm.dal.dynamicForm.entity.DynamicFormShare;
import com.kuaike.scrm.dal.dynamicForm.entity.DynamicFormSubmit;
import com.kuaike.scrm.dal.dynamicForm.mapper.DynamicFormAccessLogMapper;
import com.kuaike.scrm.dal.dynamicForm.mapper.DynamicFormMapper;
import com.kuaike.scrm.dal.dynamicForm.mapper.DynamicFormShareMapper;
import com.kuaike.scrm.dal.dynamicForm.mapper.DynamicFormSubmitMapper;
import com.kuaike.scrm.dal.follow.entity.FollowRecord;
import com.kuaike.scrm.dal.follow.mapper.FollowRecordMapper;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannelReport;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.OauthShortUrl;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelReportMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.OauthShortUrlMapper;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerInfo;
import com.kuaike.scrm.dal.meeting.entity.MeetingJoinQuitLog;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingJoinQuitLogMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.official.fans.entity.OfficialAccountFans;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansMapper;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansTagMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.radar.entity.MarketingRadar;
import com.kuaike.scrm.dal.radar.entity.MarketingRadarAccessLog;
import com.kuaike.scrm.dal.radar.entity.MarketingRadarShareDetail;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarAccessLogMapper;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarMapper;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarShareDetailMapper;
import com.kuaike.scrm.dal.system.entity.CustomerStageReason;
import com.kuaike.scrm.dal.system.mapper.CustomerStageReasonMapper;
import com.kuaike.scrm.dal.system.mapper.PackageMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactMobile;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMobileMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworkTag.entity.WeworkContactTag;
import com.kuaike.scrm.dal.weworkTag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.wework.contact.dto.ModifyRemarkDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CustomerCenterDataInitServiceImpl
implements CustomerCenterDataInitService {
    private static final Logger log = LoggerFactory.getLogger(CustomerCenterDataInitServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${marketing.url.format}")
    private String marketingPlanUrlFormat;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${region-plan.url.format}")
    private String regionPlanUrlFormat;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${room-plan.url.format}")
    private String roomPlanUrlFormat;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${friend-fission.url.format}")
    private String friendFissionUrlFormat;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${oauth.shortUrl}")
    private String oauthShortUrl;
    @Resource
    private WeworkContactRelationMapper contactRelationMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private WeworkContactTagMapper weworkContactTagMapper;
    @Resource
    private OfficialAccountFansTagMapper accountFansTagMapper;
    @Resource
    private WeworkContactStageMapper contactStageMapper;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private MarketingPlanMapper marketingPlanMapper;
    @Resource
    private MarketingChannelMapper marketingChannelMapper;
    @Resource
    private OauthShortUrlMapper oauthShortUrlMapper;
    @Resource
    private FollowRecordMapper followRecordMapper;
    @Resource
    private CustomerStageReasonMapper stageReasonMapper;
    @Resource
    private PackageMapper packageMapper;
    @Resource
    private OfficialAccountFansMapper accountFansMapper;
    @Resource
    private MarketingChannelReportMapper channelReportMapper;
    @Resource
    private MarketingRadarAccessLogMapper radarAccessLogMapper;
    @Resource
    private MarketingRadarMapper marketingRadarMapper;
    @Resource
    private MarketingRadarShareDetailMapper marketingRadarShareDetailMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private DynamicFormAccessLogMapper dynamicFormAccessLogMapper;
    @Resource
    private DynamicFormMapper dynamicFormMapper;
    @Resource
    private DynamicFormShareMapper dynamicFormShareMapper;
    @Resource
    private DynamicFormSubmitMapper dynamicFormSubmitMapper;
    @Resource
    private MeetingJoinQuitLogMapper meetingJoinQuitLogMapper;
    @Resource
    private MeetingMapper meetingMapper;
    @Resource
    private WeworkContactMobileMapper contactMobileMapper;
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Resource
    private WeworkContactMobileMapper weworkContactMobileMapper;
    @Resource
    private MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Autowired
    private ContactOpService contactOpService;
    @Autowired
    private CcCustomerInfoService ccCustomerInfoService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private CcCustomerDetailService ccCustomerDetailService;
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Autowired
    private CcCustomerBindService ccCustomerBindService;
    @Autowired
    private CcCustomerTagService ccCustomerTagService;
    @Autowired
    private CcCustomerStageService ccCustomerStageService;
    @Autowired
    private CcCustomerFollowRecordService ccCustomerFollowRecordService;
    @Autowired
    private CustomerCenterService customerCenterService;
    @Autowired
    private CcCustomerEventService ccCustomerEventService;
    private static final String SOURCE = "scrm";
    private ExecutorService executorService;

    @PostConstruct
    public void initPool() {
        int theadNums = 50;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("initData-customerCenter-thread-%d").setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error("initData customerCenter error", e);
            }
        }).build();
        this.executorService = new ThreadPoolExecutor(5, theadNums, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.executorService);
    }

    @Override
    public void initWeworkContactByCorpId(String corpIds) {
        List corpIdList = null;
        corpIdList = StringUtils.isNotBlank((CharSequence)corpIds) ? Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)corpIds)) : this.businessCustomerMapper.getAllCorpIds();
        ArrayList finishList = Lists.newArrayListWithCapacity((int)corpIdList.size());
        for (String corpId : corpIdList) {
            this.executorService.execute(() -> {
                try {
                    log.info("init wework contact data start....");
                    this.initWeworkContact(corpId);
                    finishList.add(corpId);
                    log.info("wework contact finish corp list: {}", (Object)finishList);
                }
                catch (Exception e) {
                    log.error("init wework contact data error: ", (Throwable)e);
                }
            });
        }
    }

    @Override
    public void initOfficialFansByCorpId(String corpIds) {
        List corpIdList = null;
        corpIdList = StringUtils.isNotBlank((CharSequence)corpIds) ? Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)corpIds)) : this.businessCustomerMapper.getAllCorpIds();
        ArrayList finishList = Lists.newArrayListWithCapacity((int)corpIdList.size());
        for (String corpId : corpIdList) {
            this.executorService.execute(() -> {
                try {
                    log.info("init official fans data start....");
                    this.initOfficialAccountFans(corpId);
                    finishList.add(corpId);
                    log.info("official fans finish corp list: {}", (Object)finishList);
                }
                catch (Exception e) {
                    log.error("init official fans data error: ", (Throwable)e);
                }
            });
        }
    }

    @Override
    public void initChannelReportByCorpId(String corpIds) {
        List corpIdList = null;
        corpIdList = StringUtils.isNotBlank((CharSequence)corpIds) ? Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)corpIds)) : this.businessCustomerMapper.getAllCorpIds();
        ArrayList finishList = Lists.newArrayListWithCapacity((int)corpIdList.size());
        for (String corpId : corpIdList) {
            this.executorService.execute(() -> {
                try {
                    log.info("init channel report data start....");
                    this.initChannelReport(corpId);
                    finishList.add(corpId);
                    log.info("channel report finish corp list: {}", (Object)finishList);
                }
                catch (Exception e) {
                    log.error("init channel report data error: ", (Throwable)e);
                }
            });
        }
    }

    @Override
    public void initRadarByCorpId(String corpIds) {
        List corpIdList = null;
        corpIdList = StringUtils.isNotBlank((CharSequence)corpIds) ? Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)corpIds)) : this.businessCustomerMapper.getAllCorpIds();
        ArrayList finishList = Lists.newArrayListWithCapacity((int)corpIdList.size());
        for (String corpId : corpIdList) {
            this.executorService.execute(() -> {
                try {
                    log.info("init radar access log data start....");
                    this.initRadar(corpId);
                    finishList.add(corpId);
                    log.info("radar access log finish corp list: {}", (Object)finishList);
                }
                catch (Exception e) {
                    log.error("init radar access log data error: ", (Throwable)e);
                }
            });
        }
    }

    @Override
    public void initFormByCorpId(String corpIds) {
        List corpIdList = null;
        corpIdList = StringUtils.isNotBlank((CharSequence)corpIds) ? Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)corpIds)) : this.businessCustomerMapper.getAllCorpIds();
        ArrayList finishList = Lists.newArrayListWithCapacity((int)corpIdList.size());
        for (String corpId : corpIdList) {
            this.executorService.execute(() -> {
                try {
                    log.info("init form event data start....");
                    this.initForm(corpId);
                    finishList.add(corpId);
                    log.info("form event finish corp list: {}", (Object)finishList);
                }
                catch (Exception e) {
                    log.error("init form event data error: ", (Throwable)e);
                }
            });
        }
    }

    @Override
    public void initMeetingByCorpId(String corpIds) {
        List corpIdList = null;
        corpIdList = StringUtils.isNotBlank((CharSequence)corpIds) ? Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)corpIds)) : this.businessCustomerMapper.getAllCorpIds();
        ArrayList finishList = Lists.newArrayListWithCapacity((int)corpIdList.size());
        for (String corpId : corpIdList) {
            this.executorService.execute(() -> {
                try {
                    log.info("init meeting event data start....");
                    this.initMeeting(corpId);
                    finishList.add(corpId);
                    log.info("meeting event finish corp list: {}", (Object)finishList);
                }
                catch (Exception e) {
                    log.error("meeting form event data error: ", (Throwable)e);
                }
            });
        }
    }

    @Override
    public void initFollowRecordByCorpId(String corpIds) {
        List corpIdList = null;
        corpIdList = StringUtils.isNotBlank((CharSequence)corpIds) ? Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)corpIds)) : this.businessCustomerMapper.getAllCorpIds();
        ArrayList finishList = Lists.newArrayListWithCapacity((int)corpIdList.size());
        for (String corpId : corpIdList) {
            this.executorService.execute(() -> {
                try {
                    log.info("init follow record data start....");
                    this.initFollowRecord(corpId);
                    finishList.add(corpId);
                    log.info("follow record finish corp list: {}", (Object)finishList);
                }
                catch (Exception e) {
                    log.error("init follow record data error: ", (Throwable)e);
                }
            });
        }
    }

    @Override
    public void initFollowRecordByCorpIdAndId(String corpId, Long recordId) {
        this.executorService.execute(() -> {
            log.info("init follow record data corpiD: {}, start recordId: {}....", (Object)corpId, (Object)recordId);
            this.initFollowRecordById(corpId, recordId);
        });
    }

    private void initWeworkContact(String corpId) {
        WeworkContact contact = new WeworkContact();
        contact.setCorpId(corpId);
        int count = this.weworkContactMapper.selectCount((Object)contact);
        PageDto pageDto = this.getFirstPage(count);
        int pages = pageDto.getTotalPageNum();
        log.info("weworkContact pages: {}", (Object)pages);
        BusinessCustomer biz = this.businessCustomerMapper.getByCorpId(corpId);
        Long bizId = biz.getId();
        boolean isOpenCrm = this.isOpenCrm(biz);
        List customerStageReasons = this.stageReasonMapper.queryReasonList(bizId, corpId);
        Map<Long, String> stageReasonMap = customerStageReasons.stream().collect(Collectors.toMap(CustomerStageReason::getId, CustomerStageReason::getReason));
        for (int page = 1; page <= pages; ++page) {
            pageDto.setPageNum(Integer.valueOf(page));
            log.info("init weworkContact corpId: {}, pageDto: {}", (Object)corpId, (Object)pageDto);
            List contactPage = this.weworkContactMapper.contactPage(corpId, pageDto);
            if (CollectionUtils.isEmpty((Collection)contactPage)) continue;
            this.executorService.execute(() -> {
                try {
                    ArrayList updateList = Lists.newArrayListWithCapacity((int)contactPage.size());
                    for (WeworkContact weworkContact : contactPage) {
                        if (!StringUtils.isBlank((CharSequence)weworkContact.getCustomerNum())) continue;
                        String customerNum = this.ccCustomerNumService.getCustomerNumByWeworkContactId(weworkContact.getBizId(), weworkContact.getContactId(), weworkContact.getUnionid());
                        weworkContact.setCustomerNum(customerNum);
                        updateList.add(weworkContact);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                        this.weworkContactMapper.batchUpdateCustomer((Collection)updateList);
                    }
                    List contactIds = contactPage.stream().map(it -> it.getContactId()).collect(Collectors.toList());
                    Map<String, String> contactNumMap = contactPage.stream().collect(Collectors.toMap(WeworkContact::getContactId, WeworkContact::getCustomerNum));
                    List relationList = this.contactRelationMapper.queryByCorpIdAndContactIds(corpId, contactIds);
                    Set weworkUserIds1 = relationList.stream().map(it -> it.getWeworkUserId()).collect(Collectors.toSet());
                    List contactTags = this.weworkContactTagMapper.queryByCorpIdAndContactIds(corpId, contactIds);
                    Set weworkUserIds2 = contactTags.stream().map(it -> it.getWeworkUserId()).collect(Collectors.toSet());
                    List weworkContactStages = this.contactStageMapper.queryStageByContactIds(corpId, contactIds);
                    HashSet weworkUserIds = Sets.newHashSet();
                    weworkUserIds.addAll(weworkUserIds1);
                    weworkUserIds.addAll(weworkUserIds2);
                    Map weworkUserIdNumMap = this.weworkUserMapper.selectWeworkUserIdAndNumByWeworkUserIds(corpId, (Collection)weworkUserIds);
                    this.initCustomerStage(bizId, weworkContactStages, contactNumMap, stageReasonMap);
                    this.initContactRelation(bizId, relationList, contactNumMap, weworkUserIdNumMap);
                    this.initTagRelation(bizId, contactTags, contactNumMap, weworkUserIdNumMap);
                    ArrayList detailList = Lists.newArrayListWithCapacity((int)contactPage.size());
                    for (WeworkContact weworkContact : contactPage) {
                        CustomerDetailReq req = this.initCustomerBasicInfo(weworkContact.getBizId(), weworkContact.getCustomerNum(), weworkContact);
                        detailList.add(req);
                        if (!StringUtils.isNotBlank((CharSequence)weworkContact.getMobile())) continue;
                        this.initMobileCustomer(bizId, corpId, weworkContact.getMobile(), weworkContact.getName(), null, -1L, isOpenCrm);
                    }
                    log.info("init customer detail, params: {}", (Object)detailList);
                    this.ccCustomerDetailService.addBatch(bizId, (List)detailList);
                }
                catch (Exception e) {
                    log.error("init wework contact error: ", (Throwable)e);
                }
            });
        }
    }

    public void initMobileCustomer(Long bizId, String corpId, String mobile, String name, List<String> tagIds, Long userId, Boolean isOpenCrm) {
        try {
            log.info("pushMobileCustomer bizId: {}, mobile: {}, name: {}, userId: {}", new Object[]{bizId, mobile, name, userId});
            if (!isOpenCrm.booleanValue()) {
                this.ccCustomerNumService.getCustomerNumByMobile(bizId, mobile);
                return;
            }
            CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
            if (!MobileUtils.isPhone((String)mobile)) {
                log.warn("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a \u4e0d\u6dfb\u52a0\u5230\u7ebf\u7d22\uff1a mobile:{}", (Object)mobile);
            }
            crmLeadsInfoReq.setMobile(mobile);
            crmLeadsInfoReq.setCorpId(corpId);
            boolean exists = this.crmLeadsService.exists(crmLeadsInfoReq);
            if (exists) {
                return;
            }
            CrmLeadsReq crmLeadsReq = new CrmLeadsReq();
            crmLeadsReq.setCorpId(corpId);
            crmLeadsReq.setMobile(mobile);
            crmLeadsReq.setName(name);
            crmLeadsReq.setTagIds(tagIds);
            crmLeadsReq.setCreatorId(userId);
            crmLeadsReq.setAllocRule(Integer.valueOf(RawLeadsAllocRule.INNER_SYSTEM.getValue()));
            if (userId >= 0L) {
                crmLeadsReq.setAllocUserId(userId);
            }
            crmLeadsReq.setSourceType(Integer.valueOf(SourceType.SCRM_SYNC.getValue()));
            this.crmLeadsService.addLeads(crmLeadsReq);
        }
        catch (Exception e) {
            log.info("mobile customer bizId: {}, mobile: {}", (Object)bizId, (Object)mobile);
            log.error("mobile customer error: ", (Throwable)e);
        }
    }

    private void initOfficialAccountFans(String corpId) {
        OfficialAccountFans accountFans = new OfficialAccountFans();
        accountFans.setCorpId(corpId);
        int count = this.accountFansMapper.selectCount((Object)accountFans);
        PageDto pageDto = this.getFirstPage(count);
        int pages = pageDto.getTotalPageNum();
        log.info("official account fans pages: {}", (Object)pages);
        for (int page = 1; page <= pages; ++page) {
            pageDto.setPageNum(Integer.valueOf(page));
            log.info("init officialAccount corpId: {}, pageDto: {}", (Object)corpId, (Object)pageDto);
            List fansPage = this.accountFansMapper.accountFansPage(corpId, pageDto);
            ArrayList updateList = Lists.newArrayListWithCapacity((int)fansPage.size());
            for (OfficialAccountFans fans : fansPage) {
                if (!StringUtils.isBlank((CharSequence)fans.getCustomerNum())) continue;
                String customerNum = this.ccCustomerNumService.getCustomerNumByOfficialFans(fans.getBizId(), fans.getAppId(), fans.getOpenId(), fans.getUnionId());
                fans.setCustomerNum(customerNum);
                updateList.add(fans);
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                this.accountFansMapper.batchUpdateCustomer((Collection)updateList);
            }
            for (OfficialAccountFans fans : fansPage) {
                this.initFansTagRelation(fans.getBizId(), fans.getUniqueId(), fans.getCustomerNum());
            }
        }
    }

    private void initChannelReport(String corpId) {
        MarketingChannelReport channelReport = new MarketingChannelReport();
        channelReport.setCorpId(corpId);
        int count = this.channelReportMapper.selectCount((Object)channelReport);
        PageDto pageDto = this.getFirstPage(count);
        int pages = pageDto.getTotalPageNum();
        log.info("channel report pages: {}", (Object)pages);
        List list = this.marketingPlanMapper.queryPlanByCorpId(corpId);
        Map planMap = list.stream().collect(Collectors.toMap(MarketingPlan::getId, Function.identity()));
        List marketingChannelList = this.marketingChannelMapper.queryMarketingChannelByCorpId(corpId);
        Map channelMap = marketingChannelList.stream().collect(Collectors.toMap(f -> f.getPlanId() + "$" + f.getChannelId(), Function.identity()));
        for (int page = 1; page <= pages; ++page) {
            pageDto.setPageNum(Integer.valueOf(page));
            log.info("init officialAccount corpId: {}, pageDto: {}", (Object)corpId, (Object)pageDto);
            List reportPage = this.channelReportMapper.channelReportPage(corpId, pageDto);
            ArrayList updateList = Lists.newArrayListWithCapacity((int)reportPage.size());
            for (MarketingChannelReport report : reportPage) {
                String customerNum = report.getCustomerNum();
                if (StringUtils.isBlank((CharSequence)report.getCustomerNum())) {
                    customerNum = StringUtils.isNotBlank((CharSequence)report.getAppId()) && !report.getAppId().equals(report.getCorpId()) && StringUtils.isNotBlank((CharSequence)report.getOpenId()) ? this.ccCustomerNumService.getCustomerNumByOfficialFans(report.getBizId(), report.getAppId(), report.getOpenId(), report.getUnionId()) : (StringUtils.isNotBlank((CharSequence)channelReport.getContactId()) ? this.ccCustomerNumService.getCustomerNumByWeworkContactId(channelReport.getBizId(), channelReport.getContactId(), null) : (StringUtils.isNotBlank((CharSequence)report.getOpenId()) ? this.ccCustomerNumService.getCustomerNumByWeworkOpenId(report.getBizId(), report.getOpenId()) : this.ccCustomerNumService.getCustomerNumByH5Cookie(channelReport.getBizId(), channelReport.getUniqId())));
                    report.setCustomerNum(customerNum);
                    updateList.add(report);
                }
                MarketingPlan plan = (MarketingPlan)planMap.get(report.getPlanId());
                EventPage eventPage = new EventPage();
                eventPage.setTitle(plan.getName());
                eventPage.setIcon(plan.getBgImg());
                MarketingChannel marketingChannel = (MarketingChannel)channelMap.get(report.getPlanId() + "$" + report.getChannelId());
                if (marketingChannel == null) continue;
                String originUrl = this.getChannelUrl(marketingChannel.getNum(), plan.getType());
                OauthShortUrl oauthShort = this.oauthShortUrlMapper.queryShortUrlByOriginUrl(originUrl);
                if (oauthShort != null) {
                    eventPage.setUrl(originUrl);
                    String shortUrl = MessageFormat.format(this.oauthShortUrl, oauthShort.getShortUrl());
                    eventPage.setShortUrl(shortUrl);
                }
                EventModule module = new EventModule();
                module.setType(ModuleType.MARKETING_PLAN.getCode());
                module.setName(plan.getName());
                module.setNum(plan.getNum());
                module.setPlanType(PlanType.get((int)plan.getType()).getDesc());
                module.setChannelId(report.getChannelId());
                EventVisitor visitor = new EventVisitor();
                visitor.setName(report.getNickName());
                visitor.setAvatar(report.getHeadUrl());
                visitor.setType(Integer.valueOf(VisitorType.WEWORK.getValue()));
                visitor.setAppId(report.getAppId());
                visitor.setOpenId(report.getOpenId());
                visitor.setContactId(report.getContactId());
                visitor.setUnionId(report.getUnionId());
                visitor.setCountry(report.getCountry());
                visitor.setProvince(report.getProvince());
                visitor.setCity(report.getCity());
                visitor.setIp(report.getIp());
                visitor.setUniqId(report.getUniqId());
                String accessNum = this.idGen.getNum();
                CustomerEventReq eventReq = new CustomerEventReq();
                eventReq.setEventType(EventType.VISIT_PAGE.getCode());
                eventReq.setSource(SOURCE);
                eventReq.setEventTime(report.getCreateTime());
                eventReq.setBizId(plan.getBizId());
                eventReq.setCustomerNum(customerNum);
                EventData eventData = new EventData();
                eventReq.setEventData(eventData);
                eventData.setAccessNum(accessNum);
                eventData.setPage(eventPage);
                eventData.setModule(module);
                eventData.setSharer(null);
                eventData.setVisitor(visitor);
                log.info("save visit page marketing report event: {}", (Object)eventReq);
                try {
                    this.ccCustomerEventService.add(eventReq);
                }
                catch (Exception e) {
                    log.error("add visit page event data error: ", (Throwable)e);
                }
            }
            if (!CollectionUtils.isNotEmpty((Collection)updateList)) continue;
            this.channelReportMapper.batchUpdateCustomer((Collection)updateList);
        }
    }

    private String getChannelUrl(String num, int planType) {
        if (planType == PlanType.CHANNEL_PLAN.getValue()) {
            return MessageFormat.format(this.marketingPlanUrlFormat, num);
        }
        if (planType == PlanType.REGION_PLAN.getValue()) {
            return MessageFormat.format(this.regionPlanUrlFormat, num);
        }
        if (planType == PlanType.ROOM_PLAN.getValue()) {
            return MessageFormat.format(this.roomPlanUrlFormat, num);
        }
        if (planType == PlanType.FRIEND_FISSION_PLAN.getValue()) {
            return MessageFormat.format(this.friendFissionUrlFormat, num);
        }
        return null;
    }

    private void initRadar(String corpId) {
        MarketingRadarAccessLog accessLog = new MarketingRadarAccessLog();
        accessLog.setCorpId(corpId);
        int count = this.radarAccessLogMapper.selectCount((Object)accessLog);
        PageDto pageDto = this.getFirstPage(count);
        int pages = pageDto.getTotalPageNum();
        log.info("radar access log pages: {}", (Object)pages);
        List radarList = this.marketingRadarMapper.queryRadarList(corpId);
        Map radarMap = radarList.stream().collect(Collectors.toMap(MarketingRadar::getNum, Function.identity()));
        for (int page = 1; page <= pages; ++page) {
            pageDto.setPageNum(Integer.valueOf(page));
            List radarAccessLogPage = this.radarAccessLogMapper.radarAccessLogPage(corpId, pageDto);
            ArrayList updateList = Lists.newArrayListWithCapacity((int)radarAccessLogPage.size());
            for (MarketingRadarAccessLog radarAccessLog : radarAccessLogPage) {
                if (StringUtils.isBlank((CharSequence)radarAccessLog.getCustomerNum())) {
                    String customerNum = null;
                    customerNum = StringUtils.isNotBlank((CharSequence)radarAccessLog.getContactId()) ? this.ccCustomerNumService.getCustomerNumByWeworkContactId(radarAccessLog.getBizId(), radarAccessLog.getContactId(), null) : (StringUtils.isNotBlank((CharSequence)radarAccessLog.getOpenId()) ? this.ccCustomerNumService.getCustomerNumByWeworkOpenId(radarAccessLog.getBizId(), radarAccessLog.getOpenId()) : this.ccCustomerNumService.getCustomerNumByH5Cookie(radarAccessLog.getBizId(), radarAccessLog.getUniqId()));
                    radarAccessLog.setCustomerNum(customerNum);
                    updateList.add(radarAccessLog);
                }
                MarketingRadar radar = (MarketingRadar)radarMap.get(radarAccessLog.getMarketingRadarNum());
                MarketingRadarShareDetail shareDetail = this.marketingRadarShareDetailMapper.queryShareByNum(radarAccessLog.getBizId(), radarAccessLog.getMarketingRadarShareNum());
                if (shareDetail == null || radar == null) continue;
                EventPage eventPage = new EventPage();
                eventPage.setTitle(radar.getTitle());
                String shortNum = radarAccessLog.getMarketingRadarShareNum();
                OauthShortUrl shortUrlDto = this.oauthShortUrlMapper.getByShortUrl(shortNum);
                eventPage.setUrl(shortUrlDto.getOriginUrl());
                eventPage.setSourceUrl(radar.getUrl());
                String shortUrl = MessageFormat.format(this.oauthShortUrl, shortNum);
                eventPage.setShortUrl(shortUrl);
                EventModule module = new EventModule();
                module.setType(ModuleType.RADAR.getCode());
                module.setName(radar.getTitle());
                module.setNum(radar.getNum());
                EventSharer sharer = new EventSharer();
                WeworkUser weworkUser = null;
                if (StringUtils.isNotBlank((CharSequence)shareDetail.getShareWeworkUserNum())) {
                    weworkUser = this.weworkUserMapper.queryWeworkUserByNum(shareDetail.getShareWeworkUserNum());
                }
                if (weworkUser != null) {
                    sharer.setName(weworkUser.getName());
                    sharer.setWeworkUserId(weworkUser.getWeworkUserId());
                }
                if (StringUtils.isBlank((CharSequence)sharer.getName())) {
                    User user = (User)this.userMapper.selectByPrimaryKey((Object)shareDetail.getShareUserId());
                    sharer.setName(user.getName());
                }
                sharer.setUserId(shareDetail.getShareUserId());
                sharer.setWeworkUserNum(shareDetail.getShareWeworkUserNum());
                EventVisitor visitor = new EventVisitor();
                visitor.setType(Integer.valueOf(VisitorType.WEWORK.getValue()));
                visitor.setAppId(radarAccessLog.getOpenId());
                visitor.setContactId(radarAccessLog.getContactId());
                visitor.setName(radarAccessLog.getVisitorNickName());
                visitor.setAvatar(radarAccessLog.getVisitorAvatar());
                visitor.setUniqId(radarAccessLog.getUniqId());
                AccessInfo accessInfo = new AccessInfo();
                accessInfo.setVisitBeginTime(radarAccessLog.getVisitBeginTime());
                accessInfo.setVisitEndTime(radarAccessLog.getVisitEndTime());
                accessInfo.setStayTime(radarAccessLog.getStayTime());
                accessInfo.setFinishPercent(radarAccessLog.getFinishPercent());
                CustomerEventReq eventReq = new CustomerEventReq();
                eventReq.setEventType(EventType.VISIT_PAGE.getCode());
                eventReq.setSource(SOURCE);
                eventReq.setEventTime(radarAccessLog.getCreateTime());
                eventReq.setBizId(radarAccessLog.getBizId());
                eventReq.setCustomerNum(radarAccessLog.getCustomerNum());
                EventData eventData = new EventData();
                eventReq.setEventData(eventData);
                eventData.setAccessNum(radarAccessLog.getNum());
                eventData.setPage(eventPage);
                eventData.setModule(module);
                eventData.setSharer(sharer);
                eventData.setVisitor(visitor);
                eventData.setAccessInfo(accessInfo);
                log.info("visit page radar: {}", (Object)eventReq);
                try {
                    this.ccCustomerEventService.add(eventReq);
                }
                catch (Exception e) {
                    log.error("add visit page event data error: ", (Throwable)e);
                }
            }
            if (!CollectionUtils.isNotEmpty((Collection)updateList)) continue;
            this.radarAccessLogMapper.batchUpdateCustomer((Collection)updateList);
        }
    }

    private void initForm(String corpId) {
        DynamicFormAccessLog accessLog = new DynamicFormAccessLog();
        accessLog.setCorpId(corpId);
        int count = this.dynamicFormAccessLogMapper.selectCount((Object)accessLog);
        PageDto pageDto = this.getFirstPage(count);
        int pages = pageDto.getTotalPageNum();
        log.info("form access log pages: {}", (Object)pages);
        DynamicForm queryForm = new DynamicForm();
        queryForm.setCorpId(corpId);
        List dynamicFormList = this.dynamicFormMapper.select((Object)queryForm);
        Map dynamicFormMap = dynamicFormList.stream().collect(Collectors.toMap(DynamicForm::getNum, Function.identity()));
        for (int page = 1; page <= pages; ++page) {
            pageDto.setPageNum(Integer.valueOf(page));
            List formAccessLogPage = this.dynamicFormAccessLogMapper.formAccessLogPage(corpId, pageDto);
            for (DynamicFormAccessLog formAccessLog : formAccessLogPage) {
                if (StringUtils.isBlank((CharSequence)formAccessLog.getCustomerNum())) continue;
                DynamicForm dynamicForm = (DynamicForm)dynamicFormMap.get(formAccessLog.getDynamicFormNum());
                DynamicFormShare shareDetail = new DynamicFormShare();
                shareDetail.setNum(formAccessLog.getDynamicFormShareNum());
                shareDetail = (DynamicFormShare)this.dynamicFormShareMapper.selectOne((Object)shareDetail);
                if (shareDetail == null) {
                    log.warn("query form share is null shareNum: {}", (Object)formAccessLog.getDynamicFormShareNum());
                    continue;
                }
                EventPage eventPage = new EventPage();
                eventPage.setTitle(dynamicForm.getName());
                String shortNum = formAccessLog.getDynamicFormShareNum();
                OauthShortUrl shortUrlDto = this.oauthShortUrlMapper.getByShortUrl(shortNum);
                eventPage.setUrl(shortUrlDto.getOriginUrl());
                String shortUrl = MessageFormat.format(this.oauthShortUrl, shortNum);
                eventPage.setShortUrl(shortUrl);
                EventModule module = new EventModule();
                module.setType(ModuleType.DYNAMIC_FORM.getCode());
                module.setName(dynamicForm.getName());
                module.setNum(dynamicForm.getNum());
                EventSharer sharer = new EventSharer();
                WeworkUser weworkUser = null;
                if (StringUtils.isNotBlank((CharSequence)shareDetail.getWeworkUserNum())) {
                    weworkUser = this.weworkUserMapper.queryWeworkUserByNum(shareDetail.getWeworkUserNum());
                }
                if (weworkUser != null) {
                    sharer.setName(weworkUser.getName());
                    sharer.setWeworkUserId(weworkUser.getWeworkUserId());
                }
                if (StringUtils.isBlank((CharSequence)sharer.getName())) {
                    User user = (User)this.userMapper.selectByPrimaryKey((Object)shareDetail.getUserId());
                    sharer.setName(user.getName());
                }
                sharer.setUserId(shareDetail.getUserId());
                sharer.setWeworkUserNum(shareDetail.getWeworkUserNum());
                EventVisitor visitor = new EventVisitor();
                visitor.setType(Integer.valueOf(VisitorType.WEWORK.getValue()));
                visitor.setAppId(formAccessLog.getOpenId());
                visitor.setContactId(formAccessLog.getContactId());
                visitor.setName(formAccessLog.getNickname());
                visitor.setAvatar(formAccessLog.getAvatar());
                visitor.setUniqId(formAccessLog.getUniqId());
                CustomerEventReq eventReq = new CustomerEventReq();
                eventReq.setEventType(EventType.VISIT_PAGE.getCode());
                eventReq.setSource(SOURCE);
                if (formAccessLog.getSubmit() == 1) {
                    eventReq.setEventTime(formAccessLog.getUpdateTime());
                } else {
                    eventReq.setEventTime(formAccessLog.getCreateTime());
                }
                eventReq.setBizId(formAccessLog.getBizId());
                eventReq.setCustomerNum(formAccessLog.getCustomerNum());
                EventData eventData = new EventData();
                eventReq.setEventData(eventData);
                eventData.setAccessNum(formAccessLog.getNum());
                eventData.setPage(eventPage);
                eventData.setModule(module);
                eventData.setSharer(sharer);
                eventData.setVisitor(visitor);
                if (formAccessLog.getSubmit() == 1) {
                    List submitList = this.dynamicFormSubmitMapper.querySubmitByAccessNum(formAccessLog.getBizId(), formAccessLog.getNum());
                    ArrayList submitDtos = Lists.newArrayList();
                    for (DynamicFormSubmit submit : submitList) {
                        FormSubmitDto submitDto = new FormSubmitDto();
                        submitDto.setKey(submit.getFormKey());
                        submitDto.setValue(submit.getFormValue());
                        submitDtos.add(submitDto);
                    }
                    eventData.setSubmitList((List)submitDtos);
                }
                log.info("save visit page form event: {}", (Object)eventReq);
                try {
                    this.ccCustomerEventService.add(eventReq);
                }
                catch (Exception e) {
                    log.error("add visit page event data error: ", (Throwable)e);
                }
            }
        }
    }

    private void initMeeting(String corpId) {
        MeetingJoinQuitLog accessLog = new MeetingJoinQuitLog();
        accessLog.setCorpId(corpId);
        int count = this.meetingJoinQuitLogMapper.selectCount((Object)accessLog);
        PageDto pageDto = this.getFirstPage(count);
        int pages = pageDto.getTotalPageNum();
        log.info("meeting access log pages: {}", (Object)pages);
        List meetingList = this.meetingMapper.queryMeetingList(corpId);
        Map meetingMap = meetingList.stream().collect(Collectors.toMap(Meeting::getId, Function.identity()));
        for (int page = 1; page <= pages; ++page) {
            pageDto.setPageNum(Integer.valueOf(page));
            List meetingLogPage = this.meetingJoinQuitLogMapper.meetingLogPage(corpId, pageDto);
            Set contactIds = meetingLogPage.stream().map(it -> it.getContactId()).collect(Collectors.toSet());
            List contactList = this.weworkContactMapper.queryWeworkContactList(corpId, contactIds);
            Map contactMap = contactList.stream().collect(Collectors.toMap(WeworkContact::getContactId, Function.identity()));
            List weworkUserNums = meetingLogPage.stream().map(it -> it.getWeworkUserNum()).collect(Collectors.toList());
            List weworkUsers = this.weworkUserMapper.queryInfoListByNums(weworkUserNums);
            Map weworkUserMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getNum, Function.identity()));
            for (MeetingJoinQuitLog meetingJoinQuitLog : meetingLogPage) {
                if (StringUtils.isBlank((CharSequence)meetingJoinQuitLog.getContactId())) continue;
                Meeting meeting = (Meeting)meetingMap.get(meetingJoinQuitLog.getMeetingId());
                WeworkContact contact = (WeworkContact)contactMap.get(meetingJoinQuitLog.getContactId());
                if (meeting == null || contact == null) continue;
                CustomerEventReq eventReq = new CustomerEventReq();
                eventReq.setEventType(EventType.LIVE.getCode());
                eventReq.setSource(SOURCE);
                eventReq.setEventTime(new Date());
                eventReq.setBizId(meeting.getBizId());
                eventReq.setCustomerNum(contact.getCustomerNum());
                EventData eventData = new EventData();
                eventReq.setEventData(eventData);
                EventModule module = new EventModule();
                eventData.setModule(module);
                module.setType(ModuleType.LIVE.getCode());
                module.setNum(meeting.getNum());
                module.setMeetingId(meeting.getId());
                module.setMeetingType(meeting.getType());
                EventPage eventPage = new EventPage();
                eventData.setPage(eventPage);
                eventPage.setTitle(meeting.getTitle());
                eventPage.setUrl(meeting.getMeetingUrl());
                EventVisitor visitor = new EventVisitor();
                eventData.setVisitor(visitor);
                visitor.setName(meetingJoinQuitLog.getBjyName());
                visitor.setAvatar(meetingJoinQuitLog.getBjyAvatar());
                visitor.setContactId(meetingJoinQuitLog.getContactId());
                EventSharer sharer = new EventSharer();
                eventData.setSharer(sharer);
                String weworkUserNum = meetingJoinQuitLog.getWeworkUserNum();
                WeworkUser weworkUser = (WeworkUser)weworkUserMap.get(weworkUserNum);
                sharer.setWeworkUserNum(weworkUserNum);
                sharer.setName(weworkUser == null ? null : weworkUser.getName());
                sharer.setWeworkUserId(weworkUser == null ? null : weworkUser.getWeworkUserId());
                AccessInfo accessInfo = new AccessInfo();
                eventData.setAccessInfo(accessInfo);
                accessInfo.setVisitBeginTime(meetingJoinQuitLog.getJoinTime());
                accessInfo.setVisitEndTime(meetingJoinQuitLog.getQuitTime());
                accessInfo.setStayTime(Long.valueOf((long)meetingJoinQuitLog.getDuration().intValue() * 1000L));
                log.info("save visit page meeting event: {}", (Object)eventReq);
                try {
                    this.ccCustomerEventService.add(eventReq);
                }
                catch (Exception e) {
                    log.error("save fans subscribe event error: ", (Throwable)e);
                }
            }
        }
    }

    private void initContactRelation(Long bizId, List<WeworkContactRelation> relations, Map<String, String> contactNumMap, Map<String, String> userIdMap) {
        ArrayList bindReqList = Lists.newArrayListWithCapacity((int)relations.size());
        for (WeworkContactRelation contactRelation : relations) {
            String customerNum = contactNumMap.get(contactRelation.getContactId());
            String weworkUserNum = userIdMap.get(contactRelation.getWeworkUserId());
            CustomerBindReq bindingReq = new CustomerBindReq();
            bindingReq.setUserId(Long.valueOf(-1L));
            bindingReq.setCustomerNum(customerNum);
            bindingReq.setWeworkUserNum(weworkUserNum);
            bindingReq.setIsDeleted(contactRelation.getIsDeleted());
            if (contactRelation.getIsDeleted() == 1) {
                bindingReq.setDeleteTime(contactRelation.getDeletedTime());
            }
            bindReqList.add(bindingReq);
        }
        if (CollectionUtils.isEmpty((Collection)bindReqList)) {
            return;
        }
        BatchSetBindingReq batchSetBindingReq = new BatchSetBindingReq();
        batchSetBindingReq.setBizId(bizId);
        batchSetBindingReq.setSource(SOURCE);
        batchSetBindingReq.setList((List)bindReqList);
        log.info("init contact relation params: {}", (Object)batchSetBindingReq);
        this.ccCustomerBindService.batchSetBinding(batchSetBindingReq);
    }

    private void initTagRelation(Long bizId, List<WeworkContactTag> contactTags, Map<String, String> contactNumMap, Map<String, String> userMap) {
        if (CollectionUtils.isEmpty(contactTags)) {
            return;
        }
        ArrayList tagReqList = Lists.newArrayList();
        Map<String, List<WeworkContactTag>> contactTagMap = contactTags.stream().collect(Collectors.groupingBy(WeworkContactTag::getContactId));
        contactTagMap.forEach((contactId, list) -> {
            String customerNum = (String)contactNumMap.get(contactId);
            HashMap map = Maps.newHashMap();
            for (WeworkContactTag contactTag : list) {
                if (StringUtils.isEmpty((CharSequence)contactTag.getTagId())) continue;
                String weworkUserId2 = contactTag.getWeworkUserId();
                if (map.containsKey(weworkUserId2)) {
                    ((List)map.get(weworkUserId2)).add(contactTag.getTagId());
                    continue;
                }
                ArrayList tagIds2 = Lists.newArrayList();
                tagIds2.add(contactTag.getTagId());
                map.put(weworkUserId2, tagIds2);
            }
            map.forEach((weworkUserId, tagIds) -> {
                if (CollectionUtils.isEmpty((Collection)tagIds)) {
                    return;
                }
                String weworkUserNum = (String)userMap.get(weworkUserId);
                CustomerTagReq tagReq = new CustomerTagReq();
                tagReq.setCustomerNum(customerNum);
                tagReq.setWeworkUserNum(weworkUserNum);
                tagReq.setTagIds(tagIds);
                tagReqList.add(tagReq);
            });
        });
        if (CollectionUtils.isEmpty((Collection)tagReqList)) {
            return;
        }
        BatchSetTagReq batchSetTagReq = new BatchSetTagReq();
        batchSetTagReq.setBizId(bizId);
        batchSetTagReq.setSource(SOURCE);
        batchSetTagReq.setList((List)tagReqList);
        log.info("init tag params: {}", (Object)batchSetTagReq);
        this.ccCustomerTagService.batchSetTags(batchSetTagReq);
    }

    private void initFansTagRelation(Long bizId, String fansId, String customerNum) {
        List fansTags = this.accountFansTagMapper.queryTagByTypeAndFansId(fansId);
        if (CollectionUtils.isEmpty((Collection)fansTags)) {
            return;
        }
        List tagIds = fansTags.stream().map(it -> it.getOfficialAccountTagId()).collect(Collectors.toList());
        SetTagReq tagReq = new SetTagReq();
        tagReq.setBizId(bizId);
        tagReq.setCustomerNum(customerNum);
        tagReq.setSource(SOURCE);
        tagReq.setTagIds(tagIds);
        log.info("init fans tag params: {}", (Object)tagReq);
        this.ccCustomerTagService.setTags(tagReq);
    }

    private void initCustomerStage(Long bizId, List<WeworkContactStage> stageList, Map<String, String> contactNumMap, Map<Long, String> stageReasonMap) {
        ArrayList stageReqList = Lists.newArrayList();
        for (WeworkContactStage contactStage : stageList) {
            CustomerStageReq stageReq = new CustomerStageReq();
            stageReq.setUserId(Long.valueOf(-1L));
            stageReq.setWeworkUserNum(contactStage.getWeworkUserNum());
            stageReq.setStageId(contactStage.getStageId());
            if (stageReq.getStageId() == null) {
                stageReq.setStageId(contactStage.getFinalStageId());
            }
            stageReq.setCustomerNum(contactNumMap.get(contactStage.getContactId()));
            stageReq.setRemark(contactStage.getRemark());
            stageReq.setStatus(contactStage.getStatus());
            stageReq.setFinalStageId(contactStage.getFinalStageId());
            if (Objects.nonNull(contactStage.getStageReasonId())) {
                String stageReason = stageReasonMap.get(contactStage.getStageReasonId());
                stageReq.setStageReason(stageReason);
            }
            stageReqList.add(stageReq);
        }
        if (CollectionUtils.isEmpty((Collection)stageReqList)) {
            return;
        }
        BatchSetStageReq batchSetStageReq = new BatchSetStageReq();
        batchSetStageReq.setBizId(bizId);
        batchSetStageReq.setSource(SOURCE);
        batchSetStageReq.setList((List)stageReqList);
        log.info("init customer tag params: {}", (Object)batchSetStageReq);
        this.ccCustomerStageService.batchSetStage(batchSetStageReq);
    }

    private CustomerDetailReq initCustomerBasicInfo(Long bizId, String customerNum, WeworkContact contact) {
        CustomerDetailReq detailReq = new CustomerDetailReq();
        detailReq.setBizId(bizId);
        detailReq.setCustomerNum(customerNum);
        detailReq.setName(contact.getName());
        detailReq.setAvatar(contact.getAvatar());
        detailReq.setCorpName(contact.getCorpName());
        detailReq.setCorpFullName(contact.getCorpFullName());
        detailReq.setType(contact.getType());
        detailReq.setGender(contact.getGender());
        detailReq.setSource(SOURCE);
        return detailReq;
    }

    private void initFollowRecord(String corpId) {
        FollowRecord followRecord = new FollowRecord();
        followRecord.setCorpId(corpId);
        int count = this.followRecordMapper.selectCount((Object)followRecord);
        PageDto pageDto = this.getFirstPage(count);
        int pages = pageDto.getTotalPageNum();
        log.info("followRecord count: {},  pages: {}", (Object)count, (Object)pages);
        for (int page = 1; page <= pages; ++page) {
            pageDto.setPageNum(Integer.valueOf(page));
            log.info("init followRecord corpId: {}, pageDto: {}", (Object)corpId, (Object)pageDto);
            List recordList = this.followRecordMapper.queryAllRecord(corpId, pageDto);
            if (!CollectionUtils.isNotEmpty((Collection)recordList)) continue;
            this.pushFollowRecord(recordList);
        }
    }

    private void initFollowRecordById(String corpId, Long recordId) {
        log.info("initFollowRecordById CorpID: {}, begin recordId: {}", (Object)corpId, (Object)recordId);
        int count = this.followRecordMapper.queryAllRecordByRecordIdCount(corpId, recordId);
        PageDto pageDto = this.getFirstPage(count);
        int pages = pageDto.getTotalPageNum();
        log.info("initFollowRecordById count: {},  pages: {}", (Object)count, (Object)pages);
        for (int page = 1; page <= pages; ++page) {
            pageDto.setPageNum(Integer.valueOf(page));
            List recordList = this.followRecordMapper.queryAllRecordByRecordId(corpId, recordId, pageDto);
            this.pushFollowRecord(recordList);
        }
    }

    private void pushFollowRecord(List<FollowRecord> recordList) {
        ArrayList reqList = Lists.newArrayList();
        Long bizId = null;
        Long recordID = 0L;
        for (FollowRecord record : recordList) {
            FollowReq req = new FollowReq();
            req.setBizId(record.getBizId());
            req.setWeworkUserNum(record.getWeworkUserNum());
            WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(req.getWeworkUserNum());
            if (Objects.nonNull(weworkUser)) {
                req.setWeworkUserName(weworkUser.getName());
            }
            bizId = record.getBizId();
            String customerNum = this.ccCustomerNumService.getCustomerNumByWeworkContactId(record.getBizId(), record.getWeworkContactId(), null);
            req.setCustomerNum(customerNum);
            req.setSource(SOURCE);
            req.setUserId(Long.valueOf(-1L));
            String remark = this.getFollowRecordRemark(record);
            req.setFollowContent(remark);
            req.setFollowType(record.getType());
            req.setViewContent(record.getContent());
            req.setFollowTime(record.getCreateTime());
            JsonContentDto contentDto = this.customerCenterService.buildJsonContentDto(record);
            req.setJsonContent(contentDto);
            reqList.add(req);
            recordID = record.getId();
        }
        if (CollectionUtils.isNotEmpty((Collection)reqList) && bizId != null) {
            this.ccCustomerFollowRecordService.addBatch(bizId, SOURCE, (List)reqList);
            log.info("pushFollowRecord init current recordId: {} ----------------------", (Object)recordID);
        }
    }

    private String getFollowRecordRemark(FollowRecord record) {
        FollowRecordParamReqDto paramReqDto;
        if (record.getType() == 3 && StringUtils.isNotBlank((CharSequence)record.getParams()) && Objects.nonNull(paramReqDto = (FollowRecordParamReqDto)JSONObject.parseObject((String)record.getParams(), FollowRecordParamReqDto.class))) {
            return paramReqDto.getFollowInfo().getRemark();
        }
        return "";
    }

    private PageDto getFirstPage(int count) {
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(Integer.valueOf(200));
        pageDto.setPageNum(Integer.valueOf(1));
        pageDto.setCount(Integer.valueOf(count));
        return pageDto;
    }

    private boolean isOpenCrm(BusinessCustomer record) {
        log.info("isOpenCrm record: {}", (Object)record);
        String pkgIdsStr = record.getPkgIds();
        if (StringUtils.isBlank((CharSequence)pkgIdsStr)) {
            return false;
        }
        ArrayList pkgIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)pkgIdsStr)) {
            for (String s : StringUtils.split((String)pkgIdsStr, (String)",")) {
                try {
                    Long parseLong = Long.parseLong(s);
                    pkgIds.add(parseLong);
                }
                catch (NumberFormatException e) {
                    log.error("unknown package, bizId={}, packageId:{}", (Object)record.getId(), (Object)s);
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)pkgIds)) {
            List systemIds = this.packageMapper.querySystemIds((List)pkgIds);
            for (Long id : systemIds) {
                if (id.intValue() != SystemTypeEnum.CRM.getValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void hotfixWeworkContactMobileData(String corpIds) {
        List corpIdList = null;
        corpIdList = StringUtils.isNotBlank((CharSequence)corpIds) ? Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)corpIds)) : this.businessCustomerMapper.getAllCorpIds();
        ArrayList finishList = Lists.newArrayListWithCapacity((int)corpIdList.size());
        for (String corpId : corpIdList) {
            this.executorService.execute(() -> {
                log.info("hotfixWeworkContactMobileData:  corpId: {}....", (Object)corpId);
                this.handleWeworkContactMobileData(corpId);
                finishList.add(corpId);
                log.info("hotfixWeworkContactMobileData: finishList: {}....", (Object)finishList);
            });
        }
    }

    @Override
    public void syncCustomerMobileToWework(String corpIds) {
        List corpIdList = null;
        corpIdList = StringUtils.isNotBlank((CharSequence)corpIds) ? Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)corpIds)) : this.businessCustomerMapper.getAllCorpIds();
        log.info("sync customer mobile to wework corpList: {}", (Object)corpIdList);
        for (String corpId : corpIdList) {
            this.executorService.execute(() -> {
                this.handleCorpPage(corpId);
                log.info("sync customer mobile to wework end corpId: {}....", (Object)corpId);
            });
        }
    }

    @Override
    public void syncWeworkTag(String corpIds) {
        List corpIdList = null;
        corpIdList = StringUtils.isNotBlank((CharSequence)corpIds) ? Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)corpIds)) : this.businessCustomerMapper.getAllCorpIds();
        log.info("sync wework tag to corpList: {}", (Object)corpIdList);
        for (String corpId : corpIdList) {
            this.executorService.execute(() -> {
                this.syncWeworkTagOfCorp(corpId);
                log.info("sync wework tag end corpId: {}....", (Object)corpId);
            });
        }
    }

    @Override
    public void syncMeetingJoinQuitLog(String corpIds) {
        log.info("sync meeting join quit log corpIds: {}", (Object)corpIds);
        List<String> corpIdList = this.getCorpIds(corpIds);
        for (String corpId : corpIdList) {
            this.executorService.submit(() -> {
                try {
                    this.syncMeetingJoinQuitData(corpId);
                    log.info("sync meeting join quit log end corpId: {}....", (Object)corpId);
                }
                catch (Exception e) {
                    log.error("sync meeting join quit data error: ", (Throwable)e);
                }
            });
        }
    }

    private void syncMeetingJoinQuitData(String corpId) {
        List meetingList = this.meetingMapper.queryMeetingList(corpId);
        for (Meeting meeting : meetingList) {
            List quitLogList = this.meetingJoinQuitLogMapper.queryLogListByMeetingId(corpId, meeting.getId());
            this.executorService.submit(() -> {
                try {
                    this.handleMeetingJoinQuitPage(quitLogList);
                }
                catch (Exception e) {
                    log.error("handle join quit page error: ", (Throwable)e);
                }
            });
        }
    }

    private void handleMeetingJoinQuitPage(List<MeetingJoinQuitLog> pageList) {
        if (CollectionUtils.isEmpty(pageList)) {
            log.info("meeting join quit log is empty...");
            return;
        }
        Long meetingId = pageList.get(0).getMeetingId();
        Long bizId = pageList.get(0).getBizId();
        String corpId = pageList.get(0).getCorpId();
        List customerInfoList = this.meetingCustomerInfoMapper.queryCustomerInfosByMeetingId(bizId, meetingId);
        Map customerInfoMap = customerInfoList.stream().collect(Collectors.toMap(MeetingCustomerInfo::getBjyNumber, Function.identity()));
        ArrayList addCustomerInfos = Lists.newArrayList();
        ArrayList updateCustomerInfos = Lists.newArrayList();
        for (MeetingJoinQuitLog joinQuitLog : pageList) {
            String infoId = joinQuitLog.getBjyNumber();
            if (StringUtils.isNotBlank((CharSequence)joinQuitLog.getContactId())) {
                infoId = joinQuitLog.getContactId();
            }
            MeetingCustomerInfo customerInfo = null;
            if (customerInfoMap.containsKey(joinQuitLog.getBjyNumber())) {
                customerInfo = (MeetingCustomerInfo)customerInfoMap.get(joinQuitLog.getBjyNumber());
                customerInfo.setTotalDuration(Integer.valueOf(customerInfo.getTotalDuration() + joinQuitLog.getDuration()));
                if (joinQuitLog.getDuration() > customerInfo.getMaxDuration()) {
                    customerInfo.setMaxDuration(joinQuitLog.getDuration());
                    customerInfo.setArrivalTime(joinQuitLog.getJoinTime());
                    customerInfo.setQuitTime(joinQuitLog.getQuitTime());
                }
                customerInfo.setUpdateTime(new Date());
                if (customerInfo.getId() != null) {
                    updateCustomerInfos.add(customerInfo);
                }
            } else {
                WeworkContact contact;
                customerInfo = new MeetingCustomerInfo();
                Date curTime = new Date();
                customerInfo.setNum(this.idGen.getNum());
                customerInfo.setBizId(bizId);
                customerInfo.setRoomId(joinQuitLog.getRoomId());
                customerInfo.setMeetingId(joinQuitLog.getMeetingId());
                customerInfo.setCustomerStr("");
                customerInfo.setAppId("");
                customerInfo.setOpenId("");
                customerInfo.setContactId(joinQuitLog.getContactId());
                if (StringUtils.isNotBlank((CharSequence)customerInfo.getContactId()) && (contact = this.weworkContactMapper.queryContactByContactId(corpId, customerInfo.getContactId())) != null) {
                    customerInfo.setName(contact.getName());
                    customerInfo.setAvatar(contact.getAvatar());
                }
                if (StringUtils.isBlank((CharSequence)customerInfo.getName())) {
                    customerInfo.setName(joinQuitLog.getBjyName());
                }
                if (StringUtils.isBlank((CharSequence)customerInfo.getAvatar())) {
                    customerInfo.setAvatar(customerInfo.getAvatar());
                }
                customerInfo.setBjyNumber(joinQuitLog.getBjyNumber());
                customerInfo.setBjyMobile(joinQuitLog.getBjyMobile());
                if (StringUtils.isNotBlank((CharSequence)customerInfo.getContactId())) {
                    infoId = customerInfo.getContactId();
                } else if (StringUtils.isNotBlank((CharSequence)customerInfo.getUnionId())) {
                    infoId = customerInfo.getUnionId();
                }
                customerInfo.setInfoId(infoId);
                customerInfo.setTotalDuration(joinQuitLog.getDuration());
                customerInfo.setMaxDuration(joinQuitLog.getDuration());
                customerInfo.setArrivalTime(joinQuitLog.getJoinTime());
                customerInfo.setQuitTime(joinQuitLog.getQuitTime());
                customerInfo.setJoinCount(Integer.valueOf(0));
                customerInfo.setSendMsgCount(Integer.valueOf(0));
                customerInfo.setArrivalTime(curTime);
                customerInfo.setCreateTime(curTime);
                customerInfo.setUpdateTime(curTime);
                customerInfo.setChannelId(joinQuitLog.getChannelId());
                if (joinQuitLog.getChannelId() != null && joinQuitLog.getChannelId() != -1L) {
                    Map channelNameMap = this.channelMapper.selectIdAndNameByIds(bizId, (Collection)Lists.newArrayList((Object[])new Long[]{joinQuitLog.getChannelId()}));
                    customerInfo.setChannelName((String)channelNameMap.get(joinQuitLog.getChannelId()));
                }
                addCustomerInfos.add(customerInfo);
                customerInfoMap.put(joinQuitLog.getBjyNumber(), customerInfo);
            }
            customerInfo.setJoinCount(Integer.valueOf(customerInfo.getJoinCount() + 1));
        }
        if (CollectionUtils.isNotEmpty((Collection)addCustomerInfos)) {
            this.meetingCustomerInfoMapper.batchInsert((Collection)addCustomerInfos);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateCustomerInfos)) {
            this.meetingCustomerInfoMapper.batchUpdate((Collection)updateCustomerInfos);
        }
    }

    private List<String> getCorpIds(String corpIds) {
        List corpIdList = null;
        corpIdList = StringUtils.isNotBlank((CharSequence)corpIds) ? Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)corpIds)) : this.businessCustomerMapper.getAllCorpIds();
        return corpIdList;
    }

    private void syncWeworkTagOfCorp(String corpId) {
        WeworkContact contact = new WeworkContact();
        contact.setCorpId(corpId);
        int count = this.weworkContactMapper.selectCount((Object)contact);
        PageDto pageDto = this.getFirstPage(count);
        int pages = pageDto.getTotalPageNum();
        log.info("weworkContact pages: {}", (Object)pages);
        BusinessCustomer biz = this.businessCustomerMapper.getByCorpId(corpId);
        Long bizId = biz.getId();
        for (int page = 1; page <= pages; ++page) {
            pageDto.setPageNum(Integer.valueOf(page));
            log.info("weworkContact corpId: {}, pageDto: {}", (Object)corpId, (Object)pageDto);
            List contactPage = this.weworkContactMapper.contactPage(corpId, pageDto);
            if (CollectionUtils.isEmpty((Collection)contactPage)) continue;
            List contactIds = contactPage.stream().map(it -> it.getContactId()).collect(Collectors.toList());
            Map<String, String> contactNumMap = contactPage.stream().collect(Collectors.toMap(WeworkContact::getContactId, WeworkContact::getCustomerNum));
            List contactTags = this.weworkContactTagMapper.queryByCorpIdAndContactIds(corpId, contactIds);
            Set weworkUserIds2 = contactTags.stream().map(it -> it.getWeworkUserId()).collect(Collectors.toSet());
            HashSet weworkUserIds = Sets.newHashSet();
            weworkUserIds.addAll(weworkUserIds2);
            Map weworkUserIdNumMap = this.weworkUserMapper.selectWeworkUserIdAndNumByWeworkUserIds(corpId, (Collection)weworkUserIds);
            this.initTagRelation(bizId, contactTags, contactNumMap, weworkUserIdNumMap);
        }
    }

    private void handleCorpPage(String corpId) {
        log.info("start sync customer mobile to wework corpId: {}", (Object)corpId);
        WeworkContact weworkContact = new WeworkContact();
        weworkContact.setCorpId(corpId);
        int count = this.weworkContactMapper.selectCount((Object)weworkContact);
        PageDto pageDto = this.getFirstPage(count);
        int pages = pageDto.getTotalPageNum();
        log.info("need sync customer mobile handle pages: {}", (Object)pages);
        for (int page = 1; page <= pages; ++page) {
            pageDto.setPageNum(Integer.valueOf(page));
            List contactList = this.weworkContactMapper.contactPage(corpId, pageDto);
            this.executorService.submit(() -> this.handleOneContactSyncMobile(contactList));
        }
    }

    private void handleOneContactSyncMobile(List<WeworkContact> contactList) {
        if (CollectionUtils.isEmpty(contactList)) {
            log.info("contact page is empty");
            return;
        }
        Long bizId = contactList.get(0).getBizId();
        String corpId = contactList.get(0).getCorpId();
        HashMap contactWeworkUserMap = Maps.newHashMap();
        List contactIds = contactList.stream().filter(it -> it.getIsDeleted() == 0).filter(it -> StringUtils.isNotBlank((CharSequence)it.getCustomerNum())).map(it -> it.getContactId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(contactIds)) {
            log.info("contactIds is empty");
            return;
        }
        List relationList = this.weworkContactRelationMapper.queryByCorpIdAndContactIds(corpId, contactIds);
        if (CollectionUtils.isEmpty((Collection)relationList)) {
            log.info("contact relation is empty");
            return;
        }
        for (WeworkContactRelation relation : relationList) {
            String key = relation.getContactId();
            if (contactWeworkUserMap.containsKey(key)) {
                ((List)contactWeworkUserMap.get(key)).add(relation.getWeworkUserId());
                continue;
            }
            contactWeworkUserMap.put(key, Lists.newArrayList((Object[])new String[]{relation.getWeworkUserId()}));
        }
        List contactMobiles = this.weworkContactMobileMapper.queryByCorpIdAndContactIds(corpId, contactIds);
        HashMap remarkMobileMap = Maps.newHashMap();
        for (WeworkContactMobile contactMobile : contactMobiles) {
            String key = contactMobile.getWeworkUserId() + contactMobile.getContactId();
            if (remarkMobileMap.containsKey(key)) {
                ((List)remarkMobileMap.get(key)).add(contactMobile.getRemarkMobile());
                continue;
            }
            remarkMobileMap.put(key, Lists.newArrayList((Object[])new String[]{contactMobile.getRemarkMobile()}));
        }
        for (WeworkContact contact : contactList) {
            if (contact.getIsDeleted() == 1) {
                log.info("contact is deleted contactId: {}", (Object)contact.getContactId());
                continue;
            }
            if (StringUtils.isBlank((CharSequence)contact.getCustomerNum())) {
                log.info("contact customerNum is empty, contactId: {}", (Object)contact.getContactId());
                continue;
            }
            CustomerDetailResp resp = this.ccCustomerInfoService.queryCustomerDetail(bizId, contact.getCustomerNum());
            ArrayList needSyncMobiles = Lists.newArrayList();
            if (StringUtils.isNotBlank((CharSequence)resp.getMobile1())) {
                needSyncMobiles.add(resp.getMobile1());
            }
            if (StringUtils.isNotBlank((CharSequence)resp.getMobile2())) {
                needSyncMobiles.add(resp.getMobile2());
            }
            if (needSyncMobiles.isEmpty()) {
                log.info("customer center mobiles is empty, contactId: {}", (Object)contact.getContactId());
                continue;
            }
            List weworkUserIds = (List)contactWeworkUserMap.get(contact.getContactId());
            for (String weworkUserId : weworkUserIds) {
                String key = weworkUserId + contact.getContactId();
                List existsMobile = (List)remarkMobileMap.get(key);
                ArrayList remarkMobiles = Lists.newArrayList();
                if (CollectionUtils.isEmpty((Collection)existsMobile)) {
                    remarkMobiles.addAll(needSyncMobiles);
                } else {
                    needSyncMobiles.forEach(it -> {
                        if (!remarkMobiles.contains(it)) {
                            remarkMobiles.add(it);
                        }
                    });
                    existsMobile.forEach(it -> {
                        if (!remarkMobiles.contains(it)) {
                            remarkMobiles.add(it);
                        }
                    });
                }
                if (remarkMobiles.isEmpty() || CollectionUtils.isNotEmpty((Collection)existsMobile) && existsMobile.containsAll(remarkMobiles)) {
                    log.info("remark mobiles is empty or remark mobiles is exists, key: {}", (Object)key);
                    continue;
                }
                ModifyRemarkDto remarkDto = new ModifyRemarkDto();
                remarkDto.setBizId(bizId);
                remarkDto.setCorpId(corpId);
                remarkDto.setContactId(contact.getContactId());
                remarkDto.setWeworkUserId(weworkUserId);
                remarkDto.setRemarkMobiles((List)remarkMobiles);
                this.contactOpService.modifyRemark(remarkDto);
            }
        }
    }

    private void handleWeworkContactMobileData(String corpId) {
        Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
        Integer count = this.contactMobileMapper.selectContactCountByCorpId(corpId);
        Long channelId = this.channelMapper.querySysChannelId(SysChannelEnum.QY_WEIXIN.getCode());
        if (count > 0) {
            PageDto pageDto = this.getFirstPage(count);
            int pages = pageDto.getTotalPageNum();
            for (int page = 1; page <= pages; ++page) {
                pageDto.setPageNum(Integer.valueOf(page));
                log.info("handleWeworkContactMobileData count: {},  pages: {}/{}, bizId: {}", new Object[]{count, page, pages, bizId});
                List contactIds = this.contactMobileMapper.selectContactsByCorpId(corpId, pageDto);
                log.info("handleWeworkContactMobileData contactIds: {}", (Object)contactIds);
                List contactMobiles = this.contactMobileMapper.queryByCorpIdAndContactIdList(corpId, contactIds);
                Map contactMobileMap = contactMobiles.stream().collect(Collectors.groupingBy(WeworkContactMobile::getContactId, Collectors.mapping(a -> a, Collectors.toList())));
                Map contactNameMap = this.weworkContactMapper.queryContactNameMap(corpId, (Collection)contactIds);
                List tagList = this.weworkContactTagMapper.queryByCorpIdAndContactIds(corpId, contactIds);
                Map tagIdMap = tagList.stream().collect(Collectors.groupingBy(WeworkContactTag::getContactId, Collectors.mapping(WeworkContactTag::getTagId, Collectors.toList())));
                for (String contactId : contactIds) {
                    List contactMobileList = contactMobileMap.get(contactId);
                    if (CollectionUtils.isEmpty(contactMobileList)) {
                        log.info("handleWeworkContactMobileData contactId: {}", (Object)contactId);
                        continue;
                    }
                    String customerNum = this.ccCustomerNumService.getCustomerNumByWeworkContactId(bizId, contactId, null);
                    String mobile1 = ((WeworkContactMobile)contactMobileList.get(0)).getRemarkMobile();
                    String mobile2 = "";
                    if (contactMobileList.size() > 1) {
                        mobile2 = ((WeworkContactMobile)contactMobileList.get(1)).getRemarkMobile();
                    }
                    log.info("handleWeworkContactMobileData mod mobile contactId: {}, customerNum: {}, mobile1: {}, mobile2: {}", new Object[]{contactId, customerNum, mobile1, mobile2});
                    this.modMobileToCustomer(bizId, customerNum, mobile1, mobile2);
                    if (contactMobileList.size() <= 2) continue;
                    String name = (String)contactNameMap.get(contactId);
                    List tagIds = tagIdMap.get(contactId);
                    for (int j = 2; j < contactMobileList.size(); ++j) {
                        String pushMobile = ((WeworkContactMobile)contactMobileList.get(j)).getRemarkMobile();
                        if (!StringUtils.isNotBlank((CharSequence)pushMobile)) continue;
                        log.info("handleWeworkContactMobileData push mobile toCustomer  pushMobile: {}, name: {}", (Object)pushMobile, (Object)name);
                        this.customerCenterService.pushMobileCustomer(bizId, pushMobile, name, tagIds, Long.valueOf(-1L), channelId);
                    }
                }
            }
        }
    }

    private void modMobileToCustomer(Long bizId, String customerNum, String mobile1, String mobile2) {
        log.info("modMobileToCustomer bizId:{}, customerNum: {}, mobile1: {}, mobile2: {}", new Object[]{bizId, customerNum, mobile1, mobile2});
        ModMobileReq req = new ModMobileReq();
        req.setBizId(bizId);
        if (StringUtils.isNotBlank((CharSequence)mobile1)) {
            req.setMobile1(mobile1);
        }
        if (StringUtils.isNotBlank((CharSequence)mobile2)) {
            req.setMobile2(mobile2);
        }
        req.setCustomerNum(customerNum);
        req.setModuleType(ModuleType.REMARK_MOBILE.getCode());
        req.setSource(SOURCE);
        try {
            this.ccCustomerInfoService.modCustomerMobiles(req);
        }
        catch (Exception e) {
            log.info("modMobileToCustomer  customerNum: {},", (Object)customerNum);
            log.error("modMobileToCustomer error: {}", (Object)e.toString());
        }
    }
}

