/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupsend.service.impl;

import cn.kinyun.crm.common.service.CrmCustomerService;
import cn.kinyun.crm.common.service.dto.req.CrmGroupSendFilterQuery;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.UserRoleRespDto;
import com.kuaike.scrm.common.enums.GroupSendTaskType;
import com.kuaike.scrm.common.enums.IOperatorResultType;
import com.kuaike.scrm.common.enums.OperatorResultCustomerType;
import com.kuaike.scrm.common.enums.QueryType;
import com.kuaike.scrm.common.service.ArrangeService;
import com.kuaike.scrm.common.service.BatchCacheService;
import com.kuaike.scrm.common.service.ConvertService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.OrgService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.dto.SelectedChatroom2WeworkUserDto;
import com.kuaike.scrm.common.service.dto.SelectedContact2WeworkUserDto;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.JacksonUtils;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.contactanalyse.dto.SearchContactLogParam;
import com.kuaike.scrm.dal.contactanalyse.entity.WeworkContactLog;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.contactstage.mapper.WeworkContactStageMapper;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTask;
import com.kuaike.scrm.dal.groupsend.entity.WeworkTmpStore;
import com.kuaike.scrm.dal.groupsend.mapper.WeworkGroupMsgStatMapper;
import com.kuaike.scrm.dal.groupsend.mapper.WeworkTmpStoreMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.entity.CustomerStage;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.wework.dto.ChatRoomListQuery;
import com.kuaike.scrm.dal.wework.dto.ContactWeworkNumPair;
import com.kuaike.scrm.dal.wework.dto.ContactWeworkPair;
import com.kuaike.scrm.dal.wework.dto.RelationQueryParams;
import com.kuaike.scrm.dal.wework.dto.SearchChatRoomParam;
import com.kuaike.scrm.dal.wework.dto.WeworkChatRoomUserDto;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.dto.TagGroupPair;
import com.kuaike.scrm.dal.weworktag.dto.TagGroupParams;
import com.kuaike.scrm.dal.weworktag.dto.WeworkTagParams;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.groupsend.dto.request.AddOrModReq;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchChatroomReq;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchContactReq;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchQrCodeReq;
import com.kuaike.scrm.groupsend.dto.response.MultiSearchChatroomRespDto;
import com.kuaike.scrm.groupsend.dto.response.MultiSearchContactResp;
import com.kuaike.scrm.groupsend.service.MultiSelectService;
import com.kuaike.scrm.system.dto.request.UserRoleReqDto;
import com.kuaike.scrm.system.service.UserService;
import com.kuaike.scrm.wework.contact.service.ContactRelationService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MultiSelectServiceImpl
implements MultiSelectService {
    private static final Logger log = LoggerFactory.getLogger(MultiSelectServiceImpl.class);
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private WeworkUserService weworkUserService;
    @Autowired
    private WeworkContactLogMapper weworkContactLogMapper;
    @Autowired
    private ContactRelationService contactRelationService;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private ArrangeService arrangeService;
    @Autowired
    private WeworkTmpStoreMapper tmpStoreMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private CustomerStageMapper customerStageMapper;
    @Autowired
    private WeworkContactStageMapper weworkContactStageMapper;
    @Autowired
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Autowired
    private WeworkGroupMsgStatMapper msgStatMapper;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private BatchCacheService batchCacheService;
    @Autowired
    private ConvertService convertService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private OrgService orgService;
    @Autowired
    private UserService userService;
    @Autowired
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;

    @Override
    public MultiSearchChatroomRespDto multiSearchChatroom(MultiSearchChatroomReq req, boolean returnAll) {
        log.info("multiSearchChatroom with req={}\uff0creturnAll={}", (Object)req, (Object)returnAll);
        req.validate();
        if (returnAll) {
            req.setRequestId(null);
        }
        if (StringUtils.isBlank((CharSequence)req.getRequestId())) {
            return this.searchChatroomAndStore(req, returnAll, req.getOperatorId());
        }
        return this.searchChatroom(req.getRequestId(), req.getNotSelect(), req.getPageDto(), req.getChatroomResultQuery());
    }

    private MultiSearchChatroomRespDto searchChatroomAndStore(MultiSearchChatroomReq req, boolean returnAll, Long operatorId) {
        List<Object> resultList;
        MultiSearchChatroomRespDto result = new MultiSearchChatroomRespDto();
        User user = (User)this.userMapper.selectByPrimaryKey((Object)operatorId);
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"operator not exists");
        String corpId = user.getCorpId();
        SearchChatRoomParam param = new SearchChatRoomParam();
        param.setCreateChatroomBegin(req.getCreateChatroomBegin());
        param.setChatroomResultQuery(req.getChatroomResultQuery());
        param.setCreateChatroomEnd(req.getCreateChatroomEnd());
        param.setSelectType(req.getSelectType());
        param.setNotSelect(req.getNotSelect());
        param.setRoomNameContains(req.getRoomNameContains());
        param.setWeworkUserNumList(req.getWeworkUserNumList());
        param.setCorpId(corpId);
        param.setOnlyVip(req.getOnlyVip());
        param.setNotAdmin(req.getNotAdmin());
        int count = this.weworkChatRoomMapper.searchChatRoomCount(param);
        if (count == 0) {
            return new MultiSearchChatroomRespDto();
        }
        List weworkChatRoomUserDtos = this.weworkChatRoomMapper.searchChatRoomList(param);
        Map<String, List<WeworkChatRoomUserDto>> key2List = weworkChatRoomUserDtos.stream().collect(Collectors.groupingBy(a -> String.format("%s-%s", a.getWeworkUserId(), a.getWeworkRoomId())));
        ArrayList finalResultList = resultList = Lists.newArrayList();
        key2List.forEach((key, list) -> {
            WeworkChatRoomUserDto weworkChatRoom = (WeworkChatRoomUserDto)list.get(0);
            SelectedChatroom2WeworkUserDto dto = new SelectedChatroom2WeworkUserDto();
            dto.setChatroomId(weworkChatRoom.getWeworkRoomId());
            dto.setChatroomDigitId(weworkChatRoom.getWeworkDigitId());
            dto.setChatroomName(weworkChatRoom.getName());
            dto.setWeworkAlias(weworkChatRoom.getAlias());
            dto.setWeworkName(weworkChatRoom.getWeworkUserName());
            dto.setWeworkNum(weworkChatRoom.getWeworkUserNum());
            dto.setWeworkUserDigitId(weworkChatRoom.getDigitId());
            dto.setWeworkAvatar(weworkChatRoom.getAvatar());
            finalResultList.add(dto);
        });
        resultList = resultList.stream().sorted(Comparator.comparing(SelectedChatroom2WeworkUserDto::getChatroomId)).collect(Collectors.toList());
        String requestId = UUID.randomUUID().toString();
        WeworkTmpStore tmpStore = this.buildTmpStore(operatorId, corpId, resultList, requestId, QueryType.CHAT_ROOM.getType());
        this.tmpStoreMapper.insertSelective((Object)tmpStore);
        if (!returnAll) {
            Function<SelectedChatroom2WeworkUserDto, String> function = SelectedChatroom2WeworkUserDto::getChatroomId;
            resultList = this.pageResult(req.getPageDto(), resultList, function);
        }
        result.setList(resultList);
        result.setRequestId(requestId);
        return result;
    }

    private MultiSearchChatroomRespDto searchChatroom(String requestId, Set<String> excludeChatRoomIds, PageDto pageDto, String chatroomResultQuery) {
        MultiSearchChatroomRespDto result = new MultiSearchChatroomRespDto();
        WeworkTmpStore tmpStore = this.tmpStoreMapper.queryByRequestId(requestId);
        Preconditions.checkArgument((tmpStore != null ? 1 : 0) != 0, (Object)"requestId\u53c2\u6570\u975e\u6cd5");
        String storeBody = tmpStore.getStoreBody();
        List resultList = JSONArray.parseArray((String)storeBody, SelectedChatroom2WeworkUserDto.class);
        if (CollectionUtils.isNotEmpty(excludeChatRoomIds)) {
            resultList = resultList.stream().filter(a -> !excludeChatRoomIds.contains(a.getChatroomId())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)chatroomResultQuery)) {
            List chatroomIds = resultList.stream().map(SelectedChatroom2WeworkUserDto::getChatroomId).collect(Collectors.toList());
            ChatRoomListQuery params = new ChatRoomListQuery();
            params.setCorpId(tmpStore.getCorpId());
            params.setIsDismiss(Integer.valueOf(0));
            params.setWeworkRoomIds(chatroomIds);
            params.setName(chatroomResultQuery);
            Set filteredChatroomIds = this.weworkChatRoomMapper.queryChatRoomList(params).stream().map(WeworkChatRoom::getWeworkRoomId).collect(Collectors.toSet());
            resultList = resultList.stream().filter(a -> filteredChatroomIds.contains(a.getChatroomId())).collect(Collectors.toList());
        }
        Function<SelectedChatroom2WeworkUserDto, String> function = SelectedChatroom2WeworkUserDto::getChatroomId;
        List<SelectedChatroom2WeworkUserDto> page = this.pageResult(pageDto, resultList, function);
        result.setList(page);
        result.setRequestId(requestId);
        return result;
    }

    @Override
    public MultiSearchContactResp multiSearchQrcode(MultiSearchQrCodeReq req, boolean returnAll) {
        log.info("multiSearchQrcode with req={},returnAll={}", (Object)req, (Object)returnAll);
        req.validate();
        if (returnAll) {
            req.setRequestId(null);
        }
        if (StringUtils.isBlank((CharSequence)req.getRequestId())) {
            return this.searchAndStore(req, returnAll, req.getOperatorId());
        }
        return this.search(req.getRequestId(), req.getNotSelect(), req.getPageDto(), req.getContactResultQuery());
    }

    @Override
    public MultiSearchContactResp multiSearchContact(MultiSearchContactReq params, boolean returnAll) {
        log.info("selectContactByParams, params:{},returnAll={}", (Object)params, (Object)returnAll);
        params.baseValidate();
        if (returnAll) {
            params.setRequestId(null);
        }
        if (StringUtils.isBlank((CharSequence)params.getRequestId())) {
            return this.searchAndStoreContact(params, returnAll, params.getOperatorId());
        }
        return this.search(params.getRequestId(), params.getExcludeContactIds(), params.getPageDto(), params.getQuery());
    }

    private MultiSearchContactResp search(String requestId, Set<String> excludeContactIds, PageDto pageDto, String contactResultQuery) {
        MultiSearchContactResp result = new MultiSearchContactResp();
        result.setRequestId(requestId);
        WeworkTmpStore tmpStore = this.tmpStoreMapper.queryByRequestId(requestId);
        Preconditions.checkArgument((tmpStore != null ? 1 : 0) != 0, (Object)"requestId\u53c2\u6570\u975e\u6cd5");
        String storeBody = tmpStore.getStoreBody();
        List resultList = JSONArray.parseArray((String)storeBody, SelectedContact2WeworkUserDto.class);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            result.setList(Lists.newArrayList());
            return result;
        }
        if (CollectionUtils.isNotEmpty(excludeContactIds)) {
            resultList = resultList.stream().filter(a -> !excludeContactIds.contains(a.getContactId())).collect(Collectors.toList());
        }
        List contactWeworkNumPairs = resultList.stream().map(a -> new ContactWeworkNumPair(a.getWeworkNum(), a.getContactId())).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)contactResultQuery)) {
            Set filteredContactIds = this.weworkContactRelationMapper.queryContactInfoByWeworkUserNumAndNameQuery(tmpStore.getCorpId(), contactResultQuery, contactWeworkNumPairs).stream().map(a -> a.getContactId()).collect(Collectors.toSet());
            resultList = resultList.stream().filter(a -> filteredContactIds.contains(a.getContactId())).collect(Collectors.toList());
        }
        Function<SelectedContact2WeworkUserDto, String> function = SelectedContact2WeworkUserDto::getContactId;
        List<SelectedContact2WeworkUserDto> page = this.pageResult(pageDto, resultList, function);
        result.setList(page);
        return result;
    }

    private MultiSearchContactResp searchAndStore(MultiSearchQrCodeReq req, boolean returnAll, Long operatorId) {
        List remainContactWeworkList;
        MultiSearchContactResp result = new MultiSearchContactResp();
        User user = (User)this.userMapper.selectByPrimaryKey((Object)operatorId);
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"operator not exists");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        SearchContactLogParam param = new SearchContactLogParam();
        param.setCorpId(corpId);
        param.setAddTimeBegin(req.getAddTimeBegin());
        param.setAddTimeEnd(req.getAddTimeEnd());
        param.setGroupIds(req.getGroupIds());
        param.setPlanNum(req.getPlanId());
        param.setMarketType(req.getMarketType());
        param.setOnlyVip(req.getOnlyVip());
        List contactLogs = this.weworkContactLogMapper.searchByParams(param);
        if (CollectionUtils.isEmpty((Collection)contactLogs)) {
            return new MultiSearchContactResp();
        }
        if (CollectionUtils.isNotEmpty(req.getStageIds())) {
            List customerStages = this.customerStageMapper.queryListById(bizId, corpId, req.getStageIds());
            Preconditions.checkArgument((customerStages != null ? 1 : 0) != 0, (Object)"stageIds not exists");
            Map<Integer, List<CustomerStage>> type2List = customerStages.stream().collect(Collectors.groupingBy(CustomerStage::getType));
            List status1StageIds = type2List.getOrDefault(1, Lists.newArrayList()).stream().map(CustomerStage::getId).collect(Collectors.toList());
            List status2StageIds = type2List.getOrDefault(2, Lists.newArrayList()).stream().map(CustomerStage::getId).collect(Collectors.toList());
            List contactWeworkNumPairs = contactLogs.stream().map(a -> new ContactWeworkNumPair(a.getWeworkUserNum(), a.getContactId())).distinct().collect(Collectors.toList());
            List weworkContactStages = this.weworkContactStageMapper.queryByStage(corpId, status1StageIds, status2StageIds, contactWeworkNumPairs);
            Set contactIdAndWeworkUserNumSet = weworkContactStages.stream().map(a -> StringUtils.join((Object[])new String[]{a.getContactId(), a.getWeworkUserNum()}, (String)"$$")).collect(Collectors.toSet());
            contactLogs = contactLogs.stream().filter(a -> contactIdAndWeworkUserNumSet.contains(StringUtils.join((Object[])new String[]{a.getContactId(), a.getWeworkUserNum()}, (String)"$$"))).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)contactLogs)) {
            return new MultiSearchContactResp();
        }
        List weworkUserNums = contactLogs.stream().map(WeworkContactLog::getWeworkUserNum).distinct().collect(Collectors.toList());
        Map num2WeworkUserIds = this.weworkUserService.getWeworkUserIdMapByNums(weworkUserNums);
        Set contactWeworkPairs = contactLogs.stream().map(a -> new ContactWeworkPair((String)num2WeworkUserIds.get(a.getWeworkUserNum()), a.getContactId())).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(req.getNotSelect())) {
            contactWeworkPairs = contactWeworkPairs.stream().filter(a -> !req.getNotSelect().contains(a.getContactId())).collect(Collectors.toSet());
        }
        if (CollectionUtils.isEmpty((Collection)(remainContactWeworkList = this.contactRelationService.queryRemain(corpId, contactWeworkPairs, req.getOnlyVip())))) {
            return new MultiSearchContactResp();
        }
        Set<Object> contactIds = remainContactWeworkList.stream().map(ContactWeworkPair::getContactId).collect(Collectors.toSet());
        ArrayList groupTags = Lists.newArrayList();
        ArrayList excludeGroupTags = Lists.newArrayList();
        this.fillGroupTags(groupTags, req.getIncludeTags());
        this.fillGroupTags(excludeGroupTags, req.getNotIncludeTags());
        Set newContactIds = Sets.newHashSet();
        if (req.getFilterType() != null) {
            switch (req.getFilterType()) {
                case 0: {
                    newContactIds = this.weworkContactTagMapper.queryMatchedContactIdAndIncludeOne(corpId, (Collection)contactIds, (List)groupTags);
                    break;
                }
                case 1: {
                    newContactIds = this.weworkContactTagMapper.queryMatchedContactIdAndIncludeAll(corpId, (Collection)contactIds, (List)groupTags);
                    break;
                }
                case 2: {
                    newContactIds = this.weworkContactTagMapper.queryNotExistsContactId(corpId, contactIds);
                    break;
                }
            }
            if (CollectionUtils.isEmpty((Collection)newContactIds)) {
                return new MultiSearchContactResp();
            }
            contactIds = newContactIds;
        }
        Set excludeContactIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(req.getNotIncludeTags())) {
            if (req.getExcludeFilterType() == null || req.getExcludeFilterType() == 1) {
                excludeContactIds = this.weworkContactTagMapper.queryMatchedContactIdAndIncludeOne(corpId, (Collection)contactIds, (List)excludeGroupTags);
            } else if (req.getExcludeFilterType() == 0) {
                excludeContactIds = this.weworkContactTagMapper.queryMatchedContactIdAndIncludeAll(corpId, (Collection)contactIds, (List)excludeGroupTags);
            }
        }
        if (Objects.nonNull(req.getExcludeFilterType()) && req.getExcludeFilterType() == 2) {
            excludeContactIds = this.weworkContactTagMapper.queryNotExistsContactId(corpId, (Collection)contactIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)contactIds) && CollectionUtils.isNotEmpty((Collection)excludeContactIds)) {
            contactIds.removeAll(excludeContactIds);
            if (CollectionUtils.isEmpty((Collection)contactIds)) {
                log.info("\u79fb\u9664\u4e0d\u5305\u542b\u7684\u5ba2\u6237\u540e\u96c6\u5408\u4e3a\u7a7a");
                return new MultiSearchContactResp();
            }
        }
        Set overQuotaContactIds = null;
        String month = DateUtil.getCurTimeString((String)"yyyyMM");
        overQuotaContactIds = this.msgStatMapper.queryOverQuotaContactIds(param.getCorpId(), month, (Collection)contactIds);
        if (Objects.nonNull(req.getQuotaType())) {
            Set finalOverQuotaContactIds = overQuotaContactIds;
            contactIds = req.getQuotaType().equals(1) ? contactIds.stream().filter(a -> !finalOverQuotaContactIds.contains(a)).collect(Collectors.toSet()) : contactIds.stream().filter(finalOverQuotaContactIds::contains).collect(Collectors.toSet());
        }
        HashSet finalNewContactIds = contactIds;
        Map contactId2UserIds = remainContactWeworkList.stream().filter(a -> finalNewContactIds.contains(a.getContactId())).collect(Collectors.groupingBy(ContactWeworkPair::getContactId, Collectors.mapping(ContactWeworkPair::getWeworkUserId, Collectors.toList())));
        List<SelectedContact2WeworkUserDto> resultList = this.arrangeService.arrangeAvailableWeworkUserId(corpId, contactId2UserIds);
        resultList = resultList.stream().sorted(Comparator.comparing(SelectedContact2WeworkUserDto::getContactId)).collect(Collectors.toList());
        Iterator iterator = resultList.iterator();
        while (iterator.hasNext()) {
            SelectedContact2WeworkUserDto contact2WeworkUserDto;
            contact2WeworkUserDto.setQuotaUsed(!overQuotaContactIds.contains((contact2WeworkUserDto = (SelectedContact2WeworkUserDto)iterator.next()).getContactId()));
        }
        String requestId = UUID.randomUUID().toString();
        WeworkTmpStore tmpStore = this.buildTmpStore(operatorId, corpId, resultList, requestId, QueryType.QRCODE.getType());
        this.tmpStoreMapper.insertSelective((Object)tmpStore);
        if (!returnAll) {
            Function<SelectedContact2WeworkUserDto, String> function = SelectedContact2WeworkUserDto::getContactId;
            resultList = this.pageResult(req.getPageDto(), resultList, function);
        }
        result.setList(resultList);
        result.setRequestId(requestId);
        return result;
    }

    private void fillGroupTags(List<TagGroupPair> groupTags, List<TagGroupParams> item1) {
        if (CollectionUtils.isNotEmpty(item1)) {
            for (TagGroupParams tagsDto : item1) {
                for (WeworkTagParams tagItem : tagsDto.getWeworkTags()) {
                    TagGroupPair item = new TagGroupPair();
                    item.setTagId(tagItem.getId());
                    item.setGroupId(tagsDto.getGroupId());
                    groupTags.add(item);
                }
            }
        }
    }

    @Override
    public <T, U extends Comparable<? super U>> List<T> pageResult(PageDto pageDto, List<T> resultList, Function<T, U> function) {
        List page;
        List sorted = resultList.stream().sorted(Comparator.comparing(function)).collect(Collectors.toList());
        if (pageDto != null) {
            int count = sorted.size();
            int pageSize = pageDto.getPageSize();
            int offset = Math.min(pageDto.getOffset(), count);
            int currentPageSize = Math.min(count - offset, pageSize);
            page = sorted.subList(offset, offset + currentPageSize);
            pageDto.setCount(Integer.valueOf(count));
            pageDto.setCurPageCount(Integer.valueOf(currentPageSize));
        } else {
            page = sorted;
        }
        return page;
    }

    private <T> WeworkTmpStore buildTmpStore(Long operatorId, String corpId, List<T> resultList, String requestId, Integer queryType) {
        WeworkTmpStore tmpStore = new WeworkTmpStore();
        tmpStore.setCreateTime(new Date());
        tmpStore.setIsDeleted(Integer.valueOf(0));
        tmpStore.setCreateBy(operatorId);
        tmpStore.setRequestId(requestId);
        tmpStore.setCorpId(corpId);
        tmpStore.setQueryType(queryType);
        try {
            tmpStore.setStoreBody(JacksonUtils.getInstance().writeValueAsString(resultList));
        }
        catch (JsonProcessingException e) {
            log.error("\u751f\u6210json\u5931\u8d25", (Throwable)e);
        }
        return tmpStore;
    }

    private RelationQueryParams buildRelationQueryParams(String corpId, Collection<String> weworkUserIds, Set<String> contactIds, MultiSearchContactReq params, Set<String> excludeContactIds) {
        RelationQueryParams relationQueryParams = new RelationQueryParams();
        relationQueryParams.setCorpId(corpId);
        relationQueryParams.setWeworkUserIds(weworkUserIds);
        relationQueryParams.setContactIds(contactIds);
        relationQueryParams.setSex(params.getSex());
        relationQueryParams.setAddStartTime(params.getAddStartTime());
        relationQueryParams.setAddEndTime(params.getAddEndTime());
        relationQueryParams.setExcludeContactIds(excludeContactIds);
        relationQueryParams.setQuery(params.getQuery());
        relationQueryParams.setOnlyVip(params.getOnlyVip());
        return relationQueryParams;
    }

    private MultiSearchContactResp searchAndStoreContact(MultiSearchContactReq params, boolean returnAll, Long operatorId) {
        Object customerNum2MainNum;
        String ownerWeworkUserId;
        log.info("searchAndStoreContact,params:{},returnAll:{},operatorId:{}", new Object[]{params, returnAll, operatorId});
        MultiSearchContactResp result = new MultiSearchContactResp();
        HashMap totalMap = Maps.newHashMap();
        Map weworkUserNum2IdMap = this.weworkUserMapper.selectWeworkUserNumAndIdByNums(params.getWeworkUserNums());
        if (MapUtils.isNotEmpty((Map)weworkUserNum2IdMap)) {
            totalMap.putAll(weworkUserNum2IdMap);
        }
        if (CollectionUtils.isNotEmpty(params.getNodeIds())) {
            Set allNodeIds = this.nodeService.getPosterityIds(params.getNodeIds(), params.getBizId());
            Set deptIds = this.orgService.getDepartmentIds(allNodeIds);
            Set weworkUserNums = this.weworkDepartmentUserMapper.queryUserNumByDeptIds(params.getCorpId(), (Collection)deptIds);
            Map wuNumAndIdMap = this.weworkUserMapper.selectWeworkUserNumAndIdByNums((Collection)weworkUserNums);
            log.info("\u6839\u636e\u90e8\u95e8\u67e5\u8be2\u6210\u5458\uff0c\u90e8\u95e8ID:{},\u6210\u5458\u6570\u91cf:{},\u6210\u5458ID:{}", new Object[]{deptIds, wuNumAndIdMap.size(), wuNumAndIdMap.keySet()});
            if (MapUtils.isNotEmpty((Map)wuNumAndIdMap)) {
                totalMap.putAll(wuNumAndIdMap);
            }
        }
        HashSet weworkUserIds = totalMap.values();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        UserRoleReqDto userRoleReqDto = new UserRoleReqDto();
        userRoleReqDto.setUserId(userInfo.getId());
        List userRoles = this.userService.userRoleDetail(userRoleReqDto);
        log.info("searchAndStoreContact get userRoles info : {}, userId: {}", (Object)userRoles, (Object)userInfo.getId());
        HashSet managerNodeIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)userRoles)) {
            for (UserRoleRespDto userRole : userRoles) {
                if (!CollectionUtils.isNotEmpty((Collection)userRole.getManageNodeIds())) continue;
                for (Long nodeId : userRole.getManageNodeIds()) {
                    if (nodeId == null || nodeId == 0L) continue;
                    managerNodeIds.add(nodeId);
                }
            }
        }
        log.info("searchAndStoreContact get managerNodeIds : {}, userId: {}", (Object)managerNodeIds, (Object)userInfo.getId());
        if (CollectionUtils.isEmpty((Collection)managerNodeIds) && StringUtils.isNotBlank((CharSequence)(ownerWeworkUserId = this.userMapper.queryWeworkUserIdOfUser(userInfo.getId())))) {
            weworkUserIds = Sets.newHashSet((Object[])new String[]{ownerWeworkUserId});
        }
        log.info("searchAndStoreContact get weworkUserIds: {}", weworkUserIds);
        List<Object> relations = NumberUtils.INTEGER_ZERO.equals(params.getSelectContactType()) ? this.searchAllContact(params.getCorpId(), weworkUserIds, params.getExcludeContactIds(), params.getOnlyVip()) : this.searchContactByCondition(params, weworkUserIds);
        if (CollectionUtils.isEmpty(relations)) {
            log.info("\u6839\u636e\u6761\u4ef6params:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)params);
            return new MultiSearchContactResp();
        }
        List contactIds = relations.stream().map(WeworkContactRelation::getContactId).collect(Collectors.toList());
        Long bizId = params.getBizId();
        Boolean openCrm = this.scrmBizService.isOpenCrm(bizId);
        if (openCrm.booleanValue()) {
            HashSet filterResultSets = Sets.newHashSet();
            boolean filterEnable = false;
            if (StringUtils.isNotBlank((CharSequence)params.getBatchId())) {
                filterEnable = true;
                List customerNums = this.batchCacheService.getCacheDataByBatchId(params.getBatchId());
                if (CollectionUtils.isEmpty((Collection)customerNums)) {
                    return new MultiSearchContactResp();
                }
                this.collectContactIds(this.convertService.execConvert(bizId, (Collection)customerNums, (IOperatorResultType)OperatorResultCustomerType.CUSTOMER_NUM, (IOperatorResultType)OperatorResultCustomerType.WEWORK_CONTACT_ID), filterResultSets);
            }
            if (CollectionUtils.isNotEmpty(params.getLeadsTypes())) {
                filterEnable = true;
                Map contactId2CustomerNum = this.convertService.execConvert(bizId, contactIds, (IOperatorResultType)OperatorResultCustomerType.WEWORK_CONTACT_ID, (IOperatorResultType)OperatorResultCustomerType.CUSTOMER_NUM);
                Set customerNums = contactId2CustomerNum.values().stream().filter(a -> StringUtils.isNotEmpty((CharSequence)a)).collect(Collectors.toSet());
                customerNum2MainNum = this.ccCustomerNumService.getMainNumByCustomerNum(bizId, customerNums);
                Map mainNum2LeadsCustomerNums = this.ccCustomerNumService.getLeadsCustomerNumByMainNums(bizId, (Collection)customerNum2MainNum.values().stream().filter(a -> StringUtils.isNotEmpty((CharSequence)a)).collect(Collectors.toList()));
                CrmGroupSendFilterQuery query = new CrmGroupSendFilterQuery();
                query.setBizId(bizId);
                query.setCustomerNums(mainNum2LeadsCustomerNums.values().stream().flatMap(a -> a.stream()).filter(a -> StringUtils.isNotEmpty((CharSequence)a)).collect(Collectors.toSet()));
                query.setLeadsTypes(params.getLeadsTypes());
                Set finalCustomerNums = this.crmCustomerService.filterCustomerNumByLeadsTypes(query);
                this.collectContactIds(this.convertService.execConvert(bizId, (Collection)finalCustomerNums, (IOperatorResultType)OperatorResultCustomerType.CUSTOMER_NUM, (IOperatorResultType)OperatorResultCustomerType.WEWORK_CONTACT_ID), filterResultSets);
            }
            if (filterEnable) {
                relations = relations.stream().filter(a -> filterResultSets.contains(a.getContactId())).collect(Collectors.toList());
            }
        }
        Set overQuotaContactIds = null;
        String month = DateUtil.getCurTimeString((String)"yyyyMM");
        overQuotaContactIds = this.msgStatMapper.queryOverQuotaContactIds(params.getCorpId(), month, contactIds);
        if (Objects.nonNull(params.getQuotaType())) {
            Set finalOverQuotaContactIds = overQuotaContactIds;
            relations = params.getQuotaType().equals(1) ? relations.stream().filter(a -> !finalOverQuotaContactIds.contains(a.getContactId())).collect(Collectors.toList()) : relations.stream().filter(a -> finalOverQuotaContactIds.contains(a.getContactId())).collect(Collectors.toList());
        }
        Map contactId2UserIdsMap = relations.stream().collect(Collectors.groupingBy(WeworkContactRelation::getContactId, Collectors.mapping(WeworkContactRelation::getWeworkUserId, Collectors.toList())));
        List<SelectedContact2WeworkUserDto> resultList = this.arrangeService.arrangeAvailableWeworkUserId(params.getCorpId(), contactId2UserIdsMap);
        resultList = resultList.stream().sorted(Comparator.comparing(SelectedContact2WeworkUserDto::getContactId)).collect(Collectors.toList());
        customerNum2MainNum = resultList.iterator();
        while (customerNum2MainNum.hasNext()) {
            SelectedContact2WeworkUserDto contact2WeworkUserDto;
            contact2WeworkUserDto.setQuotaUsed(!overQuotaContactIds.contains((contact2WeworkUserDto = (SelectedContact2WeworkUserDto)customerNum2MainNum.next()).getContactId()));
        }
        String requestId = UUID.randomUUID().toString();
        WeworkTmpStore tmpStore = this.buildTmpStore(operatorId, params.getCorpId(), resultList, requestId, QueryType.CONTACT.getType());
        this.tmpStoreMapper.insertSelective((Object)tmpStore);
        if (!returnAll) {
            Function<SelectedContact2WeworkUserDto, String> function = SelectedContact2WeworkUserDto::getContactId;
            resultList = this.pageResult(params.getPageDto(), resultList, function);
        }
        result.setList(resultList);
        result.setRequestId(requestId);
        return result;
    }

    private void collectContactIds(Map<String, String> convertService, Set<String> filterResultSets) {
        Map<String, String> customerNum2ContactId = convertService;
        Set matchContactIds = customerNum2ContactId.values().stream().collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(matchContactIds)) {
            filterResultSets.addAll(matchContactIds);
        }
    }

    @Override
    public List<WeworkContactRelation> searchAllContact(String corpId, Collection<String> weworkUserIds, Collection<String> excludeContactIds, Integer onlyVip) {
        if (StringUtils.isEmpty((CharSequence)corpId) || CollectionUtils.isEmpty(weworkUserIds)) {
            return Lists.newArrayList();
        }
        return this.weworkContactRelationMapper.selectByCorpIdAndWeworkUserIds(corpId, weworkUserIds, excludeContactIds, onlyVip);
    }

    @Override
    public List<WeworkContactRelation> searchContactByCondition(MultiSearchContactReq params, Collection<String> weworkUserIds) {
        log.info("searchContactByCondition,params:{},weworkUserIds:{}", (Object)params, weworkUserIds);
        params.validateParams();
        List weworkUserNums = this.weworkUserMapper.queryWeworkUserNumByIds(params.getCorpId(), weworkUserIds);
        ArrayList relations = Lists.newArrayList();
        String corpId = params.getCorpId();
        HashSet contactIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(params.getRoomIds())) {
            Set memberIds = this.weworkChatRoomRelationMapper.selectMemberIdsByCorpIdAndRoomIds(corpId, params.getRoomIds());
            if (CollectionUtils.isEmpty((Collection)memberIds)) {
                log.info("\u6839\u636ecorpId:{},roomIds:{}\u672a\u83b7\u53d6\u5230\u6210\u5458", (Object)corpId, params.getRoomIds());
                return relations;
            }
            contactIds.addAll(memberIds);
        }
        if (CollectionUtils.isNotEmpty(params.getMarketingPlanNums())) {
            Set marketingContactIds = this.weworkContactLogMapper.selectContactIdsByParams(corpId, (Collection)weworkUserNums, params.getMarketingPlanNums());
            if (CollectionUtils.isEmpty((Collection)marketingContactIds)) {
                log.info("\u6839\u636ecorpId:{},marketingPlanIds:{}, weworkUserNums:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", new Object[]{corpId, weworkUserNums, params.getMarketingPlanNums()});
                return relations;
            }
            if (CollectionUtils.isEmpty((Collection)contactIds)) {
                contactIds.addAll(marketingContactIds);
            } else {
                contactIds.retainAll(marketingContactIds);
                if (CollectionUtils.isEmpty((Collection)contactIds)) {
                    log.info("marketing \u6ca1\u6709\u4ea4\u96c6");
                    return relations;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(params.getStageIds())) {
            Set<Long> stageIds = params.getStageIds();
            log.info("stageIds:{}", stageIds);
            Set followingStageIds = this.customerStageMapper.selectIdsByIdsAndType(stageIds, Integer.valueOf(1));
            Set finishStageIds = this.customerStageMapper.selectIdsByIdsAndType(stageIds, Integer.valueOf(2));
            HashSet stageContactIds = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty((Collection)followingStageIds)) {
                Set followingContactIds = this.weworkContactStageMapper.selectContactIdsByFollowingStageIds(corpId, (Collection)weworkUserNums, (Collection)followingStageIds);
                if (CollectionUtils.isEmpty((Collection)followingContactIds)) {
                    log.info("\u6839\u636efollowingStageIds:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)followingContactIds);
                    return relations;
                }
                stageContactIds.addAll(followingContactIds);
            }
            if (CollectionUtils.isNotEmpty((Collection)finishStageIds)) {
                Set finishContactIds = this.weworkContactStageMapper.selectContactIdsByFinishStageIds(corpId, (Collection)weworkUserNums, (Collection)finishStageIds);
                if (CollectionUtils.isEmpty((Collection)finishContactIds)) {
                    log.info("\u6839\u636efinishContactIds:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)finishContactIds);
                    return relations;
                }
                stageContactIds.addAll(finishContactIds);
            }
            if (CollectionUtils.isEmpty((Collection)stageContactIds)) {
                log.info("\u6839\u636estageIds:{}\u672a\u83b7\u53d6\u5230\u5ba2\u6237", stageIds);
                return relations;
            }
            if (CollectionUtils.isEmpty((Collection)contactIds)) {
                contactIds.addAll(stageContactIds);
            } else {
                contactIds.retainAll(stageContactIds);
                if (CollectionUtils.isEmpty((Collection)contactIds)) {
                    log.info("stage \u6ca1\u6709\u4ea4\u96c6");
                    return relations;
                }
            }
        }
        if (Objects.nonNull(params.getTagCondition())) {
            HashSet includeTagContactIds = Sets.newHashSet();
            if (params.getTagCondition() == 2) {
                Set noneTagContactIds = this.weworkContactRelationMapper.selectNoneTagContact(corpId, weworkUserIds);
                if (CollectionUtils.isEmpty((Collection)noneTagContactIds)) {
                    log.info("\u672a\u83b7\u53d6\u5230\u65e0\u4efb\u4f55\u6807\u7b7e\u7684\u5ba2\u6237");
                    return relations;
                }
                includeTagContactIds.addAll(noneTagContactIds);
            } else if (params.getTagCondition() == 1) {
                Set sameMeetTagContactIds = this.weworkContactTagMapper.selectSameMeetTagContactIds(corpId, weworkUserIds, params.getIncludeTags());
                if (CollectionUtils.isEmpty((Collection)sameMeetTagContactIds)) {
                    log.info("\u672a\u83b7\u53d6\u5230\u540c\u65f6\u6ee1\u8db3\u4ee5\u4e0b\u6807\u7b7e:{}\u7684\u5ba2\u6237", params.getIncludeTags());
                    return relations;
                }
                includeTagContactIds.addAll(sameMeetTagContactIds);
            } else if (params.getTagCondition() == 0) {
                Set meetOneOfTagContactIds = this.weworkContactTagMapper.selectMeetOneOfTageContactIds(corpId, weworkUserIds, params.getIncludeTags());
                if (CollectionUtils.isEmpty((Collection)meetOneOfTagContactIds)) {
                    log.info("\u672a\u83b7\u53d6\u5230\u6ee1\u8db3\u4ee5\u4e0b\u6807\u7b7e{}\u5176\u4e2d\u4e4b\u4e00\u7684\u5ba2\u6237", params.getIncludeTags());
                    return relations;
                }
                includeTagContactIds.addAll(meetOneOfTagContactIds);
            }
            if (CollectionUtils.isEmpty((Collection)includeTagContactIds)) {
                log.info("\u6839\u636e\u5305\u542b\u7684\u6807\u7b7e\uff1a{}\u672a\u83b7\u53d6\u5230\u5ba2\u6237", params.getIncludeTags());
                return relations;
            }
            if (CollectionUtils.isEmpty((Collection)contactIds)) {
                contactIds.addAll(includeTagContactIds);
            } else {
                contactIds.retainAll(includeTagContactIds);
                if (CollectionUtils.isEmpty((Collection)contactIds)) {
                    log.info("includeTag \u6ca1\u6709\u4ea4\u96c6");
                    return relations;
                }
            }
        }
        HashSet excludeContactIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(params.getExcludeContactIds())) {
            excludeContactIds.addAll(params.getExcludeContactIds());
        }
        Set excludeTagContactIds = null;
        if (CollectionUtils.isNotEmpty(params.getExcludeTags())) {
            if (Objects.isNull(params.getExcludeFilterType()) || params.getExcludeFilterType() == 1) {
                excludeTagContactIds = this.weworkContactTagMapper.selectSameMeetTagContactIds(corpId, weworkUserIds, params.getExcludeTags());
            } else if (params.getExcludeFilterType() == 0) {
                excludeTagContactIds = this.weworkContactTagMapper.selectMeetOneOfTageContactIds(corpId, weworkUserIds, params.getExcludeTags());
            }
        }
        if (Objects.nonNull(params.getExcludeFilterType()) && params.getExcludeFilterType() == 2) {
            excludeTagContactIds = this.weworkContactRelationMapper.selectNoneTagContact(corpId, weworkUserIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)contactIds) && CollectionUtils.isNotEmpty(excludeTagContactIds)) {
            contactIds.removeAll(excludeTagContactIds);
            if (CollectionUtils.isEmpty((Collection)contactIds)) {
                log.info("\u79fb\u9664\u4e0d\u5305\u542b\u7684\u5ba2\u6237\u540e\u96c6\u5408\u4e3a\u7a7a");
                return relations;
            }
        }
        if (CollectionUtils.isNotEmpty(excludeTagContactIds)) {
            excludeContactIds.addAll(excludeTagContactIds);
        }
        RelationQueryParams queryParams = this.buildRelationQueryParams(corpId, weworkUserIds, contactIds, params, excludeContactIds);
        return this.weworkContactRelationMapper.selectRelationsByQueryParams(queryParams);
    }

    @Override
    public Set<String> queryMultiSelectSendPair(MessageGroupSendTask task) {
        HashSet resultSet = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)task.getQueryRequestId())) {
            WeworkTmpStore weworkTmpStore = this.tmpStoreMapper.queryByRequestId(task.getQueryRequestId());
            switch (QueryType.getByType((int)weworkTmpStore.getQueryType())) {
                case CONTACT: 
                case QRCODE: {
                    List contact2List = JSONArray.parseArray((String)weworkTmpStore.getStoreBody(), SelectedContact2WeworkUserDto.class);
                    Set contactSet = contact2List.stream().map(a -> StringUtils.join((Object[])new String[]{a.getWeworkNum(), a.getContactId()}, (String)"##")).collect(Collectors.toSet());
                    resultSet.addAll(contactSet);
                    break;
                }
                case CHAT_ROOM: {
                    List chatroom2List = JSONArray.parseArray((String)weworkTmpStore.getStoreBody(), SelectedChatroom2WeworkUserDto.class);
                    Set chatroomSet = chatroom2List.stream().map(a -> StringUtils.join((Object[])new String[]{a.getWeworkNum(), a.getChatroomId()}, (String)"##")).collect(Collectors.toSet());
                    resultSet.addAll(chatroomSet);
                    break;
                }
            }
        } else {
            AddOrModReq req = (AddOrModReq)JSON.parseObject((String)task.getParamsJson(), AddOrModReq.class);
            switch (QueryType.getByType((int)task.getQueryType())) {
                case CONTACT: {
                    MultiSearchContactResp contactResp = this.multiSearchContact(req.getGroupsendContact(), true);
                    Set contactSet = contactResp.getList().stream().map(a -> StringUtils.join((Object[])new String[]{a.getWeworkNum(), a.getContactId()}, (String)"##")).collect(Collectors.toSet());
                    resultSet.addAll(contactSet);
                    break;
                }
                case CHAT_ROOM: {
                    if (task.getTaskType().equals(GroupSendTaskType.SIDEBAR.getValue())) {
                        MultiSearchChatroomRespDto chatroomResp = this.multiSearchChatroom(req.getGroupsendChatRoom(), true);
                        Set chatroomSet = chatroomResp.getList().stream().map(a -> StringUtils.join((Object[])new String[]{a.getWeworkNum(), a.getChatroomId()}, (String)"##")).collect(Collectors.toSet());
                        resultSet.addAll(chatroomSet);
                        break;
                    }
                    Set emptyChatroomSet = req.getWeworkUserNums().stream().map(a -> StringUtils.join((Object[])new String[]{a, "emptyReceiverId"}, (String)"##")).collect(Collectors.toSet());
                    resultSet.addAll(emptyChatroomSet);
                    break;
                }
                case QRCODE: {
                    MultiSearchContactResp contactResp1 = this.multiSearchQrcode(req.getGroupsendQrCodeContact(), true);
                    Set contactSet1 = contactResp1.getList().stream().map(a -> StringUtils.join((Object[])new String[]{a.getWeworkNum(), a.getContactId()}, (String)"##")).collect(Collectors.toSet());
                    resultSet.addAll(contactSet1);
                    break;
                }
            }
        }
        return resultSet;
    }
}

