/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupsend.dto.request;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.jsmsg.UniformMsgDto;
import com.kuaike.scrm.common.enums.GroupSendTaskType;
import com.kuaike.scrm.common.enums.JsMsgType;
import com.kuaike.scrm.common.service.dto.SelectedContact2WeworkUserDto;
import com.kuaike.scrm.common.service.dto.WeworkUserDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchChatroomReq;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchContactReq;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchQrCodeReq;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class AddOrModReq {
    private String taskNum;
    private String taskName;
    private Integer queryType;
    private Long fkTaskId;
    private Integer fkType;
    private Integer inviteInfoType;
    private List<UniformMsgDto> contentList;
    private Integer sendType;
    private Integer taskType;
    private Date sendTime;
    private Date deadlineTime;
    private Integer remindType;
    private List<Date> remindDates;
    private String remind;
    private Integer source;
    MultiSearchContactReq groupsendContact;
    MultiSearchChatroomReq groupsendChatRoom;
    MultiSearchQrCodeReq groupsendQrCodeContact;
    Set<String> weworkUserNums;
    Integer autoChangeTaskType;
    Integer changeTimeoutGap;
    private Integer sendCount;
    private List<WeworkUserDto> weworkUserInfos;
    private Boolean notUpdateTaskStatus = false;
    private Integer enableInviteCustomer;
    private List<SelectedContact2WeworkUserDto> weworkUserDtos;
    private static Set<JsMsgType> systemMsgTypes = Sets.newHashSet((Object[])new JsMsgType[]{JsMsgType.NEWS, JsMsgType.FILE, JsMsgType.IMAGE, JsMsgType.MEETING, JsMsgType.MINI_PROGRAM, JsMsgType.TEXT, JsMsgType.VIDEO, JsMsgType.FRIEND_FISSION_WORDS});

    public void setTaskName(String taskName) {
        this.taskName = StringUtils.abbreviate((String)taskName, (int)50);
    }

    public void validate(boolean textConvert2News) {
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.taskName) && StringUtils.length((CharSequence)this.taskName) <= 50 ? 1 : 0) != 0, (Object)"\u4efb\u52a1\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e50\u4e2a\u5b57\u7b26");
        Preconditions.checkArgument((boolean)Objects.nonNull(GroupSendTaskType.getType((int)this.taskType)), (Object)"taskType\u53c2\u6570\u672a\u8bbe\u7f6e");
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        switch (GroupSendTaskType.getType((int)this.taskType)) {
            case SIDEBAR: {
                this.checkSideBarGroupSend(currentUserInfo);
                break;
            }
            case QYAPI: {
                this.checkBackendGroupSend(currentUserInfo, textConvert2News);
                break;
            }
            case CLIENT: {
                this.checkClientGroupSend();
                break;
            }
            case VIP_GROUP_SEND_CUSTOMER: 
            case VIP_GROUP_SEND_CHATROOM: 
            case VIP_GROUP_SEND_NOTICE: {
                this.checkVipGroupSend(currentUserInfo);
                break;
            }
        }
    }

    private void checkClientGroupSend() {
        this.checkQueryTypeWithChatroomAndCustomer();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.contentList), (Object)"contentList\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet textSet = Sets.newHashSet();
        HashSet attachments = Sets.newHashSet();
        this.contentList.forEach(a -> {
            a.validate();
            JsMsgType jsMsgType = JsMsgType.get((String)a.getMsgType());
            Preconditions.checkArgument((jsMsgType != null ? 1 : 0) != 0, (Object)"\u7c7b\u578b\u4e0d\u652f\u6301");
            Preconditions.checkArgument((boolean)systemMsgTypes.contains(jsMsgType), (Object)(jsMsgType.getDesc() + "\u7c7b\u578b\u4e0d\u652f\u6301"));
            if (jsMsgType.isText()) {
                textSet.add(a);
            } else {
                attachments.add(a);
            }
            if (StringUtils.isNotEmpty((CharSequence)a.getContent())) {
                Preconditions.checkArgument((a.getContent().length() < 200 ? 1 : 0) != 0, (Object)"\u53d1\u9001\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7200\u5b57");
            }
        });
        Preconditions.checkArgument((CollectionUtils.isNotEmpty((Collection)textSet) || CollectionUtils.isNotEmpty((Collection)attachments) ? 1 : 0) != 0, (Object)"\u6587\u672c\u548c\u9644\u4ef6\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        if (CollectionUtils.isNotEmpty((Collection)textSet)) {
            Preconditions.checkArgument((textSet.size() == 1 ? 1 : 0) != 0, (Object)"\u53d1\u9001\u6587\u672c\u5185\u5bb9\u6216\u5173\u8054\u4f1a\u8bae\u5fc5\u987b\u4e8c\u9009\u4e00");
        }
        if (CollectionUtils.isNotEmpty((Collection)attachments)) {
            Preconditions.checkArgument((attachments.size() <= 9 ? 1 : 0) != 0, (Object)"\u9644\u4ef6\u4e0d\u80fd\u8d85\u8fc79\u4e2a");
        }
        Preconditions.checkArgument((this.sendTime != null ? 1 : 0) != 0, (Object)"\u5f00\u59cb\u53d1\u9001\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.deadlineTime != null && this.deadlineTime.after(this.sendTime) ? 1 : 0) != 0, (Object)"\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u53d1\u9001\u65f6\u95f4");
        Preconditions.checkArgument((this.fkType != null && this.fkType >= 0 ? 1 : 0) != 0, (Object)"fkType\u4e0d\u80fd\u4e3a\u7a7a");
        this.sendType = 1;
    }

    private void checkSideBarGroupSend(CurrentUserInfo currentUserInfo) {
        this.checkQueryTypeWithAllType(currentUserInfo);
        Preconditions.checkArgument((this.fkType != null && this.fkType >= 0 ? 1 : 0) != 0, (Object)"fkType\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.contentList), (Object)"contentList\u4e0d\u80fd\u4e3a\u7a7a");
        this.contentList.forEach(UniformMsgDto::validate);
        Preconditions.checkArgument((this.sendTime != null ? 1 : 0) != 0, (Object)"\u5f00\u59cb\u53d1\u9001\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.deadlineTime != null && this.deadlineTime.after(this.sendTime) ? 1 : 0) != 0, (Object)"\u7fa4\u53d1\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u53d1\u9001\u65f6\u95f4");
        this.sendType = 1;
    }

    private void checkVipGroupSend(CurrentUserInfo currentUserInfo) {
        this.checkQueryTypeWithAllType(currentUserInfo);
        Preconditions.checkArgument((this.fkType != null && this.fkType >= 0 ? 1 : 0) != 0, (Object)"fkType\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.contentList), (Object)"contentList\u4e0d\u80fd\u4e3a\u7a7a");
        this.contentList.forEach(UniformMsgDto::validate);
        if (this.sendTime == null) {
            this.sendTime = new Date();
            this.sendType = 0;
        } else {
            this.sendType = 1;
        }
    }

    private void checkBackendGroupSend(CurrentUserInfo currentUserInfo, boolean textConvert2News) {
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u5f53\u524d\u767b\u5f55\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkQueryTypeWithAllType(currentUserInfo);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.contentList), (Object)"contentList\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet textSet = Sets.newHashSet();
        HashSet attachments = Sets.newHashSet();
        this.contentList.forEach(a -> {
            a.validate();
            JsMsgType jsMsgType = JsMsgType.get((String)a.getMsgType());
            Preconditions.checkArgument((jsMsgType != null ? 1 : 0) != 0, (Object)"\u7c7b\u578b\u4e0d\u652f\u6301");
            Preconditions.checkArgument((boolean)systemMsgTypes.contains(jsMsgType), (Object)(jsMsgType.getDesc() + "\u7c7b\u578b\u4e0d\u652f\u6301"));
            if (jsMsgType.isText()) {
                if (!textConvert2News) {
                    textSet.add(a);
                } else {
                    attachments.add(a);
                }
            } else {
                attachments.add(a);
            }
        });
        Preconditions.checkArgument((CollectionUtils.isNotEmpty((Collection)textSet) || CollectionUtils.isNotEmpty((Collection)attachments) ? 1 : 0) != 0, (Object)"\u6587\u672c\u548c\u9644\u4ef6\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        if (CollectionUtils.isNotEmpty((Collection)textSet)) {
            Preconditions.checkArgument((textSet.size() == 1 ? 1 : 0) != 0, (Object)"\u53d1\u9001\u6587\u672c\u5185\u5bb9\u6216\u5173\u8054\u4f1a\u8bae\u5fc5\u987b\u4e8c\u9009\u4e00");
        }
        if (CollectionUtils.isNotEmpty((Collection)attachments)) {
            Preconditions.checkArgument((attachments.size() <= 9 ? 1 : 0) != 0, (Object)"\u9644\u4ef6\u4e0d\u80fd\u8d85\u8fc79\u4e2a");
        }
        if (this.sendTime == null) {
            this.sendTime = new Date();
            this.sendType = 0;
        } else {
            this.sendType = 1;
        }
        this.deadlineTime = DateUtils.addDays((Date)this.sendTime, (int)7);
        this.remind = null;
        this.remindDates = null;
        this.remindType = null;
    }

    private void checkQueryTypeWithAllType(CurrentUserInfo currentUserInfo) {
        Preconditions.checkArgument((this.queryType != null ? 1 : 0) != 0, (Object)"queryType\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.queryType >= 1 && this.queryType <= 3 ? 1 : 0) != 0, (Object)"queryType\u5fc5\u987b\u5728[1,3]\u4e4b\u95f4");
        switch (this.queryType) {
            case 1: {
                Preconditions.checkArgument((this.groupsendContact != null ? 1 : 0) != 0, (Object)"groupsendContact\u4e0d\u80fd\u4e3a\u7a7a");
                this.groupsendContact.setCorpId(currentUserInfo.getCorpId());
                this.groupsendContact.setBizId(currentUserInfo.getBizId());
                this.groupsendContact.setOperatorId(currentUserInfo.getId());
                break;
            }
            case 2: {
                if (GroupSendTaskType.QYAPI.getValue() == this.taskType.intValue()) {
                    this.groupsendChatRoom = null;
                    Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.weworkUserNums), (Object)"\u7fa4\u53d1\u7fa4\u65f6\uff0c\u6210\u5458\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    break;
                }
                Preconditions.checkArgument((this.groupsendChatRoom != null ? 1 : 0) != 0, (Object)"groupsendChatRoom\u4e0d\u80fd\u4e3a\u7a7a");
                this.groupsendChatRoom.setOperatorId(currentUserInfo.getId());
                this.groupsendChatRoom.validate();
                this.groupsendChatRoom.setChatroomResultQuery(null);
                this.groupsendChatRoom.setPageDto(null);
                break;
            }
            case 3: {
                Preconditions.checkArgument((this.groupsendQrCodeContact != null ? 1 : 0) != 0, (Object)"groupsendQrCodeContact\u4e0d\u80fd\u4e3a\u7a7a");
                this.groupsendQrCodeContact.setOperatorId(currentUserInfo.getId());
                this.groupsendQrCodeContact.validate();
                this.groupsendQrCodeContact.setContactResultQuery(null);
                this.groupsendQrCodeContact.setPageDto(null);
                break;
            }
        }
    }

    private void checkQueryTypeWithChatroomAndCustomer() {
        Preconditions.checkArgument((this.queryType != null ? 1 : 0) != 0, (Object)"queryType\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.queryType >= 1 && this.queryType <= 2 ? 1 : 0) != 0, (Object)"queryType\u5fc5\u987b\u662f\u8054\u7cfb\u4eba\u6216\u7fa4");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.weworkUserNums), (Object)"\u6210\u5458\u4e2a\u4eba\u7fa4\u53d1\u65f6\uff0c\u6210\u5458\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.groupsendContact = null;
        this.groupsendChatRoom = null;
        this.groupsendQrCodeContact = null;
    }

    public void resetQuery() {
        if (this.queryType != null) {
            switch (this.queryType) {
                case 1: {
                    if (this.groupsendContact == null) break;
                    this.groupsendContact.setRequestId(null);
                    break;
                }
                case 2: {
                    if (this.groupsendChatRoom == null) break;
                    this.groupsendChatRoom.setRequestId(null);
                    break;
                }
                case 3: {
                    if (this.groupsendQrCodeContact == null) break;
                    this.groupsendQrCodeContact.setRequestId(null);
                    break;
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddOrModReq)) {
            return false;
        }
        AddOrModReq other = (AddOrModReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$queryType = this.getQueryType();
        Integer other$queryType = other.getQueryType();
        if (this$queryType == null ? other$queryType != null : !((Object)this$queryType).equals(other$queryType)) {
            return false;
        }
        Long this$fkTaskId = this.getFkTaskId();
        Long other$fkTaskId = other.getFkTaskId();
        if (this$fkTaskId == null ? other$fkTaskId != null : !((Object)this$fkTaskId).equals(other$fkTaskId)) {
            return false;
        }
        Integer this$fkType = this.getFkType();
        Integer other$fkType = other.getFkType();
        if (this$fkType == null ? other$fkType != null : !((Object)this$fkType).equals(other$fkType)) {
            return false;
        }
        Integer this$inviteInfoType = this.getInviteInfoType();
        Integer other$inviteInfoType = other.getInviteInfoType();
        if (this$inviteInfoType == null ? other$inviteInfoType != null : !((Object)this$inviteInfoType).equals(other$inviteInfoType)) {
            return false;
        }
        Integer this$sendType = this.getSendType();
        Integer other$sendType = other.getSendType();
        if (this$sendType == null ? other$sendType != null : !((Object)this$sendType).equals(other$sendType)) {
            return false;
        }
        Integer this$taskType = this.getTaskType();
        Integer other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)this$taskType).equals(other$taskType)) {
            return false;
        }
        Integer this$remindType = this.getRemindType();
        Integer other$remindType = other.getRemindType();
        if (this$remindType == null ? other$remindType != null : !((Object)this$remindType).equals(other$remindType)) {
            return false;
        }
        Integer this$source = this.getSource();
        Integer other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Integer this$autoChangeTaskType = this.getAutoChangeTaskType();
        Integer other$autoChangeTaskType = other.getAutoChangeTaskType();
        if (this$autoChangeTaskType == null ? other$autoChangeTaskType != null : !((Object)this$autoChangeTaskType).equals(other$autoChangeTaskType)) {
            return false;
        }
        Integer this$changeTimeoutGap = this.getChangeTimeoutGap();
        Integer other$changeTimeoutGap = other.getChangeTimeoutGap();
        if (this$changeTimeoutGap == null ? other$changeTimeoutGap != null : !((Object)this$changeTimeoutGap).equals(other$changeTimeoutGap)) {
            return false;
        }
        Integer this$sendCount = this.getSendCount();
        Integer other$sendCount = other.getSendCount();
        if (this$sendCount == null ? other$sendCount != null : !((Object)this$sendCount).equals(other$sendCount)) {
            return false;
        }
        Boolean this$notUpdateTaskStatus = this.getNotUpdateTaskStatus();
        Boolean other$notUpdateTaskStatus = other.getNotUpdateTaskStatus();
        if (this$notUpdateTaskStatus == null ? other$notUpdateTaskStatus != null : !((Object)this$notUpdateTaskStatus).equals(other$notUpdateTaskStatus)) {
            return false;
        }
        Integer this$enableInviteCustomer = this.getEnableInviteCustomer();
        Integer other$enableInviteCustomer = other.getEnableInviteCustomer();
        if (this$enableInviteCustomer == null ? other$enableInviteCustomer != null : !((Object)this$enableInviteCustomer).equals(other$enableInviteCustomer)) {
            return false;
        }
        String this$taskNum = this.getTaskNum();
        String other$taskNum = other.getTaskNum();
        if (this$taskNum == null ? other$taskNum != null : !this$taskNum.equals(other$taskNum)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        List<UniformMsgDto> this$contentList = this.getContentList();
        List<UniformMsgDto> other$contentList = other.getContentList();
        if (this$contentList == null ? other$contentList != null : !((Object)this$contentList).equals(other$contentList)) {
            return false;
        }
        Date this$sendTime = this.getSendTime();
        Date other$sendTime = other.getSendTime();
        if (this$sendTime == null ? other$sendTime != null : !((Object)this$sendTime).equals(other$sendTime)) {
            return false;
        }
        Date this$deadlineTime = this.getDeadlineTime();
        Date other$deadlineTime = other.getDeadlineTime();
        if (this$deadlineTime == null ? other$deadlineTime != null : !((Object)this$deadlineTime).equals(other$deadlineTime)) {
            return false;
        }
        List<Date> this$remindDates = this.getRemindDates();
        List<Date> other$remindDates = other.getRemindDates();
        if (this$remindDates == null ? other$remindDates != null : !((Object)this$remindDates).equals(other$remindDates)) {
            return false;
        }
        String this$remind = this.getRemind();
        String other$remind = other.getRemind();
        if (this$remind == null ? other$remind != null : !this$remind.equals(other$remind)) {
            return false;
        }
        MultiSearchContactReq this$groupsendContact = this.getGroupsendContact();
        MultiSearchContactReq other$groupsendContact = other.getGroupsendContact();
        if (this$groupsendContact == null ? other$groupsendContact != null : !((Object)this$groupsendContact).equals(other$groupsendContact)) {
            return false;
        }
        MultiSearchChatroomReq this$groupsendChatRoom = this.getGroupsendChatRoom();
        MultiSearchChatroomReq other$groupsendChatRoom = other.getGroupsendChatRoom();
        if (this$groupsendChatRoom == null ? other$groupsendChatRoom != null : !((Object)this$groupsendChatRoom).equals(other$groupsendChatRoom)) {
            return false;
        }
        MultiSearchQrCodeReq this$groupsendQrCodeContact = this.getGroupsendQrCodeContact();
        MultiSearchQrCodeReq other$groupsendQrCodeContact = other.getGroupsendQrCodeContact();
        if (this$groupsendQrCodeContact == null ? other$groupsendQrCodeContact != null : !((Object)this$groupsendQrCodeContact).equals(other$groupsendQrCodeContact)) {
            return false;
        }
        Set<String> this$weworkUserNums = this.getWeworkUserNums();
        Set<String> other$weworkUserNums = other.getWeworkUserNums();
        if (this$weworkUserNums == null ? other$weworkUserNums != null : !((Object)this$weworkUserNums).equals(other$weworkUserNums)) {
            return false;
        }
        List<WeworkUserDto> this$weworkUserInfos = this.getWeworkUserInfos();
        List<WeworkUserDto> other$weworkUserInfos = other.getWeworkUserInfos();
        if (this$weworkUserInfos == null ? other$weworkUserInfos != null : !((Object)this$weworkUserInfos).equals(other$weworkUserInfos)) {
            return false;
        }
        List<SelectedContact2WeworkUserDto> this$weworkUserDtos = this.getWeworkUserDtos();
        List<SelectedContact2WeworkUserDto> other$weworkUserDtos = other.getWeworkUserDtos();
        return !(this$weworkUserDtos == null ? other$weworkUserDtos != null : !((Object)this$weworkUserDtos).equals(other$weworkUserDtos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddOrModReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $queryType = this.getQueryType();
        result = result * 59 + ($queryType == null ? 43 : ((Object)$queryType).hashCode());
        Long $fkTaskId = this.getFkTaskId();
        result = result * 59 + ($fkTaskId == null ? 43 : ((Object)$fkTaskId).hashCode());
        Integer $fkType = this.getFkType();
        result = result * 59 + ($fkType == null ? 43 : ((Object)$fkType).hashCode());
        Integer $inviteInfoType = this.getInviteInfoType();
        result = result * 59 + ($inviteInfoType == null ? 43 : ((Object)$inviteInfoType).hashCode());
        Integer $sendType = this.getSendType();
        result = result * 59 + ($sendType == null ? 43 : ((Object)$sendType).hashCode());
        Integer $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)$taskType).hashCode());
        Integer $remindType = this.getRemindType();
        result = result * 59 + ($remindType == null ? 43 : ((Object)$remindType).hashCode());
        Integer $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Integer $autoChangeTaskType = this.getAutoChangeTaskType();
        result = result * 59 + ($autoChangeTaskType == null ? 43 : ((Object)$autoChangeTaskType).hashCode());
        Integer $changeTimeoutGap = this.getChangeTimeoutGap();
        result = result * 59 + ($changeTimeoutGap == null ? 43 : ((Object)$changeTimeoutGap).hashCode());
        Integer $sendCount = this.getSendCount();
        result = result * 59 + ($sendCount == null ? 43 : ((Object)$sendCount).hashCode());
        Boolean $notUpdateTaskStatus = this.getNotUpdateTaskStatus();
        result = result * 59 + ($notUpdateTaskStatus == null ? 43 : ((Object)$notUpdateTaskStatus).hashCode());
        Integer $enableInviteCustomer = this.getEnableInviteCustomer();
        result = result * 59 + ($enableInviteCustomer == null ? 43 : ((Object)$enableInviteCustomer).hashCode());
        String $taskNum = this.getTaskNum();
        result = result * 59 + ($taskNum == null ? 43 : $taskNum.hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        List<UniformMsgDto> $contentList = this.getContentList();
        result = result * 59 + ($contentList == null ? 43 : ((Object)$contentList).hashCode());
        Date $sendTime = this.getSendTime();
        result = result * 59 + ($sendTime == null ? 43 : ((Object)$sendTime).hashCode());
        Date $deadlineTime = this.getDeadlineTime();
        result = result * 59 + ($deadlineTime == null ? 43 : ((Object)$deadlineTime).hashCode());
        List<Date> $remindDates = this.getRemindDates();
        result = result * 59 + ($remindDates == null ? 43 : ((Object)$remindDates).hashCode());
        String $remind = this.getRemind();
        result = result * 59 + ($remind == null ? 43 : $remind.hashCode());
        MultiSearchContactReq $groupsendContact = this.getGroupsendContact();
        result = result * 59 + ($groupsendContact == null ? 43 : ((Object)$groupsendContact).hashCode());
        MultiSearchChatroomReq $groupsendChatRoom = this.getGroupsendChatRoom();
        result = result * 59 + ($groupsendChatRoom == null ? 43 : ((Object)$groupsendChatRoom).hashCode());
        MultiSearchQrCodeReq $groupsendQrCodeContact = this.getGroupsendQrCodeContact();
        result = result * 59 + ($groupsendQrCodeContact == null ? 43 : ((Object)$groupsendQrCodeContact).hashCode());
        Set<String> $weworkUserNums = this.getWeworkUserNums();
        result = result * 59 + ($weworkUserNums == null ? 43 : ((Object)$weworkUserNums).hashCode());
        List<WeworkUserDto> $weworkUserInfos = this.getWeworkUserInfos();
        result = result * 59 + ($weworkUserInfos == null ? 43 : ((Object)$weworkUserInfos).hashCode());
        List<SelectedContact2WeworkUserDto> $weworkUserDtos = this.getWeworkUserDtos();
        result = result * 59 + ($weworkUserDtos == null ? 43 : ((Object)$weworkUserDtos).hashCode());
        return result;
    }

    public String getTaskNum() {
        return this.taskNum;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Integer getQueryType() {
        return this.queryType;
    }

    public Long getFkTaskId() {
        return this.fkTaskId;
    }

    public Integer getFkType() {
        return this.fkType;
    }

    public Integer getInviteInfoType() {
        return this.inviteInfoType;
    }

    public List<UniformMsgDto> getContentList() {
        return this.contentList;
    }

    public Integer getSendType() {
        return this.sendType;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public Date getDeadlineTime() {
        return this.deadlineTime;
    }

    public Integer getRemindType() {
        return this.remindType;
    }

    public List<Date> getRemindDates() {
        return this.remindDates;
    }

    public String getRemind() {
        return this.remind;
    }

    public Integer getSource() {
        return this.source;
    }

    public MultiSearchContactReq getGroupsendContact() {
        return this.groupsendContact;
    }

    public MultiSearchChatroomReq getGroupsendChatRoom() {
        return this.groupsendChatRoom;
    }

    public MultiSearchQrCodeReq getGroupsendQrCodeContact() {
        return this.groupsendQrCodeContact;
    }

    public Set<String> getWeworkUserNums() {
        return this.weworkUserNums;
    }

    public Integer getAutoChangeTaskType() {
        return this.autoChangeTaskType;
    }

    public Integer getChangeTimeoutGap() {
        return this.changeTimeoutGap;
    }

    public Integer getSendCount() {
        return this.sendCount;
    }

    public List<WeworkUserDto> getWeworkUserInfos() {
        return this.weworkUserInfos;
    }

    public Boolean getNotUpdateTaskStatus() {
        return this.notUpdateTaskStatus;
    }

    public Integer getEnableInviteCustomer() {
        return this.enableInviteCustomer;
    }

    public List<SelectedContact2WeworkUserDto> getWeworkUserDtos() {
        return this.weworkUserDtos;
    }

    public void setTaskNum(String taskNum) {
        this.taskNum = taskNum;
    }

    public void setQueryType(Integer queryType) {
        this.queryType = queryType;
    }

    public void setFkTaskId(Long fkTaskId) {
        this.fkTaskId = fkTaskId;
    }

    public void setFkType(Integer fkType) {
        this.fkType = fkType;
    }

    public void setInviteInfoType(Integer inviteInfoType) {
        this.inviteInfoType = inviteInfoType;
    }

    public void setContentList(List<UniformMsgDto> contentList) {
        this.contentList = contentList;
    }

    public void setSendType(Integer sendType) {
        this.sendType = sendType;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public void setDeadlineTime(Date deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public void setRemindType(Integer remindType) {
        this.remindType = remindType;
    }

    public void setRemindDates(List<Date> remindDates) {
        this.remindDates = remindDates;
    }

    public void setRemind(String remind) {
        this.remind = remind;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public void setGroupsendContact(MultiSearchContactReq groupsendContact) {
        this.groupsendContact = groupsendContact;
    }

    public void setGroupsendChatRoom(MultiSearchChatroomReq groupsendChatRoom) {
        this.groupsendChatRoom = groupsendChatRoom;
    }

    public void setGroupsendQrCodeContact(MultiSearchQrCodeReq groupsendQrCodeContact) {
        this.groupsendQrCodeContact = groupsendQrCodeContact;
    }

    public void setWeworkUserNums(Set<String> weworkUserNums) {
        this.weworkUserNums = weworkUserNums;
    }

    public void setAutoChangeTaskType(Integer autoChangeTaskType) {
        this.autoChangeTaskType = autoChangeTaskType;
    }

    public void setChangeTimeoutGap(Integer changeTimeoutGap) {
        this.changeTimeoutGap = changeTimeoutGap;
    }

    public void setSendCount(Integer sendCount) {
        this.sendCount = sendCount;
    }

    public void setWeworkUserInfos(List<WeworkUserDto> weworkUserInfos) {
        this.weworkUserInfos = weworkUserInfos;
    }

    public void setNotUpdateTaskStatus(Boolean notUpdateTaskStatus) {
        this.notUpdateTaskStatus = notUpdateTaskStatus;
    }

    public void setEnableInviteCustomer(Integer enableInviteCustomer) {
        this.enableInviteCustomer = enableInviteCustomer;
    }

    public void setWeworkUserDtos(List<SelectedContact2WeworkUserDto> weworkUserDtos) {
        this.weworkUserDtos = weworkUserDtos;
    }

    public String toString() {
        return "AddOrModReq(taskNum=" + this.getTaskNum() + ", taskName=" + this.getTaskName() + ", queryType=" + this.getQueryType() + ", fkTaskId=" + this.getFkTaskId() + ", fkType=" + this.getFkType() + ", inviteInfoType=" + this.getInviteInfoType() + ", contentList=" + this.getContentList() + ", sendType=" + this.getSendType() + ", taskType=" + this.getTaskType() + ", sendTime=" + this.getSendTime() + ", deadlineTime=" + this.getDeadlineTime() + ", remindType=" + this.getRemindType() + ", remindDates=" + this.getRemindDates() + ", remind=" + this.getRemind() + ", source=" + this.getSource() + ", groupsendContact=" + this.getGroupsendContact() + ", groupsendChatRoom=" + this.getGroupsendChatRoom() + ", groupsendQrCodeContact=" + this.getGroupsendQrCodeContact() + ", weworkUserNums=" + this.getWeworkUserNums() + ", autoChangeTaskType=" + this.getAutoChangeTaskType() + ", changeTimeoutGap=" + this.getChangeTimeoutGap() + ", sendCount=" + this.getSendCount() + ", weworkUserInfos=" + this.getWeworkUserInfos() + ", notUpdateTaskStatus=" + this.getNotUpdateTaskStatus() + ", enableInviteCustomer=" + this.getEnableInviteCustomer() + ", weworkUserDtos=" + this.getWeworkUserDtos() + ")";
    }
}

