/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupsend.dto.request;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.dto.jsmsg.UniformMsgDto;
import com.kuaike.scrm.common.enums.GroupSendTaskType;
import com.kuaike.scrm.common.enums.JsMsgType;
import com.kuaike.scrm.common.enums.ReceiveType;
import com.kuaike.scrm.groupsend.dto.WeworkUserSendTargetPair;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class AddOrModInnerGroupSendReq {
    private Long bizId;
    private String corpId;
    private String taskNum;
    private String taskName;
    private Long fkTaskId;
    private Integer fkType;
    private List<UniformMsgDto> contentList;
    private Integer sendType;
    private Integer taskType;
    private Date sendTime;
    private Date deadlineTime;
    private Integer remindType;
    private List<Date> remindDates;
    private String remind;
    Set<String> weworkUserNums;
    private Integer receiveType;
    private List<WeworkUserSendTargetPair> sendTargetPairs;
    private Integer visible;
    Integer autoChangeTaskType;
    private static Set<JsMsgType> systemMsgTypes = Sets.newHashSet((Object[])new JsMsgType[]{JsMsgType.NEWS, JsMsgType.IMAGE, JsMsgType.MEETING, JsMsgType.FRIEND_FISSION_WORDS, JsMsgType.MINI_PROGRAM, JsMsgType.TEXT, JsMsgType.VIDEO, JsMsgType.FILE});
    static final Set<Integer> receiveTypeSet = Sets.newHashSet((Object[])new Integer[]{ReceiveType.CHATROOM.getType(), ReceiveType.CONTACT.getType()});

    public void setTaskName(String taskName) {
        this.taskName = StringUtils.abbreviate((String)taskName, (int)50);
    }

    public void validate() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.bizId), (Object)"bizId \u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.corpId), (Object)"corpId \u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.taskName) && this.taskName.length() <= 50 ? 1 : 0) != 0, (Object)"\u4efb\u52a1\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e50\u4e2a\u5b57\u7b26");
        Preconditions.checkArgument((boolean)Objects.nonNull(GroupSendTaskType.getType((int)this.taskType)), (Object)"taskType\u53c2\u6570\u672a\u8bbe\u7f6e");
        if (Objects.isNull(this.visible)) {
            this.visible = NumberUtils.INTEGER_ONE;
        }
        switch (GroupSendTaskType.getType((int)this.taskType)) {
            case SIDEBAR: {
                this.checkSideBarGroupSend();
                break;
            }
            case QYAPI: {
                this.checkBackendGroupSend();
                break;
            }
            case CLIENT: {
                this.checkClientGroupSend();
                break;
            }
            case VIP_GROUP_SEND_CUSTOMER: {
                this.checkVipGroupSend();
                break;
            }
        }
    }

    private void checkClientGroupSend() {
        Preconditions.checkArgument((boolean)receiveTypeSet.contains(this.receiveType), (Object)"\u53d1\u9001\u5bf9\u8c61\u7c7b\u578b\u5fc5\u987b\u662f\u5ba2\u6237\u6216\u7fa4");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.weworkUserNums), (Object)"weworkUserNums\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.contentList), (Object)"contentList\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet textSet = Sets.newHashSet();
        HashSet attachments = Sets.newHashSet();
        this.contentList.forEach(a -> {
            a.validate();
            JsMsgType jsMsgType = JsMsgType.get((String)a.getMsgType());
            Preconditions.checkArgument((jsMsgType != null ? 1 : 0) != 0, (Object)"\u7c7b\u578b\u4e0d\u652f\u6301");
            Preconditions.checkArgument((boolean)systemMsgTypes.contains(jsMsgType), (Object)(jsMsgType.getDesc() + "\u7c7b\u578b\u4e0d\u652f\u6301"));
            if (jsMsgType.isText()) {
                textSet.add(a);
            } else {
                attachments.add(a);
            }
        });
        Preconditions.checkArgument((CollectionUtils.isNotEmpty((Collection)textSet) || CollectionUtils.isNotEmpty((Collection)attachments) ? 1 : 0) != 0, (Object)"\u6587\u672c\u548c\u9644\u4ef6\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        if (CollectionUtils.isNotEmpty((Collection)textSet)) {
            Preconditions.checkArgument((textSet.size() == 1 ? 1 : 0) != 0, (Object)"\u53d1\u9001\u6587\u672c\u5185\u5bb9\u6216\u5173\u8054\u4f1a\u8bae\u5fc5\u987b\u4e8c\u9009\u4e00");
        }
        if (CollectionUtils.isNotEmpty((Collection)attachments)) {
            Preconditions.checkArgument((attachments.size() <= 9 ? 1 : 0) != 0, (Object)"\u9644\u4ef6\u4e0d\u80fd\u8d85\u8fc79\u4e2a");
        }
        Preconditions.checkArgument((this.sendTime != null ? 1 : 0) != 0, (Object)"\u5f00\u59cb\u53d1\u9001\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.deadlineTime != null && this.deadlineTime.after(this.sendTime) ? 1 : 0) != 0, (Object)"\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u53d1\u9001\u65f6\u95f4");
        Preconditions.checkArgument((this.fkType != null && this.fkType >= 0 ? 1 : 0) != 0, (Object)"fkType\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void checkSideBarGroupSend() {
        Preconditions.checkArgument((boolean)receiveTypeSet.contains(this.receiveType), (Object)"\u53d1\u9001\u5bf9\u8c61\u7c7b\u578b\u5fc5\u987b\u662f\u5ba2\u6237\u6216\u7fa4");
        Preconditions.checkArgument((this.fkType != null && this.fkType >= 0 ? 1 : 0) != 0, (Object)"fkType\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.sendTargetPairs), (Object)"sendTargetPairs is null or empty");
        this.sendTargetPairs.forEach(WeworkUserSendTargetPair::validate);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.contentList), (Object)"contentList\u4e0d\u80fd\u4e3a\u7a7a");
        this.contentList.forEach(UniformMsgDto::validate);
        Preconditions.checkArgument((this.sendTime != null ? 1 : 0) != 0, (Object)"\u5f00\u59cb\u53d1\u9001\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.deadlineTime != null && this.deadlineTime.after(this.sendTime) ? 1 : 0) != 0, (Object)"\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u53d1\u9001\u65f6\u95f4");
    }

    private void checkBackendGroupSend() {
        Preconditions.checkArgument((boolean)receiveTypeSet.contains(this.receiveType), (Object)"\u53d1\u9001\u5bf9\u8c61\u7c7b\u578b\u5fc5\u987b\u662f\u5ba2\u6237\u6216\u7fa4");
        if (this.receiveType.equals(ReceiveType.CHATROOM.getType())) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.weworkUserNums), (Object)"weworkUserNums is null or empty");
            this.sendTargetPairs = null;
        } else {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.sendTargetPairs), (Object)"sendTargetPairs is null or empty");
            this.sendTargetPairs.forEach(WeworkUserSendTargetPair::validate);
        }
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.contentList), (Object)"contentList\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet textSet = Sets.newHashSet();
        HashSet attachments = Sets.newHashSet();
        this.contentList.forEach(a -> {
            a.validate();
            JsMsgType jsMsgType = JsMsgType.get((String)a.getMsgType());
            Preconditions.checkArgument((jsMsgType != null ? 1 : 0) != 0, (Object)"\u7c7b\u578b\u4e0d\u652f\u6301");
            Preconditions.checkArgument((boolean)systemMsgTypes.contains(jsMsgType), (Object)(jsMsgType.getDesc() + "\u7c7b\u578b\u4e0d\u652f\u6301"));
            if (jsMsgType.isText()) {
                textSet.add(a);
            } else {
                attachments.add(a);
            }
        });
        Preconditions.checkArgument((CollectionUtils.isNotEmpty((Collection)textSet) || CollectionUtils.isNotEmpty((Collection)attachments) ? 1 : 0) != 0, (Object)"\u6587\u672c\u548c\u9644\u4ef6\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        if (CollectionUtils.isNotEmpty((Collection)textSet)) {
            Preconditions.checkArgument((textSet.size() == 1 ? 1 : 0) != 0, (Object)"\u53d1\u9001\u6587\u672c\u5185\u5bb9\u6216\u5173\u8054\u4f1a\u8bae\u5fc5\u987b\u4e8c\u9009\u4e00");
        }
        if (CollectionUtils.isNotEmpty((Collection)attachments)) {
            Preconditions.checkArgument((attachments.size() <= 9 ? 1 : 0) != 0, (Object)"\u9644\u4ef6\u4e0d\u80fd\u8d85\u8fc79\u4e2a");
        }
        if (this.sendTime == null) {
            this.sendTime = new Date();
            this.sendType = 0;
        } else {
            Preconditions.checkArgument((boolean)this.sendTime.after(new Date()), (Object)"\u53d1\u9001\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
            this.sendType = 1;
        }
        Preconditions.checkArgument((this.fkType != null && this.fkType >= 0 ? 1 : 0) != 0, (Object)"fkType\u4e0d\u80fd\u4e3a\u7a7a");
        this.remind = null;
        this.remindDates = null;
        this.remindType = null;
    }

    private void checkVipGroupSend() {
        Preconditions.checkArgument((this.fkType != null && this.fkType >= 0 ? 1 : 0) != 0, (Object)"fkType\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.sendTargetPairs), (Object)"sendTargetPairs is null or empty");
        this.sendTargetPairs.forEach(a -> {
            a.validate();
            a.validateDigitId();
        });
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.contentList), (Object)"contentList\u4e0d\u80fd\u4e3a\u7a7a");
        this.contentList.forEach(UniformMsgDto::validate);
        if (this.sendTime == null) {
            this.sendTime = new Date();
            this.sendType = 0;
        } else {
            this.sendType = 1;
        }
    }

    public Long getBizId() {
        return this.bizId;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public String getTaskNum() {
        return this.taskNum;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Long getFkTaskId() {
        return this.fkTaskId;
    }

    public Integer getFkType() {
        return this.fkType;
    }

    public List<UniformMsgDto> getContentList() {
        return this.contentList;
    }

    public Integer getSendType() {
        return this.sendType;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public Date getDeadlineTime() {
        return this.deadlineTime;
    }

    public Integer getRemindType() {
        return this.remindType;
    }

    public List<Date> getRemindDates() {
        return this.remindDates;
    }

    public String getRemind() {
        return this.remind;
    }

    public Set<String> getWeworkUserNums() {
        return this.weworkUserNums;
    }

    public Integer getReceiveType() {
        return this.receiveType;
    }

    public List<WeworkUserSendTargetPair> getSendTargetPairs() {
        return this.sendTargetPairs;
    }

    public Integer getVisible() {
        return this.visible;
    }

    public Integer getAutoChangeTaskType() {
        return this.autoChangeTaskType;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public void setTaskNum(String taskNum) {
        this.taskNum = taskNum;
    }

    public void setFkTaskId(Long fkTaskId) {
        this.fkTaskId = fkTaskId;
    }

    public void setFkType(Integer fkType) {
        this.fkType = fkType;
    }

    public void setContentList(List<UniformMsgDto> contentList) {
        this.contentList = contentList;
    }

    public void setSendType(Integer sendType) {
        this.sendType = sendType;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public void setDeadlineTime(Date deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public void setRemindType(Integer remindType) {
        this.remindType = remindType;
    }

    public void setRemindDates(List<Date> remindDates) {
        this.remindDates = remindDates;
    }

    public void setRemind(String remind) {
        this.remind = remind;
    }

    public void setWeworkUserNums(Set<String> weworkUserNums) {
        this.weworkUserNums = weworkUserNums;
    }

    public void setReceiveType(Integer receiveType) {
        this.receiveType = receiveType;
    }

    public void setSendTargetPairs(List<WeworkUserSendTargetPair> sendTargetPairs) {
        this.sendTargetPairs = sendTargetPairs;
    }

    public void setVisible(Integer visible) {
        this.visible = visible;
    }

    public void setAutoChangeTaskType(Integer autoChangeTaskType) {
        this.autoChangeTaskType = autoChangeTaskType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddOrModInnerGroupSendReq)) {
            return false;
        }
        AddOrModInnerGroupSendReq other = (AddOrModInnerGroupSendReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        Long this$fkTaskId = this.getFkTaskId();
        Long other$fkTaskId = other.getFkTaskId();
        if (this$fkTaskId == null ? other$fkTaskId != null : !((Object)this$fkTaskId).equals(other$fkTaskId)) {
            return false;
        }
        Integer this$fkType = this.getFkType();
        Integer other$fkType = other.getFkType();
        if (this$fkType == null ? other$fkType != null : !((Object)this$fkType).equals(other$fkType)) {
            return false;
        }
        Integer this$sendType = this.getSendType();
        Integer other$sendType = other.getSendType();
        if (this$sendType == null ? other$sendType != null : !((Object)this$sendType).equals(other$sendType)) {
            return false;
        }
        Integer this$taskType = this.getTaskType();
        Integer other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)this$taskType).equals(other$taskType)) {
            return false;
        }
        Integer this$remindType = this.getRemindType();
        Integer other$remindType = other.getRemindType();
        if (this$remindType == null ? other$remindType != null : !((Object)this$remindType).equals(other$remindType)) {
            return false;
        }
        Integer this$receiveType = this.getReceiveType();
        Integer other$receiveType = other.getReceiveType();
        if (this$receiveType == null ? other$receiveType != null : !((Object)this$receiveType).equals(other$receiveType)) {
            return false;
        }
        Integer this$visible = this.getVisible();
        Integer other$visible = other.getVisible();
        if (this$visible == null ? other$visible != null : !((Object)this$visible).equals(other$visible)) {
            return false;
        }
        Integer this$autoChangeTaskType = this.getAutoChangeTaskType();
        Integer other$autoChangeTaskType = other.getAutoChangeTaskType();
        if (this$autoChangeTaskType == null ? other$autoChangeTaskType != null : !((Object)this$autoChangeTaskType).equals(other$autoChangeTaskType)) {
            return false;
        }
        String this$corpId = this.getCorpId();
        String other$corpId = other.getCorpId();
        if (this$corpId == null ? other$corpId != null : !this$corpId.equals(other$corpId)) {
            return false;
        }
        String this$taskNum = this.getTaskNum();
        String other$taskNum = other.getTaskNum();
        if (this$taskNum == null ? other$taskNum != null : !this$taskNum.equals(other$taskNum)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        List<UniformMsgDto> this$contentList = this.getContentList();
        List<UniformMsgDto> other$contentList = other.getContentList();
        if (this$contentList == null ? other$contentList != null : !((Object)this$contentList).equals(other$contentList)) {
            return false;
        }
        Date this$sendTime = this.getSendTime();
        Date other$sendTime = other.getSendTime();
        if (this$sendTime == null ? other$sendTime != null : !((Object)this$sendTime).equals(other$sendTime)) {
            return false;
        }
        Date this$deadlineTime = this.getDeadlineTime();
        Date other$deadlineTime = other.getDeadlineTime();
        if (this$deadlineTime == null ? other$deadlineTime != null : !((Object)this$deadlineTime).equals(other$deadlineTime)) {
            return false;
        }
        List<Date> this$remindDates = this.getRemindDates();
        List<Date> other$remindDates = other.getRemindDates();
        if (this$remindDates == null ? other$remindDates != null : !((Object)this$remindDates).equals(other$remindDates)) {
            return false;
        }
        String this$remind = this.getRemind();
        String other$remind = other.getRemind();
        if (this$remind == null ? other$remind != null : !this$remind.equals(other$remind)) {
            return false;
        }
        Set<String> this$weworkUserNums = this.getWeworkUserNums();
        Set<String> other$weworkUserNums = other.getWeworkUserNums();
        if (this$weworkUserNums == null ? other$weworkUserNums != null : !((Object)this$weworkUserNums).equals(other$weworkUserNums)) {
            return false;
        }
        List<WeworkUserSendTargetPair> this$sendTargetPairs = this.getSendTargetPairs();
        List<WeworkUserSendTargetPair> other$sendTargetPairs = other.getSendTargetPairs();
        return !(this$sendTargetPairs == null ? other$sendTargetPairs != null : !((Object)this$sendTargetPairs).equals(other$sendTargetPairs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddOrModInnerGroupSendReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        Long $fkTaskId = this.getFkTaskId();
        result = result * 59 + ($fkTaskId == null ? 43 : ((Object)$fkTaskId).hashCode());
        Integer $fkType = this.getFkType();
        result = result * 59 + ($fkType == null ? 43 : ((Object)$fkType).hashCode());
        Integer $sendType = this.getSendType();
        result = result * 59 + ($sendType == null ? 43 : ((Object)$sendType).hashCode());
        Integer $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)$taskType).hashCode());
        Integer $remindType = this.getRemindType();
        result = result * 59 + ($remindType == null ? 43 : ((Object)$remindType).hashCode());
        Integer $receiveType = this.getReceiveType();
        result = result * 59 + ($receiveType == null ? 43 : ((Object)$receiveType).hashCode());
        Integer $visible = this.getVisible();
        result = result * 59 + ($visible == null ? 43 : ((Object)$visible).hashCode());
        Integer $autoChangeTaskType = this.getAutoChangeTaskType();
        result = result * 59 + ($autoChangeTaskType == null ? 43 : ((Object)$autoChangeTaskType).hashCode());
        String $corpId = this.getCorpId();
        result = result * 59 + ($corpId == null ? 43 : $corpId.hashCode());
        String $taskNum = this.getTaskNum();
        result = result * 59 + ($taskNum == null ? 43 : $taskNum.hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        List<UniformMsgDto> $contentList = this.getContentList();
        result = result * 59 + ($contentList == null ? 43 : ((Object)$contentList).hashCode());
        Date $sendTime = this.getSendTime();
        result = result * 59 + ($sendTime == null ? 43 : ((Object)$sendTime).hashCode());
        Date $deadlineTime = this.getDeadlineTime();
        result = result * 59 + ($deadlineTime == null ? 43 : ((Object)$deadlineTime).hashCode());
        List<Date> $remindDates = this.getRemindDates();
        result = result * 59 + ($remindDates == null ? 43 : ((Object)$remindDates).hashCode());
        String $remind = this.getRemind();
        result = result * 59 + ($remind == null ? 43 : $remind.hashCode());
        Set<String> $weworkUserNums = this.getWeworkUserNums();
        result = result * 59 + ($weworkUserNums == null ? 43 : ((Object)$weworkUserNums).hashCode());
        List<WeworkUserSendTargetPair> $sendTargetPairs = this.getSendTargetPairs();
        result = result * 59 + ($sendTargetPairs == null ? 43 : ((Object)$sendTargetPairs).hashCode());
        return result;
    }

    public String toString() {
        return "AddOrModInnerGroupSendReq(bizId=" + this.getBizId() + ", corpId=" + this.getCorpId() + ", taskNum=" + this.getTaskNum() + ", taskName=" + this.getTaskName() + ", fkTaskId=" + this.getFkTaskId() + ", fkType=" + this.getFkType() + ", contentList=" + this.getContentList() + ", sendType=" + this.getSendType() + ", taskType=" + this.getTaskType() + ", sendTime=" + this.getSendTime() + ", deadlineTime=" + this.getDeadlineTime() + ", remindType=" + this.getRemindType() + ", remindDates=" + this.getRemindDates() + ", remind=" + this.getRemind() + ", weworkUserNums=" + this.getWeworkUserNums() + ", receiveType=" + this.getReceiveType() + ", sendTargetPairs=" + this.getSendTargetPairs() + ", visible=" + this.getVisible() + ", autoChangeTaskType=" + this.getAutoChangeTaskType() + ")";
    }
}

