/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupinvite.dto.req;

import com.kuaike.scrm.groupinvite.dto.GroupInviteContentDto;
import com.kuaike.scrm.groupinvite.dto.req.GroupInviteRoomDto;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchContactReq;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Preconditions;

public class GroupInviteAddReq {
    private String name;
    private MultiSearchContactReq groupsendContact;
    private GroupInviteContentDto context;
    private List<GroupInviteRoomDto> weworkRoomList;
    private Integer isAdvanced;
    private Integer contactFilter;

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"\u4efb\u52a1\u540d\u4e3a\u7a7a");
        Preconditions.checkArgument((this.groupsendContact != null ? 1 : 0) != 0, (Object)"\u9009\u62e9\u53d1\u9001\u5ba2\u6237\u7684\u6761\u4ef6\u4e3a\u7a7a");
        HashSet<String> roomIds = new HashSet<String>();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.weworkRoomList), (Object)"\u6ca1\u6709\u9009\u62e9\u7fa4");
        for (GroupInviteRoomDto it : this.weworkRoomList) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)it.getId()), (Object)"\u6240\u9009\u7fa4ID\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)it.getQrcode()), (Object)"\u672a\u8bbe\u7f6e\u7fa4\u4e8c\u7ef4\u7801");
            Preconditions.checkArgument((!roomIds.contains(it.getId()) ? 1 : 0) != 0, (Object)"\u6240\u9009\u7fa4\u4e0d\u53ef\u91cd\u590d");
            roomIds.add(it.getId());
        }
        Preconditions.checkArgument((this.isAdvanced != null ? 1 : 0) != 0, (Object)"\u662f\u5426\u81ea\u52a8\u8f6c\u4e3a\u624b\u52a8\u7fa4\u53d1\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.isAdvanced == 0 || this.isAdvanced == 1 ? 1 : 0) != 0, (Object)"\u662f\u5426\u81ea\u52a8\u8f6c\u4e3a\u624b\u52a8\u7fa4\u53d1\u53c2\u6570\u4e0d\u5408\u6cd5");
        Preconditions.checkArgument((this.contactFilter != null ? 1 : 0) != 0, (Object)"\u8fc7\u6ee4\u5ba2\u6237\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.contactFilter == 0 || this.contactFilter == 1 ? 1 : 0) != 0, (Object)"\u8fc7\u6ee4\u5ba2\u6237\u53c2\u6570\u4e0d\u5408\u6cd5");
    }

    public String getName() {
        return this.name;
    }

    public MultiSearchContactReq getGroupsendContact() {
        return this.groupsendContact;
    }

    public GroupInviteContentDto getContext() {
        return this.context;
    }

    public List<GroupInviteRoomDto> getWeworkRoomList() {
        return this.weworkRoomList;
    }

    public Integer getIsAdvanced() {
        return this.isAdvanced;
    }

    public Integer getContactFilter() {
        return this.contactFilter;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGroupsendContact(MultiSearchContactReq groupsendContact) {
        this.groupsendContact = groupsendContact;
    }

    public void setContext(GroupInviteContentDto context) {
        this.context = context;
    }

    public void setWeworkRoomList(List<GroupInviteRoomDto> weworkRoomList) {
        this.weworkRoomList = weworkRoomList;
    }

    public void setIsAdvanced(Integer isAdvanced) {
        this.isAdvanced = isAdvanced;
    }

    public void setContactFilter(Integer contactFilter) {
        this.contactFilter = contactFilter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupInviteAddReq)) {
            return false;
        }
        GroupInviteAddReq other = (GroupInviteAddReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$isAdvanced = this.getIsAdvanced();
        Integer other$isAdvanced = other.getIsAdvanced();
        if (this$isAdvanced == null ? other$isAdvanced != null : !((Object)this$isAdvanced).equals(other$isAdvanced)) {
            return false;
        }
        Integer this$contactFilter = this.getContactFilter();
        Integer other$contactFilter = other.getContactFilter();
        if (this$contactFilter == null ? other$contactFilter != null : !((Object)this$contactFilter).equals(other$contactFilter)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        MultiSearchContactReq this$groupsendContact = this.getGroupsendContact();
        MultiSearchContactReq other$groupsendContact = other.getGroupsendContact();
        if (this$groupsendContact == null ? other$groupsendContact != null : !((Object)this$groupsendContact).equals(other$groupsendContact)) {
            return false;
        }
        GroupInviteContentDto this$context = this.getContext();
        GroupInviteContentDto other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        List<GroupInviteRoomDto> this$weworkRoomList = this.getWeworkRoomList();
        List<GroupInviteRoomDto> other$weworkRoomList = other.getWeworkRoomList();
        return !(this$weworkRoomList == null ? other$weworkRoomList != null : !((Object)this$weworkRoomList).equals(other$weworkRoomList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupInviteAddReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $isAdvanced = this.getIsAdvanced();
        result = result * 59 + ($isAdvanced == null ? 43 : ((Object)$isAdvanced).hashCode());
        Integer $contactFilter = this.getContactFilter();
        result = result * 59 + ($contactFilter == null ? 43 : ((Object)$contactFilter).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        MultiSearchContactReq $groupsendContact = this.getGroupsendContact();
        result = result * 59 + ($groupsendContact == null ? 43 : ((Object)$groupsendContact).hashCode());
        GroupInviteContentDto $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        List<GroupInviteRoomDto> $weworkRoomList = this.getWeworkRoomList();
        result = result * 59 + ($weworkRoomList == null ? 43 : ((Object)$weworkRoomList).hashCode());
        return result;
    }

    public String toString() {
        return "GroupInviteAddReq(name=" + this.getName() + ", groupsendContact=" + this.getGroupsendContact() + ", context=" + this.getContext() + ", weworkRoomList=" + this.getWeworkRoomList() + ", isAdvanced=" + this.getIsAdvanced() + ", contactFilter=" + this.getContactFilter() + ")";
    }
}

