/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupsend.utils;

import cn.kinyun.link.common_dto.dto.OpBaseResponse;
import cn.kinyun.link.common_dto.dto.ResponseCodeType;
import com.kuaike.scrm.common.utils.JacksonUtils;
import com.kuaike.scrm.vip.dto.enums.AndroidErrorCode;
import com.kuaike.scrm.vip.dto.enums.WxError;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseErrUtil {
    private static final Logger log = LoggerFactory.getLogger(ResponseErrUtil.class);
    private static Pattern chinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]");

    public static String getRemark(OpBaseResponse opBaseResponse) {
        return ResponseErrUtil.getRemarkWithSpecial(opBaseResponse, null, null);
    }

    public static String getRemarkWithSpecial(OpBaseResponse opBaseResponse, Map<Integer, String> codeRemarkMap, Map<String, String> wxErrRemarkMap) {
        AndroidErrorCode androidErrorCode;
        String remark = "";
        if (opBaseResponse.getCode() == AndroidErrorCode.SUCCESS.getValue()) {
            return remark;
        }
        boolean customerContains = false;
        int code = opBaseResponse.getCode();
        if (opBaseResponse.getWxErr() != null) {
            int errCode = opBaseResponse.getWxErr().getErrCode();
            if (opBaseResponse.getWxErr() != null && errCode != 0) {
                if (MapUtils.isNotEmpty(wxErrRemarkMap)) {
                    String key = StringUtils.join((Object[])new Integer[]{errCode}, (String)"##");
                    customerContains = wxErrRemarkMap.containsKey(key);
                    remark = wxErrRemarkMap.get(key);
                }
                if (customerContains) {
                    return remark;
                }
                if (StringUtils.isEmpty((CharSequence)remark) && StringUtils.isNotBlank((CharSequence)opBaseResponse.getWxErr().getErrMsg()) && !opBaseResponse.getWxErr().getErrMsg().contains("CDATA") && chinesePattern.matcher(opBaseResponse.getWxErr().getErrMsg()).find()) {
                    remark = opBaseResponse.getWxErr().getErrMsg();
                }
                if (StringUtils.isEmpty((CharSequence)remark)) {
                    remark = WxError.getReasonStr((int)errCode);
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)remark) && (androidErrorCode = AndroidErrorCode.getByCode((int)code)) != null) {
            if (MapUtils.isNotEmpty(codeRemarkMap)) {
                customerContains = codeRemarkMap.containsKey(code);
                remark = codeRemarkMap.get(code);
            }
            if (customerContains) {
                return remark;
            }
            if (StringUtils.isEmpty((CharSequence)remark)) {
                remark = androidErrorCode.getDesc();
            }
        }
        if (StringUtils.isEmpty((CharSequence)remark)) {
            if (MapUtils.isNotEmpty(codeRemarkMap)) {
                customerContains = codeRemarkMap.containsKey(code);
                remark = codeRemarkMap.get(code);
            }
            if (customerContains) {
                return remark;
            }
            ResponseCodeType responseCodeType = ResponseCodeType.getInstance((int)code);
            if (responseCodeType != null) {
                if (responseCodeType == ResponseCodeType.ANDROID_PROCESS_ERROR && StringUtils.isNotEmpty((CharSequence)opBaseResponse.getMsg())) {
                    remark = opBaseResponse.getMsg();
                }
                if (responseCodeType == ResponseCodeType.ANDROID_PROCESS_ERROR && StringUtils.isEmpty((CharSequence)remark)) {
                    remark = "\u88ab\u5fae\u4fe1\u9650\u5236\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
                }
                if (StringUtils.isEmpty((CharSequence)remark)) {
                    remark = responseCodeType.getDesc();
                }
            }
        }
        if (!customerContains && StringUtils.isEmpty((CharSequence)remark)) {
            remark = "\u5904\u7406\u5f02\u5e38,\u539f\u56e0\u672a\u77e5";
        }
        return remark;
    }

    public static void main(String[] args) {
        ResponseErrUtil.convertRemark("{\n  \"code\" : 517,\n  \"msg\" : \"\u8d85\u8fc7\u7ec8\u6b62\u65f6\u95f4\",\n  \"cmd\" : 1102,\n  \"cmdStr\" : \"MsgSend\",\n  \"requestId\" : \"d0672ba2-505b-4eae-8b84-21da232cf2cd\",\n  \"body\" : null,\n  \"wxErr\" : {\n    \"errCode\" : 0,\n    \"errMsg\" : null\n  }\n}");
        ResponseErrUtil.convertRemark("{\n  \"code\" : 9999,\n  \"msg\" : \"\",\n  \"cmd\" : 1102,\n  \"cmdStr\" : \"MsgSend\",\n  \"requestId\" : \"be385ecc-e34a-4cf4-b2a0-af9ec7c5306c\",\n  \"body\" : \"\",\n  \"wxErr\" : {\n    \"errCode\" : 20,\n    \"errMsg\" : \"\"\n  }\n}");
        ResponseErrUtil.convertRemark("{\n  \"code\" : 9999,\n  \"msg\" : \"\",\n  \"cmd\" : 1102,\n  \"cmdStr\" : \"MsgSend\",\n  \"requestId\" : \"512c451d-55c6-4bfd-b41d-c705e2ec7a4a\",\n  \"body\" : \"\",\n  \"wxErr\" : {\n    \"errCode\" : 6202,\n    \"errMsg\" : \"\"\n  }\n}");
    }

    private static void convertRemark(String json) {
        try {
            OpBaseResponse opBaseResponse = (OpBaseResponse)JacksonUtils.getInstance().readValue(json, OpBaseResponse.class);
            ResponseErrUtil.getRemark(opBaseResponse);
        }
        catch (IOException e) {
            log.error("getRemark with io error", (Throwable)e);
        }
    }

    public static class LogUnknownWxErr {
        private static final Logger log = LoggerFactory.getLogger(LogUnknownWxErr.class);
        public static ConcurrentHashMap<String, Object> keys = new ConcurrentHashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void contains(OpBaseResponse opBaseResponse) {
            if (opBaseResponse == null || opBaseResponse.getWxErr() == null) {
                return;
            }
            int errCode = opBaseResponse.getWxErr().getErrCode();
            String errMsg = opBaseResponse.getWxErr().getErrMsg();
            String key = StringUtils.join((Object[])new Object[]{errCode, errMsg}, (String)"#");
            boolean needLog = false;
            ConcurrentHashMap<String, Object> concurrentHashMap = keys;
            synchronized (concurrentHashMap) {
                if (keys.contains(key)) {
                    needLog = true;
                    keys.put(key, null);
                }
            }
            if (needLog) {
                LogUnknownWxErr.logMsg(opBaseResponse);
            }
        }

        public static void logMsg(OpBaseResponse opBaseResponse) {
            log.info("{}", (Object)opBaseResponse);
        }
    }
}

