/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupsend.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.dto.jsMsg.UniformMsgDto;
import com.kuaike.scrm.common.enums.GroupSendFkType;
import com.kuaike.scrm.common.enums.GroupSendSource;
import com.kuaike.scrm.common.enums.GroupSendTaskType;
import com.kuaike.scrm.common.enums.QueryType;
import com.kuaike.scrm.common.enums.ReceiveType;
import com.kuaike.scrm.common.enums.SendStatus;
import com.kuaike.scrm.common.enums.TaskStatus;
import com.kuaike.scrm.common.service.dto.SelectedChatroom2WeworkUserDto;
import com.kuaike.scrm.common.service.dto.SelectedContact2WeworkUserDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.JacksonUtils;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTask;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendWework;
import com.kuaike.scrm.dal.groupsend.entity.WeworkTmpStore;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendDetailMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendTaskMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendWeworkMapper;
import com.kuaike.scrm.dal.groupsend.mapper.WeworkTmpStoreMapper;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerInfo;
import com.kuaike.scrm.dal.meeting.entity.MeetingSendDetail;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingSendDetailMapper;
import com.kuaike.scrm.groupsend.dto.request.AddOrModInnerGroupSendReq;
import com.kuaike.scrm.groupsend.dto.request.AddOrModReq;
import com.kuaike.scrm.groupsend.dto.request.UpdateGroupSendReq;
import com.kuaike.scrm.groupsend.dto.response.GroupSendWrapResp;
import com.kuaike.scrm.groupsend.dto.response.MultiSearchChatroomRespDto;
import com.kuaike.scrm.groupsend.dto.response.MultiSearchContactResp;
import com.kuaike.scrm.groupsend.service.GroupSendDetailService;
import com.kuaike.scrm.groupsend.service.GroupSendTaskService;
import com.kuaike.scrm.groupsend.service.GroupSendWrapService;
import com.kuaike.scrm.groupsend.service.MultiSelectService;
import com.kuaike.scrm.groupsend.service.impl.GroupSendServiceImpl;
import com.kuaike.scrm.material.dto.request.AddMaterialReqDto;
import com.kuaike.scrm.material.dto.request.DelMaterialReqDto;
import com.kuaike.scrm.material.dto.request.MaterialReqDto;
import com.kuaike.scrm.material.dto.request.ModMaterialReqDto;
import com.kuaike.scrm.material.service.MaterialManagerService;
import com.kuaike.scrm.remind.dto.req.AddRemindReqDto;
import com.kuaike.scrm.remind.dto.req.ModRemindReqDto;
import com.kuaike.scrm.remind.dto.req.RemindDetailReqDto;
import com.kuaike.scrm.remind.service.RemindService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GroupSendWrapServiceImpl
implements GroupSendWrapService {
    private static final Logger log = LoggerFactory.getLogger(GroupSendWrapServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private MessageGroupSendTaskMapper groupSendTaskMapper;
    @Resource
    private MessageGroupSendDetailMapper messageGroupSendDetailMapper;
    @Autowired
    private GroupSendTaskService groupSendTaskService;
    @Autowired
    private RemindService remindService;
    @Autowired
    private WeworkTmpStoreMapper weworkTmpStoreMapper;
    @Autowired
    private MultiSelectService multiSelectService;
    @Autowired
    private MaterialManagerService materialManagerService;
    @Autowired
    private GroupSendDetailService groupSendDetailService;
    @Autowired
    private MessageGroupSendWeworkMapper grouSendWeworkMapper;
    @Resource
    private MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    @Resource
    private MeetingSendDetailMapper meetingSendDetailMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public GroupSendWrapResp addOrModGroupSend(AddOrModReq req) {
        MessageGroupSendTask task;
        StopWatchDto timer = new StopWatchDto("addOrModGroupSend", true, log);
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("addOrModGroupSend with req={},operatorId={}", (Object)req, (Object)currentUserInfo.getId());
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        req.validate();
        int sendCount = 0;
        ArrayList remindDetailReqDtos = Lists.newArrayList();
        AtomicReference<String> requestIdStore = new AtomicReference<String>();
        timer.start("buildRemindDetailReqDtos");
        if (req.getTaskType().intValue() == GroupSendTaskType.CLIENT.getValue() || req.getTaskType().intValue() == GroupSendTaskType.QYAPI.getValue() && req.getQueryType().equals(QueryType.CHAT_ROOM.getType())) {
            sendCount = req.getWeworkUserNums().size();
            for (String weworkUserNum : req.getWeworkUserNums()) {
                if (!CollectionUtils.isNotEmpty(req.getRemindDates())) continue;
                for (Date remindDate : req.getRemindDates()) {
                    RemindDetailReqDto remindDetailReqDto = null;
                    remindDetailReqDto = req.getQueryType().equals(QueryType.CHAT_ROOM.getType()) ? new RemindDetailReqDto(weworkUserNum, remindDate, null, Integer.valueOf(2)) : new RemindDetailReqDto(weworkUserNum, remindDate, null, Integer.valueOf(1));
                    remindDetailReqDtos.add(remindDetailReqDto);
                }
            }
        } else {
            sendCount = this.buildRemindDetailReqDtos(req, currentUserInfo, remindDetailReqDtos, requestIdStore);
        }
        if (Objects.nonNull(req.getNotUpdateTaskStatus()) && req.getNotUpdateTaskStatus().booleanValue() && Objects.nonNull(req.getFkType()) && GroupSendFkType.UN_ARRIVE_MEETING.getType() == req.getFkType().intValue()) {
            log.info("\u76f4\u64ad\u95f4\u521b\u5efa\u7fa4\u53d1\u64cd\u4f5c\uff0c\u9884\u5148\u7fa4\u53d1\u4efb\u52a1\u672a0:meetingId:{},param:{}", (Object)req.getFkTaskId(), (Object)req.getGroupsendContact());
            sendCount = 0;
        }
        timer.stop();
        if (GroupSendTaskType.vipGroupSend.contains(req.getTaskType())) {
            Preconditions.checkArgument((sendCount > 0 ? 1 : 0) != 0, (Object)"\u53d1\u9001\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u53d6\u6d88\u7fa4\u53d1");
        }
        int opType = 1;
        boolean haveDetail = false;
        if (StringUtils.isBlank((CharSequence)req.getTaskNum())) {
            log.info("addGroupSend task taskName={}", (Object)req.getTaskName());
            timer.start("buildTask");
            task = this.buildTask(req, currentUserInfo, bizId, corpId, sendCount, requestIdStore);
            this.groupSendTaskMapper.insertSelective((Object)task);
            timer.stop();
            if (!GroupSendTaskType.vipGroupSend.contains(req.getTaskType())) {
                if (task.getSendTime().before(new Date())) {
                    haveDetail = true;
                    timer.start("generateGroupSendDetailAndUpdate");
                    this.groupSendTaskService.generateGroupSendDetailAndUpdate(task, req);
                    timer.stop();
                }
            } else {
                timer.start("generateGroupSendDetailAndUpdate");
                this.groupSendTaskService.generateGroupSendDetailAndUpdate(task, req);
                timer.stop();
            }
            timer.start("addRemind");
            this.addRemind(req, currentUserInfo, remindDetailReqDtos, task);
            timer.stop();
            timer.start("addTaskMaterial");
            this.addTaskMaterial(req.getContentList(), task);
            timer.stop();
            opType = 1;
        } else {
            timer.start("queryByTaskNum");
            task = this.groupSendTaskMapper.queryByTaskNum(req.getTaskNum());
            timer.stop();
            if (task == null || task.getIsDeleted() == 1) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u4e0d\u5b58\u5728\u4e0d\u80fd\u4fee\u6539");
            }
            log.info("modGroupSend task taskId={},taskNum={}", (Object)task.getId(), (Object)task.getNum());
            this.validateTaskStatus(req, task);
            String contentJson = null;
            String paramsJson = null;
            try {
                paramsJson = JSON.toJSONString((Object)req);
                contentJson = JSON.toJSONString(req.getContentList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (task.getParamsJson().equals(paramsJson)) {
                log.info("mod groupsend with not param change,taskId={}", (Object)task.getNum());
                timer.print();
                return new GroupSendWrapResp(task, null, false, req.getSource() != null && req.getSource().equals(GroupSendSource.MEETING_SERVICE.getType()));
            }
            if (Objects.equals(task.getContent(), contentJson) || !Objects.equals(task.getSendTime(), req.getSendTime()) || !Objects.equals(task.getDeadline(), req.getDeadlineTime())) {
                timer.start("updateTaskMaterial");
                this.updateTaskMaterial(req, task);
                timer.stop();
            }
            task.setParamsJson(paramsJson);
            task.setContent(contentJson);
            task.setName(req.getTaskName());
            task.setAutoChangeTaskType(req.getAutoChangeTaskType());
            task.setSendTime(req.getSendTime());
            task.setSendType(req.getSendType());
            task.setTimeoutGap(req.getChangeTimeoutGap());
            task.setFkTaskId(req.getFkTaskId());
            task.setFkType(req.getFkType());
            task.setDeadline(req.getDeadlineTime());
            task.setUpdateBy(currentUserInfo.getId());
            task.setQueryRequestId(requestIdStore.get());
            Date now = new Date();
            switch (GroupSendTaskType.getType((int)req.getTaskType())) {
                case SIDEBAR: 
                case CLIENT: {
                    haveDetail = this.updateDetail(req, timer, currentUserInfo, sendCount, requestIdStore, task, haveDetail, now);
                    break;
                }
                case QYAPI: {
                    if (now.after(req.getSendTime()) && now.before(req.getDeadlineTime())) {
                        this.groupSendDetailService.updateDetail(req, task, currentUserInfo);
                        this.groupSendTaskService.updateGroupSendTask(task, sendCount, null);
                        break;
                    }
                    this.groupSendTaskService.updateGroupSendTask(task, sendCount, null);
                }
            }
            opType = 2;
            if (!req.getFkType().equals(GroupSendFkType.MEETING.getType()) && StringUtils.isNotBlank((CharSequence)req.getRemind()) && CollectionUtils.isNotEmpty(req.getRemindDates())) {
                timer.start("modRemind");
                ModRemindReqDto reqDto = new ModRemindReqDto(Integer.valueOf(2), req.getRemindType(), req.getRemind(), task.getId(), currentUserInfo.getId(), Integer.valueOf(0), (List)remindDetailReqDtos);
                this.remindService.modRemind(reqDto);
                timer.stop();
            }
        }
        timer.start("buildGroupSendWework");
        this.buildGroupSendWework(currentUserInfo, bizId, corpId, remindDetailReqDtos, task);
        timer.stop();
        timer.print();
        return new GroupSendWrapResp(task, opType, haveDetail, req.getSource() != null && req.getSource().equals(GroupSendSource.MEETING_SERVICE.getType()));
    }

    private void buildGroupSendWework(CurrentUserInfo currentUserInfo, Long bizId, String corpId, List<RemindDetailReqDto> remindDetailReqDtos, MessageGroupSendTask task) {
        Set weworkUserNums = remindDetailReqDtos.stream().map(a -> a.getWeworkUserNum()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(weworkUserNums)) {
            return;
        }
        ArrayList sendWeworks = Lists.newArrayList();
        for (String weworkUserNum : weworkUserNums) {
            MessageGroupSendWework item = new MessageGroupSendWework();
            item.setBizId(bizId);
            item.setCorpId(corpId);
            item.setSendTime(task.getSendTime());
            item.setCreateBy(currentUserInfo.getId());
            item.setCreateTime(new Date());
            item.setSendWeworkNum(weworkUserNum);
            item.setDeadline(task.getDeadline());
            item.setIsDeleted(Integer.valueOf(0));
            item.setTaskId(task.getId());
            item.setUpdateBy(currentUserInfo.getId());
            item.setUpdateTime(new Date());
            sendWeworks.add(item);
        }
        this.grouSendWeworkMapper.deleteByTaskId(task.getId());
        this.grouSendWeworkMapper.batchInsert((Collection)sendWeworks);
    }

    private boolean updateDetail(AddOrModReq req, StopWatchDto timer, CurrentUserInfo currentUserInfo, int sendCount, AtomicReference<String> requestIdStore, MessageGroupSendTask task, boolean haveDetail, Date now) {
        Integer sendStatus = null;
        if (now.after(req.getSendTime()) && now.before(req.getDeadlineTime())) {
            if (task.getSendStatus().equals(SendStatus.SENDING.getValue())) {
                sendStatus = SendStatus.SENDING.getValue();
                timer.start("updateDetail");
                this.groupSendDetailService.updateDetail(req, task, currentUserInfo);
                timer.stop();
                haveDetail = true;
            } else {
                sendStatus = SendStatus.SENDING.getValue();
                this.groupSendTaskService.generateGroupSendDetailAndUpdate(task, req);
            }
        } else if (now.before(req.getSendTime())) {
            sendStatus = SendStatus.TO_BE_QUERY.getValue();
            timer.start("deleteDetails");
            this.groupSendDetailService.deleteDetails(task.getId(), currentUserInfo);
            timer.stop();
            haveDetail = true;
        }
        task.setSendCount(Integer.valueOf(sendCount));
        task.setQueryRequestId(requestIdStore.get());
        task.setSendStatus(sendStatus);
        timer.start("updateGroupSend");
        this.groupSendTaskService.updateGroupSend(req, task, currentUserInfo.getId());
        timer.stop();
        return haveDetail;
    }

    private MessageGroupSendTask buildTask(AddOrModReq req, CurrentUserInfo currentUserInfo, Long bizId, String corpId, Integer sendCount, AtomicReference<String> requestIdStore) {
        String newTaskNum = this.idGen.getNum();
        Date now = new Date();
        MessageGroupSendTask task = new MessageGroupSendTask();
        task.setBizId(bizId);
        task.setCorpId(corpId);
        task.setNum(newTaskNum);
        task.setFkType(req.getFkType());
        task.setFkTaskId(req.getFkTaskId());
        task.setCreateBy(currentUserInfo.getId());
        task.setCreateTime(now);
        task.setUpdateBy(currentUserInfo.getId());
        task.setUpdateTime(now);
        task.setDeadline(req.getDeadlineTime());
        task.setSendTime(req.getSendTime());
        task.setIsDeleted(Integer.valueOf(0));
        task.setSendType(req.getSendType());
        task.setQueryType(req.getQueryType());
        task.setSendCount(sendCount);
        task.setTaskStatus(TaskStatus.NORMAL.getValue());
        if (!GroupSendTaskType.vipGroupSend.contains(req.getTaskType())) {
            task.setSendStatus(Integer.valueOf(SendStatus.TO_BE_QUERY.getValue()));
        } else {
            task.setSendStatus(Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
        }
        task.setName(req.getTaskName());
        task.setQueryRequestId(requestIdStore.get());
        task.setTaskType(req.getTaskType());
        task.setAutoChangeTaskType(req.getAutoChangeTaskType());
        task.setTimeoutGap(req.getChangeTimeoutGap());
        task.setContent(JSON.toJSONString(req.getContentList()));
        task.setParamsJson(JSON.toJSONString((Object)req));
        return task;
    }

    @Override
    public int buildRemindDetailReqDtos(AddOrModReq req, CurrentUserInfo currentUserInfo, List<RemindDetailReqDto> remindDetailReqDtos, AtomicReference<String> requestIdStore) {
        int sendCount;
        if (req.getQueryType().intValue() == QueryType.CHAT_ROOM.getType()) {
            List<SelectedChatroom2WeworkUserDto> chatroomList = null;
            String requestId = null;
            if (Objects.nonNull(req.getGroupsendChatRoom())) {
                requestId = req.getGroupsendChatRoom().getRequestId();
            }
            boolean queryCache = false;
            WeworkTmpStore weworkTmpStore = null;
            if (StringUtils.isNotBlank((CharSequence)requestId) && (weworkTmpStore = this.weworkTmpStoreMapper.queryByRequestId(requestId)) != null) {
                queryCache = true;
            }
            if (!queryCache) {
                MultiSearchChatroomRespDto multiSearchChatroom = this.multiSelectService.multiSearchChatroom(req.getGroupsendChatRoom(), true);
                chatroomList = multiSearchChatroom.getList();
                requestId = multiSearchChatroom.getRequestId();
            } else {
                chatroomList = JSONArray.parseArray((String)weworkTmpStore.getStoreBody(), SelectedChatroom2WeworkUserDto.class);
            }
            sendCount = chatroomList.size();
            if (CollectionUtils.isNotEmpty(chatroomList) && CollectionUtils.isNotEmpty(req.getRemindDates()) && StringUtils.isNotBlank((CharSequence)req.getRemind())) {
                Map<String, List<SelectedChatroom2WeworkUserDto>> weworkNum2List = chatroomList.stream().collect(Collectors.groupingBy(a -> a.getWeworkNum()));
                weworkNum2List.entrySet().stream().forEach(item -> {
                    String weworkUserNum = (String)item.getKey();
                    String chatroomId = ((SelectedChatroom2WeworkUserDto)((List)item.getValue()).stream().findFirst().get()).getChatroomId();
                    for (Date remindDate : req.getRemindDates()) {
                        RemindDetailReqDto remindDetailReqDto = new RemindDetailReqDto(weworkUserNum, remindDate, chatroomId, Integer.valueOf(2));
                        remindDetailReqDtos.add(remindDetailReqDto);
                    }
                });
            }
            requestIdStore.set(requestId);
        } else {
            List<SelectedContact2WeworkUserDto> contactList = null;
            String requestId = null;
            if (req.getQueryType().equals(QueryType.CONTACT.getType())) {
                if (Objects.nonNull(req.getGroupsendContact())) {
                    requestId = req.getGroupsendContact().getRequestId();
                }
            } else if (Objects.nonNull(req.getGroupsendQrCodeContact())) {
                requestId = req.getGroupsendQrCodeContact().getRequestId();
            }
            boolean queryCache = false;
            WeworkTmpStore weworkTmpStore = null;
            if (StringUtils.isNotBlank((CharSequence)requestId) && (weworkTmpStore = this.weworkTmpStoreMapper.queryByRequestId(requestId)) != null) {
                queryCache = true;
            }
            if (!queryCache) {
                MultiSearchContactResp multiSearchContact = null;
                multiSearchContact = req.getQueryType().equals(QueryType.CONTACT.getType()) ? this.multiSelectService.multiSearchContact(req.getGroupsendContact(), true) : this.multiSelectService.multiSearchQrcode(req.getGroupsendQrCodeContact(), true);
                contactList = multiSearchContact.getList();
                requestId = multiSearchContact.getRequestId();
            } else {
                contactList = JSONArray.parseArray((String)weworkTmpStore.getStoreBody(), SelectedContact2WeworkUserDto.class);
            }
            sendCount = contactList.size();
            if (CollectionUtils.isNotEmpty((Collection)contactList) && CollectionUtils.isNotEmpty(req.getRemindDates()) && StringUtils.isNotBlank((CharSequence)req.getRemind())) {
                Map<String, List<SelectedContact2WeworkUserDto>> weworkNum2List = contactList.stream().collect(Collectors.groupingBy(a -> a.getWeworkNum()));
                weworkNum2List.entrySet().stream().forEach(item -> {
                    String weworkUserNum = (String)item.getKey();
                    String contactId = ((SelectedContact2WeworkUserDto)((List)item.getValue()).stream().findFirst().get()).getContactId();
                    for (Date remindDate : req.getRemindDates()) {
                        RemindDetailReqDto remindDetailReqDto = new RemindDetailReqDto(weworkUserNum, remindDate, contactId, Integer.valueOf(1));
                        remindDetailReqDtos.add(remindDetailReqDto);
                    }
                });
            }
            requestIdStore.set(requestId);
        }
        return sendCount;
    }

    public void validateTaskStatus(AddOrModReq req, MessageGroupSendTask task) {
        if (task == null || task.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u4e0d\u5b58\u5728\u4e0d\u80fd\u4fee\u6539");
        }
        if (task.getFkType().intValue() == GroupSendFkType.MEETING.getType()) {
            Preconditions.checkArgument((boolean)task.getFkType().equals(req.getFkType()), (Object)"\u4f1a\u8bae\u4efb\u52a1\u4e0d\u53ef\u4fee\u6539\u4e3a\u5176\u4ed6\u4efb\u52a1");
            Preconditions.checkArgument((boolean)task.getFkTaskId().equals(req.getFkTaskId()), (Object)"\u4f1a\u8bae\u4efb\u52a1\u4e0d\u53ef\u6362\u7ed1");
        }
        if (task.getFkType() != 0) {
            Preconditions.checkArgument((boolean)Objects.equals(req.getFkType(), task.getFkType()), (Object)"\u7fa4\u53d1\u4efb\u52a1\u4e0d\u53ef\u4fee\u6539\u4e3a\u5176\u4ed6\u5173\u8054\u7c7b\u578b");
            Preconditions.checkArgument((boolean)Objects.equals(req.getFkTaskId(), task.getFkTaskId()), (Object)"\u7fa4\u53d1\u4efb\u52a1\u5173\u8054\u4efb\u52a1\u4e0d\u53ef\u4fee\u6539\u4e3a\u5176\u4ed6\u5173\u8054\u4efb\u52a1");
        }
        if (GroupSendFkType.MEETING.getType() == task.getFkType().intValue()) {
            Preconditions.checkArgument((req.getQueryType().equals(QueryType.CONTACT.getType()) || req.getQueryType().equals(QueryType.QRCODE.getType()) ? 1 : 0) != 0, (Object)"\u4f1a\u8bae\u7c7b\u578b\u4e0d\u652f\u6301\u9009\u7fa4");
            if (GroupSendSource.WEB.getType() == req.getSource().intValue()) {
                List contentList = JSONArray.parseArray((String)task.getContent(), UniformMsgDto.class);
                Preconditions.checkArgument((boolean)Objects.equals(req.getContentList(), contentList), (Object)"\u4f1a\u8bae\u7c7b\u578b\u7fa4\u53d1,\u5185\u5bb9\u4e0d\u80fd\u4fee\u6539");
            }
        }
        if (task.getTaskType().equals(GroupSendTaskType.QYAPI.getValue())) {
            if (task.getTaskStatus().equals(TaskStatus.NORMAL.getValue())) {
                Preconditions.checkArgument((task.getSendStatus() < SendStatus.SENDING.getValue() && task.getSendTime().after(new Date()) ? 1 : 0) != 0, (Object)"\u7cfb\u7edf\u7fa4\u53d1\u5728\u542f\u52a8\u540e\u4e0d\u53ef\u4fee\u6539");
            } else {
                Preconditions.checkArgument((task.getSendStatus() < SendStatus.SENDING.getValue() ? 1 : 0) != 0, (Object)"\u7cfb\u7edf\u7fa4\u53d1\u5728\u7981\u7528\u72b6\u6001\u4e0b\u4e0d\u80fd\u4fee\u6539\u4e0d\u5728\u5f85\u53d1\u9001\u7684\u4efb\u52a1");
            }
        }
        if (task.getSendStatus().intValue() == SendStatus.ALREADY_SEND.getValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u5df2\u7ecf\u53d1\u9001\u6210\u529f\u4e0d\u53ef\u66f4\u65b0");
        }
    }

    public void validateTaskStatus2(AddOrModInnerGroupSendReq req, MessageGroupSendTask task) {
        if (task == null || task.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u4e0d\u5b58\u5728\u4e0d\u80fd\u4fee\u6539");
        }
        Preconditions.checkArgument((boolean)req.getFkType().equals(task.getFkType()), (Object)"\u7fa4\u53d1\u4efb\u52a1\u4e0d\u53ef\u4fee\u6539\u4e3a\u5176\u4ed6\u5173\u8054\u7c7b\u578b");
        Preconditions.checkArgument((boolean)req.getFkTaskId().equals(task.getFkTaskId()), (Object)"\u7fa4\u53d1\u4efb\u52a1\u5173\u8054\u4efb\u52a1\u4e0d\u53ef\u4fee\u6539\u4e3a\u5176\u4ed6\u5173\u8054\u4efb\u52a1");
        if (task.getFkType().intValue() == GroupSendFkType.MEETING.getType()) {
            Preconditions.checkArgument((boolean)task.getFkType().equals(req.getFkType()), (Object)"\u4f1a\u8bae\u4efb\u52a1\u4e0d\u53ef\u4fee\u6539\u4e3a\u5176\u4ed6\u4efb\u52a1");
            Preconditions.checkArgument((boolean)task.getFkTaskId().equals(req.getFkTaskId()), (Object)"\u4f1a\u8bae\u4efb\u52a1\u4e0d\u53ef\u6362\u7ed1");
        }
        if (task.getTaskType().equals(GroupSendTaskType.QYAPI.getValue())) {
            Preconditions.checkArgument((task.getSendStatus() < SendStatus.SENDING.getValue() && task.getSendTime().after(new Date()) ? 1 : 0) != 0, (Object)"\u7cfb\u7edf\u7fa4\u53d1\u5728\u542f\u52a8\u540e\u4e0d\u53ef\u4fee\u6539");
        }
        if (task.getSendStatus().intValue() == SendStatus.ALREADY_SEND.getValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u5df2\u7ecf\u53d1\u9001\u6210\u529f\u4e0d\u53ef\u66f4\u65b0");
        }
    }

    private void addRemind(AddOrModReq req, CurrentUserInfo currentUserInfo, List<RemindDetailReqDto> remindDetailReqDtos, MessageGroupSendTask task) {
        if (req.getFkType().equals(GroupSendFkType.MEETING.getType())) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)req.getRemind()) && CollectionUtils.isNotEmpty(req.getRemindDates()) && CollectionUtils.isNotEmpty(remindDetailReqDtos)) {
            AddRemindReqDto addRemindReqDto = new AddRemindReqDto(currentUserInfo.getId(), currentUserInfo.getBizId(), currentUserInfo.getCorpId(), Integer.valueOf(2), req.getRemindType(), req.getRemind(), task.getId(), currentUserInfo.getId(), Integer.valueOf(0), remindDetailReqDtos);
            this.remindService.addRemind(addRemindReqDto);
        }
    }

    private void addRemind2(AddOrModInnerGroupSendReq req, CurrentUserInfo currentUserInfo, List<RemindDetailReqDto> remindDetailReqDtos, MessageGroupSendTask task) {
        if (req.getFkType().equals(GroupSendFkType.MEETING.getType())) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)req.getRemind()) && CollectionUtils.isNotEmpty(req.getRemindDates()) && CollectionUtils.isNotEmpty(remindDetailReqDtos)) {
            AddRemindReqDto addRemindReqDto = new AddRemindReqDto(currentUserInfo.getId(), currentUserInfo.getBizId(), currentUserInfo.getCorpId(), Integer.valueOf(2), req.getRemindType(), req.getRemind(), task.getId(), currentUserInfo.getId(), Integer.valueOf(0), remindDetailReqDtos);
            this.remindService.addRemind(addRemindReqDto);
        }
    }

    private void addTaskMaterial(List<UniformMsgDto> contentList, MessageGroupSendTask task) {
        if (GroupSendServiceImpl.vipGroupSend.contains(task.getTaskType())) {
            return;
        }
        List materialReqDtos = contentList.stream().filter(a -> a.getFile() != null && StringUtils.isNotBlank((CharSequence)a.getFile().getFileUrl()) || a.getMiniprogram() != null && StringUtils.isNotBlank((CharSequence)a.getMiniprogram().getImgUrl())).map(a -> {
            MaterialReqDto materialReqDto = new MaterialReqDto();
            if (a.getFile() != null && StringUtils.isNotBlank((CharSequence)a.getFile().getFileUrl())) {
                materialReqDto.setType(a.getMsgType());
                materialReqDto.setFileUrl(a.getFile().getFileUrl());
                materialReqDto.setFileName(a.getFile().getFileName());
            } else {
                materialReqDto.setType("image");
                materialReqDto.setFileUrl(a.getMiniprogram().getImgUrl());
                materialReqDto.setFileName("");
            }
            return materialReqDto;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(materialReqDtos)) {
            AddMaterialReqDto addMaterialReqDto = new AddMaterialReqDto();
            addMaterialReqDto.setFkId(task.getId());
            addMaterialReqDto.setFkType(Integer.valueOf(1));
            addMaterialReqDto.setStartTime(task.getSendTime());
            addMaterialReqDto.setEndTime(task.getDeadline() != null ? task.getDeadline() : DateUtils.addDays((Date)task.getSendTime(), (int)5));
            addMaterialReqDto.setMaterialReqDtoList(materialReqDtos);
            this.materialManagerService.add(addMaterialReqDto);
        }
    }

    private void updateTaskMaterial(AddOrModReq req, MessageGroupSendTask task) {
        if (GroupSendServiceImpl.vipGroupSend.contains(task.getTaskType())) {
            return;
        }
        List oldContentList = JSONArray.parseArray((String)task.getContent(), UniformMsgDto.class);
        List oldUrls = oldContentList.stream().filter(a -> a.getFile() != null && StringUtils.isNotBlank((CharSequence)a.getFile().getFileUrl())).map(a -> {
            MaterialReqDto materialReqDto = new MaterialReqDto();
            materialReqDto.setType(a.getMsgType());
            materialReqDto.setFileUrl(a.getFile().getFileUrl());
            materialReqDto.setFileName(a.getFile().getFileName());
            return materialReqDto;
        }).collect(Collectors.toList());
        List newUrls = req.getContentList().stream().filter(a -> a.getFile() != null && StringUtils.isNotBlank((CharSequence)a.getFile().getFileUrl())).map(a -> {
            MaterialReqDto materialReqDto = new MaterialReqDto();
            materialReqDto.setType(a.getMsgType());
            materialReqDto.setFileUrl(a.getFile().getFileUrl());
            materialReqDto.setFileName(a.getFile().getFileName());
            return materialReqDto;
        }).collect(Collectors.toList());
        Collection needDelMaterials = CollectionUtils.subtract(oldUrls, newUrls);
        Collection needAddMaterials = CollectionUtils.subtract(newUrls, oldUrls);
        Collection needModMaterials = null;
        if (!task.getSendTime().equals(req.getSendTime()) || !task.getDeadline().equals(req.getDeadlineTime())) {
            needModMaterials = CollectionUtils.intersection(oldUrls, newUrls);
        }
        if (CollectionUtils.isNotEmpty((Collection)needDelMaterials)) {
            DelMaterialReqDto reqDto = new DelMaterialReqDto();
            reqDto.setFkId(task.getId());
            reqDto.setFkType(Integer.valueOf(1));
            reqDto.setMaterialReqDtoList((List)Lists.newArrayList((Iterable)needDelMaterials));
            this.materialManagerService.delete(reqDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)needModMaterials)) {
            ModMaterialReqDto modMaterialReqDto = new ModMaterialReqDto();
            modMaterialReqDto.setFkId(task.getFkTaskId());
            modMaterialReqDto.setFkType(task.getFkType());
            modMaterialReqDto.setEndTime(req.getDeadlineTime() != null ? req.getDeadlineTime() : DateUtils.addDays((Date)req.getSendTime(), (int)5));
            modMaterialReqDto.setStartTime(req.getSendTime());
            this.materialManagerService.mod(modMaterialReqDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)needAddMaterials)) {
            AddMaterialReqDto addMaterialReqDto = new AddMaterialReqDto();
            addMaterialReqDto.setFkId(task.getId());
            addMaterialReqDto.setFkType(Integer.valueOf(1));
            addMaterialReqDto.setStartTime(req.getSendTime());
            addMaterialReqDto.setEndTime(req.getDeadlineTime() != null ? req.getDeadlineTime() : DateUtils.addDays((Date)req.getSendTime(), (int)5));
            addMaterialReqDto.setMaterialReqDtoList((List)Lists.newArrayList((Iterable)needAddMaterials));
            this.materialManagerService.add(addMaterialReqDto);
        }
    }

    private void updateTaskMaterial2(AddOrModInnerGroupSendReq req, MessageGroupSendTask task) {
        List oldContentList = JSONArray.parseArray((String)task.getContent(), UniformMsgDto.class);
        List oldUrls = oldContentList.stream().filter(a -> a.getFile() != null && StringUtils.isNotBlank((CharSequence)a.getFile().getFileUrl())).map(a -> {
            MaterialReqDto materialReqDto = new MaterialReqDto();
            materialReqDto.setType(a.getMsgType());
            materialReqDto.setFileUrl(a.getFile().getFileUrl());
            materialReqDto.setFileName(a.getFile().getFileName());
            return materialReqDto;
        }).collect(Collectors.toList());
        List newUrls = req.getContentList().stream().filter(a -> a.getFile() != null && StringUtils.isNotBlank((CharSequence)a.getFile().getFileUrl())).map(a -> {
            MaterialReqDto materialReqDto = new MaterialReqDto();
            materialReqDto.setType(a.getMsgType());
            materialReqDto.setFileUrl(a.getFile().getFileUrl());
            materialReqDto.setFileName(a.getFile().getFileName());
            return materialReqDto;
        }).collect(Collectors.toList());
        Collection needDelMaterials = CollectionUtils.subtract(oldUrls, newUrls);
        Collection needAddMaterials = CollectionUtils.subtract(newUrls, oldUrls);
        Collection needModMaterials = null;
        if (!task.getSendTime().equals(req.getSendTime()) || !task.getDeadline().equals(req.getDeadlineTime())) {
            needModMaterials = CollectionUtils.intersection(oldUrls, newUrls);
        }
        if (CollectionUtils.isNotEmpty((Collection)needDelMaterials)) {
            DelMaterialReqDto reqDto = new DelMaterialReqDto();
            reqDto.setFkId(task.getId());
            reqDto.setFkType(Integer.valueOf(1));
            reqDto.setMaterialReqDtoList((List)Lists.newArrayList((Iterable)needDelMaterials));
            this.materialManagerService.delete(reqDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)needModMaterials)) {
            ModMaterialReqDto modMaterialReqDto = new ModMaterialReqDto();
            modMaterialReqDto.setFkId(task.getFkTaskId());
            modMaterialReqDto.setFkType(task.getFkType());
            modMaterialReqDto.setEndTime(req.getDeadlineTime() != null ? req.getDeadlineTime() : DateUtils.addDays((Date)req.getSendTime(), (int)5));
            modMaterialReqDto.setStartTime(req.getSendTime());
            this.materialManagerService.mod(modMaterialReqDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)needAddMaterials)) {
            AddMaterialReqDto addMaterialReqDto = new AddMaterialReqDto();
            addMaterialReqDto.setFkId(task.getId());
            addMaterialReqDto.setFkType(Integer.valueOf(1));
            addMaterialReqDto.setStartTime(req.getSendTime());
            addMaterialReqDto.setEndTime(req.getDeadlineTime() != null ? req.getDeadlineTime() : DateUtils.addDays((Date)req.getSendTime(), (int)5));
            addMaterialReqDto.setMaterialReqDtoList((List)Lists.newArrayList((Iterable)needAddMaterials));
            this.materialManagerService.add(addMaterialReqDto);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public GroupSendWrapResp updateWithOutParam(UpdateGroupSendReq req) {
        log.info("updateWithOutParam with req={}", (Object)req);
        req.validate();
        MessageGroupSendTask task = this.groupSendTaskMapper.queryByTaskNum(req.getTaskNum());
        if (task == null || task.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7fa4\u53d1\u4efb\u52a1\u4e0d\u5b58\u5728\u65e0\u6cd5\u4fee\u6539");
        }
        if (task.getSendStatus().equals(SendStatus.ALREADY_SEND.getValue())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7fa4\u53d1\u4efb\u52a1\u5df2\u7ed3\u675f\u65e0\u6cd5\u4fee\u6539");
        }
        if (!task.getFkTaskId().equals(req.getFkId()) || !task.getFkType().equals(req.getFkType())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7fa4\u53d1\u4efb\u52a1\u548c\u5916\u952e\u7c7b\u578b\u65e0\u6cd5\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        AddOrModReq addOrModReq = null;
        try {
            addOrModReq = (AddOrModReq)JacksonUtils.getInstance().readValue(task.getParamsJson(), AddOrModReq.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (addOrModReq.getDeadlineTime() != null) {
            addOrModReq.setDeadlineTime(req.getDeadline());
            task.setDeadline(req.getDeadline());
        }
        if (CollectionUtils.isNotEmpty(req.getContents())) {
            addOrModReq.setContentList(req.getContents());
            String contentStr = null;
            try {
                contentStr = JacksonUtils.getInstance().writeValueAsString(req.getContents());
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            task.setContent(contentStr);
        }
        String paramJson = null;
        try {
            paramJson = JacksonUtils.getInstance().writeValueAsString((Object)addOrModReq);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        task.setParamsJson(paramJson);
        task.setUpdateTime(new Date());
        task.setUpdateBy(req.getOperatorId());
        this.groupSendTaskMapper.updateByPrimaryKeySelective((Object)task);
        return new GroupSendWrapResp(task, 2, false, req.getSource() != null && req.getSource().equals(GroupSendSource.MEETING_SERVICE.getType()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public GroupSendWrapResp warpGenerateDetail(MessageGroupSendTask task, Date now) {
        AddOrModReq req = null;
        try {
            req = (AddOrModReq)JacksonUtils.getInstance().readValue(task.getParamsJson(), AddOrModReq.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (GroupSendFkType.UN_ARRIVE_MEETING.getType() == task.getFkType().intValue() && Objects.nonNull(req)) {
            if (now.after(task.getSendTime()) && now.before(task.getDeadline())) {
                return this.buildUnArriveReq(req, task);
            }
            if (now.after(task.getDeadline())) {
                this.groupSendTaskService.updateGroupSendTask(task, task.getSendCount(), SendStatus.ALREADY_SEND.getValue());
                return new GroupSendWrapResp(task, 2, false, req.getSource() != null && req.getSource().equals(GroupSendSource.MEETING_SERVICE.getType()));
            }
        }
        return this.groupSendTaskService.generateGroupSendDetailAndUpdate(task, req);
    }

    private GroupSendWrapResp buildUnArriveReq(AddOrModReq req, MessageGroupSendTask task) {
        Long meetingId = task.getFkTaskId();
        if (Objects.isNull(meetingId)) {
            log.error("\u3010\u76f4\u64ad\u95f4\u7fa4\u53d1\u3011: \u6ca1\u6709\u76f4\u64ad\u95f4id \uff1ataskId: {},", (Object)task.getId());
            this.groupSendTaskService.updateGroupSendTask(task, 0, SendStatus.ALREADY_SEND.getValue());
            return new GroupSendWrapResp(task, 2, false, req.getSource() != null && req.getSource().equals(GroupSendSource.MEETING_SERVICE.getType()));
        }
        List meetingSendDetails = this.meetingSendDetailMapper.queryRemindByMeetingIds(task.getBizId(), (Collection)Lists.newArrayList((Object[])new Long[]{meetingId}));
        if (CollectionUtils.isEmpty((Collection)meetingSendDetails)) {
            log.error("\u3010\u76f4\u64ad\u95f4\u7fa4\u53d1\u3011: MeetingSendDetail isNull \uff1ataskId: {},", (Object)task.getId());
            return null;
        }
        Set shouSendNoArriveGroupSend = meetingSendDetails.stream().map(MeetingSendDetail::getContactId).collect(Collectors.toSet());
        Map<String, List<MeetingSendDetail>> groupByContactIds = meetingSendDetails.stream().filter(item -> Objects.nonNull(item.getContactId())).collect(Collectors.groupingBy(MeetingSendDetail::getContactId));
        log.info("\u3010\u76f4\u64ad\u95f4\u7fa4\u53d1\u3011taskId:{},shouldSendNoArriveContactId:{}", (Object)task.getId(), (Object)JSON.toJSONString(shouSendNoArriveGroupSend));
        List meetingCustomerInfos = this.meetingCustomerInfoMapper.queryMeetingCustomerByMeetingId(task.getBizId(), task.getFkTaskId());
        log.info("\u3010\u76f4\u64ad\u95f4\u7fa4\u53d1\u3011taskId:{},meetingCustomerInfos:{}", (Object)task.getId(), (Object)JSON.toJSONString((Object)meetingCustomerInfos));
        if (CollectionUtils.isNotEmpty((Collection)meetingCustomerInfos)) {
            Set arriveMeetingContactId = meetingCustomerInfos.stream().filter(customerInfo -> customerInfo.getArrivalTime() != null && StringUtils.isNotBlank((CharSequence)customerInfo.getContactId())).map(MeetingCustomerInfo::getContactId).collect(Collectors.toSet());
            log.info("\u3010\u76f4\u64ad\u95f4\u7fa4\u53d1\u3011\u76f4\u64ad\u95f4\u5df2\u5230\u8bfe\u7528\u6237contactId \u4e3a\uff1a{}", (Object)JSON.toJSONString(arriveMeetingContactId));
            shouSendNoArriveGroupSend.removeAll(arriveMeetingContactId);
        }
        ArrayList weworkUserDtos = Lists.newArrayList();
        for (String contactId : shouSendNoArriveGroupSend) {
            List<MeetingSendDetail> realTaskDetail = Optional.ofNullable(groupByContactIds.get(contactId)).orElse(Lists.newArrayList());
            if (!CollectionUtils.isNotEmpty(realTaskDetail)) continue;
            MeetingSendDetail meetingSendDetail = realTaskDetail.get(0);
            SelectedContact2WeworkUserDto userDto = new SelectedContact2WeworkUserDto();
            userDto.setContactId(meetingSendDetail.getContactId());
            userDto.setWeworkNum(meetingSendDetail.getWeworkUserNum());
            weworkUserDtos.add(userDto);
        }
        req.setWeworkUserDtos(weworkUserDtos);
        log.info("\u3010\u76f4\u64ad\u95f4\u7fa4\u53d1\u3011\u521b\u5efa\u76f4\u64ad\u95f4\u672a\u5230\u5ba2\u7528\u6237\u53c2\u6570 \u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)req));
        return this.groupSendTaskService.generateGroupSendDetailAndUpdate(task, req);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MessageGroupSendTask addOrModInnerGroupSend(AddOrModInnerGroupSendReq req) {
        MessageGroupSendTask task;
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("addOrModInnerGroupSend with req={},operatorId={}", (Object)req, (Object)currentUserInfo.getId());
        StopWatchDto timer = new StopWatchDto("addOrModInnerGroupSend", true, log);
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        req.validate();
        int sendCount = 0;
        ArrayList remindDetailReqDtos = Lists.newArrayList();
        switch (GroupSendTaskType.getType((int)req.getTaskType())) {
            case SIDEBAR: {
                sendCount = req.getSendTargetPairs().size();
                break;
            }
            case QYAPI: {
                if (req.getReceiveType().equals(ReceiveType.CHATROOM.getType())) {
                    sendCount = req.getWeworkUserNums().size();
                    break;
                }
                sendCount = req.getSendTargetPairs().size();
                break;
            }
            case CLIENT: {
                sendCount = req.getWeworkUserNums().size();
            }
        }
        if (StringUtils.isBlank((CharSequence)req.getTaskNum())) {
            log.info("addGroupSend task taskName={}", (Object)req.getTaskName());
            timer.start("buildTask");
            task = this.buildTask2(req, currentUserInfo, bizId, corpId, sendCount);
            this.groupSendTaskMapper.insertSelective((Object)task);
            timer.stop();
            this.groupSendTaskService.generateGroupSendDetailAndUpdate(task, req);
            timer.start("addRemind");
            this.addRemind2(req, currentUserInfo, remindDetailReqDtos, task);
            timer.stop();
            timer.start("addTaskMaterial");
            this.addTaskMaterial(req.getContentList(), task);
            timer.stop();
        } else {
            timer.start("queryByTaskNum");
            task = this.groupSendTaskMapper.queryByTaskNum(req.getTaskNum());
            timer.stop();
            if (task == null || task.getIsDeleted() == 1) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u4e0d\u5b58\u5728\u4e0d\u80fd\u4fee\u6539");
            }
            log.info("modGroupSend task taskId={},taskNum={}", (Object)task.getId(), (Object)task.getNum());
            this.validateTaskStatus2(req, task);
            String contentJson = null;
            String paramsJson = null;
            try {
                paramsJson = JSON.toJSONString((Object)req);
                contentJson = JSON.toJSONString(req.getContentList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (task.getParamsJson().equals(paramsJson)) {
                log.info("mod groupsend with not param change,taskId={}", (Object)task.getNum());
                timer.print();
                return task;
            }
            if (!(task.getContent().equals(contentJson) && task.getSendTime().equals(req.getSendTime()) && task.getDeadline().equals(req.getDeadlineTime()))) {
                timer.start("updateTaskMaterial");
                this.updateTaskMaterial2(req, task);
                timer.stop();
            }
            Date now = new Date();
            timer.start("updateDetails");
            switch (GroupSendTaskType.getType((int)req.getTaskType())) {
                case SIDEBAR: 
                case CLIENT: {
                    this.updateSidebarDetails(req, currentUserInfo, timer, task, now, sendCount);
                    break;
                }
                case QYAPI: {
                    this.groupSendDetailService.updateDetail2(req, task, currentUserInfo);
                    this.groupSendTaskService.updateGroupSend2(req, task, currentUserInfo.getId());
                }
            }
            timer.stop();
            if (!req.getFkType().equals(GroupSendFkType.MEETING.getType()) && StringUtils.isNotBlank((CharSequence)req.getRemind()) && CollectionUtils.isNotEmpty(req.getRemindDates())) {
                timer.start("modRemind");
                ModRemindReqDto reqDto = new ModRemindReqDto(Integer.valueOf(2), req.getRemindType(), req.getRemind(), task.getId(), currentUserInfo.getId(), Integer.valueOf(0), (List)remindDetailReqDtos);
                this.remindService.modRemind(reqDto);
                timer.stop();
            }
        }
        timer.start("buildGroupSendWework");
        this.buildGroupSendWework(currentUserInfo, bizId, corpId, remindDetailReqDtos, task);
        timer.stop();
        timer.print();
        return task;
    }

    private Integer updateSidebarDetails(AddOrModInnerGroupSendReq req, CurrentUserInfo currentUserInfo, StopWatchDto timer, MessageGroupSendTask task, Date now, Integer sendCount) {
        Integer sendStatus = null;
        if (now.after(req.getSendTime()) && now.before(req.getDeadlineTime())) {
            if (task.getSendStatus().equals(SendStatus.SENDING.getValue())) {
                sendStatus = SendStatus.SENDING.getValue();
                timer.start("updateDetail");
                this.groupSendDetailService.updateDetail2(req, task, currentUserInfo);
                timer.stop();
            } else {
                sendStatus = SendStatus.SENDING.getValue();
                this.groupSendTaskService.generateGroupSendDetailAndUpdate(task, req);
            }
        } else if (now.before(req.getSendTime())) {
            sendStatus = SendStatus.TO_BE_QUERY.getValue();
            timer.start("deleteDetails");
            this.groupSendDetailService.deleteDetails(task.getId(), currentUserInfo);
            timer.stop();
        }
        task.setSendCount(sendCount);
        task.setSendStatus(sendStatus);
        timer.start("updateGroupSend");
        this.groupSendTaskService.updateGroupSend2(req, task, currentUserInfo.getId());
        return sendStatus;
    }

    private MessageGroupSendTask buildTask2(AddOrModInnerGroupSendReq req, CurrentUserInfo currentUserInfo, Long bizId, String corpId, Integer sendCount) {
        String newTaskNum = this.idGen.getNum();
        Date now = new Date();
        MessageGroupSendTask task = new MessageGroupSendTask();
        task.setBizId(bizId);
        task.setCorpId(corpId);
        task.setNum(newTaskNum);
        task.setFkType(req.getFkType());
        task.setFkTaskId(req.getFkTaskId());
        task.setCreateBy(currentUserInfo.getId());
        task.setCreateTime(now);
        task.setUpdateBy(currentUserInfo.getId());
        task.setUpdateTime(now);
        task.setDeadline(req.getDeadlineTime());
        task.setSendTime(req.getSendTime());
        task.setIsDeleted(Integer.valueOf(0));
        task.setSendType(req.getSendType());
        task.setQueryType(Integer.valueOf(QueryType.DEFAULT.getType()));
        task.setSendCount(sendCount);
        task.setTaskStatus(TaskStatus.NORMAL.getValue());
        task.setSendStatus(Integer.valueOf(SendStatus.TO_BE_QUERY.getValue()));
        task.setName(req.getTaskName());
        task.setQueryRequestId("");
        task.setTaskType(req.getTaskType());
        task.setAutoChangeTaskType(req.getAutoChangeTaskType());
        task.setTimeoutGap(null);
        task.setContent(JSON.toJSONString(req.getContentList()));
        task.setParamsJson(JSON.toJSONString((Object)req));
        return task;
    }
}

